<?php
/**
 * Copyright Talisman Innovations Ltd. (2018). All rights reserved.
 */

namespace Eposnow;

use GuzzleHttp\HandlerStack;
use GuzzleHttp\Client;
use Psr\Log\LoggerInterface;
use ConnectorSupport\Guzzle\Handler\Wrapper;
use ConnectorSupport\Guzzle\Handler\Logger;
use ConnectorSupport\Guzzle\Handler\Console;

class ClientBuilder
{
    /**
     * @param string $baseUri
     * @param string $username
     * @param string $password
     * @param null|LoggerInterface $logger
     * @return Client
     */
    public static function getClient($baseUri, $username, $password, $logger = null)
    {
        $stack = HandlerStack::create();

        $wrapper = Wrapper::create();
        $stack->push($wrapper);

        $request = Logger::create($logger);
        $stack->push($request);

        $client = new Client([

            'base_uri' => $baseUri,
            'headers' => ['Content-Type' => 'application/json'],
            'auth' => [$username, $password],
            'handler' => $stack

        ]);

        return $client;
    }
}