# Eposnow\EposnowApi

All URIs are relative to *https://api.eposnowhq.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**addCustomerAddresses**](EposnowApi.md#addCustomerAddresses) | **POST** /api/v4/CustomerAddress | Create CustomerAddresses
[**addCustomers**](EposnowApi.md#addCustomers) | **POST** /api/v4/Customer | Create Customers
[**addDiscountReasons**](EposnowApi.md#addDiscountReasons) | **POST** /api/v4/DiscountReason | Create DiscountReasons
[**addProductStock**](EposnowApi.md#addProductStock) | **POST** /api/v4/ProductStock/Add | Add product stock
[**addRefundReasons**](EposnowApi.md#addRefundReasons) | **POST** /api/v4/RefundReason | Create RefundReasons
[**addTransaction**](EposnowApi.md#addTransaction) | **POST** /api/v4/Transaction | Create Transaction
[**addTransactionReferenceCodes**](EposnowApi.md#addTransactionReferenceCodes) | **POST** /api/v4/TransactionReferenceCode | Create TransactionReferenceCodes
[**addWebhookTriggers**](EposnowApi.md#addWebhookTriggers) | **POST** /api/v4/Webhook | Subscribe for webhooks
[**getBrandById**](EposnowApi.md#getBrandById) | **GET** /api/v4/Brand/{id} | Get a Brand by id
[**getBrands**](EposnowApi.md#getBrands) | **GET** /api/v4/Brand | Get all Brands
[**getCategories**](EposnowApi.md#getCategories) | **GET** /api/v4/Category | Get all Categories
[**getCategoryById**](EposnowApi.md#getCategoryById) | **GET** /api/v4/Category/{id} | Get Category by id
[**getColourById**](EposnowApi.md#getColourById) | **GET** /api/v4/Colour/{id} | Get Colour by id
[**getColours**](EposnowApi.md#getColours) | **GET** /api/v4/Colour | Get all Colours
[**getCustomerAddressById**](EposnowApi.md#getCustomerAddressById) | **GET** /api/v4/CustomerAddress/{id} | Get CustomerAddress by id
[**getCustomerAddresses**](EposnowApi.md#getCustomerAddresses) | **GET** /api/v4/CustomerAddress | Get all Customer Addresses
[**getCustomerAddressesByCustomerId**](EposnowApi.md#getCustomerAddressesByCustomerId) | **GET** /api/v4/CustomerAddress/Customer/{customerId} | Get CustomerAddresses by CustomerId
[**getCustomerById**](EposnowApi.md#getCustomerById) | **GET** /api/v4/Customer/{id} | Get Customer by id
[**getCustomers**](EposnowApi.md#getCustomers) | **GET** /api/v4/Customer | Get all Customers
[**getCustomersByEmail**](EposnowApi.md#getCustomersByEmail) | **GET** /api/v4/Customer/GetByEmail | Get all Customers by email address
[**getDevices**](EposnowApi.md#getDevices) | **GET** /api/v4/Device | Get all Devices
[**getDiscountReasonById**](EposnowApi.md#getDiscountReasonById) | **GET** /api/v4/DiscountReason/{id} | Get a DiscountReason by id
[**getDiscountReasons**](EposnowApi.md#getDiscountReasons) | **GET** /api/v4/DiscountReason | Get all DiscountReasons
[**getEndOfDayById**](EposnowApi.md#getEndOfDayById) | **GET** /api/v4/EndOfDay/{id} | Get EndOfDay by id
[**getEndOfDays**](EposnowApi.md#getEndOfDays) | **GET** /api/v4/EndOfDay | Get all EndOfDays
[**getLocationById**](EposnowApi.md#getLocationById) | **GET** /api/v4/Location/{id} | Get a Location by id
[**getLocations**](EposnowApi.md#getLocations) | **GET** /api/v4/Location | Get all Locations
[**getProductById**](EposnowApi.md#getProductById) | **GET** /api/v4/Product/{id} | Get a Product by Id
[**getProductStock**](EposnowApi.md#getProductStock) | **GET** /api/v4/ProductStock | Get all product stocks
[**getProductStockByLocationId**](EposnowApi.md#getProductStockByLocationId) | **GET** /api/v4/ProductStock/Location/{locationId} | Get ProductStocks for Location
[**getProductStockByProductId**](EposnowApi.md#getProductStockByProductId) | **GET** /api/v4/ProductStock/Product/{productId} | Get ProductStocks for Product
[**getProductStockByProductIdAndLocationId**](EposnowApi.md#getProductStockByProductIdAndLocationId) | **GET** /api/v4/ProductStock/Product/{productId}/Location/{locationId} | Get Stocks for a Product in a Location
[**getProducts**](EposnowApi.md#getProducts) | **GET** /api/v4/Product | Get all products
[**getProductsByVariantGroupId**](EposnowApi.md#getProductsByVariantGroupId) | **GET** /api/v2/Product | Get all products by variant group id
[**getRefundReasonById**](EposnowApi.md#getRefundReasonById) | **GET** /api/v4/RefundReason/{id} | Get a RefundReason by id
[**getRefundReasons**](EposnowApi.md#getRefundReasons) | **GET** /api/v4/RefundReason | Get all RefundReasons
[**getStaff**](EposnowApi.md#getStaff) | **GET** /api/v4/Staff | Get all Staff
[**getStaffById**](EposnowApi.md#getStaffById) | **GET** /api/v4/Staff/{id} | Get Staff by id
[**getSupplierById**](EposnowApi.md#getSupplierById) | **GET** /api/v4/Supplier/{id} | Get a Supplier by id
[**getSuppliers**](EposnowApi.md#getSuppliers) | **GET** /api/v4/Supplier | Get all Suppliers
[**getTaxGroupById**](EposnowApi.md#getTaxGroupById) | **GET** /api/v4/TaxGroup/{id} | Get a TaxGroup by id
[**getTaxGroups**](EposnowApi.md#getTaxGroups) | **GET** /api/v4/TaxGroup | Get all TaxGroups
[**getTenderTypeById**](EposnowApi.md#getTenderTypeById) | **GET** /api/v4/TenderType/{id} | Get a TenderType by id
[**getTenderTypes**](EposnowApi.md#getTenderTypes) | **GET** /api/v4/TenderType | Get all TenderTypes
[**getTransactionByBarcode**](EposnowApi.md#getTransactionByBarcode) | **GET** /api/v4/Transaction/Barcode/{barcode} | Get a Transaction by barcode
[**getTransactionById**](EposnowApi.md#getTransactionById) | **GET** /api/v4/Transaction/{id} | Get Transaction by id
[**getTransactionByReferenceCode**](EposnowApi.md#getTransactionByReferenceCode) | **GET** /api/v4/Transaction/ReferenceCode/{referenceCode} | Get a Transaction by reference code
[**getTransactionReferenceCodeById**](EposnowApi.md#getTransactionReferenceCodeById) | **GET** /api/v4/TransactionReferenceCode/{id} | Get TransactionReferenceCode by id
[**getTransactionReferenceCodeByTransactionId**](EposnowApi.md#getTransactionReferenceCodeByTransactionId) | **GET** /api/v4/TransactionReferenceCode/Transaction/{id} | Get TransactionReferenceCode by transaction id
[**getTransactionReferenceCodes**](EposnowApi.md#getTransactionReferenceCodes) | **GET** /api/v4/TransactionReferenceCode | Get all TransactionReferenceCodes
[**getTransactions**](EposnowApi.md#getTransactions) | **GET** /api/v4/Transaction | Get Transactions
[**getTransactionsBetweenDates**](EposnowApi.md#getTransactionsBetweenDates) | **GET** /api/v4/Transaction/GetByDate | Get Transactions between 2 dates
[**getWebhookTriggers**](EposnowApi.md#getWebhookTriggers) | **GET** /api/v4/Webhook | Get All Webhook Triggers
[**removeProductStock**](EposnowApi.md#removeProductStock) | **POST** /api/v4/ProductStock/Remove | Remove product stock
[**removeWebhookTriggers**](EposnowApi.md#removeWebhookTriggers) | **DELETE** /api/v4/Webhook | Unsubscribe from webhooks
[**updateWebhook**](EposnowApi.md#updateWebhook) | **PUT** /api/v4/Webhook | Update the base url for webhooks


# **addCustomerAddresses**
> \Eposnow\Model\CustomerAddressArrayResponse addCustomerAddresses($request)

Create CustomerAddresses



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$request = new \Eposnow\Model\CustomerAddressCreateArrayRequest(); // \Eposnow\Model\CustomerAddressCreateArrayRequest | 

try {
    $result = $apiInstance->addCustomerAddresses($request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->addCustomerAddresses: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **request** | [**\Eposnow\Model\CustomerAddressCreateArrayRequest**](../Model/CustomerAddressCreateArrayRequest.md)|  |

### Return type

[**\Eposnow\Model\CustomerAddressArrayResponse**](../Model/CustomerAddressArrayResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **addCustomers**
> \Eposnow\Model\CustomerArrayResponse addCustomers($request)

Create Customers



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$request = new \Eposnow\Model\CustomerCreateArrayRequest(); // \Eposnow\Model\CustomerCreateArrayRequest | 

try {
    $result = $apiInstance->addCustomers($request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->addCustomers: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **request** | [**\Eposnow\Model\CustomerCreateArrayRequest**](../Model/CustomerCreateArrayRequest.md)|  |

### Return type

[**\Eposnow\Model\CustomerArrayResponse**](../Model/CustomerArrayResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **addDiscountReasons**
> \Eposnow\Model\DiscountReasonArrayResponse addDiscountReasons($request)

Create DiscountReasons



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$request = new \Eposnow\Model\DiscountReasonCreateArrayRequest(); // \Eposnow\Model\DiscountReasonCreateArrayRequest | 

try {
    $result = $apiInstance->addDiscountReasons($request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->addDiscountReasons: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **request** | [**\Eposnow\Model\DiscountReasonCreateArrayRequest**](../Model/DiscountReasonCreateArrayRequest.md)|  |

### Return type

[**\Eposnow\Model\DiscountReasonArrayResponse**](../Model/DiscountReasonArrayResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **addProductStock**
> \Eposnow\Model\ProductStockObjectResponse addProductStock($request)

Add product stock



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$request = new \Eposnow\Model\ProductStockAddObjectRequest(); // \Eposnow\Model\ProductStockAddObjectRequest | 

try {
    $result = $apiInstance->addProductStock($request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->addProductStock: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **request** | [**\Eposnow\Model\ProductStockAddObjectRequest**](../Model/ProductStockAddObjectRequest.md)|  |

### Return type

[**\Eposnow\Model\ProductStockObjectResponse**](../Model/ProductStockObjectResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **addRefundReasons**
> \Eposnow\Model\RefundReasonArrayResponse addRefundReasons($request)

Create RefundReasons



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$request = new \Eposnow\Model\RefundReasonCreateArrayRequest(); // \Eposnow\Model\RefundReasonCreateArrayRequest | 

try {
    $result = $apiInstance->addRefundReasons($request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->addRefundReasons: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **request** | [**\Eposnow\Model\RefundReasonCreateArrayRequest**](../Model/RefundReasonCreateArrayRequest.md)|  |

### Return type

[**\Eposnow\Model\RefundReasonArrayResponse**](../Model/RefundReasonArrayResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **addTransaction**
> \Eposnow\Model\TransactionObjectResponse addTransaction($transaction)

Create Transaction



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$transaction = new \Eposnow\Model\Transaction(); // \Eposnow\Model\Transaction | 

try {
    $result = $apiInstance->addTransaction($transaction);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->addTransaction: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **transaction** | [**\Eposnow\Model\Transaction**](../Model/Transaction.md)|  |

### Return type

[**\Eposnow\Model\TransactionObjectResponse**](../Model/TransactionObjectResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **addTransactionReferenceCodes**
> \Eposnow\Model\TransactionReferenceCodeArrayResponse addTransactionReferenceCodes($transaction)

Create TransactionReferenceCodes



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$transaction = new \Eposnow\Model\TransactionReferenceCodeCreateArrayRequest(); // \Eposnow\Model\TransactionReferenceCodeCreateArrayRequest | 

try {
    $result = $apiInstance->addTransactionReferenceCodes($transaction);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->addTransactionReferenceCodes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **transaction** | [**\Eposnow\Model\TransactionReferenceCodeCreateArrayRequest**](../Model/TransactionReferenceCodeCreateArrayRequest.md)|  |

### Return type

[**\Eposnow\Model\TransactionReferenceCodeArrayResponse**](../Model/TransactionReferenceCodeArrayResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **addWebhookTriggers**
> \Eposnow\Model\WebhookObjectResponse addWebhookTriggers($triggers)

Subscribe for webhooks



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$triggers = new \Eposnow\Model\WebhookTriggerArrayRequest(); // \Eposnow\Model\WebhookTriggerArrayRequest | 

try {
    $result = $apiInstance->addWebhookTriggers($triggers);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->addWebhookTriggers: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **triggers** | [**\Eposnow\Model\WebhookTriggerArrayRequest**](../Model/WebhookTriggerArrayRequest.md)|  |

### Return type

[**\Eposnow\Model\WebhookObjectResponse**](../Model/WebhookObjectResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getBrandById**
> \Eposnow\Model\BrandObjectResponse getBrandById($id)

Get a Brand by id



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Brand id

try {
    $result = $apiInstance->getBrandById($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->getBrandById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Brand id |

### Return type

[**\Eposnow\Model\BrandObjectResponse**](../Model/BrandObjectResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getBrands**
> \Eposnow\Model\BrandArrayResponse getBrands($page)

Get all Brands



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$page = 789; // int | Page number

try {
    $result = $apiInstance->getBrands($page);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->getBrands: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page** | **int**| Page number | [optional]

### Return type

[**\Eposnow\Model\BrandArrayResponse**](../Model/BrandArrayResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getCategories**
> \Eposnow\Model\CategoryArrayResponse getCategories($page)

Get all Categories



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$page = 789; // int | Page number

try {
    $result = $apiInstance->getCategories($page);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->getCategories: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page** | **int**| Page number | [optional]

### Return type

[**\Eposnow\Model\CategoryArrayResponse**](../Model/CategoryArrayResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getCategoryById**
> \Eposnow\Model\CategoryObjectResponse getCategoryById($id)

Get Category by id



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Category id

try {
    $result = $apiInstance->getCategoryById($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->getCategoryById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Category id |

### Return type

[**\Eposnow\Model\CategoryObjectResponse**](../Model/CategoryObjectResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getColourById**
> \Eposnow\Model\ColourObjectResponse getColourById($id)

Get Colour by id



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Colour id

try {
    $result = $apiInstance->getColourById($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->getColourById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Colour id |

### Return type

[**\Eposnow\Model\ColourObjectResponse**](../Model/ColourObjectResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getColours**
> \Eposnow\Model\ColourArrayResponse getColours($page)

Get all Colours



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$page = 789; // int | Page number

try {
    $result = $apiInstance->getColours($page);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->getColours: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page** | **int**| Page number | [optional]

### Return type

[**\Eposnow\Model\ColourArrayResponse**](../Model/ColourArrayResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getCustomerAddressById**
> \Eposnow\Model\CustomerAddressObjectResponse getCustomerAddressById($id)

Get CustomerAddress by id



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | CustomerAddress id

try {
    $result = $apiInstance->getCustomerAddressById($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->getCustomerAddressById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| CustomerAddress id |

### Return type

[**\Eposnow\Model\CustomerAddressObjectResponse**](../Model/CustomerAddressObjectResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getCustomerAddresses**
> \Eposnow\Model\CustomerAddressArrayResponse getCustomerAddresses($page)

Get all Customer Addresses



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$page = 789; // int | Page number

try {
    $result = $apiInstance->getCustomerAddresses($page);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->getCustomerAddresses: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page** | **int**| Page number | [optional]

### Return type

[**\Eposnow\Model\CustomerAddressArrayResponse**](../Model/CustomerAddressArrayResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getCustomerAddressesByCustomerId**
> \Eposnow\Model\CustomerAddressArrayResponse getCustomerAddressesByCustomerId($customer_id)

Get CustomerAddresses by CustomerId



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$customer_id = 789; // int | Customer id

try {
    $result = $apiInstance->getCustomerAddressesByCustomerId($customer_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->getCustomerAddressesByCustomerId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **customer_id** | **int**| Customer id |

### Return type

[**\Eposnow\Model\CustomerAddressArrayResponse**](../Model/CustomerAddressArrayResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getCustomerById**
> \Eposnow\Model\CustomerObjectResponse getCustomerById($id)

Get Customer by id



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Customer id

try {
    $result = $apiInstance->getCustomerById($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->getCustomerById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Customer id |

### Return type

[**\Eposnow\Model\CustomerObjectResponse**](../Model/CustomerObjectResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getCustomers**
> \Eposnow\Model\CustomerArrayResponse getCustomers($page)

Get all Customers



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$page = 789; // int | Page number

try {
    $result = $apiInstance->getCustomers($page);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->getCustomers: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page** | **int**| Page number | [optional]

### Return type

[**\Eposnow\Model\CustomerArrayResponse**](../Model/CustomerArrayResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getCustomersByEmail**
> \Eposnow\Model\CustomerArrayResponse getCustomersByEmail($email, $page)

Get all Customers by email address



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$email = 789; // int | Email address
$page = 789; // int | Page number

try {
    $result = $apiInstance->getCustomersByEmail($email, $page);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->getCustomersByEmail: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **email** | **int**| Email address |
 **page** | **int**| Page number | [optional]

### Return type

[**\Eposnow\Model\CustomerArrayResponse**](../Model/CustomerArrayResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getDevices**
> \Eposnow\Model\DeviceArrayResponse getDevices($page)

Get all Devices



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$page = 789; // int | Page number

try {
    $result = $apiInstance->getDevices($page);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->getDevices: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page** | **int**| Page number | [optional]

### Return type

[**\Eposnow\Model\DeviceArrayResponse**](../Model/DeviceArrayResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getDiscountReasonById**
> \Eposnow\Model\DiscountReasonObjectResponse getDiscountReasonById($id)

Get a DiscountReason by id



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | DiscountReason id

try {
    $result = $apiInstance->getDiscountReasonById($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->getDiscountReasonById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| DiscountReason id |

### Return type

[**\Eposnow\Model\DiscountReasonObjectResponse**](../Model/DiscountReasonObjectResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getDiscountReasons**
> \Eposnow\Model\DiscountReasonArrayResponse getDiscountReasons($page)

Get all DiscountReasons



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$page = 789; // int | Page number

try {
    $result = $apiInstance->getDiscountReasons($page);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->getDiscountReasons: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page** | **int**| Page number | [optional]

### Return type

[**\Eposnow\Model\DiscountReasonArrayResponse**](../Model/DiscountReasonArrayResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getEndOfDayById**
> \Eposnow\Model\EndOfDayObjectResponse getEndOfDayById($id)

Get EndOfDay by id



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | EndOfDay id

try {
    $result = $apiInstance->getEndOfDayById($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->getEndOfDayById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| EndOfDay id |

### Return type

[**\Eposnow\Model\EndOfDayObjectResponse**](../Model/EndOfDayObjectResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getEndOfDays**
> \Eposnow\Model\EndOfDayArrayResponse getEndOfDays($page)

Get all EndOfDays



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$page = 789; // int | Page number

try {
    $result = $apiInstance->getEndOfDays($page);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->getEndOfDays: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page** | **int**| Page number | [optional]

### Return type

[**\Eposnow\Model\EndOfDayArrayResponse**](../Model/EndOfDayArrayResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getLocationById**
> \Eposnow\Model\LocationObjectResponse getLocationById($id)

Get a Location by id



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Location id

try {
    $result = $apiInstance->getLocationById($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->getLocationById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Location id |

### Return type

[**\Eposnow\Model\LocationObjectResponse**](../Model/LocationObjectResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getLocations**
> \Eposnow\Model\LocationArrayResponse getLocations($page)

Get all Locations



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$page = 789; // int | Page number

try {
    $result = $apiInstance->getLocations($page);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->getLocations: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page** | **int**| Page number | [optional]

### Return type

[**\Eposnow\Model\LocationArrayResponse**](../Model/LocationArrayResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProductById**
> \Eposnow\Model\ProductObjectResponse getProductById($id, $show_deleted)

Get a Product by Id



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Product id
$show_deleted = true; // bool | Show Deleted Products

try {
    $result = $apiInstance->getProductById($id, $show_deleted);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->getProductById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Product id |
 **show_deleted** | **bool**| Show Deleted Products | [optional]

### Return type

[**\Eposnow\Model\ProductObjectResponse**](../Model/ProductObjectResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProductStock**
> \Eposnow\Model\ProductStockArrayResponse getProductStock($page)

Get all product stocks



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$page = 789; // int | Page number

try {
    $result = $apiInstance->getProductStock($page);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->getProductStock: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page** | **int**| Page number | [optional]

### Return type

[**\Eposnow\Model\ProductStockArrayResponse**](../Model/ProductStockArrayResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProductStockByLocationId**
> \Eposnow\Model\ProductStockArrayResponse getProductStockByLocationId($location_id, $page)

Get ProductStocks for Location



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$location_id = 789; // int | Location id
$page = 789; // int | Page number

try {
    $result = $apiInstance->getProductStockByLocationId($location_id, $page);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->getProductStockByLocationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **location_id** | **int**| Location id |
 **page** | **int**| Page number | [optional]

### Return type

[**\Eposnow\Model\ProductStockArrayResponse**](../Model/ProductStockArrayResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProductStockByProductId**
> \Eposnow\Model\ProductStockArrayResponse getProductStockByProductId($product_id, $page)

Get ProductStocks for Product



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$product_id = 789; // int | Product id
$page = 789; // int | Page number

try {
    $result = $apiInstance->getProductStockByProductId($product_id, $page);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->getProductStockByProductId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **product_id** | **int**| Product id |
 **page** | **int**| Page number | [optional]

### Return type

[**\Eposnow\Model\ProductStockArrayResponse**](../Model/ProductStockArrayResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProductStockByProductIdAndLocationId**
> \Eposnow\Model\ProductStockObjectResponse getProductStockByProductIdAndLocationId($product_id, $location_id)

Get Stocks for a Product in a Location



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$product_id = 789; // int | Product id
$location_id = 789; // int | Location id

try {
    $result = $apiInstance->getProductStockByProductIdAndLocationId($product_id, $location_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->getProductStockByProductIdAndLocationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **product_id** | **int**| Product id |
 **location_id** | **int**| Location id |

### Return type

[**\Eposnow\Model\ProductStockObjectResponse**](../Model/ProductStockObjectResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProducts**
> \Eposnow\Model\ProductArrayResponse getProducts($page)

Get all products



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$page = 789; // int | Page number

try {
    $result = $apiInstance->getProducts($page);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->getProducts: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page** | **int**| Page number | [optional]

### Return type

[**\Eposnow\Model\ProductArrayResponse**](../Model/ProductArrayResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProductsByVariantGroupId**
> \Eposnow\Model\ProductV2ArrayResponse getProductsByVariantGroupId($variant_group_id, $page)

Get all products by variant group id



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$variant_group_id = 789; // int | Page number
$page = 789; // int | Page number

try {
    $result = $apiInstance->getProductsByVariantGroupId($variant_group_id, $page);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->getProductsByVariantGroupId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **variant_group_id** | **int**| Page number | [optional]
 **page** | **int**| Page number | [optional]

### Return type

[**\Eposnow\Model\ProductV2ArrayResponse**](../Model/ProductV2ArrayResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getRefundReasonById**
> \Eposnow\Model\RefundReasonObjectResponse getRefundReasonById($id)

Get a RefundReason by id



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | RefundReason id

try {
    $result = $apiInstance->getRefundReasonById($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->getRefundReasonById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| RefundReason id |

### Return type

[**\Eposnow\Model\RefundReasonObjectResponse**](../Model/RefundReasonObjectResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getRefundReasons**
> \Eposnow\Model\RefundReasonArrayResponse getRefundReasons($page)

Get all RefundReasons



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$page = 789; // int | Page number

try {
    $result = $apiInstance->getRefundReasons($page);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->getRefundReasons: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page** | **int**| Page number | [optional]

### Return type

[**\Eposnow\Model\RefundReasonArrayResponse**](../Model/RefundReasonArrayResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getStaff**
> \Eposnow\Model\StaffArrayResponse getStaff($page)

Get all Staff



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$page = 789; // int | Page number

try {
    $result = $apiInstance->getStaff($page);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->getStaff: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page** | **int**| Page number | [optional]

### Return type

[**\Eposnow\Model\StaffArrayResponse**](../Model/StaffArrayResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getStaffById**
> \Eposnow\Model\StaffObjectResponse getStaffById($id)

Get Staff by id



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Staff id

try {
    $result = $apiInstance->getStaffById($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->getStaffById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Staff id |

### Return type

[**\Eposnow\Model\StaffObjectResponse**](../Model/StaffObjectResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getSupplierById**
> \Eposnow\Model\SupplierObjectResponse getSupplierById($id)

Get a Supplier by id



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Supplier id

try {
    $result = $apiInstance->getSupplierById($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->getSupplierById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Supplier id |

### Return type

[**\Eposnow\Model\SupplierObjectResponse**](../Model/SupplierObjectResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getSuppliers**
> \Eposnow\Model\SupplierArrayResponse getSuppliers($page)

Get all Suppliers



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$page = 789; // int | Page number

try {
    $result = $apiInstance->getSuppliers($page);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->getSuppliers: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page** | **int**| Page number | [optional]

### Return type

[**\Eposnow\Model\SupplierArrayResponse**](../Model/SupplierArrayResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTaxGroupById**
> \Eposnow\Model\TaxGroupObjectResponse getTaxGroupById($id)

Get a TaxGroup by id



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | TaxGroup id

try {
    $result = $apiInstance->getTaxGroupById($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->getTaxGroupById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| TaxGroup id |

### Return type

[**\Eposnow\Model\TaxGroupObjectResponse**](../Model/TaxGroupObjectResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTaxGroups**
> \Eposnow\Model\TaxGroupArrayResponse getTaxGroups($page)

Get all TaxGroups



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$page = 789; // int | Page number

try {
    $result = $apiInstance->getTaxGroups($page);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->getTaxGroups: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page** | **int**| Page number | [optional]

### Return type

[**\Eposnow\Model\TaxGroupArrayResponse**](../Model/TaxGroupArrayResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTenderTypeById**
> \Eposnow\Model\TenderTypeObjectResponse getTenderTypeById($id)

Get a TenderType by id



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | TenderType id

try {
    $result = $apiInstance->getTenderTypeById($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->getTenderTypeById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| TenderType id |

### Return type

[**\Eposnow\Model\TenderTypeObjectResponse**](../Model/TenderTypeObjectResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTenderTypes**
> \Eposnow\Model\TenderTypeArrayResponse getTenderTypes($page)

Get all TenderTypes



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$page = 789; // int | Page number

try {
    $result = $apiInstance->getTenderTypes($page);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->getTenderTypes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page** | **int**| Page number | [optional]

### Return type

[**\Eposnow\Model\TenderTypeArrayResponse**](../Model/TenderTypeArrayResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTransactionByBarcode**
> \Eposnow\Model\TransactionObjectResponse getTransactionByBarcode($barcode)

Get a Transaction by barcode



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$barcode = "barcode_example"; // string | Barcode

try {
    $result = $apiInstance->getTransactionByBarcode($barcode);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->getTransactionByBarcode: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **barcode** | **string**| Barcode |

### Return type

[**\Eposnow\Model\TransactionObjectResponse**](../Model/TransactionObjectResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTransactionById**
> \Eposnow\Model\TransactionObjectResponse getTransactionById($id, $lock_transaction)

Get Transaction by id



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | Transaction id
$lock_transaction = true; // bool | Lock transaction

try {
    $result = $apiInstance->getTransactionById($id, $lock_transaction);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->getTransactionById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Transaction id |
 **lock_transaction** | **bool**| Lock transaction | [optional]

### Return type

[**\Eposnow\Model\TransactionObjectResponse**](../Model/TransactionObjectResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTransactionByReferenceCode**
> \Eposnow\Model\TransactionObjectResponse getTransactionByReferenceCode($reference_code)

Get a Transaction by reference code



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$reference_code = "reference_code_example"; // string | ReferenceCode

try {
    $result = $apiInstance->getTransactionByReferenceCode($reference_code);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->getTransactionByReferenceCode: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **reference_code** | **string**| ReferenceCode |

### Return type

[**\Eposnow\Model\TransactionObjectResponse**](../Model/TransactionObjectResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTransactionReferenceCodeById**
> \Eposnow\Model\TransactionReferenceCodeObjectResponse getTransactionReferenceCodeById($id)

Get TransactionReferenceCode by id



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | TransactionReferenceCode id

try {
    $result = $apiInstance->getTransactionReferenceCodeById($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->getTransactionReferenceCodeById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| TransactionReferenceCode id |

### Return type

[**\Eposnow\Model\TransactionReferenceCodeObjectResponse**](../Model/TransactionReferenceCodeObjectResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTransactionReferenceCodeByTransactionId**
> \Eposnow\Model\TransactionReferenceCodeObjectResponse getTransactionReferenceCodeByTransactionId($id)

Get TransactionReferenceCode by transaction id



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | Transaction id

try {
    $result = $apiInstance->getTransactionReferenceCodeByTransactionId($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->getTransactionReferenceCodeByTransactionId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Transaction id |

### Return type

[**\Eposnow\Model\TransactionReferenceCodeObjectResponse**](../Model/TransactionReferenceCodeObjectResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTransactionReferenceCodes**
> \Eposnow\Model\TransactionReferenceCodeArrayResponse getTransactionReferenceCodes($page)

Get all TransactionReferenceCodes



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$page = 789; // int | Page number

try {
    $result = $apiInstance->getTransactionReferenceCodes($page);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->getTransactionReferenceCodes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page** | **int**| Page number | [optional]

### Return type

[**\Eposnow\Model\TransactionReferenceCodeArrayResponse**](../Model/TransactionReferenceCodeArrayResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTransactions**
> \Eposnow\Model\TransactionArrayResponse getTransactions($status, $page)

Get Transactions



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$status = 789; // int | Status
$page = 789; // int | Page number

try {
    $result = $apiInstance->getTransactions($status, $page);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->getTransactions: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **status** | **int**| Status | [optional]
 **page** | **int**| Page number | [optional]

### Return type

[**\Eposnow\Model\TransactionArrayResponse**](../Model/TransactionArrayResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTransactionsBetweenDates**
> \Eposnow\Model\TransactionArrayResponse getTransactionsBetweenDates($start_date, $end_date, $status, $page)

Get Transactions between 2 dates



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$start_date = new \DateTime("2013-10-20"); // \DateTime | Start date
$end_date = new \DateTime("2013-10-20"); // \DateTime | End date
$status = 789; // int | Status
$page = 789; // int | Page number

try {
    $result = $apiInstance->getTransactionsBetweenDates($start_date, $end_date, $status, $page);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->getTransactionsBetweenDates: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **start_date** | **\DateTime**| Start date |
 **end_date** | **\DateTime**| End date |
 **status** | **int**| Status | [optional]
 **page** | **int**| Page number | [optional]

### Return type

[**\Eposnow\Model\TransactionArrayResponse**](../Model/TransactionArrayResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getWebhookTriggers**
> \Eposnow\Model\WebhookObjectResponse getWebhookTriggers()

Get All Webhook Triggers



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);

try {
    $result = $apiInstance->getWebhookTriggers();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->getWebhookTriggers: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\Eposnow\Model\WebhookObjectResponse**](../Model/WebhookObjectResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **removeProductStock**
> \Eposnow\Model\ProductStockObjectResponse removeProductStock($request)

Remove product stock



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$request = new \Eposnow\Model\ProductStockRemoveObjectRequest(); // \Eposnow\Model\ProductStockRemoveObjectRequest | 

try {
    $result = $apiInstance->removeProductStock($request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->removeProductStock: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **request** | [**\Eposnow\Model\ProductStockRemoveObjectRequest**](../Model/ProductStockRemoveObjectRequest.md)|  |

### Return type

[**\Eposnow\Model\ProductStockObjectResponse**](../Model/ProductStockObjectResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **removeWebhookTriggers**
> removeWebhookTriggers($trigger_ids)

Unsubscribe from webhooks



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$trigger_ids = new \Eposnow\Model\WebhookTriggerRemoveArrayRequest(); // \Eposnow\Model\WebhookTriggerRemoveArrayRequest | 

try {
    $apiInstance->removeWebhookTriggers($trigger_ids);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->removeWebhookTriggers: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **trigger_ids** | [**\Eposnow\Model\WebhookTriggerRemoveArrayRequest**](../Model/WebhookTriggerRemoveArrayRequest.md)|  |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateWebhook**
> updateWebhook($base_url)

Update the base url for webhooks



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$base_url = "base_url_example"; // string | 

try {
    $apiInstance->updateWebhook($base_url);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->updateWebhook: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **base_url** | **string**|  |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

