# .
Eposnow.

This PHP package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0.0
- Package version: 1.0
- Build package: io.swagger.codegen.languages.PhpClientCodegen

## Requirements

PHP 5.5 and later

## Installation & Usage
### Composer

To install the bindings via [Composer](http://getcomposer.org/), add the following to `composer.json`:

```
{
  "repositories": [
    {
      "type": "git",
      "url": "https://github.com/Talisman/Eposnow.git"
    }
  ],
  "require": {
    "Talisman/Eposnow": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
    require_once('/path/to/./vendor/autoload.php');
```

## Tests

To run the unit tests:

```
composer install
./vendor/bin/phpunit
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Eposnow\Api\EposnowApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$request = new \Eposnow\Model\CustomerAddressCreateArrayRequest(); // \Eposnow\Model\CustomerAddressCreateArrayRequest | 

try {
    $result = $apiInstance->addCustomerAddresses($request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EposnowApi->addCustomerAddresses: ', $e->getMessage(), PHP_EOL;
}

?>
```

## Documentation for API Endpoints

All URIs are relative to *https://api.eposnowhq.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*EposnowApi* | [**addCustomerAddresses**](docs/Api/EposnowApi.md#addcustomeraddresses) | **POST** /api/v4/CustomerAddress | Create CustomerAddresses
*EposnowApi* | [**addCustomers**](docs/Api/EposnowApi.md#addcustomers) | **POST** /api/v4/Customer | Create Customers
*EposnowApi* | [**addDiscountReasons**](docs/Api/EposnowApi.md#adddiscountreasons) | **POST** /api/v4/DiscountReason | Create DiscountReasons
*EposnowApi* | [**addProductStock**](docs/Api/EposnowApi.md#addproductstock) | **POST** /api/v4/ProductStock/Add | Add product stock
*EposnowApi* | [**addRefundReasons**](docs/Api/EposnowApi.md#addrefundreasons) | **POST** /api/v4/RefundReason | Create RefundReasons
*EposnowApi* | [**addTransaction**](docs/Api/EposnowApi.md#addtransaction) | **POST** /api/v4/Transaction | Create Transaction
*EposnowApi* | [**addTransactionReferenceCodes**](docs/Api/EposnowApi.md#addtransactionreferencecodes) | **POST** /api/v4/TransactionReferenceCode | Create TransactionReferenceCodes
*EposnowApi* | [**addWebhookTriggers**](docs/Api/EposnowApi.md#addwebhooktriggers) | **POST** /api/v4/Webhook | Subscribe for webhooks
*EposnowApi* | [**getBrandById**](docs/Api/EposnowApi.md#getbrandbyid) | **GET** /api/v4/Brand/{id} | Get a Brand by id
*EposnowApi* | [**getBrands**](docs/Api/EposnowApi.md#getbrands) | **GET** /api/v4/Brand | Get all Brands
*EposnowApi* | [**getCategories**](docs/Api/EposnowApi.md#getcategories) | **GET** /api/v4/Category | Get all Categories
*EposnowApi* | [**getCategoryById**](docs/Api/EposnowApi.md#getcategorybyid) | **GET** /api/v4/Category/{id} | Get Category by id
*EposnowApi* | [**getColourById**](docs/Api/EposnowApi.md#getcolourbyid) | **GET** /api/v4/Colour/{id} | Get Colour by id
*EposnowApi* | [**getColours**](docs/Api/EposnowApi.md#getcolours) | **GET** /api/v4/Colour | Get all Colours
*EposnowApi* | [**getCustomerAddressById**](docs/Api/EposnowApi.md#getcustomeraddressbyid) | **GET** /api/v4/CustomerAddress/{id} | Get CustomerAddress by id
*EposnowApi* | [**getCustomerAddresses**](docs/Api/EposnowApi.md#getcustomeraddresses) | **GET** /api/v4/CustomerAddress | Get all Customer Addresses
*EposnowApi* | [**getCustomerAddressesByCustomerId**](docs/Api/EposnowApi.md#getcustomeraddressesbycustomerid) | **GET** /api/v4/CustomerAddress/Customer/{customerId} | Get CustomerAddresses by CustomerId
*EposnowApi* | [**getCustomerById**](docs/Api/EposnowApi.md#getcustomerbyid) | **GET** /api/v4/Customer/{id} | Get Customer by id
*EposnowApi* | [**getCustomers**](docs/Api/EposnowApi.md#getcustomers) | **GET** /api/v4/Customer | Get all Customers
*EposnowApi* | [**getCustomersByEmail**](docs/Api/EposnowApi.md#getcustomersbyemail) | **GET** /api/v4/Customer/GetByEmail | Get all Customers by email address
*EposnowApi* | [**getDevices**](docs/Api/EposnowApi.md#getdevices) | **GET** /api/v4/Device | Get all Devices
*EposnowApi* | [**getDiscountReasonById**](docs/Api/EposnowApi.md#getdiscountreasonbyid) | **GET** /api/v4/DiscountReason/{id} | Get a DiscountReason by id
*EposnowApi* | [**getDiscountReasons**](docs/Api/EposnowApi.md#getdiscountreasons) | **GET** /api/v4/DiscountReason | Get all DiscountReasons
*EposnowApi* | [**getEndOfDayById**](docs/Api/EposnowApi.md#getendofdaybyid) | **GET** /api/v4/EndOfDay/{id} | Get EndOfDay by id
*EposnowApi* | [**getEndOfDays**](docs/Api/EposnowApi.md#getendofdays) | **GET** /api/v4/EndOfDay | Get all EndOfDays
*EposnowApi* | [**getLocationById**](docs/Api/EposnowApi.md#getlocationbyid) | **GET** /api/v4/Location/{id} | Get a Location by id
*EposnowApi* | [**getLocations**](docs/Api/EposnowApi.md#getlocations) | **GET** /api/v4/Location | Get all Locations
*EposnowApi* | [**getProductById**](docs/Api/EposnowApi.md#getproductbyid) | **GET** /api/v4/Product/{id} | Get a Product by Id
*EposnowApi* | [**getProductStock**](docs/Api/EposnowApi.md#getproductstock) | **GET** /api/v4/ProductStock | Get all product stocks
*EposnowApi* | [**getProductStockByLocationId**](docs/Api/EposnowApi.md#getproductstockbylocationid) | **GET** /api/v4/ProductStock/Location/{locationId} | Get ProductStocks for Location
*EposnowApi* | [**getProductStockByProductId**](docs/Api/EposnowApi.md#getproductstockbyproductid) | **GET** /api/v4/ProductStock/Product/{productId} | Get ProductStocks for Product
*EposnowApi* | [**getProductStockByProductIdAndLocationId**](docs/Api/EposnowApi.md#getproductstockbyproductidandlocationid) | **GET** /api/v4/ProductStock/Product/{productId}/Location/{locationId} | Get Stocks for a Product in a Location
*EposnowApi* | [**getProducts**](docs/Api/EposnowApi.md#getproducts) | **GET** /api/v4/Product | Get all products
*EposnowApi* | [**getProductsByVariantGroupId**](docs/Api/EposnowApi.md#getproductsbyvariantgroupid) | **GET** /api/v2/Product | Get all products by variant group id
*EposnowApi* | [**getRefundReasonById**](docs/Api/EposnowApi.md#getrefundreasonbyid) | **GET** /api/v4/RefundReason/{id} | Get a RefundReason by id
*EposnowApi* | [**getRefundReasons**](docs/Api/EposnowApi.md#getrefundreasons) | **GET** /api/v4/RefundReason | Get all RefundReasons
*EposnowApi* | [**getStaff**](docs/Api/EposnowApi.md#getstaff) | **GET** /api/v4/Staff | Get all Staff
*EposnowApi* | [**getStaffById**](docs/Api/EposnowApi.md#getstaffbyid) | **GET** /api/v4/Staff/{id} | Get Staff by id
*EposnowApi* | [**getSupplierById**](docs/Api/EposnowApi.md#getsupplierbyid) | **GET** /api/v4/Supplier/{id} | Get a Supplier by id
*EposnowApi* | [**getSuppliers**](docs/Api/EposnowApi.md#getsuppliers) | **GET** /api/v4/Supplier | Get all Suppliers
*EposnowApi* | [**getTaxGroupById**](docs/Api/EposnowApi.md#gettaxgroupbyid) | **GET** /api/v4/TaxGroup/{id} | Get a TaxGroup by id
*EposnowApi* | [**getTaxGroups**](docs/Api/EposnowApi.md#gettaxgroups) | **GET** /api/v4/TaxGroup | Get all TaxGroups
*EposnowApi* | [**getTenderTypeById**](docs/Api/EposnowApi.md#gettendertypebyid) | **GET** /api/v4/TenderType/{id} | Get a TenderType by id
*EposnowApi* | [**getTenderTypes**](docs/Api/EposnowApi.md#gettendertypes) | **GET** /api/v4/TenderType | Get all TenderTypes
*EposnowApi* | [**getTransactionByBarcode**](docs/Api/EposnowApi.md#gettransactionbybarcode) | **GET** /api/v4/Transaction/Barcode/{barcode} | Get a Transaction by barcode
*EposnowApi* | [**getTransactionById**](docs/Api/EposnowApi.md#gettransactionbyid) | **GET** /api/v4/Transaction/{id} | Get Transaction by id
*EposnowApi* | [**getTransactionByReferenceCode**](docs/Api/EposnowApi.md#gettransactionbyreferencecode) | **GET** /api/v4/Transaction/ReferenceCode/{referenceCode} | Get a Transaction by reference code
*EposnowApi* | [**getTransactionReferenceCodeById**](docs/Api/EposnowApi.md#gettransactionreferencecodebyid) | **GET** /api/v4/TransactionReferenceCode/{id} | Get TransactionReferenceCode by id
*EposnowApi* | [**getTransactionReferenceCodeByTransactionId**](docs/Api/EposnowApi.md#gettransactionreferencecodebytransactionid) | **GET** /api/v4/TransactionReferenceCode/Transaction/{id} | Get TransactionReferenceCode by transaction id
*EposnowApi* | [**getTransactionReferenceCodes**](docs/Api/EposnowApi.md#gettransactionreferencecodes) | **GET** /api/v4/TransactionReferenceCode | Get all TransactionReferenceCodes
*EposnowApi* | [**getTransactions**](docs/Api/EposnowApi.md#gettransactions) | **GET** /api/v4/Transaction | Get Transactions
*EposnowApi* | [**getTransactionsBetweenDates**](docs/Api/EposnowApi.md#gettransactionsbetweendates) | **GET** /api/v4/Transaction/GetByDate | Get Transactions between 2 dates
*EposnowApi* | [**getWebhookTriggers**](docs/Api/EposnowApi.md#getwebhooktriggers) | **GET** /api/v4/Webhook | Get All Webhook Triggers
*EposnowApi* | [**removeProductStock**](docs/Api/EposnowApi.md#removeproductstock) | **POST** /api/v4/ProductStock/Remove | Remove product stock
*EposnowApi* | [**removeWebhookTriggers**](docs/Api/EposnowApi.md#removewebhooktriggers) | **DELETE** /api/v4/Webhook | Unsubscribe from webhooks
*EposnowApi* | [**updateWebhook**](docs/Api/EposnowApi.md#updatewebhook) | **PUT** /api/v4/Webhook | Update the base url for webhooks


## Documentation For Models

 - [Brand](docs/Model/Brand.md)
 - [BrandArrayResponse](docs/Model/BrandArrayResponse.md)
 - [BrandObjectResponse](docs/Model/BrandObjectResponse.md)
 - [Category](docs/Model/Category.md)
 - [CategoryArrayResponse](docs/Model/CategoryArrayResponse.md)
 - [CategoryObjectResponse](docs/Model/CategoryObjectResponse.md)
 - [Colour](docs/Model/Colour.md)
 - [ColourArrayResponse](docs/Model/ColourArrayResponse.md)
 - [ColourObjectResponse](docs/Model/ColourObjectResponse.md)
 - [Customer](docs/Model/Customer.md)
 - [CustomerAddress](docs/Model/CustomerAddress.md)
 - [CustomerAddressArrayResponse](docs/Model/CustomerAddressArrayResponse.md)
 - [CustomerAddressCreateArrayRequest](docs/Model/CustomerAddressCreateArrayRequest.md)
 - [CustomerAddressCreateRequest](docs/Model/CustomerAddressCreateRequest.md)
 - [CustomerAddressObjectResponse](docs/Model/CustomerAddressObjectResponse.md)
 - [CustomerArrayResponse](docs/Model/CustomerArrayResponse.md)
 - [CustomerCreateArrayRequest](docs/Model/CustomerCreateArrayRequest.md)
 - [CustomerCreateRequest](docs/Model/CustomerCreateRequest.md)
 - [CustomerObjectResponse](docs/Model/CustomerObjectResponse.md)
 - [Device](docs/Model/Device.md)
 - [DeviceArrayResponse](docs/Model/DeviceArrayResponse.md)
 - [DiscountReason](docs/Model/DiscountReason.md)
 - [DiscountReasonArrayResponse](docs/Model/DiscountReasonArrayResponse.md)
 - [DiscountReasonCreateArrayRequest](docs/Model/DiscountReasonCreateArrayRequest.md)
 - [DiscountReasonCreateRequest](docs/Model/DiscountReasonCreateRequest.md)
 - [DiscountReasonObjectResponse](docs/Model/DiscountReasonObjectResponse.md)
 - [EndOfDay](docs/Model/EndOfDay.md)
 - [EndOfDayArrayResponse](docs/Model/EndOfDayArrayResponse.md)
 - [EndOfDayObjectResponse](docs/Model/EndOfDayObjectResponse.md)
 - [Location](docs/Model/Location.md)
 - [LocationArrayResponse](docs/Model/LocationArrayResponse.md)
 - [LocationObjectResponse](docs/Model/LocationObjectResponse.md)
 - [MarketingConsent](docs/Model/MarketingConsent.md)
 - [MiscProductItem](docs/Model/MiscProductItem.md)
 - [PopupNote](docs/Model/PopupNote.md)
 - [Product](docs/Model/Product.md)
 - [ProductArrayResponse](docs/Model/ProductArrayResponse.md)
 - [ProductMeasurementDetails](docs/Model/ProductMeasurementDetails.md)
 - [ProductObjectResponse](docs/Model/ProductObjectResponse.md)
 - [ProductStock](docs/Model/ProductStock.md)
 - [ProductStockAddObjectRequest](docs/Model/ProductStockAddObjectRequest.md)
 - [ProductStockAddRequest](docs/Model/ProductStockAddRequest.md)
 - [ProductStockArrayResponse](docs/Model/ProductStockArrayResponse.md)
 - [ProductStockBatch](docs/Model/ProductStockBatch.md)
 - [ProductStockObjectResponse](docs/Model/ProductStockObjectResponse.md)
 - [ProductStockRemoveObjectRequest](docs/Model/ProductStockRemoveObjectRequest.md)
 - [ProductStockRemoveRequest](docs/Model/ProductStockRemoveRequest.md)
 - [ProductV2](docs/Model/ProductV2.md)
 - [ProductV2ArrayResponse](docs/Model/ProductV2ArrayResponse.md)
 - [RefundReason](docs/Model/RefundReason.md)
 - [RefundReasonArrayResponse](docs/Model/RefundReasonArrayResponse.md)
 - [RefundReasonCreateArrayRequest](docs/Model/RefundReasonCreateArrayRequest.md)
 - [RefundReasonCreateRequest](docs/Model/RefundReasonCreateRequest.md)
 - [RefundReasonObjectResponse](docs/Model/RefundReasonObjectResponse.md)
 - [Role](docs/Model/Role.md)
 - [Staff](docs/Model/Staff.md)
 - [StaffArrayResponse](docs/Model/StaffArrayResponse.md)
 - [StaffObjectResponse](docs/Model/StaffObjectResponse.md)
 - [StockBatchMeasurementDetails](docs/Model/StockBatchMeasurementDetails.md)
 - [StockBatchMeasurementDetailsRequest](docs/Model/StockBatchMeasurementDetailsRequest.md)
 - [Supplier](docs/Model/Supplier.md)
 - [SupplierArrayResponse](docs/Model/SupplierArrayResponse.md)
 - [SupplierObjectResponse](docs/Model/SupplierObjectResponse.md)
 - [Tax](docs/Model/Tax.md)
 - [TaxGroup](docs/Model/TaxGroup.md)
 - [TaxGroupArrayResponse](docs/Model/TaxGroupArrayResponse.md)
 - [TaxGroupObjectResponse](docs/Model/TaxGroupObjectResponse.md)
 - [TaxGroupRate](docs/Model/TaxGroupRate.md)
 - [Tender](docs/Model/Tender.md)
 - [TenderType](docs/Model/TenderType.md)
 - [TenderTypeArrayResponse](docs/Model/TenderTypeArrayResponse.md)
 - [TenderTypeObjectResponse](docs/Model/TenderTypeObjectResponse.md)
 - [Transaction](docs/Model/Transaction.md)
 - [TransactionArrayResponse](docs/Model/TransactionArrayResponse.md)
 - [TransactionDetail](docs/Model/TransactionDetail.md)
 - [TransactionItem](docs/Model/TransactionItem.md)
 - [TransactionItemMeasurementDetails](docs/Model/TransactionItemMeasurementDetails.md)
 - [TransactionObjectResponse](docs/Model/TransactionObjectResponse.md)
 - [TransactionReferenceCode](docs/Model/TransactionReferenceCode.md)
 - [TransactionReferenceCodeArrayResponse](docs/Model/TransactionReferenceCodeArrayResponse.md)
 - [TransactionReferenceCodeCreateArrayRequest](docs/Model/TransactionReferenceCodeCreateArrayRequest.md)
 - [TransactionReferenceCodeCreateRequest](docs/Model/TransactionReferenceCodeCreateRequest.md)
 - [TransactionReferenceCodeObjectResponse](docs/Model/TransactionReferenceCodeObjectResponse.md)
 - [TransactionTable](docs/Model/TransactionTable.md)
 - [Webhook](docs/Model/Webhook.md)
 - [WebhookObjectRequest](docs/Model/WebhookObjectRequest.md)
 - [WebhookObjectResponse](docs/Model/WebhookObjectResponse.md)
 - [WebhookTrigger](docs/Model/WebhookTrigger.md)
 - [WebhookTriggerArrayRequest](docs/Model/WebhookTriggerArrayRequest.md)
 - [WebhookTriggerRemoveArrayRequest](docs/Model/WebhookTriggerRemoveArrayRequest.md)


## Documentation For Authorization

 All endpoints do not require authorization.


## Author




