<?php
/**
 * TempestModelsShopsProductsV2Product
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  EKMv2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * EKM Partner API
 *
 * Our new API allows partners to build significantly better integrations with the EKM platform.    To try out the below endpoints, or for full up to date representations of the request / response models, please see the [swagger page](https://api.ekm.net/swagger/index.html). (We display examples here, but the swagger page is guaranteed to show the complete model.)    To keep up to date with the latest updates, please see our [RSS feed](https://partners.ekm.net/ChangeLog/Feed) or the [partner dashboard](https://partners.ekm.net/).
 *
 * The version of the OpenAPI document: v2
 * Contact: api-support@ekm.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace EKMv2\Model;

use \ArrayAccess;
use \EKMv2\ObjectSerializer;

/**
 * TempestModelsShopsProductsV2Product Class Doc Comment
 *
 * @category Class
 * @package  EKMv2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class TempestModelsShopsProductsV2Product implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Tempest.Models.Shops.Products.V2.Product';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'int',
        'primaryCategoryId' => 'int',
        'name' => 'string',
        'description' => 'string',
        'shortDescription' => 'string',
        'numberInStock' => 'int',
        'price' => 'float',
        'rrp' => 'float',
        'productCode' => 'string',
        'chargeDelivery' => 'bool',
        'specialOffer' => 'bool',
        'brand' => 'string',
        'condition' => 'string',
        'gtin' => 'string',
        'mpn' => 'string',
        'productWeight' => 'float',
        'canBeAddedToCart' => 'bool',
        'taxApplicable' => 'bool',
        'taxRateId' => 'int',
        'live' => 'bool',
        'orderNote' => 'string',
        'redirectUrl' => 'string',
        'lastModified' => '\DateTime',
        'metaDescription' => 'string',
        'metaKeywords' => 'string',
        'metaTitle' => 'string',
        'totalProductStock' => 'int',
        'orderLocation' => 'int',
        'productImage1Id' => 'int',
        'productImage2Id' => 'int',
        'productImage3Id' => 'int',
        'productImage4Id' => 'int',
        'productImage5Id' => 'int',
        'parentProductId' => 'int',
        'seoFriendlyUrl' => 'string',
        'variantIds' => 'int[]',
        'optionIds' => 'int[]',
        'categoryIds' => 'int[]',
        'variantCombinationIds' => 'int[]',
        'attributeItemIds' => 'int[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => 'int64',
        'primaryCategoryId' => 'int64',
        'name' => null,
        'description' => null,
        'shortDescription' => null,
        'numberInStock' => 'int64',
        'price' => 'double',
        'rrp' => 'double',
        'productCode' => null,
        'chargeDelivery' => null,
        'specialOffer' => null,
        'brand' => null,
        'condition' => null,
        'gtin' => null,
        'mpn' => null,
        'productWeight' => 'double',
        'canBeAddedToCart' => null,
        'taxApplicable' => null,
        'taxRateId' => 'int32',
        'live' => null,
        'orderNote' => null,
        'redirectUrl' => null,
        'lastModified' => 'date-time',
        'metaDescription' => null,
        'metaKeywords' => null,
        'metaTitle' => null,
        'totalProductStock' => 'int64',
        'orderLocation' => 'int64',
        'productImage1Id' => 'int64',
        'productImage2Id' => 'int64',
        'productImage3Id' => 'int64',
        'productImage4Id' => 'int64',
        'productImage5Id' => 'int64',
        'parentProductId' => 'int64',
        'seoFriendlyUrl' => null,
        'variantIds' => 'int64',
        'optionIds' => 'int64',
        'categoryIds' => 'int64',
        'variantCombinationIds' => 'int64',
        'attributeItemIds' => 'int64'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'id' => false,
        'primaryCategoryId' => true,
        'name' => true,
        'description' => true,
        'shortDescription' => true,
        'numberInStock' => false,
        'price' => false,
        'rrp' => false,
        'productCode' => true,
        'chargeDelivery' => false,
        'specialOffer' => false,
        'brand' => true,
        'condition' => true,
        'gtin' => true,
        'mpn' => true,
        'productWeight' => false,
        'canBeAddedToCart' => false,
        'taxApplicable' => false,
        'taxRateId' => true,
        'live' => false,
        'orderNote' => true,
        'redirectUrl' => true,
        'lastModified' => false,
        'metaDescription' => true,
        'metaKeywords' => true,
        'metaTitle' => true,
        'totalProductStock' => false,
        'orderLocation' => false,
        'productImage1Id' => true,
        'productImage2Id' => true,
        'productImage3Id' => true,
        'productImage4Id' => true,
        'productImage5Id' => true,
        'parentProductId' => true,
        'seoFriendlyUrl' => true,
        'variantIds' => true,
        'optionIds' => true,
        'categoryIds' => true,
        'variantCombinationIds' => true,
        'attributeItemIds' => true
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'primaryCategoryId' => 'primary_category_id',
        'name' => 'name',
        'description' => 'description',
        'shortDescription' => 'short_description',
        'numberInStock' => 'number_in_stock',
        'price' => 'price',
        'rrp' => 'rrp',
        'productCode' => 'product_code',
        'chargeDelivery' => 'charge_delivery',
        'specialOffer' => 'special_offer',
        'brand' => 'brand',
        'condition' => 'condition',
        'gtin' => 'gtin',
        'mpn' => 'mpn',
        'productWeight' => 'product_weight',
        'canBeAddedToCart' => 'can_be_added_to_cart',
        'taxApplicable' => 'tax_applicable',
        'taxRateId' => 'tax_rate_id',
        'live' => 'live',
        'orderNote' => 'order_note',
        'redirectUrl' => 'redirect_url',
        'lastModified' => 'last_modified',
        'metaDescription' => 'meta_description',
        'metaKeywords' => 'meta_keywords',
        'metaTitle' => 'meta_title',
        'totalProductStock' => 'total_product_stock',
        'orderLocation' => 'order_location',
        'productImage1Id' => 'product_image1_id',
        'productImage2Id' => 'product_image2_id',
        'productImage3Id' => 'product_image3_id',
        'productImage4Id' => 'product_image4_id',
        'productImage5Id' => 'product_image5_id',
        'parentProductId' => 'parent_product_id',
        'seoFriendlyUrl' => 'seo_friendly_url',
        'variantIds' => 'variant_ids',
        'optionIds' => 'option_ids',
        'categoryIds' => 'category_ids',
        'variantCombinationIds' => 'variant_combination_ids',
        'attributeItemIds' => 'attribute_item_ids'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'primaryCategoryId' => 'setPrimaryCategoryId',
        'name' => 'setName',
        'description' => 'setDescription',
        'shortDescription' => 'setShortDescription',
        'numberInStock' => 'setNumberInStock',
        'price' => 'setPrice',
        'rrp' => 'setRrp',
        'productCode' => 'setProductCode',
        'chargeDelivery' => 'setChargeDelivery',
        'specialOffer' => 'setSpecialOffer',
        'brand' => 'setBrand',
        'condition' => 'setCondition',
        'gtin' => 'setGtin',
        'mpn' => 'setMpn',
        'productWeight' => 'setProductWeight',
        'canBeAddedToCart' => 'setCanBeAddedToCart',
        'taxApplicable' => 'setTaxApplicable',
        'taxRateId' => 'setTaxRateId',
        'live' => 'setLive',
        'orderNote' => 'setOrderNote',
        'redirectUrl' => 'setRedirectUrl',
        'lastModified' => 'setLastModified',
        'metaDescription' => 'setMetaDescription',
        'metaKeywords' => 'setMetaKeywords',
        'metaTitle' => 'setMetaTitle',
        'totalProductStock' => 'setTotalProductStock',
        'orderLocation' => 'setOrderLocation',
        'productImage1Id' => 'setProductImage1Id',
        'productImage2Id' => 'setProductImage2Id',
        'productImage3Id' => 'setProductImage3Id',
        'productImage4Id' => 'setProductImage4Id',
        'productImage5Id' => 'setProductImage5Id',
        'parentProductId' => 'setParentProductId',
        'seoFriendlyUrl' => 'setSeoFriendlyUrl',
        'variantIds' => 'setVariantIds',
        'optionIds' => 'setOptionIds',
        'categoryIds' => 'setCategoryIds',
        'variantCombinationIds' => 'setVariantCombinationIds',
        'attributeItemIds' => 'setAttributeItemIds'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'primaryCategoryId' => 'getPrimaryCategoryId',
        'name' => 'getName',
        'description' => 'getDescription',
        'shortDescription' => 'getShortDescription',
        'numberInStock' => 'getNumberInStock',
        'price' => 'getPrice',
        'rrp' => 'getRrp',
        'productCode' => 'getProductCode',
        'chargeDelivery' => 'getChargeDelivery',
        'specialOffer' => 'getSpecialOffer',
        'brand' => 'getBrand',
        'condition' => 'getCondition',
        'gtin' => 'getGtin',
        'mpn' => 'getMpn',
        'productWeight' => 'getProductWeight',
        'canBeAddedToCart' => 'getCanBeAddedToCart',
        'taxApplicable' => 'getTaxApplicable',
        'taxRateId' => 'getTaxRateId',
        'live' => 'getLive',
        'orderNote' => 'getOrderNote',
        'redirectUrl' => 'getRedirectUrl',
        'lastModified' => 'getLastModified',
        'metaDescription' => 'getMetaDescription',
        'metaKeywords' => 'getMetaKeywords',
        'metaTitle' => 'getMetaTitle',
        'totalProductStock' => 'getTotalProductStock',
        'orderLocation' => 'getOrderLocation',
        'productImage1Id' => 'getProductImage1Id',
        'productImage2Id' => 'getProductImage2Id',
        'productImage3Id' => 'getProductImage3Id',
        'productImage4Id' => 'getProductImage4Id',
        'productImage5Id' => 'getProductImage5Id',
        'parentProductId' => 'getParentProductId',
        'seoFriendlyUrl' => 'getSeoFriendlyUrl',
        'variantIds' => 'getVariantIds',
        'optionIds' => 'getOptionIds',
        'categoryIds' => 'getCategoryIds',
        'variantCombinationIds' => 'getVariantCombinationIds',
        'attributeItemIds' => 'getAttributeItemIds'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('primaryCategoryId', $data ?? [], null);
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('description', $data ?? [], null);
        $this->setIfExists('shortDescription', $data ?? [], null);
        $this->setIfExists('numberInStock', $data ?? [], null);
        $this->setIfExists('price', $data ?? [], null);
        $this->setIfExists('rrp', $data ?? [], null);
        $this->setIfExists('productCode', $data ?? [], null);
        $this->setIfExists('chargeDelivery', $data ?? [], null);
        $this->setIfExists('specialOffer', $data ?? [], null);
        $this->setIfExists('brand', $data ?? [], null);
        $this->setIfExists('condition', $data ?? [], null);
        $this->setIfExists('gtin', $data ?? [], null);
        $this->setIfExists('mpn', $data ?? [], null);
        $this->setIfExists('productWeight', $data ?? [], null);
        $this->setIfExists('canBeAddedToCart', $data ?? [], null);
        $this->setIfExists('taxApplicable', $data ?? [], null);
        $this->setIfExists('taxRateId', $data ?? [], null);
        $this->setIfExists('live', $data ?? [], null);
        $this->setIfExists('orderNote', $data ?? [], null);
        $this->setIfExists('redirectUrl', $data ?? [], null);
        $this->setIfExists('lastModified', $data ?? [], null);
        $this->setIfExists('metaDescription', $data ?? [], null);
        $this->setIfExists('metaKeywords', $data ?? [], null);
        $this->setIfExists('metaTitle', $data ?? [], null);
        $this->setIfExists('totalProductStock', $data ?? [], null);
        $this->setIfExists('orderLocation', $data ?? [], null);
        $this->setIfExists('productImage1Id', $data ?? [], null);
        $this->setIfExists('productImage2Id', $data ?? [], null);
        $this->setIfExists('productImage3Id', $data ?? [], null);
        $this->setIfExists('productImage4Id', $data ?? [], null);
        $this->setIfExists('productImage5Id', $data ?? [], null);
        $this->setIfExists('parentProductId', $data ?? [], null);
        $this->setIfExists('seoFriendlyUrl', $data ?? [], null);
        $this->setIfExists('variantIds', $data ?? [], null);
        $this->setIfExists('optionIds', $data ?? [], null);
        $this->setIfExists('categoryIds', $data ?? [], null);
        $this->setIfExists('variantCombinationIds', $data ?? [], null);
        $this->setIfExists('attributeItemIds', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['name'] === null) {
            $invalidProperties[] = "'name' can't be null";
        }
        if (!is_null($this->container['price']) && ($this->container['price'] < 0)) {
            $invalidProperties[] = "invalid value for 'price', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['rrp']) && ($this->container['rrp'] < 0)) {
            $invalidProperties[] = "invalid value for 'rrp', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['productWeight']) && ($this->container['productWeight'] < 0)) {
            $invalidProperties[] = "invalid value for 'productWeight', must be bigger than or equal to 0.";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return int|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int|null $id id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets primaryCategoryId
     *
     * @return int|null
     */
    public function getPrimaryCategoryId()
    {
        return $this->container['primaryCategoryId'];
    }

    /**
     * Sets primaryCategoryId
     *
     * @param int|null $primaryCategoryId primaryCategoryId
     *
     * @return self
     */
    public function setPrimaryCategoryId($primaryCategoryId)
    {
        if (is_null($primaryCategoryId)) {
            array_push($this->openAPINullablesSetToNull, 'primaryCategoryId');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('primaryCategoryId', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['primaryCategoryId'] = $primaryCategoryId;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string $name name
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            array_push($this->openAPINullablesSetToNull, 'name');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('name', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string|null $description description
     *
     * @return self
     */
    public function setDescription($description)
    {
        if (is_null($description)) {
            array_push($this->openAPINullablesSetToNull, 'description');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('description', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets shortDescription
     *
     * @return string|null
     */
    public function getShortDescription()
    {
        return $this->container['shortDescription'];
    }

    /**
     * Sets shortDescription
     *
     * @param string|null $shortDescription shortDescription
     *
     * @return self
     */
    public function setShortDescription($shortDescription)
    {
        if (is_null($shortDescription)) {
            array_push($this->openAPINullablesSetToNull, 'shortDescription');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('shortDescription', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['shortDescription'] = $shortDescription;

        return $this;
    }

    /**
     * Gets numberInStock
     *
     * @return int|null
     */
    public function getNumberInStock()
    {
        return $this->container['numberInStock'];
    }

    /**
     * Sets numberInStock
     *
     * @param int|null $numberInStock numberInStock
     *
     * @return self
     */
    public function setNumberInStock($numberInStock)
    {
        if (is_null($numberInStock)) {
            throw new \InvalidArgumentException('non-nullable numberInStock cannot be null');
        }
        $this->container['numberInStock'] = $numberInStock;

        return $this;
    }

    /**
     * Gets price
     *
     * @return float|null
     */
    public function getPrice()
    {
        return $this->container['price'];
    }

    /**
     * Sets price
     *
     * @param float|null $price price
     *
     * @return self
     */
    public function setPrice($price)
    {
        if (is_null($price)) {
            throw new \InvalidArgumentException('non-nullable price cannot be null');
        }

        if (($price < 0)) {
            throw new \InvalidArgumentException('invalid value for $price when calling TempestModelsShopsProductsV2Product., must be bigger than or equal to 0.');
        }

        $this->container['price'] = $price;

        return $this;
    }

    /**
     * Gets rrp
     *
     * @return float|null
     */
    public function getRrp()
    {
        return $this->container['rrp'];
    }

    /**
     * Sets rrp
     *
     * @param float|null $rrp rrp
     *
     * @return self
     */
    public function setRrp($rrp)
    {
        if (is_null($rrp)) {
            throw new \InvalidArgumentException('non-nullable rrp cannot be null');
        }

        if (($rrp < 0)) {
            throw new \InvalidArgumentException('invalid value for $rrp when calling TempestModelsShopsProductsV2Product., must be bigger than or equal to 0.');
        }

        $this->container['rrp'] = $rrp;

        return $this;
    }

    /**
     * Gets productCode
     *
     * @return string|null
     */
    public function getProductCode()
    {
        return $this->container['productCode'];
    }

    /**
     * Sets productCode
     *
     * @param string|null $productCode productCode
     *
     * @return self
     */
    public function setProductCode($productCode)
    {
        if (is_null($productCode)) {
            array_push($this->openAPINullablesSetToNull, 'productCode');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('productCode', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['productCode'] = $productCode;

        return $this;
    }

    /**
     * Gets chargeDelivery
     *
     * @return bool|null
     */
    public function getChargeDelivery()
    {
        return $this->container['chargeDelivery'];
    }

    /**
     * Sets chargeDelivery
     *
     * @param bool|null $chargeDelivery chargeDelivery
     *
     * @return self
     */
    public function setChargeDelivery($chargeDelivery)
    {
        if (is_null($chargeDelivery)) {
            throw new \InvalidArgumentException('non-nullable chargeDelivery cannot be null');
        }
        $this->container['chargeDelivery'] = $chargeDelivery;

        return $this;
    }

    /**
     * Gets specialOffer
     *
     * @return bool|null
     */
    public function getSpecialOffer()
    {
        return $this->container['specialOffer'];
    }

    /**
     * Sets specialOffer
     *
     * @param bool|null $specialOffer specialOffer
     *
     * @return self
     */
    public function setSpecialOffer($specialOffer)
    {
        if (is_null($specialOffer)) {
            throw new \InvalidArgumentException('non-nullable specialOffer cannot be null');
        }
        $this->container['specialOffer'] = $specialOffer;

        return $this;
    }

    /**
     * Gets brand
     *
     * @return string|null
     */
    public function getBrand()
    {
        return $this->container['brand'];
    }

    /**
     * Sets brand
     *
     * @param string|null $brand brand
     *
     * @return self
     */
    public function setBrand($brand)
    {
        if (is_null($brand)) {
            array_push($this->openAPINullablesSetToNull, 'brand');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('brand', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['brand'] = $brand;

        return $this;
    }

    /**
     * Gets condition
     *
     * @return string|null
     */
    public function getCondition()
    {
        return $this->container['condition'];
    }

    /**
     * Sets condition
     *
     * @param string|null $condition condition
     *
     * @return self
     */
    public function setCondition($condition)
    {
        if (is_null($condition)) {
            array_push($this->openAPINullablesSetToNull, 'condition');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('condition', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['condition'] = $condition;

        return $this;
    }

    /**
     * Gets gtin
     *
     * @return string|null
     */
    public function getGtin()
    {
        return $this->container['gtin'];
    }

    /**
     * Sets gtin
     *
     * @param string|null $gtin gtin
     *
     * @return self
     */
    public function setGtin($gtin)
    {
        if (is_null($gtin)) {
            array_push($this->openAPINullablesSetToNull, 'gtin');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('gtin', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['gtin'] = $gtin;

        return $this;
    }

    /**
     * Gets mpn
     *
     * @return string|null
     */
    public function getMpn()
    {
        return $this->container['mpn'];
    }

    /**
     * Sets mpn
     *
     * @param string|null $mpn mpn
     *
     * @return self
     */
    public function setMpn($mpn)
    {
        if (is_null($mpn)) {
            array_push($this->openAPINullablesSetToNull, 'mpn');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('mpn', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['mpn'] = $mpn;

        return $this;
    }

    /**
     * Gets productWeight
     *
     * @return float|null
     */
    public function getProductWeight()
    {
        return $this->container['productWeight'];
    }

    /**
     * Sets productWeight
     *
     * @param float|null $productWeight productWeight
     *
     * @return self
     */
    public function setProductWeight($productWeight)
    {
        if (is_null($productWeight)) {
            throw new \InvalidArgumentException('non-nullable productWeight cannot be null');
        }

        if (($productWeight < 0)) {
            throw new \InvalidArgumentException('invalid value for $productWeight when calling TempestModelsShopsProductsV2Product., must be bigger than or equal to 0.');
        }

        $this->container['productWeight'] = $productWeight;

        return $this;
    }

    /**
     * Gets canBeAddedToCart
     *
     * @return bool|null
     */
    public function getCanBeAddedToCart()
    {
        return $this->container['canBeAddedToCart'];
    }

    /**
     * Sets canBeAddedToCart
     *
     * @param bool|null $canBeAddedToCart canBeAddedToCart
     *
     * @return self
     */
    public function setCanBeAddedToCart($canBeAddedToCart)
    {
        if (is_null($canBeAddedToCart)) {
            throw new \InvalidArgumentException('non-nullable canBeAddedToCart cannot be null');
        }
        $this->container['canBeAddedToCart'] = $canBeAddedToCart;

        return $this;
    }

    /**
     * Gets taxApplicable
     *
     * @return bool|null
     */
    public function getTaxApplicable()
    {
        return $this->container['taxApplicable'];
    }

    /**
     * Sets taxApplicable
     *
     * @param bool|null $taxApplicable taxApplicable
     *
     * @return self
     */
    public function setTaxApplicable($taxApplicable)
    {
        if (is_null($taxApplicable)) {
            throw new \InvalidArgumentException('non-nullable taxApplicable cannot be null');
        }
        $this->container['taxApplicable'] = $taxApplicable;

        return $this;
    }

    /**
     * Gets taxRateId
     *
     * @return int|null
     */
    public function getTaxRateId()
    {
        return $this->container['taxRateId'];
    }

    /**
     * Sets taxRateId
     *
     * @param int|null $taxRateId taxRateId
     *
     * @return self
     */
    public function setTaxRateId($taxRateId)
    {
        if (is_null($taxRateId)) {
            array_push($this->openAPINullablesSetToNull, 'taxRateId');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('taxRateId', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['taxRateId'] = $taxRateId;

        return $this;
    }

    /**
     * Gets live
     *
     * @return bool|null
     */
    public function getLive()
    {
        return $this->container['live'];
    }

    /**
     * Sets live
     *
     * @param bool|null $live live
     *
     * @return self
     */
    public function setLive($live)
    {
        if (is_null($live)) {
            throw new \InvalidArgumentException('non-nullable live cannot be null');
        }
        $this->container['live'] = $live;

        return $this;
    }

    /**
     * Gets orderNote
     *
     * @return string|null
     */
    public function getOrderNote()
    {
        return $this->container['orderNote'];
    }

    /**
     * Sets orderNote
     *
     * @param string|null $orderNote orderNote
     *
     * @return self
     */
    public function setOrderNote($orderNote)
    {
        if (is_null($orderNote)) {
            array_push($this->openAPINullablesSetToNull, 'orderNote');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('orderNote', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['orderNote'] = $orderNote;

        return $this;
    }

    /**
     * Gets redirectUrl
     *
     * @return string|null
     */
    public function getRedirectUrl()
    {
        return $this->container['redirectUrl'];
    }

    /**
     * Sets redirectUrl
     *
     * @param string|null $redirectUrl redirectUrl
     *
     * @return self
     */
    public function setRedirectUrl($redirectUrl)
    {
        if (is_null($redirectUrl)) {
            array_push($this->openAPINullablesSetToNull, 'redirectUrl');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('redirectUrl', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['redirectUrl'] = $redirectUrl;

        return $this;
    }

    /**
     * Gets lastModified
     *
     * @return \DateTime|null
     */
    public function getLastModified()
    {
        return $this->container['lastModified'];
    }

    /**
     * Sets lastModified
     *
     * @param \DateTime|null $lastModified lastModified
     *
     * @return self
     */
    public function setLastModified($lastModified)
    {
        if (is_null($lastModified)) {
            throw new \InvalidArgumentException('non-nullable lastModified cannot be null');
        }
        $this->container['lastModified'] = $lastModified;

        return $this;
    }

    /**
     * Gets metaDescription
     *
     * @return string|null
     */
    public function getMetaDescription()
    {
        return $this->container['metaDescription'];
    }

    /**
     * Sets metaDescription
     *
     * @param string|null $metaDescription metaDescription
     *
     * @return self
     */
    public function setMetaDescription($metaDescription)
    {
        if (is_null($metaDescription)) {
            array_push($this->openAPINullablesSetToNull, 'metaDescription');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('metaDescription', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['metaDescription'] = $metaDescription;

        return $this;
    }

    /**
     * Gets metaKeywords
     *
     * @return string|null
     */
    public function getMetaKeywords()
    {
        return $this->container['metaKeywords'];
    }

    /**
     * Sets metaKeywords
     *
     * @param string|null $metaKeywords metaKeywords
     *
     * @return self
     */
    public function setMetaKeywords($metaKeywords)
    {
        if (is_null($metaKeywords)) {
            array_push($this->openAPINullablesSetToNull, 'metaKeywords');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('metaKeywords', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['metaKeywords'] = $metaKeywords;

        return $this;
    }

    /**
     * Gets metaTitle
     *
     * @return string|null
     */
    public function getMetaTitle()
    {
        return $this->container['metaTitle'];
    }

    /**
     * Sets metaTitle
     *
     * @param string|null $metaTitle metaTitle
     *
     * @return self
     */
    public function setMetaTitle($metaTitle)
    {
        if (is_null($metaTitle)) {
            array_push($this->openAPINullablesSetToNull, 'metaTitle');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('metaTitle', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['metaTitle'] = $metaTitle;

        return $this;
    }

    /**
     * Gets totalProductStock
     *
     * @return int|null
     */
    public function getTotalProductStock()
    {
        return $this->container['totalProductStock'];
    }

    /**
     * Sets totalProductStock
     *
     * @param int|null $totalProductStock totalProductStock
     *
     * @return self
     */
    public function setTotalProductStock($totalProductStock)
    {
        if (is_null($totalProductStock)) {
            throw new \InvalidArgumentException('non-nullable totalProductStock cannot be null');
        }
        $this->container['totalProductStock'] = $totalProductStock;

        return $this;
    }

    /**
     * Gets orderLocation
     *
     * @return int|null
     */
    public function getOrderLocation()
    {
        return $this->container['orderLocation'];
    }

    /**
     * Sets orderLocation
     *
     * @param int|null $orderLocation orderLocation
     *
     * @return self
     */
    public function setOrderLocation($orderLocation)
    {
        if (is_null($orderLocation)) {
            throw new \InvalidArgumentException('non-nullable orderLocation cannot be null');
        }
        $this->container['orderLocation'] = $orderLocation;

        return $this;
    }

    /**
     * Gets productImage1Id
     *
     * @return int|null
     */
    public function getProductImage1Id()
    {
        return $this->container['productImage1Id'];
    }

    /**
     * Sets productImage1Id
     *
     * @param int|null $productImage1Id productImage1Id
     *
     * @return self
     */
    public function setProductImage1Id($productImage1Id)
    {
        if (is_null($productImage1Id)) {
            array_push($this->openAPINullablesSetToNull, 'productImage1Id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('productImage1Id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['productImage1Id'] = $productImage1Id;

        return $this;
    }

    /**
     * Gets productImage2Id
     *
     * @return int|null
     */
    public function getProductImage2Id()
    {
        return $this->container['productImage2Id'];
    }

    /**
     * Sets productImage2Id
     *
     * @param int|null $productImage2Id productImage2Id
     *
     * @return self
     */
    public function setProductImage2Id($productImage2Id)
    {
        if (is_null($productImage2Id)) {
            array_push($this->openAPINullablesSetToNull, 'productImage2Id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('productImage2Id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['productImage2Id'] = $productImage2Id;

        return $this;
    }

    /**
     * Gets productImage3Id
     *
     * @return int|null
     */
    public function getProductImage3Id()
    {
        return $this->container['productImage3Id'];
    }

    /**
     * Sets productImage3Id
     *
     * @param int|null $productImage3Id productImage3Id
     *
     * @return self
     */
    public function setProductImage3Id($productImage3Id)
    {
        if (is_null($productImage3Id)) {
            array_push($this->openAPINullablesSetToNull, 'productImage3Id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('productImage3Id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['productImage3Id'] = $productImage3Id;

        return $this;
    }

    /**
     * Gets productImage4Id
     *
     * @return int|null
     */
    public function getProductImage4Id()
    {
        return $this->container['productImage4Id'];
    }

    /**
     * Sets productImage4Id
     *
     * @param int|null $productImage4Id productImage4Id
     *
     * @return self
     */
    public function setProductImage4Id($productImage4Id)
    {
        if (is_null($productImage4Id)) {
            array_push($this->openAPINullablesSetToNull, 'productImage4Id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('productImage4Id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['productImage4Id'] = $productImage4Id;

        return $this;
    }

    /**
     * Gets productImage5Id
     *
     * @return int|null
     */
    public function getProductImage5Id()
    {
        return $this->container['productImage5Id'];
    }

    /**
     * Sets productImage5Id
     *
     * @param int|null $productImage5Id productImage5Id
     *
     * @return self
     */
    public function setProductImage5Id($productImage5Id)
    {
        if (is_null($productImage5Id)) {
            array_push($this->openAPINullablesSetToNull, 'productImage5Id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('productImage5Id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['productImage5Id'] = $productImage5Id;

        return $this;
    }

    /**
     * Gets parentProductId
     *
     * @return int|null
     */
    public function getParentProductId()
    {
        return $this->container['parentProductId'];
    }

    /**
     * Sets parentProductId
     *
     * @param int|null $parentProductId parentProductId
     *
     * @return self
     */
    public function setParentProductId($parentProductId)
    {
        if (is_null($parentProductId)) {
            array_push($this->openAPINullablesSetToNull, 'parentProductId');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('parentProductId', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['parentProductId'] = $parentProductId;

        return $this;
    }

    /**
     * Gets seoFriendlyUrl
     *
     * @return string|null
     */
    public function getSeoFriendlyUrl()
    {
        return $this->container['seoFriendlyUrl'];
    }

    /**
     * Sets seoFriendlyUrl
     *
     * @param string|null $seoFriendlyUrl seoFriendlyUrl
     *
     * @return self
     */
    public function setSeoFriendlyUrl($seoFriendlyUrl)
    {
        if (is_null($seoFriendlyUrl)) {
            array_push($this->openAPINullablesSetToNull, 'seoFriendlyUrl');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('seoFriendlyUrl', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['seoFriendlyUrl'] = $seoFriendlyUrl;

        return $this;
    }

    /**
     * Gets variantIds
     *
     * @return int[]|null
     */
    public function getVariantIds()
    {
        return $this->container['variantIds'];
    }

    /**
     * Sets variantIds
     *
     * @param int[]|null $variantIds variantIds
     *
     * @return self
     */
    public function setVariantIds($variantIds)
    {
        if (is_null($variantIds)) {
            array_push($this->openAPINullablesSetToNull, 'variantIds');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('variantIds', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['variantIds'] = $variantIds;

        return $this;
    }

    /**
     * Gets optionIds
     *
     * @return int[]|null
     */
    public function getOptionIds()
    {
        return $this->container['optionIds'];
    }

    /**
     * Sets optionIds
     *
     * @param int[]|null $optionIds optionIds
     *
     * @return self
     */
    public function setOptionIds($optionIds)
    {
        if (is_null($optionIds)) {
            array_push($this->openAPINullablesSetToNull, 'optionIds');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('optionIds', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['optionIds'] = $optionIds;

        return $this;
    }

    /**
     * Gets categoryIds
     *
     * @return int[]|null
     */
    public function getCategoryIds()
    {
        return $this->container['categoryIds'];
    }

    /**
     * Sets categoryIds
     *
     * @param int[]|null $categoryIds categoryIds
     *
     * @return self
     */
    public function setCategoryIds($categoryIds)
    {
        if (is_null($categoryIds)) {
            array_push($this->openAPINullablesSetToNull, 'categoryIds');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('categoryIds', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['categoryIds'] = $categoryIds;

        return $this;
    }

    /**
     * Gets variantCombinationIds
     *
     * @return int[]|null
     */
    public function getVariantCombinationIds()
    {
        return $this->container['variantCombinationIds'];
    }

    /**
     * Sets variantCombinationIds
     *
     * @param int[]|null $variantCombinationIds variantCombinationIds
     *
     * @return self
     */
    public function setVariantCombinationIds($variantCombinationIds)
    {
        if (is_null($variantCombinationIds)) {
            array_push($this->openAPINullablesSetToNull, 'variantCombinationIds');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('variantCombinationIds', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['variantCombinationIds'] = $variantCombinationIds;

        return $this;
    }

    /**
     * Gets attributeItemIds
     *
     * @return int[]|null
     */
    public function getAttributeItemIds()
    {
        return $this->container['attributeItemIds'];
    }

    /**
     * Sets attributeItemIds
     *
     * @param int[]|null $attributeItemIds attributeItemIds
     *
     * @return self
     */
    public function setAttributeItemIds($attributeItemIds)
    {
        if (is_null($attributeItemIds)) {
            array_push($this->openAPINullablesSetToNull, 'attributeItemIds');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('attributeItemIds', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['attributeItemIds'] = $attributeItemIds;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


