<?php
/**
 * TempestModelsShopsOrdersV2Order
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  EKMv2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * EKM Partner API
 *
 * Our new API allows partners to build significantly better integrations with the EKM platform.    To try out the below endpoints, or for full up to date representations of the request / response models, please see the [swagger page](https://api.ekm.net/swagger/index.html). (We display examples here, but the swagger page is guaranteed to show the complete model.)    To keep up to date with the latest updates, please see our [RSS feed](https://partners.ekm.net/ChangeLog/Feed) or the [partner dashboard](https://partners.ekm.net/).
 *
 * The version of the OpenAPI document: v2
 * Contact: api-support@ekm.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace EKMv2\Model;

use \ArrayAccess;
use \EKMv2\ObjectSerializer;

/**
 * TempestModelsShopsOrdersV2Order Class Doc Comment
 *
 * @category Class
 * @package  EKMv2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class TempestModelsShopsOrdersV2Order implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Tempest.Models.Shops.Orders.V2.Order';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'int',
        'orderNumber' => 'string',
        'orderDate' => '\DateTime',
        'isConfirmed' => 'bool',
        'subTotal' => 'float',
        'totalDelivery' => 'float',
        'totalTax' => 'float',
        'totalCost' => 'float',
        'status' => 'string',
        'paymentStatus' => 'string',
        'deliveryMethod' => 'string',
        'transactionId' => 'string',
        'transactionStatus' => 'string',
        'orderType' => 'string',
        'useShippingAddress' => 'bool',
        'shippingAddress' => '\EKMv2\Model\TempestModelsShopsOrdersV1ShippingAddress',
        'internalNotes' => 'string',
        'customerFacingNotes' => 'string',
        'emailed' => 'bool',
        'discounts' => 'string',
        'discountsTotal' => 'float',
        'shippingCompany' => 'string',
        'ipAddress' => 'string',
        'guid' => 'string',
        'lastUpdated' => '\DateTime',
        'deliveryTaxRate' => 'float',
        'deliveryIncludesTax' => 'int',
        'customFieldsTotal' => 'float',
        'customFieldsTaxTotal' => 'float',
        'customerDetails' => '\EKMv2\Model\TempestModelsShopsOrdersV1OrderCustomerDetails',
        'customFields' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => 'int64',
        'orderNumber' => null,
        'orderDate' => 'date-time',
        'isConfirmed' => null,
        'subTotal' => 'double',
        'totalDelivery' => 'double',
        'totalTax' => 'double',
        'totalCost' => 'double',
        'status' => null,
        'paymentStatus' => null,
        'deliveryMethod' => null,
        'transactionId' => null,
        'transactionStatus' => null,
        'orderType' => null,
        'useShippingAddress' => null,
        'shippingAddress' => null,
        'internalNotes' => null,
        'customerFacingNotes' => null,
        'emailed' => null,
        'discounts' => null,
        'discountsTotal' => 'double',
        'shippingCompany' => null,
        'ipAddress' => null,
        'guid' => 'uuid',
        'lastUpdated' => 'date-time',
        'deliveryTaxRate' => 'double',
        'deliveryIncludesTax' => 'int32',
        'customFieldsTotal' => 'double',
        'customFieldsTaxTotal' => 'double',
        'customerDetails' => null,
        'customFields' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'id' => false,
        'orderNumber' => true,
        'orderDate' => false,
        'isConfirmed' => false,
        'subTotal' => false,
        'totalDelivery' => false,
        'totalTax' => false,
        'totalCost' => false,
        'status' => true,
        'paymentStatus' => true,
        'deliveryMethod' => true,
        'transactionId' => true,
        'transactionStatus' => true,
        'orderType' => true,
        'useShippingAddress' => false,
        'shippingAddress' => false,
        'internalNotes' => true,
        'customerFacingNotes' => true,
        'emailed' => false,
        'discounts' => true,
        'discountsTotal' => false,
        'shippingCompany' => true,
        'ipAddress' => true,
        'guid' => false,
        'lastUpdated' => true,
        'deliveryTaxRate' => true,
        'deliveryIncludesTax' => true,
        'customFieldsTotal' => true,
        'customFieldsTaxTotal' => true,
        'customerDetails' => false,
        'customFields' => true
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'orderNumber' => 'order_number',
        'orderDate' => 'order_date',
        'isConfirmed' => 'is_confirmed',
        'subTotal' => 'sub_total',
        'totalDelivery' => 'total_delivery',
        'totalTax' => 'total_tax',
        'totalCost' => 'total_cost',
        'status' => 'status',
        'paymentStatus' => 'payment_status',
        'deliveryMethod' => 'delivery_method',
        'transactionId' => 'transaction_id',
        'transactionStatus' => 'transaction_status',
        'orderType' => 'order_type',
        'useShippingAddress' => 'use_shipping_address',
        'shippingAddress' => 'shipping_address',
        'internalNotes' => 'internal_notes',
        'customerFacingNotes' => 'customer_facing_notes',
        'emailed' => 'emailed',
        'discounts' => 'discounts',
        'discountsTotal' => 'discounts_total',
        'shippingCompany' => 'shipping_company',
        'ipAddress' => 'ip_address',
        'guid' => 'guid',
        'lastUpdated' => 'last_updated',
        'deliveryTaxRate' => 'delivery_tax_rate',
        'deliveryIncludesTax' => 'delivery_includes_tax',
        'customFieldsTotal' => 'custom_fields_total',
        'customFieldsTaxTotal' => 'custom_fields_tax_total',
        'customerDetails' => 'customer_details',
        'customFields' => 'custom_fields'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'orderNumber' => 'setOrderNumber',
        'orderDate' => 'setOrderDate',
        'isConfirmed' => 'setIsConfirmed',
        'subTotal' => 'setSubTotal',
        'totalDelivery' => 'setTotalDelivery',
        'totalTax' => 'setTotalTax',
        'totalCost' => 'setTotalCost',
        'status' => 'setStatus',
        'paymentStatus' => 'setPaymentStatus',
        'deliveryMethod' => 'setDeliveryMethod',
        'transactionId' => 'setTransactionId',
        'transactionStatus' => 'setTransactionStatus',
        'orderType' => 'setOrderType',
        'useShippingAddress' => 'setUseShippingAddress',
        'shippingAddress' => 'setShippingAddress',
        'internalNotes' => 'setInternalNotes',
        'customerFacingNotes' => 'setCustomerFacingNotes',
        'emailed' => 'setEmailed',
        'discounts' => 'setDiscounts',
        'discountsTotal' => 'setDiscountsTotal',
        'shippingCompany' => 'setShippingCompany',
        'ipAddress' => 'setIpAddress',
        'guid' => 'setGuid',
        'lastUpdated' => 'setLastUpdated',
        'deliveryTaxRate' => 'setDeliveryTaxRate',
        'deliveryIncludesTax' => 'setDeliveryIncludesTax',
        'customFieldsTotal' => 'setCustomFieldsTotal',
        'customFieldsTaxTotal' => 'setCustomFieldsTaxTotal',
        'customerDetails' => 'setCustomerDetails',
        'customFields' => 'setCustomFields'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'orderNumber' => 'getOrderNumber',
        'orderDate' => 'getOrderDate',
        'isConfirmed' => 'getIsConfirmed',
        'subTotal' => 'getSubTotal',
        'totalDelivery' => 'getTotalDelivery',
        'totalTax' => 'getTotalTax',
        'totalCost' => 'getTotalCost',
        'status' => 'getStatus',
        'paymentStatus' => 'getPaymentStatus',
        'deliveryMethod' => 'getDeliveryMethod',
        'transactionId' => 'getTransactionId',
        'transactionStatus' => 'getTransactionStatus',
        'orderType' => 'getOrderType',
        'useShippingAddress' => 'getUseShippingAddress',
        'shippingAddress' => 'getShippingAddress',
        'internalNotes' => 'getInternalNotes',
        'customerFacingNotes' => 'getCustomerFacingNotes',
        'emailed' => 'getEmailed',
        'discounts' => 'getDiscounts',
        'discountsTotal' => 'getDiscountsTotal',
        'shippingCompany' => 'getShippingCompany',
        'ipAddress' => 'getIpAddress',
        'guid' => 'getGuid',
        'lastUpdated' => 'getLastUpdated',
        'deliveryTaxRate' => 'getDeliveryTaxRate',
        'deliveryIncludesTax' => 'getDeliveryIncludesTax',
        'customFieldsTotal' => 'getCustomFieldsTotal',
        'customFieldsTaxTotal' => 'getCustomFieldsTaxTotal',
        'customerDetails' => 'getCustomerDetails',
        'customFields' => 'getCustomFields'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('orderNumber', $data ?? [], null);
        $this->setIfExists('orderDate', $data ?? [], null);
        $this->setIfExists('isConfirmed', $data ?? [], null);
        $this->setIfExists('subTotal', $data ?? [], null);
        $this->setIfExists('totalDelivery', $data ?? [], null);
        $this->setIfExists('totalTax', $data ?? [], null);
        $this->setIfExists('totalCost', $data ?? [], null);
        $this->setIfExists('status', $data ?? [], null);
        $this->setIfExists('paymentStatus', $data ?? [], null);
        $this->setIfExists('deliveryMethod', $data ?? [], null);
        $this->setIfExists('transactionId', $data ?? [], null);
        $this->setIfExists('transactionStatus', $data ?? [], null);
        $this->setIfExists('orderType', $data ?? [], null);
        $this->setIfExists('useShippingAddress', $data ?? [], null);
        $this->setIfExists('shippingAddress', $data ?? [], null);
        $this->setIfExists('internalNotes', $data ?? [], null);
        $this->setIfExists('customerFacingNotes', $data ?? [], null);
        $this->setIfExists('emailed', $data ?? [], null);
        $this->setIfExists('discounts', $data ?? [], null);
        $this->setIfExists('discountsTotal', $data ?? [], null);
        $this->setIfExists('shippingCompany', $data ?? [], null);
        $this->setIfExists('ipAddress', $data ?? [], null);
        $this->setIfExists('guid', $data ?? [], null);
        $this->setIfExists('lastUpdated', $data ?? [], null);
        $this->setIfExists('deliveryTaxRate', $data ?? [], null);
        $this->setIfExists('deliveryIncludesTax', $data ?? [], null);
        $this->setIfExists('customFieldsTotal', $data ?? [], null);
        $this->setIfExists('customFieldsTaxTotal', $data ?? [], null);
        $this->setIfExists('customerDetails', $data ?? [], null);
        $this->setIfExists('customFields', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['id'] === null) {
            $invalidProperties[] = "'id' can't be null";
        }
        if ($this->container['orderNumber'] === null) {
            $invalidProperties[] = "'orderNumber' can't be null";
        }
        if ($this->container['orderDate'] === null) {
            $invalidProperties[] = "'orderDate' can't be null";
        }
        if ($this->container['isConfirmed'] === null) {
            $invalidProperties[] = "'isConfirmed' can't be null";
        }
        if ($this->container['subTotal'] === null) {
            $invalidProperties[] = "'subTotal' can't be null";
        }
        if ($this->container['totalDelivery'] === null) {
            $invalidProperties[] = "'totalDelivery' can't be null";
        }
        if ($this->container['totalTax'] === null) {
            $invalidProperties[] = "'totalTax' can't be null";
        }
        if ($this->container['totalCost'] === null) {
            $invalidProperties[] = "'totalCost' can't be null";
        }
        if ($this->container['status'] === null) {
            $invalidProperties[] = "'status' can't be null";
        }
        if ($this->container['deliveryMethod'] === null) {
            $invalidProperties[] = "'deliveryMethod' can't be null";
        }
        if ($this->container['transactionId'] === null) {
            $invalidProperties[] = "'transactionId' can't be null";
        }
        if ($this->container['transactionStatus'] === null) {
            $invalidProperties[] = "'transactionStatus' can't be null";
        }
        if ($this->container['orderType'] === null) {
            $invalidProperties[] = "'orderType' can't be null";
        }
        if ($this->container['useShippingAddress'] === null) {
            $invalidProperties[] = "'useShippingAddress' can't be null";
        }
        if ($this->container['shippingAddress'] === null) {
            $invalidProperties[] = "'shippingAddress' can't be null";
        }
        if ($this->container['internalNotes'] === null) {
            $invalidProperties[] = "'internalNotes' can't be null";
        }
        if ($this->container['customerFacingNotes'] === null) {
            $invalidProperties[] = "'customerFacingNotes' can't be null";
        }
        if ($this->container['emailed'] === null) {
            $invalidProperties[] = "'emailed' can't be null";
        }
        if ($this->container['discounts'] === null) {
            $invalidProperties[] = "'discounts' can't be null";
        }
        if ($this->container['discountsTotal'] === null) {
            $invalidProperties[] = "'discountsTotal' can't be null";
        }
        if ($this->container['shippingCompany'] === null) {
            $invalidProperties[] = "'shippingCompany' can't be null";
        }
        if ($this->container['ipAddress'] === null) {
            $invalidProperties[] = "'ipAddress' can't be null";
        }
        if ($this->container['guid'] === null) {
            $invalidProperties[] = "'guid' can't be null";
        }
        if ($this->container['deliveryIncludesTax'] === null) {
            $invalidProperties[] = "'deliveryIncludesTax' can't be null";
        }
        if ($this->container['customFieldsTotal'] === null) {
            $invalidProperties[] = "'customFieldsTotal' can't be null";
        }
        if ($this->container['customFieldsTaxTotal'] === null) {
            $invalidProperties[] = "'customFieldsTaxTotal' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return int
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int $id id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets orderNumber
     *
     * @return string
     */
    public function getOrderNumber()
    {
        return $this->container['orderNumber'];
    }

    /**
     * Sets orderNumber
     *
     * @param string $orderNumber orderNumber
     *
     * @return self
     */
    public function setOrderNumber($orderNumber)
    {
        if (is_null($orderNumber)) {
            array_push($this->openAPINullablesSetToNull, 'orderNumber');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('orderNumber', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['orderNumber'] = $orderNumber;

        return $this;
    }

    /**
     * Gets orderDate
     *
     * @return \DateTime
     */
    public function getOrderDate()
    {
        return $this->container['orderDate'];
    }

    /**
     * Sets orderDate
     *
     * @param \DateTime $orderDate orderDate
     *
     * @return self
     */
    public function setOrderDate($orderDate)
    {
        if (is_null($orderDate)) {
            throw new \InvalidArgumentException('non-nullable orderDate cannot be null');
        }
        $this->container['orderDate'] = $orderDate;

        return $this;
    }

    /**
     * Gets isConfirmed
     *
     * @return bool
     */
    public function getIsConfirmed()
    {
        return $this->container['isConfirmed'];
    }

    /**
     * Sets isConfirmed
     *
     * @param bool $isConfirmed isConfirmed
     *
     * @return self
     */
    public function setIsConfirmed($isConfirmed)
    {
        if (is_null($isConfirmed)) {
            throw new \InvalidArgumentException('non-nullable isConfirmed cannot be null');
        }
        $this->container['isConfirmed'] = $isConfirmed;

        return $this;
    }

    /**
     * Gets subTotal
     *
     * @return float
     */
    public function getSubTotal()
    {
        return $this->container['subTotal'];
    }

    /**
     * Sets subTotal
     *
     * @param float $subTotal subTotal
     *
     * @return self
     */
    public function setSubTotal($subTotal)
    {
        if (is_null($subTotal)) {
            throw new \InvalidArgumentException('non-nullable subTotal cannot be null');
        }
        $this->container['subTotal'] = $subTotal;

        return $this;
    }

    /**
     * Gets totalDelivery
     *
     * @return float
     */
    public function getTotalDelivery()
    {
        return $this->container['totalDelivery'];
    }

    /**
     * Sets totalDelivery
     *
     * @param float $totalDelivery totalDelivery
     *
     * @return self
     */
    public function setTotalDelivery($totalDelivery)
    {
        if (is_null($totalDelivery)) {
            throw new \InvalidArgumentException('non-nullable totalDelivery cannot be null');
        }
        $this->container['totalDelivery'] = $totalDelivery;

        return $this;
    }

    /**
     * Gets totalTax
     *
     * @return float
     */
    public function getTotalTax()
    {
        return $this->container['totalTax'];
    }

    /**
     * Sets totalTax
     *
     * @param float $totalTax totalTax
     *
     * @return self
     */
    public function setTotalTax($totalTax)
    {
        if (is_null($totalTax)) {
            throw new \InvalidArgumentException('non-nullable totalTax cannot be null');
        }
        $this->container['totalTax'] = $totalTax;

        return $this;
    }

    /**
     * Gets totalCost
     *
     * @return float
     */
    public function getTotalCost()
    {
        return $this->container['totalCost'];
    }

    /**
     * Sets totalCost
     *
     * @param float $totalCost totalCost
     *
     * @return self
     */
    public function setTotalCost($totalCost)
    {
        if (is_null($totalCost)) {
            throw new \InvalidArgumentException('non-nullable totalCost cannot be null');
        }
        $this->container['totalCost'] = $totalCost;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string $status status
     *
     * @return self
     */
    public function setStatus($status)
    {
        if (is_null($status)) {
            array_push($this->openAPINullablesSetToNull, 'status');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('status', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets paymentStatus
     *
     * @return string|null
     */
    public function getPaymentStatus()
    {
        return $this->container['paymentStatus'];
    }

    /**
     * Sets paymentStatus
     *
     * @param string|null $paymentStatus paymentStatus
     *
     * @return self
     */
    public function setPaymentStatus($paymentStatus)
    {
        if (is_null($paymentStatus)) {
            array_push($this->openAPINullablesSetToNull, 'paymentStatus');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('paymentStatus', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['paymentStatus'] = $paymentStatus;

        return $this;
    }

    /**
     * Gets deliveryMethod
     *
     * @return string
     */
    public function getDeliveryMethod()
    {
        return $this->container['deliveryMethod'];
    }

    /**
     * Sets deliveryMethod
     *
     * @param string $deliveryMethod deliveryMethod
     *
     * @return self
     */
    public function setDeliveryMethod($deliveryMethod)
    {
        if (is_null($deliveryMethod)) {
            array_push($this->openAPINullablesSetToNull, 'deliveryMethod');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('deliveryMethod', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['deliveryMethod'] = $deliveryMethod;

        return $this;
    }

    /**
     * Gets transactionId
     *
     * @return string
     */
    public function getTransactionId()
    {
        return $this->container['transactionId'];
    }

    /**
     * Sets transactionId
     *
     * @param string $transactionId transactionId
     *
     * @return self
     */
    public function setTransactionId($transactionId)
    {
        if (is_null($transactionId)) {
            array_push($this->openAPINullablesSetToNull, 'transactionId');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('transactionId', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['transactionId'] = $transactionId;

        return $this;
    }

    /**
     * Gets transactionStatus
     *
     * @return string
     */
    public function getTransactionStatus()
    {
        return $this->container['transactionStatus'];
    }

    /**
     * Sets transactionStatus
     *
     * @param string $transactionStatus transactionStatus
     *
     * @return self
     */
    public function setTransactionStatus($transactionStatus)
    {
        if (is_null($transactionStatus)) {
            array_push($this->openAPINullablesSetToNull, 'transactionStatus');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('transactionStatus', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['transactionStatus'] = $transactionStatus;

        return $this;
    }

    /**
     * Gets orderType
     *
     * @return string
     */
    public function getOrderType()
    {
        return $this->container['orderType'];
    }

    /**
     * Sets orderType
     *
     * @param string $orderType orderType
     *
     * @return self
     */
    public function setOrderType($orderType)
    {
        if (is_null($orderType)) {
            array_push($this->openAPINullablesSetToNull, 'orderType');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('orderType', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['orderType'] = $orderType;

        return $this;
    }

    /**
     * Gets useShippingAddress
     *
     * @return bool
     */
    public function getUseShippingAddress()
    {
        return $this->container['useShippingAddress'];
    }

    /**
     * Sets useShippingAddress
     *
     * @param bool $useShippingAddress useShippingAddress
     *
     * @return self
     */
    public function setUseShippingAddress($useShippingAddress)
    {
        if (is_null($useShippingAddress)) {
            throw new \InvalidArgumentException('non-nullable useShippingAddress cannot be null');
        }
        $this->container['useShippingAddress'] = $useShippingAddress;

        return $this;
    }

    /**
     * Gets shippingAddress
     *
     * @return \EKMv2\Model\TempestModelsShopsOrdersV1ShippingAddress
     */
    public function getShippingAddress()
    {
        return $this->container['shippingAddress'];
    }

    /**
     * Sets shippingAddress
     *
     * @param \EKMv2\Model\TempestModelsShopsOrdersV1ShippingAddress $shippingAddress shippingAddress
     *
     * @return self
     */
    public function setShippingAddress($shippingAddress)
    {
        if (is_null($shippingAddress)) {
            throw new \InvalidArgumentException('non-nullable shippingAddress cannot be null');
        }
        $this->container['shippingAddress'] = $shippingAddress;

        return $this;
    }

    /**
     * Gets internalNotes
     *
     * @return string
     */
    public function getInternalNotes()
    {
        return $this->container['internalNotes'];
    }

    /**
     * Sets internalNotes
     *
     * @param string $internalNotes internalNotes
     *
     * @return self
     */
    public function setInternalNotes($internalNotes)
    {
        if (is_null($internalNotes)) {
            array_push($this->openAPINullablesSetToNull, 'internalNotes');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('internalNotes', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['internalNotes'] = $internalNotes;

        return $this;
    }

    /**
     * Gets customerFacingNotes
     *
     * @return string
     */
    public function getCustomerFacingNotes()
    {
        return $this->container['customerFacingNotes'];
    }

    /**
     * Sets customerFacingNotes
     *
     * @param string $customerFacingNotes customerFacingNotes
     *
     * @return self
     */
    public function setCustomerFacingNotes($customerFacingNotes)
    {
        if (is_null($customerFacingNotes)) {
            array_push($this->openAPINullablesSetToNull, 'customerFacingNotes');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('customerFacingNotes', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['customerFacingNotes'] = $customerFacingNotes;

        return $this;
    }

    /**
     * Gets emailed
     *
     * @return bool
     */
    public function getEmailed()
    {
        return $this->container['emailed'];
    }

    /**
     * Sets emailed
     *
     * @param bool $emailed emailed
     *
     * @return self
     */
    public function setEmailed($emailed)
    {
        if (is_null($emailed)) {
            throw new \InvalidArgumentException('non-nullable emailed cannot be null');
        }
        $this->container['emailed'] = $emailed;

        return $this;
    }

    /**
     * Gets discounts
     *
     * @return string
     */
    public function getDiscounts()
    {
        return $this->container['discounts'];
    }

    /**
     * Sets discounts
     *
     * @param string $discounts discounts
     *
     * @return self
     */
    public function setDiscounts($discounts)
    {
        if (is_null($discounts)) {
            array_push($this->openAPINullablesSetToNull, 'discounts');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('discounts', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['discounts'] = $discounts;

        return $this;
    }

    /**
     * Gets discountsTotal
     *
     * @return float
     */
    public function getDiscountsTotal()
    {
        return $this->container['discountsTotal'];
    }

    /**
     * Sets discountsTotal
     *
     * @param float $discountsTotal discountsTotal
     *
     * @return self
     */
    public function setDiscountsTotal($discountsTotal)
    {
        if (is_null($discountsTotal)) {
            throw new \InvalidArgumentException('non-nullable discountsTotal cannot be null');
        }
        $this->container['discountsTotal'] = $discountsTotal;

        return $this;
    }

    /**
     * Gets shippingCompany
     *
     * @return string
     */
    public function getShippingCompany()
    {
        return $this->container['shippingCompany'];
    }

    /**
     * Sets shippingCompany
     *
     * @param string $shippingCompany shippingCompany
     *
     * @return self
     */
    public function setShippingCompany($shippingCompany)
    {
        if (is_null($shippingCompany)) {
            array_push($this->openAPINullablesSetToNull, 'shippingCompany');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('shippingCompany', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['shippingCompany'] = $shippingCompany;

        return $this;
    }

    /**
     * Gets ipAddress
     *
     * @return string
     */
    public function getIpAddress()
    {
        return $this->container['ipAddress'];
    }

    /**
     * Sets ipAddress
     *
     * @param string $ipAddress ipAddress
     *
     * @return self
     */
    public function setIpAddress($ipAddress)
    {
        if (is_null($ipAddress)) {
            array_push($this->openAPINullablesSetToNull, 'ipAddress');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('ipAddress', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['ipAddress'] = $ipAddress;

        return $this;
    }

    /**
     * Gets guid
     *
     * @return string
     */
    public function getGuid()
    {
        return $this->container['guid'];
    }

    /**
     * Sets guid
     *
     * @param string $guid guid
     *
     * @return self
     */
    public function setGuid($guid)
    {
        if (is_null($guid)) {
            throw new \InvalidArgumentException('non-nullable guid cannot be null');
        }
        $this->container['guid'] = $guid;

        return $this;
    }

    /**
     * Gets lastUpdated
     *
     * @return \DateTime|null
     */
    public function getLastUpdated()
    {
        return $this->container['lastUpdated'];
    }

    /**
     * Sets lastUpdated
     *
     * @param \DateTime|null $lastUpdated lastUpdated
     *
     * @return self
     */
    public function setLastUpdated($lastUpdated)
    {
        if (is_null($lastUpdated)) {
            array_push($this->openAPINullablesSetToNull, 'lastUpdated');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('lastUpdated', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['lastUpdated'] = $lastUpdated;

        return $this;
    }

    /**
     * Gets deliveryTaxRate
     *
     * @return float|null
     */
    public function getDeliveryTaxRate()
    {
        return $this->container['deliveryTaxRate'];
    }

    /**
     * Sets deliveryTaxRate
     *
     * @param float|null $deliveryTaxRate deliveryTaxRate
     *
     * @return self
     */
    public function setDeliveryTaxRate($deliveryTaxRate)
    {
        if (is_null($deliveryTaxRate)) {
            array_push($this->openAPINullablesSetToNull, 'deliveryTaxRate');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('deliveryTaxRate', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['deliveryTaxRate'] = $deliveryTaxRate;

        return $this;
    }

    /**
     * Gets deliveryIncludesTax
     *
     * @return int
     */
    public function getDeliveryIncludesTax()
    {
        return $this->container['deliveryIncludesTax'];
    }

    /**
     * Sets deliveryIncludesTax
     *
     * @param int $deliveryIncludesTax deliveryIncludesTax
     *
     * @return self
     */
    public function setDeliveryIncludesTax($deliveryIncludesTax)
    {
        if (is_null($deliveryIncludesTax)) {
            array_push($this->openAPINullablesSetToNull, 'deliveryIncludesTax');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('deliveryIncludesTax', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['deliveryIncludesTax'] = $deliveryIncludesTax;

        return $this;
    }

    /**
     * Gets customFieldsTotal
     *
     * @return float
     */
    public function getCustomFieldsTotal()
    {
        return $this->container['customFieldsTotal'];
    }

    /**
     * Sets customFieldsTotal
     *
     * @param float $customFieldsTotal customFieldsTotal
     *
     * @return self
     */
    public function setCustomFieldsTotal($customFieldsTotal)
    {
        if (is_null($customFieldsTotal)) {
            array_push($this->openAPINullablesSetToNull, 'customFieldsTotal');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('customFieldsTotal', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['customFieldsTotal'] = $customFieldsTotal;

        return $this;
    }

    /**
     * Gets customFieldsTaxTotal
     *
     * @return float
     */
    public function getCustomFieldsTaxTotal()
    {
        return $this->container['customFieldsTaxTotal'];
    }

    /**
     * Sets customFieldsTaxTotal
     *
     * @param float $customFieldsTaxTotal customFieldsTaxTotal
     *
     * @return self
     */
    public function setCustomFieldsTaxTotal($customFieldsTaxTotal)
    {
        if (is_null($customFieldsTaxTotal)) {
            array_push($this->openAPINullablesSetToNull, 'customFieldsTaxTotal');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('customFieldsTaxTotal', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['customFieldsTaxTotal'] = $customFieldsTaxTotal;

        return $this;
    }

    /**
     * Gets customerDetails
     *
     * @return \EKMv2\Model\TempestModelsShopsOrdersV1OrderCustomerDetails|null
     */
    public function getCustomerDetails()
    {
        return $this->container['customerDetails'];
    }

    /**
     * Sets customerDetails
     *
     * @param \EKMv2\Model\TempestModelsShopsOrdersV1OrderCustomerDetails|null $customerDetails customerDetails
     *
     * @return self
     */
    public function setCustomerDetails($customerDetails)
    {
        if (is_null($customerDetails)) {
            throw new \InvalidArgumentException('non-nullable customerDetails cannot be null');
        }
        $this->container['customerDetails'] = $customerDetails;

        return $this;
    }

    /**
     * Gets customFields
     *
     * @return string|null
     */
    public function getCustomFields()
    {
        return $this->container['customFields'];
    }

    /**
     * Sets customFields
     *
     * @param string|null $customFields customFields
     *
     * @return self
     */
    public function setCustomFields($customFields)
    {
        if (is_null($customFields)) {
            array_push($this->openAPINullablesSetToNull, 'customFields');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('customFields', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['customFields'] = $customFields;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


