<?php
/**
 * WebhooksApi
 * PHP version 8.1
 *
 * @category Class
 * @package  EKMv2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * EKM Partner API
 *
 * Our new API allows partners to build significantly better integrations with the EKM platform.    To try out the below endpoints, or for full up to date representations of the request / response models, please see the [swagger page](https://api.ekm.net/swagger/index.html). (We display examples here, but the swagger page is guaranteed to show the complete model.)    To keep up to date with the latest updates, please see our [RSS feed](https://partners.ekm.net/ChangeLog/Feed) or the [partner dashboard](https://partners.ekm.net/).
 *
 * The version of the OpenAPI document: v2
 * Contact: api-support@ekm.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace EKMv2\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use EKMv2\ApiException;
use EKMv2\Configuration;
use EKMv2\FormDataProcessor;
use EKMv2\HeaderSelector;
use EKMv2\ObjectSerializer;

/**
 * WebhooksApi Class Doc Comment
 *
 * @category Class
 * @package  EKMv2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class WebhooksApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'apiV2WebhooksIdDelete' => [
            'application/json',
        ],
        'apiV2WebhooksIdGet' => [
            'application/json',
        ],
        'apiV2WebhooksPost' => [
            'application/json',
        ],
        'apiV2WebhooksPut' => [
            'application/json',
        ],
        'apiV2WebhooksWebhooksGet' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation apiV2WebhooksIdDelete
     *
     * Unsubscribe from a webhook
     *
     * @param  string $id The ID of the subscription to delete (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2WebhooksIdDelete'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function apiV2WebhooksIdDelete($id, string $contentType = self::contentTypes['apiV2WebhooksIdDelete'][0])
    {
        $this->apiV2WebhooksIdDeleteWithHttpInfo($id, $contentType);
    }

    /**
     * Operation apiV2WebhooksIdDeleteWithHttpInfo
     *
     * Unsubscribe from a webhook
     *
     * @param  string $id The ID of the subscription to delete (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2WebhooksIdDelete'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV2WebhooksIdDeleteWithHttpInfo($id, string $contentType = self::contentTypes['apiV2WebhooksIdDelete'][0])
    {
        $request = $this->apiV2WebhooksIdDeleteRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV2WebhooksIdDeleteAsync
     *
     * Unsubscribe from a webhook
     *
     * @param  string $id The ID of the subscription to delete (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2WebhooksIdDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2WebhooksIdDeleteAsync($id, string $contentType = self::contentTypes['apiV2WebhooksIdDelete'][0])
    {
        return $this->apiV2WebhooksIdDeleteAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV2WebhooksIdDeleteAsyncWithHttpInfo
     *
     * Unsubscribe from a webhook
     *
     * @param  string $id The ID of the subscription to delete (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2WebhooksIdDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2WebhooksIdDeleteAsyncWithHttpInfo($id, string $contentType = self::contentTypes['apiV2WebhooksIdDelete'][0])
    {
        $returnType = '';
        $request = $this->apiV2WebhooksIdDeleteRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV2WebhooksIdDelete'
     *
     * @param  string $id The ID of the subscription to delete (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2WebhooksIdDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV2WebhooksIdDeleteRequest($id, string $contentType = self::contentTypes['apiV2WebhooksIdDelete'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling apiV2WebhooksIdDelete'
            );
        }


        $resourcePath = '/api/v2/Webhooks/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV2WebhooksIdGet
     *
     * Get a specific subscription
     *
     * @param  string $id id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2WebhooksIdGet'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function apiV2WebhooksIdGet($id, string $contentType = self::contentTypes['apiV2WebhooksIdGet'][0])
    {
        $this->apiV2WebhooksIdGetWithHttpInfo($id, $contentType);
    }

    /**
     * Operation apiV2WebhooksIdGetWithHttpInfo
     *
     * Get a specific subscription
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2WebhooksIdGet'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV2WebhooksIdGetWithHttpInfo($id, string $contentType = self::contentTypes['apiV2WebhooksIdGet'][0])
    {
        $request = $this->apiV2WebhooksIdGetRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV2WebhooksIdGetAsync
     *
     * Get a specific subscription
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2WebhooksIdGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2WebhooksIdGetAsync($id, string $contentType = self::contentTypes['apiV2WebhooksIdGet'][0])
    {
        return $this->apiV2WebhooksIdGetAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV2WebhooksIdGetAsyncWithHttpInfo
     *
     * Get a specific subscription
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2WebhooksIdGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2WebhooksIdGetAsyncWithHttpInfo($id, string $contentType = self::contentTypes['apiV2WebhooksIdGet'][0])
    {
        $returnType = '';
        $request = $this->apiV2WebhooksIdGetRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV2WebhooksIdGet'
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2WebhooksIdGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV2WebhooksIdGetRequest($id, string $contentType = self::contentTypes['apiV2WebhooksIdGet'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling apiV2WebhooksIdGet'
            );
        }


        $resourcePath = '/api/v2/Webhooks/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV2WebhooksPost
     *
     * Update a webhook subscription
     *
     * @param  \EKMv2\Model\TempestModelsWebhooksV2UpdateWebhookSubscription|null $tempestModelsWebhooksV2UpdateWebhookSubscription The subscription to be updated (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2WebhooksPost'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function apiV2WebhooksPost($tempestModelsWebhooksV2UpdateWebhookSubscription = null, string $contentType = self::contentTypes['apiV2WebhooksPost'][0])
    {
        $this->apiV2WebhooksPostWithHttpInfo($tempestModelsWebhooksV2UpdateWebhookSubscription, $contentType);
    }

    /**
     * Operation apiV2WebhooksPostWithHttpInfo
     *
     * Update a webhook subscription
     *
     * @param  \EKMv2\Model\TempestModelsWebhooksV2UpdateWebhookSubscription|null $tempestModelsWebhooksV2UpdateWebhookSubscription The subscription to be updated (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2WebhooksPost'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV2WebhooksPostWithHttpInfo($tempestModelsWebhooksV2UpdateWebhookSubscription = null, string $contentType = self::contentTypes['apiV2WebhooksPost'][0])
    {
        $request = $this->apiV2WebhooksPostRequest($tempestModelsWebhooksV2UpdateWebhookSubscription, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV2WebhooksPostAsync
     *
     * Update a webhook subscription
     *
     * @param  \EKMv2\Model\TempestModelsWebhooksV2UpdateWebhookSubscription|null $tempestModelsWebhooksV2UpdateWebhookSubscription The subscription to be updated (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2WebhooksPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2WebhooksPostAsync($tempestModelsWebhooksV2UpdateWebhookSubscription = null, string $contentType = self::contentTypes['apiV2WebhooksPost'][0])
    {
        return $this->apiV2WebhooksPostAsyncWithHttpInfo($tempestModelsWebhooksV2UpdateWebhookSubscription, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV2WebhooksPostAsyncWithHttpInfo
     *
     * Update a webhook subscription
     *
     * @param  \EKMv2\Model\TempestModelsWebhooksV2UpdateWebhookSubscription|null $tempestModelsWebhooksV2UpdateWebhookSubscription The subscription to be updated (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2WebhooksPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2WebhooksPostAsyncWithHttpInfo($tempestModelsWebhooksV2UpdateWebhookSubscription = null, string $contentType = self::contentTypes['apiV2WebhooksPost'][0])
    {
        $returnType = '';
        $request = $this->apiV2WebhooksPostRequest($tempestModelsWebhooksV2UpdateWebhookSubscription, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV2WebhooksPost'
     *
     * @param  \EKMv2\Model\TempestModelsWebhooksV2UpdateWebhookSubscription|null $tempestModelsWebhooksV2UpdateWebhookSubscription The subscription to be updated (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2WebhooksPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV2WebhooksPostRequest($tempestModelsWebhooksV2UpdateWebhookSubscription = null, string $contentType = self::contentTypes['apiV2WebhooksPost'][0])
    {



        $resourcePath = '/api/v2/Webhooks';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($tempestModelsWebhooksV2UpdateWebhookSubscription)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($tempestModelsWebhooksV2UpdateWebhookSubscription));
            } else {
                $httpBody = $tempestModelsWebhooksV2UpdateWebhookSubscription;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV2WebhooksPut
     *
     * Create a webhook subscription
     *
     * @param  \EKMv2\Model\TempestModelsWebhooksV2AddWebhookSubscription|null $tempestModelsWebhooksV2AddWebhookSubscription The subscription to be added (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2WebhooksPut'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function apiV2WebhooksPut($tempestModelsWebhooksV2AddWebhookSubscription = null, string $contentType = self::contentTypes['apiV2WebhooksPut'][0])
    {
        $this->apiV2WebhooksPutWithHttpInfo($tempestModelsWebhooksV2AddWebhookSubscription, $contentType);
    }

    /**
     * Operation apiV2WebhooksPutWithHttpInfo
     *
     * Create a webhook subscription
     *
     * @param  \EKMv2\Model\TempestModelsWebhooksV2AddWebhookSubscription|null $tempestModelsWebhooksV2AddWebhookSubscription The subscription to be added (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2WebhooksPut'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV2WebhooksPutWithHttpInfo($tempestModelsWebhooksV2AddWebhookSubscription = null, string $contentType = self::contentTypes['apiV2WebhooksPut'][0])
    {
        $request = $this->apiV2WebhooksPutRequest($tempestModelsWebhooksV2AddWebhookSubscription, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV2WebhooksPutAsync
     *
     * Create a webhook subscription
     *
     * @param  \EKMv2\Model\TempestModelsWebhooksV2AddWebhookSubscription|null $tempestModelsWebhooksV2AddWebhookSubscription The subscription to be added (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2WebhooksPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2WebhooksPutAsync($tempestModelsWebhooksV2AddWebhookSubscription = null, string $contentType = self::contentTypes['apiV2WebhooksPut'][0])
    {
        return $this->apiV2WebhooksPutAsyncWithHttpInfo($tempestModelsWebhooksV2AddWebhookSubscription, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV2WebhooksPutAsyncWithHttpInfo
     *
     * Create a webhook subscription
     *
     * @param  \EKMv2\Model\TempestModelsWebhooksV2AddWebhookSubscription|null $tempestModelsWebhooksV2AddWebhookSubscription The subscription to be added (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2WebhooksPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2WebhooksPutAsyncWithHttpInfo($tempestModelsWebhooksV2AddWebhookSubscription = null, string $contentType = self::contentTypes['apiV2WebhooksPut'][0])
    {
        $returnType = '';
        $request = $this->apiV2WebhooksPutRequest($tempestModelsWebhooksV2AddWebhookSubscription, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV2WebhooksPut'
     *
     * @param  \EKMv2\Model\TempestModelsWebhooksV2AddWebhookSubscription|null $tempestModelsWebhooksV2AddWebhookSubscription The subscription to be added (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2WebhooksPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV2WebhooksPutRequest($tempestModelsWebhooksV2AddWebhookSubscription = null, string $contentType = self::contentTypes['apiV2WebhooksPut'][0])
    {



        $resourcePath = '/api/v2/Webhooks';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($tempestModelsWebhooksV2AddWebhookSubscription)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($tempestModelsWebhooksV2AddWebhookSubscription));
            } else {
                $httpBody = $tempestModelsWebhooksV2AddWebhookSubscription;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV2WebhooksWebhooksGet
     *
     * Get list of existing subscriptions
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2WebhooksWebhooksGet'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function apiV2WebhooksWebhooksGet(string $contentType = self::contentTypes['apiV2WebhooksWebhooksGet'][0])
    {
        $this->apiV2WebhooksWebhooksGetWithHttpInfo($contentType);
    }

    /**
     * Operation apiV2WebhooksWebhooksGetWithHttpInfo
     *
     * Get list of existing subscriptions
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2WebhooksWebhooksGet'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV2WebhooksWebhooksGetWithHttpInfo(string $contentType = self::contentTypes['apiV2WebhooksWebhooksGet'][0])
    {
        $request = $this->apiV2WebhooksWebhooksGetRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV2WebhooksWebhooksGetAsync
     *
     * Get list of existing subscriptions
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2WebhooksWebhooksGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2WebhooksWebhooksGetAsync(string $contentType = self::contentTypes['apiV2WebhooksWebhooksGet'][0])
    {
        return $this->apiV2WebhooksWebhooksGetAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV2WebhooksWebhooksGetAsyncWithHttpInfo
     *
     * Get list of existing subscriptions
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2WebhooksWebhooksGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2WebhooksWebhooksGetAsyncWithHttpInfo(string $contentType = self::contentTypes['apiV2WebhooksWebhooksGet'][0])
    {
        $returnType = '';
        $request = $this->apiV2WebhooksWebhooksGetRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV2WebhooksWebhooksGet'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2WebhooksWebhooksGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV2WebhooksWebhooksGetRequest(string $contentType = self::contentTypes['apiV2WebhooksWebhooksGet'][0])
    {


        $resourcePath = '/api/v2/Webhooks/webhooks';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
