<?php
/**
 * ProductVariantsApi
 * PHP version 8.1
 *
 * @category Class
 * @package  EKMv2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * EKM Partner API
 *
 * Our new API allows partners to build significantly better integrations with the EKM platform.    To try out the below endpoints, or for full up to date representations of the request / response models, please see the [swagger page](https://api.ekm.net/swagger/index.html). (We display examples here, but the swagger page is guaranteed to show the complete model.)    To keep up to date with the latest updates, please see our [RSS feed](https://partners.ekm.net/ChangeLog/Feed) or the [partner dashboard](https://partners.ekm.net/).
 *
 * The version of the OpenAPI document: v2
 * Contact: api-support@ekm.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace EKMv2\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use EKMv2\ApiException;
use EKMv2\Configuration;
use EKMv2\FormDataProcessor;
use EKMv2\HeaderSelector;
use EKMv2\ObjectSerializer;

/**
 * ProductVariantsApi Class Doc Comment
 *
 * @category Class
 * @package  EKMv2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ProductVariantsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'apiV2ProductsPidVariantCombinationsGet' => [
            'application/json',
        ],
        'apiV2ProductsPidVariantCombinationsSearchGet' => [
            'application/json',
        ],
        'apiV2ProductsPidVariantCombinationsVcidGet' => [
            'application/json',
        ],
        'apiV2ProductsPidVariantCombinationsVcidImagesGet' => [
            'application/json',
        ],
        'apiV2ProductsPidVariantCombinationsVcidImagesImageNumberPost' => [
            'application/json',
        ],
        'apiV2ProductsPidVariantCombinationsVcidPut' => [
            'application/json',
        ],
        'apiV2ProductsPidVariantsGet' => [
            'application/json',
        ],
        'apiV2ProductsPidVariantsPost' => [
            'application/json',
        ],
        'apiV2ProductsPidVariantsVidChoicesGet' => [
            'application/json',
        ],
        'apiV2ProductsPidVariantsVidChoicesPost' => [
            'application/json',
        ],
        'apiV2ProductsPidVariantsVidChoicesVcidDelete' => [
            'application/json',
        ],
        'apiV2ProductsPidVariantsVidChoicesVcidGet' => [
            'application/json',
        ],
        'apiV2ProductsPidVariantsVidChoicesVcidPut' => [
            'application/json',
        ],
        'apiV2ProductsPidVariantsVidDelete' => [
            'application/json',
        ],
        'apiV2ProductsPidVariantsVidGet' => [
            'application/json',
        ],
        'apiV2ProductsPidVariantsVidPut' => [
            'application/json',
        ],
        'apiV2ProductsVariantCombinationsSearchGet' => [
            'application/json',
        ],
        'apiV2ProductsVariantsChoicesIdGet' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation apiV2ProductsPidVariantCombinationsGet
     *
     * Get the variant combinations associated with a parent product
     *
     * @param  int $pid The ID of the product that the variant combinations are children of (required)
     * @param  int|null $page Page number to display (optional)
     * @param  int|null $limit Items per page (maximum 20) (optional)
     * @param  string|null $orderby Field to order results. Prefix with a - (dash) for descending e.g. -id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantCombinationsGet'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV2VariantCombination|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError
     */
    public function apiV2ProductsPidVariantCombinationsGet($pid, $page = null, $limit = null, $orderby = null, string $contentType = self::contentTypes['apiV2ProductsPidVariantCombinationsGet'][0])
    {
        list($response) = $this->apiV2ProductsPidVariantCombinationsGetWithHttpInfo($pid, $page, $limit, $orderby, $contentType);
        return $response;
    }

    /**
     * Operation apiV2ProductsPidVariantCombinationsGetWithHttpInfo
     *
     * Get the variant combinations associated with a parent product
     *
     * @param  int $pid The ID of the product that the variant combinations are children of (required)
     * @param  int|null $page Page number to display (optional)
     * @param  int|null $limit Items per page (maximum 20) (optional)
     * @param  string|null $orderby Field to order results. Prefix with a - (dash) for descending e.g. -id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantCombinationsGet'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV2VariantCombination|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV2ProductsPidVariantCombinationsGetWithHttpInfo($pid, $page = null, $limit = null, $orderby = null, string $contentType = self::contentTypes['apiV2ProductsPidVariantCombinationsGet'][0])
    {
        $request = $this->apiV2ProductsPidVariantCombinationsGetRequest($pid, $page, $limit, $orderby, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV2VariantCombination',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV2VariantCombination',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV2VariantCombination',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV2ProductsPidVariantCombinationsGetAsync
     *
     * Get the variant combinations associated with a parent product
     *
     * @param  int $pid The ID of the product that the variant combinations are children of (required)
     * @param  int|null $page Page number to display (optional)
     * @param  int|null $limit Items per page (maximum 20) (optional)
     * @param  string|null $orderby Field to order results. Prefix with a - (dash) for descending e.g. -id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantCombinationsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2ProductsPidVariantCombinationsGetAsync($pid, $page = null, $limit = null, $orderby = null, string $contentType = self::contentTypes['apiV2ProductsPidVariantCombinationsGet'][0])
    {
        return $this->apiV2ProductsPidVariantCombinationsGetAsyncWithHttpInfo($pid, $page, $limit, $orderby, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV2ProductsPidVariantCombinationsGetAsyncWithHttpInfo
     *
     * Get the variant combinations associated with a parent product
     *
     * @param  int $pid The ID of the product that the variant combinations are children of (required)
     * @param  int|null $page Page number to display (optional)
     * @param  int|null $limit Items per page (maximum 20) (optional)
     * @param  string|null $orderby Field to order results. Prefix with a - (dash) for descending e.g. -id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantCombinationsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2ProductsPidVariantCombinationsGetAsyncWithHttpInfo($pid, $page = null, $limit = null, $orderby = null, string $contentType = self::contentTypes['apiV2ProductsPidVariantCombinationsGet'][0])
    {
        $returnType = '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV2VariantCombination';
        $request = $this->apiV2ProductsPidVariantCombinationsGetRequest($pid, $page, $limit, $orderby, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV2ProductsPidVariantCombinationsGet'
     *
     * @param  int $pid The ID of the product that the variant combinations are children of (required)
     * @param  int|null $page Page number to display (optional)
     * @param  int|null $limit Items per page (maximum 20) (optional)
     * @param  string|null $orderby Field to order results. Prefix with a - (dash) for descending e.g. -id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantCombinationsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV2ProductsPidVariantCombinationsGetRequest($pid, $page = null, $limit = null, $orderby = null, string $contentType = self::contentTypes['apiV2ProductsPidVariantCombinationsGet'][0])
    {

        // verify the required parameter 'pid' is set
        if ($pid === null || (is_array($pid) && count($pid) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pid when calling apiV2ProductsPidVariantCombinationsGet'
            );
        }





        $resourcePath = '/api/v2/products/{pid}/variant_combinations';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $orderby,
            'orderby', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($pid !== null) {
            $resourcePath = str_replace(
                '{' . 'pid' . '}',
                ObjectSerializer::toPathValue($pid),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV2ProductsPidVariantCombinationsSearchGet
     *
     * Search variants by parent product ID based on a given criteria
     *
     * @param  int $pid The ID of the product that the the variant combinations are a child of (required)
     * @param  int|null $page Page number to display (optional)
     * @param  int|null $limit Items per page (maximum 20) (optional)
     * @param  string|null $query A &lt;a href&#x3D;\&quot;#tag/OData\&quot; target&#x3D;\&quot;_blank\&quot;&gt;search&lt;/a&gt; query e.g. live eq true (optional)
     * @param  string|null $orderby Field to order results. Prefix with a - (dash) for descending e.g. -id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantCombinationsSearchGet'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV1ProductVariant|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV1ProductVariant
     */
    public function apiV2ProductsPidVariantCombinationsSearchGet($pid, $page = null, $limit = null, $query = null, $orderby = null, string $contentType = self::contentTypes['apiV2ProductsPidVariantCombinationsSearchGet'][0])
    {
        list($response) = $this->apiV2ProductsPidVariantCombinationsSearchGetWithHttpInfo($pid, $page, $limit, $query, $orderby, $contentType);
        return $response;
    }

    /**
     * Operation apiV2ProductsPidVariantCombinationsSearchGetWithHttpInfo
     *
     * Search variants by parent product ID based on a given criteria
     *
     * @param  int $pid The ID of the product that the the variant combinations are a child of (required)
     * @param  int|null $page Page number to display (optional)
     * @param  int|null $limit Items per page (maximum 20) (optional)
     * @param  string|null $query A &lt;a href&#x3D;\&quot;#tag/OData\&quot; target&#x3D;\&quot;_blank\&quot;&gt;search&lt;/a&gt; query e.g. live eq true (optional)
     * @param  string|null $orderby Field to order results. Prefix with a - (dash) for descending e.g. -id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantCombinationsSearchGet'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV1ProductVariant|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV1ProductVariant, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV2ProductsPidVariantCombinationsSearchGetWithHttpInfo($pid, $page = null, $limit = null, $query = null, $orderby = null, string $contentType = self::contentTypes['apiV2ProductsPidVariantCombinationsSearchGet'][0])
    {
        $request = $this->apiV2ProductsPidVariantCombinationsSearchGetRequest($pid, $page, $limit, $query, $orderby, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV1ProductVariant',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV1ProductVariant',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV1ProductVariant',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV1ProductVariant',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV1ProductVariant',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV2ProductsPidVariantCombinationsSearchGetAsync
     *
     * Search variants by parent product ID based on a given criteria
     *
     * @param  int $pid The ID of the product that the the variant combinations are a child of (required)
     * @param  int|null $page Page number to display (optional)
     * @param  int|null $limit Items per page (maximum 20) (optional)
     * @param  string|null $query A &lt;a href&#x3D;\&quot;#tag/OData\&quot; target&#x3D;\&quot;_blank\&quot;&gt;search&lt;/a&gt; query e.g. live eq true (optional)
     * @param  string|null $orderby Field to order results. Prefix with a - (dash) for descending e.g. -id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantCombinationsSearchGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2ProductsPidVariantCombinationsSearchGetAsync($pid, $page = null, $limit = null, $query = null, $orderby = null, string $contentType = self::contentTypes['apiV2ProductsPidVariantCombinationsSearchGet'][0])
    {
        return $this->apiV2ProductsPidVariantCombinationsSearchGetAsyncWithHttpInfo($pid, $page, $limit, $query, $orderby, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV2ProductsPidVariantCombinationsSearchGetAsyncWithHttpInfo
     *
     * Search variants by parent product ID based on a given criteria
     *
     * @param  int $pid The ID of the product that the the variant combinations are a child of (required)
     * @param  int|null $page Page number to display (optional)
     * @param  int|null $limit Items per page (maximum 20) (optional)
     * @param  string|null $query A &lt;a href&#x3D;\&quot;#tag/OData\&quot; target&#x3D;\&quot;_blank\&quot;&gt;search&lt;/a&gt; query e.g. live eq true (optional)
     * @param  string|null $orderby Field to order results. Prefix with a - (dash) for descending e.g. -id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantCombinationsSearchGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2ProductsPidVariantCombinationsSearchGetAsyncWithHttpInfo($pid, $page = null, $limit = null, $query = null, $orderby = null, string $contentType = self::contentTypes['apiV2ProductsPidVariantCombinationsSearchGet'][0])
    {
        $returnType = '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV1ProductVariant';
        $request = $this->apiV2ProductsPidVariantCombinationsSearchGetRequest($pid, $page, $limit, $query, $orderby, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV2ProductsPidVariantCombinationsSearchGet'
     *
     * @param  int $pid The ID of the product that the the variant combinations are a child of (required)
     * @param  int|null $page Page number to display (optional)
     * @param  int|null $limit Items per page (maximum 20) (optional)
     * @param  string|null $query A &lt;a href&#x3D;\&quot;#tag/OData\&quot; target&#x3D;\&quot;_blank\&quot;&gt;search&lt;/a&gt; query e.g. live eq true (optional)
     * @param  string|null $orderby Field to order results. Prefix with a - (dash) for descending e.g. -id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantCombinationsSearchGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV2ProductsPidVariantCombinationsSearchGetRequest($pid, $page = null, $limit = null, $query = null, $orderby = null, string $contentType = self::contentTypes['apiV2ProductsPidVariantCombinationsSearchGet'][0])
    {

        // verify the required parameter 'pid' is set
        if ($pid === null || (is_array($pid) && count($pid) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pid when calling apiV2ProductsPidVariantCombinationsSearchGet'
            );
        }






        $resourcePath = '/api/v2/products/{pid}/variant_combinations/search';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $query,
            'query', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $orderby,
            'orderby', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($pid !== null) {
            $resourcePath = str_replace(
                '{' . 'pid' . '}',
                ObjectSerializer::toPathValue($pid),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV2ProductsPidVariantCombinationsVcidGet
     *
     * Get a single variant combination associated with a parent product
     *
     * @param  int $pid The ID of the product that the the variant combination is a child of (required)
     * @param  int $vcid The variant combination ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantCombinationsVcidGet'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantCombination|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError
     */
    public function apiV2ProductsPidVariantCombinationsVcidGet($pid, $vcid, string $contentType = self::contentTypes['apiV2ProductsPidVariantCombinationsVcidGet'][0])
    {
        list($response) = $this->apiV2ProductsPidVariantCombinationsVcidGetWithHttpInfo($pid, $vcid, $contentType);
        return $response;
    }

    /**
     * Operation apiV2ProductsPidVariantCombinationsVcidGetWithHttpInfo
     *
     * Get a single variant combination associated with a parent product
     *
     * @param  int $pid The ID of the product that the the variant combination is a child of (required)
     * @param  int $vcid The variant combination ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantCombinationsVcidGet'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantCombination|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV2ProductsPidVariantCombinationsVcidGetWithHttpInfo($pid, $vcid, string $contentType = self::contentTypes['apiV2ProductsPidVariantCombinationsVcidGet'][0])
    {
        $request = $this->apiV2ProductsPidVariantCombinationsVcidGetRequest($pid, $vcid, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantCombination',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantCombination',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantCombination',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV2ProductsPidVariantCombinationsVcidGetAsync
     *
     * Get a single variant combination associated with a parent product
     *
     * @param  int $pid The ID of the product that the the variant combination is a child of (required)
     * @param  int $vcid The variant combination ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantCombinationsVcidGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2ProductsPidVariantCombinationsVcidGetAsync($pid, $vcid, string $contentType = self::contentTypes['apiV2ProductsPidVariantCombinationsVcidGet'][0])
    {
        return $this->apiV2ProductsPidVariantCombinationsVcidGetAsyncWithHttpInfo($pid, $vcid, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV2ProductsPidVariantCombinationsVcidGetAsyncWithHttpInfo
     *
     * Get a single variant combination associated with a parent product
     *
     * @param  int $pid The ID of the product that the the variant combination is a child of (required)
     * @param  int $vcid The variant combination ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantCombinationsVcidGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2ProductsPidVariantCombinationsVcidGetAsyncWithHttpInfo($pid, $vcid, string $contentType = self::contentTypes['apiV2ProductsPidVariantCombinationsVcidGet'][0])
    {
        $returnType = '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantCombination';
        $request = $this->apiV2ProductsPidVariantCombinationsVcidGetRequest($pid, $vcid, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV2ProductsPidVariantCombinationsVcidGet'
     *
     * @param  int $pid The ID of the product that the the variant combination is a child of (required)
     * @param  int $vcid The variant combination ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantCombinationsVcidGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV2ProductsPidVariantCombinationsVcidGetRequest($pid, $vcid, string $contentType = self::contentTypes['apiV2ProductsPidVariantCombinationsVcidGet'][0])
    {

        // verify the required parameter 'pid' is set
        if ($pid === null || (is_array($pid) && count($pid) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pid when calling apiV2ProductsPidVariantCombinationsVcidGet'
            );
        }

        // verify the required parameter 'vcid' is set
        if ($vcid === null || (is_array($vcid) && count($vcid) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $vcid when calling apiV2ProductsPidVariantCombinationsVcidGet'
            );
        }


        $resourcePath = '/api/v2/products/{pid}/variant_combinations/{vcid}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($pid !== null) {
            $resourcePath = str_replace(
                '{' . 'pid' . '}',
                ObjectSerializer::toPathValue($pid),
                $resourcePath
            );
        }
        // path params
        if ($vcid !== null) {
            $resourcePath = str_replace(
                '{' . 'vcid' . '}',
                ObjectSerializer::toPathValue($vcid),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV2ProductsPidVariantCombinationsVcidImagesGet
     *
     * Get a variant combination&#39;s images.
     *
     * @param  int $pid The product ID (required)
     * @param  int $vcid The variant combination ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantCombinationsVcidImagesGet'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV1ProductImages|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError
     */
    public function apiV2ProductsPidVariantCombinationsVcidImagesGet($pid, $vcid, string $contentType = self::contentTypes['apiV2ProductsPidVariantCombinationsVcidImagesGet'][0])
    {
        list($response) = $this->apiV2ProductsPidVariantCombinationsVcidImagesGetWithHttpInfo($pid, $vcid, $contentType);
        return $response;
    }

    /**
     * Operation apiV2ProductsPidVariantCombinationsVcidImagesGetWithHttpInfo
     *
     * Get a variant combination&#39;s images.
     *
     * @param  int $pid The product ID (required)
     * @param  int $vcid The variant combination ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantCombinationsVcidImagesGet'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV1ProductImages|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV2ProductsPidVariantCombinationsVcidImagesGetWithHttpInfo($pid, $vcid, string $contentType = self::contentTypes['apiV2ProductsPidVariantCombinationsVcidImagesGet'][0])
    {
        $request = $this->apiV2ProductsPidVariantCombinationsVcidImagesGetRequest($pid, $vcid, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV1ProductImages',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV1ProductImages',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV1ProductImages',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV2ProductsPidVariantCombinationsVcidImagesGetAsync
     *
     * Get a variant combination&#39;s images.
     *
     * @param  int $pid The product ID (required)
     * @param  int $vcid The variant combination ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantCombinationsVcidImagesGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2ProductsPidVariantCombinationsVcidImagesGetAsync($pid, $vcid, string $contentType = self::contentTypes['apiV2ProductsPidVariantCombinationsVcidImagesGet'][0])
    {
        return $this->apiV2ProductsPidVariantCombinationsVcidImagesGetAsyncWithHttpInfo($pid, $vcid, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV2ProductsPidVariantCombinationsVcidImagesGetAsyncWithHttpInfo
     *
     * Get a variant combination&#39;s images.
     *
     * @param  int $pid The product ID (required)
     * @param  int $vcid The variant combination ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantCombinationsVcidImagesGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2ProductsPidVariantCombinationsVcidImagesGetAsyncWithHttpInfo($pid, $vcid, string $contentType = self::contentTypes['apiV2ProductsPidVariantCombinationsVcidImagesGet'][0])
    {
        $returnType = '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV1ProductImages';
        $request = $this->apiV2ProductsPidVariantCombinationsVcidImagesGetRequest($pid, $vcid, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV2ProductsPidVariantCombinationsVcidImagesGet'
     *
     * @param  int $pid The product ID (required)
     * @param  int $vcid The variant combination ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantCombinationsVcidImagesGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV2ProductsPidVariantCombinationsVcidImagesGetRequest($pid, $vcid, string $contentType = self::contentTypes['apiV2ProductsPidVariantCombinationsVcidImagesGet'][0])
    {

        // verify the required parameter 'pid' is set
        if ($pid === null || (is_array($pid) && count($pid) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pid when calling apiV2ProductsPidVariantCombinationsVcidImagesGet'
            );
        }

        // verify the required parameter 'vcid' is set
        if ($vcid === null || (is_array($vcid) && count($vcid) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $vcid when calling apiV2ProductsPidVariantCombinationsVcidImagesGet'
            );
        }


        $resourcePath = '/api/v2/products/{pid}/variant_combinations/{vcid}/images';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($pid !== null) {
            $resourcePath = str_replace(
                '{' . 'pid' . '}',
                ObjectSerializer::toPathValue($pid),
                $resourcePath
            );
        }
        // path params
        if ($vcid !== null) {
            $resourcePath = str_replace(
                '{' . 'vcid' . '}',
                ObjectSerializer::toPathValue($vcid),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV2ProductsPidVariantCombinationsVcidImagesImageNumberPost
     *
     * Assign an image URL to a variant combination
     *
     * @param  int $pid The parent product ID that the variant combination is associated with (required)
     * @param  int $vcid The variant combination ID (required)
     * @param  int $imageNumber The image position that the URL will be assigned to (required)
     * @param  string $imageUrl The URL of the image to be assigned (required)
     * @param  int $id The product ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantCombinationsVcidImagesImageNumberPost'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV1ProductImages|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError
     */
    public function apiV2ProductsPidVariantCombinationsVcidImagesImageNumberPost($pid, $vcid, $imageNumber, $imageUrl, $id, string $contentType = self::contentTypes['apiV2ProductsPidVariantCombinationsVcidImagesImageNumberPost'][0])
    {
        list($response) = $this->apiV2ProductsPidVariantCombinationsVcidImagesImageNumberPostWithHttpInfo($pid, $vcid, $imageNumber, $imageUrl, $id, $contentType);
        return $response;
    }

    /**
     * Operation apiV2ProductsPidVariantCombinationsVcidImagesImageNumberPostWithHttpInfo
     *
     * Assign an image URL to a variant combination
     *
     * @param  int $pid The parent product ID that the variant combination is associated with (required)
     * @param  int $vcid The variant combination ID (required)
     * @param  int $imageNumber The image position that the URL will be assigned to (required)
     * @param  string $imageUrl The URL of the image to be assigned (required)
     * @param  int $id The product ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantCombinationsVcidImagesImageNumberPost'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV1ProductImages|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV2ProductsPidVariantCombinationsVcidImagesImageNumberPostWithHttpInfo($pid, $vcid, $imageNumber, $imageUrl, $id, string $contentType = self::contentTypes['apiV2ProductsPidVariantCombinationsVcidImagesImageNumberPost'][0])
    {
        $request = $this->apiV2ProductsPidVariantCombinationsVcidImagesImageNumberPostRequest($pid, $vcid, $imageNumber, $imageUrl, $id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV1ProductImages',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV1ProductImages',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV1ProductImages',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV2ProductsPidVariantCombinationsVcidImagesImageNumberPostAsync
     *
     * Assign an image URL to a variant combination
     *
     * @param  int $pid The parent product ID that the variant combination is associated with (required)
     * @param  int $vcid The variant combination ID (required)
     * @param  int $imageNumber The image position that the URL will be assigned to (required)
     * @param  string $imageUrl The URL of the image to be assigned (required)
     * @param  int $id The product ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantCombinationsVcidImagesImageNumberPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2ProductsPidVariantCombinationsVcidImagesImageNumberPostAsync($pid, $vcid, $imageNumber, $imageUrl, $id, string $contentType = self::contentTypes['apiV2ProductsPidVariantCombinationsVcidImagesImageNumberPost'][0])
    {
        return $this->apiV2ProductsPidVariantCombinationsVcidImagesImageNumberPostAsyncWithHttpInfo($pid, $vcid, $imageNumber, $imageUrl, $id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV2ProductsPidVariantCombinationsVcidImagesImageNumberPostAsyncWithHttpInfo
     *
     * Assign an image URL to a variant combination
     *
     * @param  int $pid The parent product ID that the variant combination is associated with (required)
     * @param  int $vcid The variant combination ID (required)
     * @param  int $imageNumber The image position that the URL will be assigned to (required)
     * @param  string $imageUrl The URL of the image to be assigned (required)
     * @param  int $id The product ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantCombinationsVcidImagesImageNumberPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2ProductsPidVariantCombinationsVcidImagesImageNumberPostAsyncWithHttpInfo($pid, $vcid, $imageNumber, $imageUrl, $id, string $contentType = self::contentTypes['apiV2ProductsPidVariantCombinationsVcidImagesImageNumberPost'][0])
    {
        $returnType = '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV1ProductImages';
        $request = $this->apiV2ProductsPidVariantCombinationsVcidImagesImageNumberPostRequest($pid, $vcid, $imageNumber, $imageUrl, $id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV2ProductsPidVariantCombinationsVcidImagesImageNumberPost'
     *
     * @param  int $pid The parent product ID that the variant combination is associated with (required)
     * @param  int $vcid The variant combination ID (required)
     * @param  int $imageNumber The image position that the URL will be assigned to (required)
     * @param  string $imageUrl The URL of the image to be assigned (required)
     * @param  int $id The product ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantCombinationsVcidImagesImageNumberPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV2ProductsPidVariantCombinationsVcidImagesImageNumberPostRequest($pid, $vcid, $imageNumber, $imageUrl, $id, string $contentType = self::contentTypes['apiV2ProductsPidVariantCombinationsVcidImagesImageNumberPost'][0])
    {

        // verify the required parameter 'pid' is set
        if ($pid === null || (is_array($pid) && count($pid) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pid when calling apiV2ProductsPidVariantCombinationsVcidImagesImageNumberPost'
            );
        }

        // verify the required parameter 'vcid' is set
        if ($vcid === null || (is_array($vcid) && count($vcid) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $vcid when calling apiV2ProductsPidVariantCombinationsVcidImagesImageNumberPost'
            );
        }

        // verify the required parameter 'imageNumber' is set
        if ($imageNumber === null || (is_array($imageNumber) && count($imageNumber) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $imageNumber when calling apiV2ProductsPidVariantCombinationsVcidImagesImageNumberPost'
            );
        }

        // verify the required parameter 'imageUrl' is set
        if ($imageUrl === null || (is_array($imageUrl) && count($imageUrl) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $imageUrl when calling apiV2ProductsPidVariantCombinationsVcidImagesImageNumberPost'
            );
        }

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling apiV2ProductsPidVariantCombinationsVcidImagesImageNumberPost'
            );
        }


        $resourcePath = '/api/v2/products/{pid}/variant_combinations/{vcid}/images/{imageNumber}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $imageUrl,
            'imageUrl', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $id,
            'id', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);


        // path params
        if ($pid !== null) {
            $resourcePath = str_replace(
                '{' . 'pid' . '}',
                ObjectSerializer::toPathValue($pid),
                $resourcePath
            );
        }
        // path params
        if ($vcid !== null) {
            $resourcePath = str_replace(
                '{' . 'vcid' . '}',
                ObjectSerializer::toPathValue($vcid),
                $resourcePath
            );
        }
        // path params
        if ($imageNumber !== null) {
            $resourcePath = str_replace(
                '{' . 'imageNumber' . '}',
                ObjectSerializer::toPathValue($imageNumber),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV2ProductsPidVariantCombinationsVcidPut
     *
     * Update a single variant combination
     *
     * @param  int $pid The ID of the product that the the variant combination is a child of (required)
     * @param  int $vcid The variant combination ID (required)
     * @param  \EKMv2\Model\TempestModelsShopsProductsV2VariantCombination|null $tempestModelsShopsProductsV2VariantCombination tempestModelsShopsProductsV2VariantCombination (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantCombinationsVcidPut'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantCombination|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError
     */
    public function apiV2ProductsPidVariantCombinationsVcidPut($pid, $vcid, $tempestModelsShopsProductsV2VariantCombination = null, string $contentType = self::contentTypes['apiV2ProductsPidVariantCombinationsVcidPut'][0])
    {
        list($response) = $this->apiV2ProductsPidVariantCombinationsVcidPutWithHttpInfo($pid, $vcid, $tempestModelsShopsProductsV2VariantCombination, $contentType);
        return $response;
    }

    /**
     * Operation apiV2ProductsPidVariantCombinationsVcidPutWithHttpInfo
     *
     * Update a single variant combination
     *
     * @param  int $pid The ID of the product that the the variant combination is a child of (required)
     * @param  int $vcid The variant combination ID (required)
     * @param  \EKMv2\Model\TempestModelsShopsProductsV2VariantCombination|null $tempestModelsShopsProductsV2VariantCombination (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantCombinationsVcidPut'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantCombination|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV2ProductsPidVariantCombinationsVcidPutWithHttpInfo($pid, $vcid, $tempestModelsShopsProductsV2VariantCombination = null, string $contentType = self::contentTypes['apiV2ProductsPidVariantCombinationsVcidPut'][0])
    {
        $request = $this->apiV2ProductsPidVariantCombinationsVcidPutRequest($pid, $vcid, $tempestModelsShopsProductsV2VariantCombination, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantCombination',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantCombination',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantCombination',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV2ProductsPidVariantCombinationsVcidPutAsync
     *
     * Update a single variant combination
     *
     * @param  int $pid The ID of the product that the the variant combination is a child of (required)
     * @param  int $vcid The variant combination ID (required)
     * @param  \EKMv2\Model\TempestModelsShopsProductsV2VariantCombination|null $tempestModelsShopsProductsV2VariantCombination (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantCombinationsVcidPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2ProductsPidVariantCombinationsVcidPutAsync($pid, $vcid, $tempestModelsShopsProductsV2VariantCombination = null, string $contentType = self::contentTypes['apiV2ProductsPidVariantCombinationsVcidPut'][0])
    {
        return $this->apiV2ProductsPidVariantCombinationsVcidPutAsyncWithHttpInfo($pid, $vcid, $tempestModelsShopsProductsV2VariantCombination, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV2ProductsPidVariantCombinationsVcidPutAsyncWithHttpInfo
     *
     * Update a single variant combination
     *
     * @param  int $pid The ID of the product that the the variant combination is a child of (required)
     * @param  int $vcid The variant combination ID (required)
     * @param  \EKMv2\Model\TempestModelsShopsProductsV2VariantCombination|null $tempestModelsShopsProductsV2VariantCombination (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantCombinationsVcidPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2ProductsPidVariantCombinationsVcidPutAsyncWithHttpInfo($pid, $vcid, $tempestModelsShopsProductsV2VariantCombination = null, string $contentType = self::contentTypes['apiV2ProductsPidVariantCombinationsVcidPut'][0])
    {
        $returnType = '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantCombination';
        $request = $this->apiV2ProductsPidVariantCombinationsVcidPutRequest($pid, $vcid, $tempestModelsShopsProductsV2VariantCombination, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV2ProductsPidVariantCombinationsVcidPut'
     *
     * @param  int $pid The ID of the product that the the variant combination is a child of (required)
     * @param  int $vcid The variant combination ID (required)
     * @param  \EKMv2\Model\TempestModelsShopsProductsV2VariantCombination|null $tempestModelsShopsProductsV2VariantCombination (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantCombinationsVcidPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV2ProductsPidVariantCombinationsVcidPutRequest($pid, $vcid, $tempestModelsShopsProductsV2VariantCombination = null, string $contentType = self::contentTypes['apiV2ProductsPidVariantCombinationsVcidPut'][0])
    {

        // verify the required parameter 'pid' is set
        if ($pid === null || (is_array($pid) && count($pid) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pid when calling apiV2ProductsPidVariantCombinationsVcidPut'
            );
        }

        // verify the required parameter 'vcid' is set
        if ($vcid === null || (is_array($vcid) && count($vcid) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $vcid when calling apiV2ProductsPidVariantCombinationsVcidPut'
            );
        }



        $resourcePath = '/api/v2/products/{pid}/variant_combinations/{vcid}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($pid !== null) {
            $resourcePath = str_replace(
                '{' . 'pid' . '}',
                ObjectSerializer::toPathValue($pid),
                $resourcePath
            );
        }
        // path params
        if ($vcid !== null) {
            $resourcePath = str_replace(
                '{' . 'vcid' . '}',
                ObjectSerializer::toPathValue($vcid),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($tempestModelsShopsProductsV2VariantCombination)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($tempestModelsShopsProductsV2VariantCombination));
            } else {
                $httpBody = $tempestModelsShopsProductsV2VariantCombination;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV2ProductsPidVariantsGet
     *
     * Get all of a product&#39;s associated variants
     *
     * @param  int $pid The parent product ID (required)
     * @param  int|null $page Page number to display (optional)
     * @param  int|null $limit Items per page (maximum 20) (optional)
     * @param  string|null $orderby Field to order results. Prefix with a - (dash) for descending e.g. -id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantsGet'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV2Variant|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError
     */
    public function apiV2ProductsPidVariantsGet($pid, $page = null, $limit = null, $orderby = null, string $contentType = self::contentTypes['apiV2ProductsPidVariantsGet'][0])
    {
        list($response) = $this->apiV2ProductsPidVariantsGetWithHttpInfo($pid, $page, $limit, $orderby, $contentType);
        return $response;
    }

    /**
     * Operation apiV2ProductsPidVariantsGetWithHttpInfo
     *
     * Get all of a product&#39;s associated variants
     *
     * @param  int $pid The parent product ID (required)
     * @param  int|null $page Page number to display (optional)
     * @param  int|null $limit Items per page (maximum 20) (optional)
     * @param  string|null $orderby Field to order results. Prefix with a - (dash) for descending e.g. -id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantsGet'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV2Variant|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV2ProductsPidVariantsGetWithHttpInfo($pid, $page = null, $limit = null, $orderby = null, string $contentType = self::contentTypes['apiV2ProductsPidVariantsGet'][0])
    {
        $request = $this->apiV2ProductsPidVariantsGetRequest($pid, $page, $limit, $orderby, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV2Variant',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV2Variant',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV2Variant',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV2ProductsPidVariantsGetAsync
     *
     * Get all of a product&#39;s associated variants
     *
     * @param  int $pid The parent product ID (required)
     * @param  int|null $page Page number to display (optional)
     * @param  int|null $limit Items per page (maximum 20) (optional)
     * @param  string|null $orderby Field to order results. Prefix with a - (dash) for descending e.g. -id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2ProductsPidVariantsGetAsync($pid, $page = null, $limit = null, $orderby = null, string $contentType = self::contentTypes['apiV2ProductsPidVariantsGet'][0])
    {
        return $this->apiV2ProductsPidVariantsGetAsyncWithHttpInfo($pid, $page, $limit, $orderby, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV2ProductsPidVariantsGetAsyncWithHttpInfo
     *
     * Get all of a product&#39;s associated variants
     *
     * @param  int $pid The parent product ID (required)
     * @param  int|null $page Page number to display (optional)
     * @param  int|null $limit Items per page (maximum 20) (optional)
     * @param  string|null $orderby Field to order results. Prefix with a - (dash) for descending e.g. -id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2ProductsPidVariantsGetAsyncWithHttpInfo($pid, $page = null, $limit = null, $orderby = null, string $contentType = self::contentTypes['apiV2ProductsPidVariantsGet'][0])
    {
        $returnType = '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV2Variant';
        $request = $this->apiV2ProductsPidVariantsGetRequest($pid, $page, $limit, $orderby, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV2ProductsPidVariantsGet'
     *
     * @param  int $pid The parent product ID (required)
     * @param  int|null $page Page number to display (optional)
     * @param  int|null $limit Items per page (maximum 20) (optional)
     * @param  string|null $orderby Field to order results. Prefix with a - (dash) for descending e.g. -id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV2ProductsPidVariantsGetRequest($pid, $page = null, $limit = null, $orderby = null, string $contentType = self::contentTypes['apiV2ProductsPidVariantsGet'][0])
    {

        // verify the required parameter 'pid' is set
        if ($pid === null || (is_array($pid) && count($pid) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pid when calling apiV2ProductsPidVariantsGet'
            );
        }





        $resourcePath = '/api/v2/products/{pid}/variants';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $orderby,
            'orderby', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($pid !== null) {
            $resourcePath = str_replace(
                '{' . 'pid' . '}',
                ObjectSerializer::toPathValue($pid),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV2ProductsPidVariantsPost
     *
     * Add a new variant to a specific product.
     *
     * @param  int $pid The ID of the product that the variant will be added to (required)
     * @param  \EKMv2\Model\TempestModelsShopsProductsV2AddVariant|null $tempestModelsShopsProductsV2AddVariant tempestModelsShopsProductsV2AddVariant (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantsPost'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2Variant|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError
     */
    public function apiV2ProductsPidVariantsPost($pid, $tempestModelsShopsProductsV2AddVariant = null, string $contentType = self::contentTypes['apiV2ProductsPidVariantsPost'][0])
    {
        list($response) = $this->apiV2ProductsPidVariantsPostWithHttpInfo($pid, $tempestModelsShopsProductsV2AddVariant, $contentType);
        return $response;
    }

    /**
     * Operation apiV2ProductsPidVariantsPostWithHttpInfo
     *
     * Add a new variant to a specific product.
     *
     * @param  int $pid The ID of the product that the variant will be added to (required)
     * @param  \EKMv2\Model\TempestModelsShopsProductsV2AddVariant|null $tempestModelsShopsProductsV2AddVariant (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantsPost'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2Variant|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV2ProductsPidVariantsPostWithHttpInfo($pid, $tempestModelsShopsProductsV2AddVariant = null, string $contentType = self::contentTypes['apiV2ProductsPidVariantsPost'][0])
    {
        $request = $this->apiV2ProductsPidVariantsPostRequest($pid, $tempestModelsShopsProductsV2AddVariant, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 201:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2Variant',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2Variant',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2Variant',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV2ProductsPidVariantsPostAsync
     *
     * Add a new variant to a specific product.
     *
     * @param  int $pid The ID of the product that the variant will be added to (required)
     * @param  \EKMv2\Model\TempestModelsShopsProductsV2AddVariant|null $tempestModelsShopsProductsV2AddVariant (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantsPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2ProductsPidVariantsPostAsync($pid, $tempestModelsShopsProductsV2AddVariant = null, string $contentType = self::contentTypes['apiV2ProductsPidVariantsPost'][0])
    {
        return $this->apiV2ProductsPidVariantsPostAsyncWithHttpInfo($pid, $tempestModelsShopsProductsV2AddVariant, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV2ProductsPidVariantsPostAsyncWithHttpInfo
     *
     * Add a new variant to a specific product.
     *
     * @param  int $pid The ID of the product that the variant will be added to (required)
     * @param  \EKMv2\Model\TempestModelsShopsProductsV2AddVariant|null $tempestModelsShopsProductsV2AddVariant (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantsPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2ProductsPidVariantsPostAsyncWithHttpInfo($pid, $tempestModelsShopsProductsV2AddVariant = null, string $contentType = self::contentTypes['apiV2ProductsPidVariantsPost'][0])
    {
        $returnType = '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2Variant';
        $request = $this->apiV2ProductsPidVariantsPostRequest($pid, $tempestModelsShopsProductsV2AddVariant, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV2ProductsPidVariantsPost'
     *
     * @param  int $pid The ID of the product that the variant will be added to (required)
     * @param  \EKMv2\Model\TempestModelsShopsProductsV2AddVariant|null $tempestModelsShopsProductsV2AddVariant (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantsPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV2ProductsPidVariantsPostRequest($pid, $tempestModelsShopsProductsV2AddVariant = null, string $contentType = self::contentTypes['apiV2ProductsPidVariantsPost'][0])
    {

        // verify the required parameter 'pid' is set
        if ($pid === null || (is_array($pid) && count($pid) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pid when calling apiV2ProductsPidVariantsPost'
            );
        }



        $resourcePath = '/api/v2/products/{pid}/variants';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($pid !== null) {
            $resourcePath = str_replace(
                '{' . 'pid' . '}',
                ObjectSerializer::toPathValue($pid),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($tempestModelsShopsProductsV2AddVariant)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($tempestModelsShopsProductsV2AddVariant));
            } else {
                $httpBody = $tempestModelsShopsProductsV2AddVariant;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV2ProductsPidVariantsVidChoicesGet
     *
     * Get the choices associated with a specific variant
     *
     * @param  int $pid The ID of the product that the variant belongs to (required)
     * @param  int $vid The ID of the variant to get the choices for (required)
     * @param  int|null $page Page number to display (optional)
     * @param  int|null $limit Items per page (maximum 20) (optional)
     * @param  string|null $orderby Field to order results. Prefix with a - (dash) for descending e.g. -id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantsVidChoicesGet'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV2VariantChoice|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError
     */
    public function apiV2ProductsPidVariantsVidChoicesGet($pid, $vid, $page = null, $limit = null, $orderby = null, string $contentType = self::contentTypes['apiV2ProductsPidVariantsVidChoicesGet'][0])
    {
        list($response) = $this->apiV2ProductsPidVariantsVidChoicesGetWithHttpInfo($pid, $vid, $page, $limit, $orderby, $contentType);
        return $response;
    }

    /**
     * Operation apiV2ProductsPidVariantsVidChoicesGetWithHttpInfo
     *
     * Get the choices associated with a specific variant
     *
     * @param  int $pid The ID of the product that the variant belongs to (required)
     * @param  int $vid The ID of the variant to get the choices for (required)
     * @param  int|null $page Page number to display (optional)
     * @param  int|null $limit Items per page (maximum 20) (optional)
     * @param  string|null $orderby Field to order results. Prefix with a - (dash) for descending e.g. -id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantsVidChoicesGet'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV2VariantChoice|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV2ProductsPidVariantsVidChoicesGetWithHttpInfo($pid, $vid, $page = null, $limit = null, $orderby = null, string $contentType = self::contentTypes['apiV2ProductsPidVariantsVidChoicesGet'][0])
    {
        $request = $this->apiV2ProductsPidVariantsVidChoicesGetRequest($pid, $vid, $page, $limit, $orderby, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV2VariantChoice',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV2VariantChoice',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV2VariantChoice',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV2ProductsPidVariantsVidChoicesGetAsync
     *
     * Get the choices associated with a specific variant
     *
     * @param  int $pid The ID of the product that the variant belongs to (required)
     * @param  int $vid The ID of the variant to get the choices for (required)
     * @param  int|null $page Page number to display (optional)
     * @param  int|null $limit Items per page (maximum 20) (optional)
     * @param  string|null $orderby Field to order results. Prefix with a - (dash) for descending e.g. -id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantsVidChoicesGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2ProductsPidVariantsVidChoicesGetAsync($pid, $vid, $page = null, $limit = null, $orderby = null, string $contentType = self::contentTypes['apiV2ProductsPidVariantsVidChoicesGet'][0])
    {
        return $this->apiV2ProductsPidVariantsVidChoicesGetAsyncWithHttpInfo($pid, $vid, $page, $limit, $orderby, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV2ProductsPidVariantsVidChoicesGetAsyncWithHttpInfo
     *
     * Get the choices associated with a specific variant
     *
     * @param  int $pid The ID of the product that the variant belongs to (required)
     * @param  int $vid The ID of the variant to get the choices for (required)
     * @param  int|null $page Page number to display (optional)
     * @param  int|null $limit Items per page (maximum 20) (optional)
     * @param  string|null $orderby Field to order results. Prefix with a - (dash) for descending e.g. -id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantsVidChoicesGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2ProductsPidVariantsVidChoicesGetAsyncWithHttpInfo($pid, $vid, $page = null, $limit = null, $orderby = null, string $contentType = self::contentTypes['apiV2ProductsPidVariantsVidChoicesGet'][0])
    {
        $returnType = '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV2VariantChoice';
        $request = $this->apiV2ProductsPidVariantsVidChoicesGetRequest($pid, $vid, $page, $limit, $orderby, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV2ProductsPidVariantsVidChoicesGet'
     *
     * @param  int $pid The ID of the product that the variant belongs to (required)
     * @param  int $vid The ID of the variant to get the choices for (required)
     * @param  int|null $page Page number to display (optional)
     * @param  int|null $limit Items per page (maximum 20) (optional)
     * @param  string|null $orderby Field to order results. Prefix with a - (dash) for descending e.g. -id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantsVidChoicesGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV2ProductsPidVariantsVidChoicesGetRequest($pid, $vid, $page = null, $limit = null, $orderby = null, string $contentType = self::contentTypes['apiV2ProductsPidVariantsVidChoicesGet'][0])
    {

        // verify the required parameter 'pid' is set
        if ($pid === null || (is_array($pid) && count($pid) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pid when calling apiV2ProductsPidVariantsVidChoicesGet'
            );
        }

        // verify the required parameter 'vid' is set
        if ($vid === null || (is_array($vid) && count($vid) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $vid when calling apiV2ProductsPidVariantsVidChoicesGet'
            );
        }





        $resourcePath = '/api/v2/products/{pid}/variants/{vid}/choices';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $orderby,
            'orderby', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($pid !== null) {
            $resourcePath = str_replace(
                '{' . 'pid' . '}',
                ObjectSerializer::toPathValue($pid),
                $resourcePath
            );
        }
        // path params
        if ($vid !== null) {
            $resourcePath = str_replace(
                '{' . 'vid' . '}',
                ObjectSerializer::toPathValue($vid),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV2ProductsPidVariantsVidChoicesPost
     *
     * Create a new choice for a specific variant
     *
     * @param  int $pid The ID of the product that the variant belongs to (required)
     * @param  int $vid The ID of the variant to add the choice to (required)
     * @param  \EKMv2\Model\TempestModelsShopsProductsV2AddVariantChoice|null $tempestModelsShopsProductsV2AddVariantChoice tempestModelsShopsProductsV2AddVariantChoice (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantsVidChoicesPost'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantChoice|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError
     */
    public function apiV2ProductsPidVariantsVidChoicesPost($pid, $vid, $tempestModelsShopsProductsV2AddVariantChoice = null, string $contentType = self::contentTypes['apiV2ProductsPidVariantsVidChoicesPost'][0])
    {
        list($response) = $this->apiV2ProductsPidVariantsVidChoicesPostWithHttpInfo($pid, $vid, $tempestModelsShopsProductsV2AddVariantChoice, $contentType);
        return $response;
    }

    /**
     * Operation apiV2ProductsPidVariantsVidChoicesPostWithHttpInfo
     *
     * Create a new choice for a specific variant
     *
     * @param  int $pid The ID of the product that the variant belongs to (required)
     * @param  int $vid The ID of the variant to add the choice to (required)
     * @param  \EKMv2\Model\TempestModelsShopsProductsV2AddVariantChoice|null $tempestModelsShopsProductsV2AddVariantChoice (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantsVidChoicesPost'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantChoice|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV2ProductsPidVariantsVidChoicesPostWithHttpInfo($pid, $vid, $tempestModelsShopsProductsV2AddVariantChoice = null, string $contentType = self::contentTypes['apiV2ProductsPidVariantsVidChoicesPost'][0])
    {
        $request = $this->apiV2ProductsPidVariantsVidChoicesPostRequest($pid, $vid, $tempestModelsShopsProductsV2AddVariantChoice, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 201:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantChoice',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantChoice',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantChoice',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV2ProductsPidVariantsVidChoicesPostAsync
     *
     * Create a new choice for a specific variant
     *
     * @param  int $pid The ID of the product that the variant belongs to (required)
     * @param  int $vid The ID of the variant to add the choice to (required)
     * @param  \EKMv2\Model\TempestModelsShopsProductsV2AddVariantChoice|null $tempestModelsShopsProductsV2AddVariantChoice (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantsVidChoicesPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2ProductsPidVariantsVidChoicesPostAsync($pid, $vid, $tempestModelsShopsProductsV2AddVariantChoice = null, string $contentType = self::contentTypes['apiV2ProductsPidVariantsVidChoicesPost'][0])
    {
        return $this->apiV2ProductsPidVariantsVidChoicesPostAsyncWithHttpInfo($pid, $vid, $tempestModelsShopsProductsV2AddVariantChoice, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV2ProductsPidVariantsVidChoicesPostAsyncWithHttpInfo
     *
     * Create a new choice for a specific variant
     *
     * @param  int $pid The ID of the product that the variant belongs to (required)
     * @param  int $vid The ID of the variant to add the choice to (required)
     * @param  \EKMv2\Model\TempestModelsShopsProductsV2AddVariantChoice|null $tempestModelsShopsProductsV2AddVariantChoice (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantsVidChoicesPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2ProductsPidVariantsVidChoicesPostAsyncWithHttpInfo($pid, $vid, $tempestModelsShopsProductsV2AddVariantChoice = null, string $contentType = self::contentTypes['apiV2ProductsPidVariantsVidChoicesPost'][0])
    {
        $returnType = '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantChoice';
        $request = $this->apiV2ProductsPidVariantsVidChoicesPostRequest($pid, $vid, $tempestModelsShopsProductsV2AddVariantChoice, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV2ProductsPidVariantsVidChoicesPost'
     *
     * @param  int $pid The ID of the product that the variant belongs to (required)
     * @param  int $vid The ID of the variant to add the choice to (required)
     * @param  \EKMv2\Model\TempestModelsShopsProductsV2AddVariantChoice|null $tempestModelsShopsProductsV2AddVariantChoice (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantsVidChoicesPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV2ProductsPidVariantsVidChoicesPostRequest($pid, $vid, $tempestModelsShopsProductsV2AddVariantChoice = null, string $contentType = self::contentTypes['apiV2ProductsPidVariantsVidChoicesPost'][0])
    {

        // verify the required parameter 'pid' is set
        if ($pid === null || (is_array($pid) && count($pid) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pid when calling apiV2ProductsPidVariantsVidChoicesPost'
            );
        }

        // verify the required parameter 'vid' is set
        if ($vid === null || (is_array($vid) && count($vid) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $vid when calling apiV2ProductsPidVariantsVidChoicesPost'
            );
        }



        $resourcePath = '/api/v2/products/{pid}/variants/{vid}/choices';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($pid !== null) {
            $resourcePath = str_replace(
                '{' . 'pid' . '}',
                ObjectSerializer::toPathValue($pid),
                $resourcePath
            );
        }
        // path params
        if ($vid !== null) {
            $resourcePath = str_replace(
                '{' . 'vid' . '}',
                ObjectSerializer::toPathValue($vid),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($tempestModelsShopsProductsV2AddVariantChoice)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($tempestModelsShopsProductsV2AddVariantChoice));
            } else {
                $httpBody = $tempestModelsShopsProductsV2AddVariantChoice;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV2ProductsPidVariantsVidChoicesVcidDelete
     *
     * Delete a specific choice belonging to a variant
     *
     * @param  int $pid The ID of the product that the variant belongs to (required)
     * @param  int $vid The ID of the variant that the choice belongs to (required)
     * @param  int $vcid The ID of the variant choice to delete (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantsVidChoicesVcidDelete'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV1ProductOptionItem|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError
     */
    public function apiV2ProductsPidVariantsVidChoicesVcidDelete($pid, $vid, $vcid, string $contentType = self::contentTypes['apiV2ProductsPidVariantsVidChoicesVcidDelete'][0])
    {
        list($response) = $this->apiV2ProductsPidVariantsVidChoicesVcidDeleteWithHttpInfo($pid, $vid, $vcid, $contentType);
        return $response;
    }

    /**
     * Operation apiV2ProductsPidVariantsVidChoicesVcidDeleteWithHttpInfo
     *
     * Delete a specific choice belonging to a variant
     *
     * @param  int $pid The ID of the product that the variant belongs to (required)
     * @param  int $vid The ID of the variant that the choice belongs to (required)
     * @param  int $vcid The ID of the variant choice to delete (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantsVidChoicesVcidDelete'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV1ProductOptionItem|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV2ProductsPidVariantsVidChoicesVcidDeleteWithHttpInfo($pid, $vid, $vcid, string $contentType = self::contentTypes['apiV2ProductsPidVariantsVidChoicesVcidDelete'][0])
    {
        $request = $this->apiV2ProductsPidVariantsVidChoicesVcidDeleteRequest($pid, $vid, $vcid, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV1ProductOptionItem',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV1ProductOptionItem',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV1ProductOptionItem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV2ProductsPidVariantsVidChoicesVcidDeleteAsync
     *
     * Delete a specific choice belonging to a variant
     *
     * @param  int $pid The ID of the product that the variant belongs to (required)
     * @param  int $vid The ID of the variant that the choice belongs to (required)
     * @param  int $vcid The ID of the variant choice to delete (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantsVidChoicesVcidDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2ProductsPidVariantsVidChoicesVcidDeleteAsync($pid, $vid, $vcid, string $contentType = self::contentTypes['apiV2ProductsPidVariantsVidChoicesVcidDelete'][0])
    {
        return $this->apiV2ProductsPidVariantsVidChoicesVcidDeleteAsyncWithHttpInfo($pid, $vid, $vcid, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV2ProductsPidVariantsVidChoicesVcidDeleteAsyncWithHttpInfo
     *
     * Delete a specific choice belonging to a variant
     *
     * @param  int $pid The ID of the product that the variant belongs to (required)
     * @param  int $vid The ID of the variant that the choice belongs to (required)
     * @param  int $vcid The ID of the variant choice to delete (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantsVidChoicesVcidDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2ProductsPidVariantsVidChoicesVcidDeleteAsyncWithHttpInfo($pid, $vid, $vcid, string $contentType = self::contentTypes['apiV2ProductsPidVariantsVidChoicesVcidDelete'][0])
    {
        $returnType = '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV1ProductOptionItem';
        $request = $this->apiV2ProductsPidVariantsVidChoicesVcidDeleteRequest($pid, $vid, $vcid, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV2ProductsPidVariantsVidChoicesVcidDelete'
     *
     * @param  int $pid The ID of the product that the variant belongs to (required)
     * @param  int $vid The ID of the variant that the choice belongs to (required)
     * @param  int $vcid The ID of the variant choice to delete (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantsVidChoicesVcidDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV2ProductsPidVariantsVidChoicesVcidDeleteRequest($pid, $vid, $vcid, string $contentType = self::contentTypes['apiV2ProductsPidVariantsVidChoicesVcidDelete'][0])
    {

        // verify the required parameter 'pid' is set
        if ($pid === null || (is_array($pid) && count($pid) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pid when calling apiV2ProductsPidVariantsVidChoicesVcidDelete'
            );
        }

        // verify the required parameter 'vid' is set
        if ($vid === null || (is_array($vid) && count($vid) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $vid when calling apiV2ProductsPidVariantsVidChoicesVcidDelete'
            );
        }

        // verify the required parameter 'vcid' is set
        if ($vcid === null || (is_array($vcid) && count($vcid) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $vcid when calling apiV2ProductsPidVariantsVidChoicesVcidDelete'
            );
        }


        $resourcePath = '/api/v2/products/{pid}/variants/{vid}/choices/{vcid}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($pid !== null) {
            $resourcePath = str_replace(
                '{' . 'pid' . '}',
                ObjectSerializer::toPathValue($pid),
                $resourcePath
            );
        }
        // path params
        if ($vid !== null) {
            $resourcePath = str_replace(
                '{' . 'vid' . '}',
                ObjectSerializer::toPathValue($vid),
                $resourcePath
            );
        }
        // path params
        if ($vcid !== null) {
            $resourcePath = str_replace(
                '{' . 'vcid' . '}',
                ObjectSerializer::toPathValue($vcid),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV2ProductsPidVariantsVidChoicesVcidGet
     *
     * Get a single choice associated with a variant
     *
     * @param  int $pid The ID of the product that the variant belongs to (required)
     * @param  int $vid The ID of the variant to get the choices for (required)
     * @param  int $vcid The ID of the variant choice (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantsVidChoicesVcidGet'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantChoice|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError
     */
    public function apiV2ProductsPidVariantsVidChoicesVcidGet($pid, $vid, $vcid, string $contentType = self::contentTypes['apiV2ProductsPidVariantsVidChoicesVcidGet'][0])
    {
        list($response) = $this->apiV2ProductsPidVariantsVidChoicesVcidGetWithHttpInfo($pid, $vid, $vcid, $contentType);
        return $response;
    }

    /**
     * Operation apiV2ProductsPidVariantsVidChoicesVcidGetWithHttpInfo
     *
     * Get a single choice associated with a variant
     *
     * @param  int $pid The ID of the product that the variant belongs to (required)
     * @param  int $vid The ID of the variant to get the choices for (required)
     * @param  int $vcid The ID of the variant choice (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantsVidChoicesVcidGet'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantChoice|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV2ProductsPidVariantsVidChoicesVcidGetWithHttpInfo($pid, $vid, $vcid, string $contentType = self::contentTypes['apiV2ProductsPidVariantsVidChoicesVcidGet'][0])
    {
        $request = $this->apiV2ProductsPidVariantsVidChoicesVcidGetRequest($pid, $vid, $vcid, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantChoice',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantChoice',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantChoice',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV2ProductsPidVariantsVidChoicesVcidGetAsync
     *
     * Get a single choice associated with a variant
     *
     * @param  int $pid The ID of the product that the variant belongs to (required)
     * @param  int $vid The ID of the variant to get the choices for (required)
     * @param  int $vcid The ID of the variant choice (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantsVidChoicesVcidGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2ProductsPidVariantsVidChoicesVcidGetAsync($pid, $vid, $vcid, string $contentType = self::contentTypes['apiV2ProductsPidVariantsVidChoicesVcidGet'][0])
    {
        return $this->apiV2ProductsPidVariantsVidChoicesVcidGetAsyncWithHttpInfo($pid, $vid, $vcid, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV2ProductsPidVariantsVidChoicesVcidGetAsyncWithHttpInfo
     *
     * Get a single choice associated with a variant
     *
     * @param  int $pid The ID of the product that the variant belongs to (required)
     * @param  int $vid The ID of the variant to get the choices for (required)
     * @param  int $vcid The ID of the variant choice (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantsVidChoicesVcidGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2ProductsPidVariantsVidChoicesVcidGetAsyncWithHttpInfo($pid, $vid, $vcid, string $contentType = self::contentTypes['apiV2ProductsPidVariantsVidChoicesVcidGet'][0])
    {
        $returnType = '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantChoice';
        $request = $this->apiV2ProductsPidVariantsVidChoicesVcidGetRequest($pid, $vid, $vcid, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV2ProductsPidVariantsVidChoicesVcidGet'
     *
     * @param  int $pid The ID of the product that the variant belongs to (required)
     * @param  int $vid The ID of the variant to get the choices for (required)
     * @param  int $vcid The ID of the variant choice (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantsVidChoicesVcidGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV2ProductsPidVariantsVidChoicesVcidGetRequest($pid, $vid, $vcid, string $contentType = self::contentTypes['apiV2ProductsPidVariantsVidChoicesVcidGet'][0])
    {

        // verify the required parameter 'pid' is set
        if ($pid === null || (is_array($pid) && count($pid) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pid when calling apiV2ProductsPidVariantsVidChoicesVcidGet'
            );
        }

        // verify the required parameter 'vid' is set
        if ($vid === null || (is_array($vid) && count($vid) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $vid when calling apiV2ProductsPidVariantsVidChoicesVcidGet'
            );
        }

        // verify the required parameter 'vcid' is set
        if ($vcid === null || (is_array($vcid) && count($vcid) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $vcid when calling apiV2ProductsPidVariantsVidChoicesVcidGet'
            );
        }


        $resourcePath = '/api/v2/products/{pid}/variants/{vid}/choices/{vcid}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($pid !== null) {
            $resourcePath = str_replace(
                '{' . 'pid' . '}',
                ObjectSerializer::toPathValue($pid),
                $resourcePath
            );
        }
        // path params
        if ($vid !== null) {
            $resourcePath = str_replace(
                '{' . 'vid' . '}',
                ObjectSerializer::toPathValue($vid),
                $resourcePath
            );
        }
        // path params
        if ($vcid !== null) {
            $resourcePath = str_replace(
                '{' . 'vcid' . '}',
                ObjectSerializer::toPathValue($vcid),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV2ProductsPidVariantsVidChoicesVcidPut
     *
     * Update a specific choice belonging to a variant
     *
     * @param  int $pid The ID of the product that the variant belongs to (required)
     * @param  int $vid The ID of the variant that the choice belongs to (required)
     * @param  int $vcid The ID of the variant choice to update (required)
     * @param  \EKMv2\Model\TempestModelsShopsProductsV2AddVariantChoice|null $tempestModelsShopsProductsV2AddVariantChoice tempestModelsShopsProductsV2AddVariantChoice (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantsVidChoicesVcidPut'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantChoice|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError
     */
    public function apiV2ProductsPidVariantsVidChoicesVcidPut($pid, $vid, $vcid, $tempestModelsShopsProductsV2AddVariantChoice = null, string $contentType = self::contentTypes['apiV2ProductsPidVariantsVidChoicesVcidPut'][0])
    {
        list($response) = $this->apiV2ProductsPidVariantsVidChoicesVcidPutWithHttpInfo($pid, $vid, $vcid, $tempestModelsShopsProductsV2AddVariantChoice, $contentType);
        return $response;
    }

    /**
     * Operation apiV2ProductsPidVariantsVidChoicesVcidPutWithHttpInfo
     *
     * Update a specific choice belonging to a variant
     *
     * @param  int $pid The ID of the product that the variant belongs to (required)
     * @param  int $vid The ID of the variant that the choice belongs to (required)
     * @param  int $vcid The ID of the variant choice to update (required)
     * @param  \EKMv2\Model\TempestModelsShopsProductsV2AddVariantChoice|null $tempestModelsShopsProductsV2AddVariantChoice (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantsVidChoicesVcidPut'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantChoice|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV2ProductsPidVariantsVidChoicesVcidPutWithHttpInfo($pid, $vid, $vcid, $tempestModelsShopsProductsV2AddVariantChoice = null, string $contentType = self::contentTypes['apiV2ProductsPidVariantsVidChoicesVcidPut'][0])
    {
        $request = $this->apiV2ProductsPidVariantsVidChoicesVcidPutRequest($pid, $vid, $vcid, $tempestModelsShopsProductsV2AddVariantChoice, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantChoice',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantChoice',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantChoice',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV2ProductsPidVariantsVidChoicesVcidPutAsync
     *
     * Update a specific choice belonging to a variant
     *
     * @param  int $pid The ID of the product that the variant belongs to (required)
     * @param  int $vid The ID of the variant that the choice belongs to (required)
     * @param  int $vcid The ID of the variant choice to update (required)
     * @param  \EKMv2\Model\TempestModelsShopsProductsV2AddVariantChoice|null $tempestModelsShopsProductsV2AddVariantChoice (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantsVidChoicesVcidPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2ProductsPidVariantsVidChoicesVcidPutAsync($pid, $vid, $vcid, $tempestModelsShopsProductsV2AddVariantChoice = null, string $contentType = self::contentTypes['apiV2ProductsPidVariantsVidChoicesVcidPut'][0])
    {
        return $this->apiV2ProductsPidVariantsVidChoicesVcidPutAsyncWithHttpInfo($pid, $vid, $vcid, $tempestModelsShopsProductsV2AddVariantChoice, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV2ProductsPidVariantsVidChoicesVcidPutAsyncWithHttpInfo
     *
     * Update a specific choice belonging to a variant
     *
     * @param  int $pid The ID of the product that the variant belongs to (required)
     * @param  int $vid The ID of the variant that the choice belongs to (required)
     * @param  int $vcid The ID of the variant choice to update (required)
     * @param  \EKMv2\Model\TempestModelsShopsProductsV2AddVariantChoice|null $tempestModelsShopsProductsV2AddVariantChoice (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantsVidChoicesVcidPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2ProductsPidVariantsVidChoicesVcidPutAsyncWithHttpInfo($pid, $vid, $vcid, $tempestModelsShopsProductsV2AddVariantChoice = null, string $contentType = self::contentTypes['apiV2ProductsPidVariantsVidChoicesVcidPut'][0])
    {
        $returnType = '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantChoice';
        $request = $this->apiV2ProductsPidVariantsVidChoicesVcidPutRequest($pid, $vid, $vcid, $tempestModelsShopsProductsV2AddVariantChoice, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV2ProductsPidVariantsVidChoicesVcidPut'
     *
     * @param  int $pid The ID of the product that the variant belongs to (required)
     * @param  int $vid The ID of the variant that the choice belongs to (required)
     * @param  int $vcid The ID of the variant choice to update (required)
     * @param  \EKMv2\Model\TempestModelsShopsProductsV2AddVariantChoice|null $tempestModelsShopsProductsV2AddVariantChoice (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantsVidChoicesVcidPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV2ProductsPidVariantsVidChoicesVcidPutRequest($pid, $vid, $vcid, $tempestModelsShopsProductsV2AddVariantChoice = null, string $contentType = self::contentTypes['apiV2ProductsPidVariantsVidChoicesVcidPut'][0])
    {

        // verify the required parameter 'pid' is set
        if ($pid === null || (is_array($pid) && count($pid) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pid when calling apiV2ProductsPidVariantsVidChoicesVcidPut'
            );
        }

        // verify the required parameter 'vid' is set
        if ($vid === null || (is_array($vid) && count($vid) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $vid when calling apiV2ProductsPidVariantsVidChoicesVcidPut'
            );
        }

        // verify the required parameter 'vcid' is set
        if ($vcid === null || (is_array($vcid) && count($vcid) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $vcid when calling apiV2ProductsPidVariantsVidChoicesVcidPut'
            );
        }



        $resourcePath = '/api/v2/products/{pid}/variants/{vid}/choices/{vcid}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($pid !== null) {
            $resourcePath = str_replace(
                '{' . 'pid' . '}',
                ObjectSerializer::toPathValue($pid),
                $resourcePath
            );
        }
        // path params
        if ($vid !== null) {
            $resourcePath = str_replace(
                '{' . 'vid' . '}',
                ObjectSerializer::toPathValue($vid),
                $resourcePath
            );
        }
        // path params
        if ($vcid !== null) {
            $resourcePath = str_replace(
                '{' . 'vcid' . '}',
                ObjectSerializer::toPathValue($vcid),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($tempestModelsShopsProductsV2AddVariantChoice)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($tempestModelsShopsProductsV2AddVariantChoice));
            } else {
                $httpBody = $tempestModelsShopsProductsV2AddVariantChoice;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV2ProductsPidVariantsVidDelete
     *
     * Delete an existing variant
     *
     * @param  int $pid The ID of the product that the variant belongs to (required)
     * @param  int $vid The ID of the variant to be updated (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantsVidDelete'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV1ProductOption|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError
     */
    public function apiV2ProductsPidVariantsVidDelete($pid, $vid, string $contentType = self::contentTypes['apiV2ProductsPidVariantsVidDelete'][0])
    {
        list($response) = $this->apiV2ProductsPidVariantsVidDeleteWithHttpInfo($pid, $vid, $contentType);
        return $response;
    }

    /**
     * Operation apiV2ProductsPidVariantsVidDeleteWithHttpInfo
     *
     * Delete an existing variant
     *
     * @param  int $pid The ID of the product that the variant belongs to (required)
     * @param  int $vid The ID of the variant to be updated (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantsVidDelete'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV1ProductOption|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV2ProductsPidVariantsVidDeleteWithHttpInfo($pid, $vid, string $contentType = self::contentTypes['apiV2ProductsPidVariantsVidDelete'][0])
    {
        $request = $this->apiV2ProductsPidVariantsVidDeleteRequest($pid, $vid, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV1ProductOption',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV1ProductOption',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV1ProductOption',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV2ProductsPidVariantsVidDeleteAsync
     *
     * Delete an existing variant
     *
     * @param  int $pid The ID of the product that the variant belongs to (required)
     * @param  int $vid The ID of the variant to be updated (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantsVidDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2ProductsPidVariantsVidDeleteAsync($pid, $vid, string $contentType = self::contentTypes['apiV2ProductsPidVariantsVidDelete'][0])
    {
        return $this->apiV2ProductsPidVariantsVidDeleteAsyncWithHttpInfo($pid, $vid, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV2ProductsPidVariantsVidDeleteAsyncWithHttpInfo
     *
     * Delete an existing variant
     *
     * @param  int $pid The ID of the product that the variant belongs to (required)
     * @param  int $vid The ID of the variant to be updated (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantsVidDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2ProductsPidVariantsVidDeleteAsyncWithHttpInfo($pid, $vid, string $contentType = self::contentTypes['apiV2ProductsPidVariantsVidDelete'][0])
    {
        $returnType = '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV1ProductOption';
        $request = $this->apiV2ProductsPidVariantsVidDeleteRequest($pid, $vid, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV2ProductsPidVariantsVidDelete'
     *
     * @param  int $pid The ID of the product that the variant belongs to (required)
     * @param  int $vid The ID of the variant to be updated (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantsVidDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV2ProductsPidVariantsVidDeleteRequest($pid, $vid, string $contentType = self::contentTypes['apiV2ProductsPidVariantsVidDelete'][0])
    {

        // verify the required parameter 'pid' is set
        if ($pid === null || (is_array($pid) && count($pid) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pid when calling apiV2ProductsPidVariantsVidDelete'
            );
        }

        // verify the required parameter 'vid' is set
        if ($vid === null || (is_array($vid) && count($vid) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $vid when calling apiV2ProductsPidVariantsVidDelete'
            );
        }


        $resourcePath = '/api/v2/products/{pid}/variants/{vid}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($pid !== null) {
            $resourcePath = str_replace(
                '{' . 'pid' . '}',
                ObjectSerializer::toPathValue($pid),
                $resourcePath
            );
        }
        // path params
        if ($vid !== null) {
            $resourcePath = str_replace(
                '{' . 'vid' . '}',
                ObjectSerializer::toPathValue($vid),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV2ProductsPidVariantsVidGet
     *
     * Get a specific variant belonging to a product
     *
     * @param  int $pid The parent product ID (required)
     * @param  int $vid The variant ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantsVidGet'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2Variant|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError
     */
    public function apiV2ProductsPidVariantsVidGet($pid, $vid, string $contentType = self::contentTypes['apiV2ProductsPidVariantsVidGet'][0])
    {
        list($response) = $this->apiV2ProductsPidVariantsVidGetWithHttpInfo($pid, $vid, $contentType);
        return $response;
    }

    /**
     * Operation apiV2ProductsPidVariantsVidGetWithHttpInfo
     *
     * Get a specific variant belonging to a product
     *
     * @param  int $pid The parent product ID (required)
     * @param  int $vid The variant ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantsVidGet'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2Variant|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV2ProductsPidVariantsVidGetWithHttpInfo($pid, $vid, string $contentType = self::contentTypes['apiV2ProductsPidVariantsVidGet'][0])
    {
        $request = $this->apiV2ProductsPidVariantsVidGetRequest($pid, $vid, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2Variant',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2Variant',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2Variant',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV2ProductsPidVariantsVidGetAsync
     *
     * Get a specific variant belonging to a product
     *
     * @param  int $pid The parent product ID (required)
     * @param  int $vid The variant ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantsVidGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2ProductsPidVariantsVidGetAsync($pid, $vid, string $contentType = self::contentTypes['apiV2ProductsPidVariantsVidGet'][0])
    {
        return $this->apiV2ProductsPidVariantsVidGetAsyncWithHttpInfo($pid, $vid, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV2ProductsPidVariantsVidGetAsyncWithHttpInfo
     *
     * Get a specific variant belonging to a product
     *
     * @param  int $pid The parent product ID (required)
     * @param  int $vid The variant ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantsVidGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2ProductsPidVariantsVidGetAsyncWithHttpInfo($pid, $vid, string $contentType = self::contentTypes['apiV2ProductsPidVariantsVidGet'][0])
    {
        $returnType = '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2Variant';
        $request = $this->apiV2ProductsPidVariantsVidGetRequest($pid, $vid, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV2ProductsPidVariantsVidGet'
     *
     * @param  int $pid The parent product ID (required)
     * @param  int $vid The variant ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantsVidGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV2ProductsPidVariantsVidGetRequest($pid, $vid, string $contentType = self::contentTypes['apiV2ProductsPidVariantsVidGet'][0])
    {

        // verify the required parameter 'pid' is set
        if ($pid === null || (is_array($pid) && count($pid) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pid when calling apiV2ProductsPidVariantsVidGet'
            );
        }

        // verify the required parameter 'vid' is set
        if ($vid === null || (is_array($vid) && count($vid) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $vid when calling apiV2ProductsPidVariantsVidGet'
            );
        }


        $resourcePath = '/api/v2/products/{pid}/variants/{vid}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($pid !== null) {
            $resourcePath = str_replace(
                '{' . 'pid' . '}',
                ObjectSerializer::toPathValue($pid),
                $resourcePath
            );
        }
        // path params
        if ($vid !== null) {
            $resourcePath = str_replace(
                '{' . 'vid' . '}',
                ObjectSerializer::toPathValue($vid),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV2ProductsPidVariantsVidPut
     *
     * Update an existing variant
     *
     * @param  int $pid The ID of the product that the variant belongs to (required)
     * @param  int $vid The ID of the variant to be updated (required)
     * @param  \EKMv2\Model\TempestModelsShopsProductsV2AddVariant|null $tempestModelsShopsProductsV2AddVariant tempestModelsShopsProductsV2AddVariant (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantsVidPut'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2Variant|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError
     */
    public function apiV2ProductsPidVariantsVidPut($pid, $vid, $tempestModelsShopsProductsV2AddVariant = null, string $contentType = self::contentTypes['apiV2ProductsPidVariantsVidPut'][0])
    {
        list($response) = $this->apiV2ProductsPidVariantsVidPutWithHttpInfo($pid, $vid, $tempestModelsShopsProductsV2AddVariant, $contentType);
        return $response;
    }

    /**
     * Operation apiV2ProductsPidVariantsVidPutWithHttpInfo
     *
     * Update an existing variant
     *
     * @param  int $pid The ID of the product that the variant belongs to (required)
     * @param  int $vid The ID of the variant to be updated (required)
     * @param  \EKMv2\Model\TempestModelsShopsProductsV2AddVariant|null $tempestModelsShopsProductsV2AddVariant (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantsVidPut'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2Variant|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV2ProductsPidVariantsVidPutWithHttpInfo($pid, $vid, $tempestModelsShopsProductsV2AddVariant = null, string $contentType = self::contentTypes['apiV2ProductsPidVariantsVidPut'][0])
    {
        $request = $this->apiV2ProductsPidVariantsVidPutRequest($pid, $vid, $tempestModelsShopsProductsV2AddVariant, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2Variant',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2Variant',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2Variant',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV2ProductsPidVariantsVidPutAsync
     *
     * Update an existing variant
     *
     * @param  int $pid The ID of the product that the variant belongs to (required)
     * @param  int $vid The ID of the variant to be updated (required)
     * @param  \EKMv2\Model\TempestModelsShopsProductsV2AddVariant|null $tempestModelsShopsProductsV2AddVariant (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantsVidPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2ProductsPidVariantsVidPutAsync($pid, $vid, $tempestModelsShopsProductsV2AddVariant = null, string $contentType = self::contentTypes['apiV2ProductsPidVariantsVidPut'][0])
    {
        return $this->apiV2ProductsPidVariantsVidPutAsyncWithHttpInfo($pid, $vid, $tempestModelsShopsProductsV2AddVariant, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV2ProductsPidVariantsVidPutAsyncWithHttpInfo
     *
     * Update an existing variant
     *
     * @param  int $pid The ID of the product that the variant belongs to (required)
     * @param  int $vid The ID of the variant to be updated (required)
     * @param  \EKMv2\Model\TempestModelsShopsProductsV2AddVariant|null $tempestModelsShopsProductsV2AddVariant (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantsVidPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2ProductsPidVariantsVidPutAsyncWithHttpInfo($pid, $vid, $tempestModelsShopsProductsV2AddVariant = null, string $contentType = self::contentTypes['apiV2ProductsPidVariantsVidPut'][0])
    {
        $returnType = '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2Variant';
        $request = $this->apiV2ProductsPidVariantsVidPutRequest($pid, $vid, $tempestModelsShopsProductsV2AddVariant, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV2ProductsPidVariantsVidPut'
     *
     * @param  int $pid The ID of the product that the variant belongs to (required)
     * @param  int $vid The ID of the variant to be updated (required)
     * @param  \EKMv2\Model\TempestModelsShopsProductsV2AddVariant|null $tempestModelsShopsProductsV2AddVariant (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsPidVariantsVidPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV2ProductsPidVariantsVidPutRequest($pid, $vid, $tempestModelsShopsProductsV2AddVariant = null, string $contentType = self::contentTypes['apiV2ProductsPidVariantsVidPut'][0])
    {

        // verify the required parameter 'pid' is set
        if ($pid === null || (is_array($pid) && count($pid) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pid when calling apiV2ProductsPidVariantsVidPut'
            );
        }

        // verify the required parameter 'vid' is set
        if ($vid === null || (is_array($vid) && count($vid) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $vid when calling apiV2ProductsPidVariantsVidPut'
            );
        }



        $resourcePath = '/api/v2/products/{pid}/variants/{vid}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($pid !== null) {
            $resourcePath = str_replace(
                '{' . 'pid' . '}',
                ObjectSerializer::toPathValue($pid),
                $resourcePath
            );
        }
        // path params
        if ($vid !== null) {
            $resourcePath = str_replace(
                '{' . 'vid' . '}',
                ObjectSerializer::toPathValue($vid),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($tempestModelsShopsProductsV2AddVariant)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($tempestModelsShopsProductsV2AddVariant));
            } else {
                $httpBody = $tempestModelsShopsProductsV2AddVariant;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV2ProductsVariantCombinationsSearchGet
     *
     * Search variants by parent product ID based on a given criteria
     *
     * @param  int|null $page Page number to display (optional)
     * @param  int|null $limit Items per page (maximum 20) (optional)
     * @param  string|null $query A &lt;a href&#x3D;\&quot;#tag/OData\&quot; target&#x3D;\&quot;_blank\&quot;&gt;search&lt;/a&gt; query e.g. live eq true (optional)
     * @param  string|null $orderby Field to order results. Prefix with a - (dash) for descending e.g. -id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsVariantCombinationsSearchGet'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV1ProductVariant|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV1ProductVariant
     */
    public function apiV2ProductsVariantCombinationsSearchGet($page = null, $limit = null, $query = null, $orderby = null, string $contentType = self::contentTypes['apiV2ProductsVariantCombinationsSearchGet'][0])
    {
        list($response) = $this->apiV2ProductsVariantCombinationsSearchGetWithHttpInfo($page, $limit, $query, $orderby, $contentType);
        return $response;
    }

    /**
     * Operation apiV2ProductsVariantCombinationsSearchGetWithHttpInfo
     *
     * Search variants by parent product ID based on a given criteria
     *
     * @param  int|null $page Page number to display (optional)
     * @param  int|null $limit Items per page (maximum 20) (optional)
     * @param  string|null $query A &lt;a href&#x3D;\&quot;#tag/OData\&quot; target&#x3D;\&quot;_blank\&quot;&gt;search&lt;/a&gt; query e.g. live eq true (optional)
     * @param  string|null $orderby Field to order results. Prefix with a - (dash) for descending e.g. -id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsVariantCombinationsSearchGet'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV1ProductVariant|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV1ProductVariant, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV2ProductsVariantCombinationsSearchGetWithHttpInfo($page = null, $limit = null, $query = null, $orderby = null, string $contentType = self::contentTypes['apiV2ProductsVariantCombinationsSearchGet'][0])
    {
        $request = $this->apiV2ProductsVariantCombinationsSearchGetRequest($page, $limit, $query, $orderby, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV1ProductVariant',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV1ProductVariant',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV1ProductVariant',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV1ProductVariant',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV1ProductVariant',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV2ProductsVariantCombinationsSearchGetAsync
     *
     * Search variants by parent product ID based on a given criteria
     *
     * @param  int|null $page Page number to display (optional)
     * @param  int|null $limit Items per page (maximum 20) (optional)
     * @param  string|null $query A &lt;a href&#x3D;\&quot;#tag/OData\&quot; target&#x3D;\&quot;_blank\&quot;&gt;search&lt;/a&gt; query e.g. live eq true (optional)
     * @param  string|null $orderby Field to order results. Prefix with a - (dash) for descending e.g. -id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsVariantCombinationsSearchGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2ProductsVariantCombinationsSearchGetAsync($page = null, $limit = null, $query = null, $orderby = null, string $contentType = self::contentTypes['apiV2ProductsVariantCombinationsSearchGet'][0])
    {
        return $this->apiV2ProductsVariantCombinationsSearchGetAsyncWithHttpInfo($page, $limit, $query, $orderby, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV2ProductsVariantCombinationsSearchGetAsyncWithHttpInfo
     *
     * Search variants by parent product ID based on a given criteria
     *
     * @param  int|null $page Page number to display (optional)
     * @param  int|null $limit Items per page (maximum 20) (optional)
     * @param  string|null $query A &lt;a href&#x3D;\&quot;#tag/OData\&quot; target&#x3D;\&quot;_blank\&quot;&gt;search&lt;/a&gt; query e.g. live eq true (optional)
     * @param  string|null $orderby Field to order results. Prefix with a - (dash) for descending e.g. -id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsVariantCombinationsSearchGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2ProductsVariantCombinationsSearchGetAsyncWithHttpInfo($page = null, $limit = null, $query = null, $orderby = null, string $contentType = self::contentTypes['apiV2ProductsVariantCombinationsSearchGet'][0])
    {
        $returnType = '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV1ProductVariant';
        $request = $this->apiV2ProductsVariantCombinationsSearchGetRequest($page, $limit, $query, $orderby, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV2ProductsVariantCombinationsSearchGet'
     *
     * @param  int|null $page Page number to display (optional)
     * @param  int|null $limit Items per page (maximum 20) (optional)
     * @param  string|null $query A &lt;a href&#x3D;\&quot;#tag/OData\&quot; target&#x3D;\&quot;_blank\&quot;&gt;search&lt;/a&gt; query e.g. live eq true (optional)
     * @param  string|null $orderby Field to order results. Prefix with a - (dash) for descending e.g. -id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsVariantCombinationsSearchGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV2ProductsVariantCombinationsSearchGetRequest($page = null, $limit = null, $query = null, $orderby = null, string $contentType = self::contentTypes['apiV2ProductsVariantCombinationsSearchGet'][0])
    {






        $resourcePath = '/api/v2/products/variant_combinations/search';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $query,
            'query', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $orderby,
            'orderby', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV2ProductsVariantsChoicesIdGet
     *
     * Get a single variant choice by ID
     *
     * @param  int $id The variant choice ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsVariantsChoicesIdGet'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantChoice|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError
     */
    public function apiV2ProductsVariantsChoicesIdGet($id, string $contentType = self::contentTypes['apiV2ProductsVariantsChoicesIdGet'][0])
    {
        list($response) = $this->apiV2ProductsVariantsChoicesIdGetWithHttpInfo($id, $contentType);
        return $response;
    }

    /**
     * Operation apiV2ProductsVariantsChoicesIdGetWithHttpInfo
     *
     * Get a single variant choice by ID
     *
     * @param  int $id The variant choice ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsVariantsChoicesIdGet'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantChoice|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV2ProductsVariantsChoicesIdGetWithHttpInfo($id, string $contentType = self::contentTypes['apiV2ProductsVariantsChoicesIdGet'][0])
    {
        $request = $this->apiV2ProductsVariantsChoicesIdGetRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantChoice',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantChoice',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantChoice',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV2ProductsVariantsChoicesIdGetAsync
     *
     * Get a single variant choice by ID
     *
     * @param  int $id The variant choice ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsVariantsChoicesIdGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2ProductsVariantsChoicesIdGetAsync($id, string $contentType = self::contentTypes['apiV2ProductsVariantsChoicesIdGet'][0])
    {
        return $this->apiV2ProductsVariantsChoicesIdGetAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV2ProductsVariantsChoicesIdGetAsyncWithHttpInfo
     *
     * Get a single variant choice by ID
     *
     * @param  int $id The variant choice ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsVariantsChoicesIdGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2ProductsVariantsChoicesIdGetAsyncWithHttpInfo($id, string $contentType = self::contentTypes['apiV2ProductsVariantsChoicesIdGet'][0])
    {
        $returnType = '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantChoice';
        $request = $this->apiV2ProductsVariantsChoicesIdGetRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV2ProductsVariantsChoicesIdGet'
     *
     * @param  int $id The variant choice ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ProductsVariantsChoicesIdGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV2ProductsVariantsChoicesIdGetRequest($id, string $contentType = self::contentTypes['apiV2ProductsVariantsChoicesIdGet'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling apiV2ProductsVariantsChoicesIdGet'
            );
        }


        $resourcePath = '/api/v2/products/variants/choices/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
