<?php
/**
 * OrdersApi
 * PHP version 8.1
 *
 * @category Class
 * @package  EKMv2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * EKM Partner API
 *
 * Our new API allows partners to build significantly better integrations with the EKM platform.    To try out the below endpoints, or for full up to date representations of the request / response models, please see the [swagger page](https://api.ekm.net/swagger/index.html). (We display examples here, but the swagger page is guaranteed to show the complete model.)    To keep up to date with the latest updates, please see our [RSS feed](https://partners.ekm.net/ChangeLog/Feed) or the [partner dashboard](https://partners.ekm.net/).
 *
 * The version of the OpenAPI document: v2
 * Contact: api-support@ekm.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace EKMv2\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use EKMv2\ApiException;
use EKMv2\Configuration;
use EKMv2\FormDataProcessor;
use EKMv2\HeaderSelector;
use EKMv2\ObjectSerializer;

/**
 * OrdersApi Class Doc Comment
 *
 * @category Class
 * @package  EKMv2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class OrdersApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'apiV2OrdersGet' => [
            'application/json',
        ],
        'apiV2OrdersIdGet' => [
            'application/json',
        ],
        'apiV2OrdersIdItemsGet' => [
            'application/json',
        ],
        'apiV2OrdersIdItemsItemIdGet' => [
            'application/json',
        ],
        'apiV2OrdersIdStatusPut' => [
            'application/json',
        ],
        'apiV2OrdersSearchGet' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation apiV2OrdersGet
     *
     * Get a paginated set of orders
     *
     * @param  int|null $page Page number to display (optional)
     * @param  int|null $limit Items per page (maximum 20) (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2OrdersGet'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsOrdersV2Order
     */
    public function apiV2OrdersGet($page = null, $limit = null, string $contentType = self::contentTypes['apiV2OrdersGet'][0])
    {
        list($response) = $this->apiV2OrdersGetWithHttpInfo($page, $limit, $contentType);
        return $response;
    }

    /**
     * Operation apiV2OrdersGetWithHttpInfo
     *
     * Get a paginated set of orders
     *
     * @param  int|null $page Page number to display (optional)
     * @param  int|null $limit Items per page (maximum 20) (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2OrdersGet'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsOrdersV2Order, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV2OrdersGetWithHttpInfo($page = null, $limit = null, string $contentType = self::contentTypes['apiV2OrdersGet'][0])
    {
        $request = $this->apiV2OrdersGetRequest($page, $limit, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsOrdersV2Order',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsOrdersV2Order',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsOrdersV2Order',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV2OrdersGetAsync
     *
     * Get a paginated set of orders
     *
     * @param  int|null $page Page number to display (optional)
     * @param  int|null $limit Items per page (maximum 20) (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2OrdersGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2OrdersGetAsync($page = null, $limit = null, string $contentType = self::contentTypes['apiV2OrdersGet'][0])
    {
        return $this->apiV2OrdersGetAsyncWithHttpInfo($page, $limit, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV2OrdersGetAsyncWithHttpInfo
     *
     * Get a paginated set of orders
     *
     * @param  int|null $page Page number to display (optional)
     * @param  int|null $limit Items per page (maximum 20) (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2OrdersGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2OrdersGetAsyncWithHttpInfo($page = null, $limit = null, string $contentType = self::contentTypes['apiV2OrdersGet'][0])
    {
        $returnType = '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsOrdersV2Order';
        $request = $this->apiV2OrdersGetRequest($page, $limit, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV2OrdersGet'
     *
     * @param  int|null $page Page number to display (optional)
     * @param  int|null $limit Items per page (maximum 20) (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2OrdersGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV2OrdersGetRequest($page = null, $limit = null, string $contentType = self::contentTypes['apiV2OrdersGet'][0])
    {




        $resourcePath = '/api/v2/orders';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV2OrdersIdGet
     *
     * Get an order by ID
     *
     * @param  int $id The order ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2OrdersIdGet'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsOrdersV2Order|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError
     */
    public function apiV2OrdersIdGet($id, string $contentType = self::contentTypes['apiV2OrdersIdGet'][0])
    {
        list($response) = $this->apiV2OrdersIdGetWithHttpInfo($id, $contentType);
        return $response;
    }

    /**
     * Operation apiV2OrdersIdGetWithHttpInfo
     *
     * Get an order by ID
     *
     * @param  int $id The order ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2OrdersIdGet'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsOrdersV2Order|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV2OrdersIdGetWithHttpInfo($id, string $contentType = self::contentTypes['apiV2OrdersIdGet'][0])
    {
        $request = $this->apiV2OrdersIdGetRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsOrdersV2Order',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsOrdersV2Order',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsOrdersV2Order',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV2OrdersIdGetAsync
     *
     * Get an order by ID
     *
     * @param  int $id The order ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2OrdersIdGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2OrdersIdGetAsync($id, string $contentType = self::contentTypes['apiV2OrdersIdGet'][0])
    {
        return $this->apiV2OrdersIdGetAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV2OrdersIdGetAsyncWithHttpInfo
     *
     * Get an order by ID
     *
     * @param  int $id The order ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2OrdersIdGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2OrdersIdGetAsyncWithHttpInfo($id, string $contentType = self::contentTypes['apiV2OrdersIdGet'][0])
    {
        $returnType = '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsOrdersV2Order';
        $request = $this->apiV2OrdersIdGetRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV2OrdersIdGet'
     *
     * @param  int $id The order ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2OrdersIdGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV2OrdersIdGetRequest($id, string $contentType = self::contentTypes['apiV2OrdersIdGet'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling apiV2OrdersIdGet'
            );
        }


        $resourcePath = '/api/v2/orders/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV2OrdersIdItemsGet
     *
     * Get an order&#39;s items
     *
     * @param  int $id The order&#39;s ID&#39; (required)
     * @param  int|null $page Page number to display (optional)
     * @param  int|null $limit Items per page (maximum 20) (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2OrdersIdItemsGet'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsOrdersV2OrderItem
     */
    public function apiV2OrdersIdItemsGet($id, $page = null, $limit = null, string $contentType = self::contentTypes['apiV2OrdersIdItemsGet'][0])
    {
        list($response) = $this->apiV2OrdersIdItemsGetWithHttpInfo($id, $page, $limit, $contentType);
        return $response;
    }

    /**
     * Operation apiV2OrdersIdItemsGetWithHttpInfo
     *
     * Get an order&#39;s items
     *
     * @param  int $id The order&#39;s ID&#39; (required)
     * @param  int|null $page Page number to display (optional)
     * @param  int|null $limit Items per page (maximum 20) (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2OrdersIdItemsGet'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsOrdersV2OrderItem, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV2OrdersIdItemsGetWithHttpInfo($id, $page = null, $limit = null, string $contentType = self::contentTypes['apiV2OrdersIdItemsGet'][0])
    {
        $request = $this->apiV2OrdersIdItemsGetRequest($id, $page, $limit, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsOrdersV2OrderItem',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsOrdersV2OrderItem',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsOrdersV2OrderItem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV2OrdersIdItemsGetAsync
     *
     * Get an order&#39;s items
     *
     * @param  int $id The order&#39;s ID&#39; (required)
     * @param  int|null $page Page number to display (optional)
     * @param  int|null $limit Items per page (maximum 20) (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2OrdersIdItemsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2OrdersIdItemsGetAsync($id, $page = null, $limit = null, string $contentType = self::contentTypes['apiV2OrdersIdItemsGet'][0])
    {
        return $this->apiV2OrdersIdItemsGetAsyncWithHttpInfo($id, $page, $limit, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV2OrdersIdItemsGetAsyncWithHttpInfo
     *
     * Get an order&#39;s items
     *
     * @param  int $id The order&#39;s ID&#39; (required)
     * @param  int|null $page Page number to display (optional)
     * @param  int|null $limit Items per page (maximum 20) (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2OrdersIdItemsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2OrdersIdItemsGetAsyncWithHttpInfo($id, $page = null, $limit = null, string $contentType = self::contentTypes['apiV2OrdersIdItemsGet'][0])
    {
        $returnType = '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsOrdersV2OrderItem';
        $request = $this->apiV2OrdersIdItemsGetRequest($id, $page, $limit, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV2OrdersIdItemsGet'
     *
     * @param  int $id The order&#39;s ID&#39; (required)
     * @param  int|null $page Page number to display (optional)
     * @param  int|null $limit Items per page (maximum 20) (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2OrdersIdItemsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV2OrdersIdItemsGetRequest($id, $page = null, $limit = null, string $contentType = self::contentTypes['apiV2OrdersIdItemsGet'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling apiV2OrdersIdItemsGet'
            );
        }




        $resourcePath = '/api/v2/orders/{id}/items';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV2OrdersIdItemsItemIdGet
     *
     * Get a specific item from an order
     *
     * @param  int $id The order&#39;s ID (required)
     * @param  int $itemId The order item&#39;s ID&#39; (required)
     * @param  int $itemId2 The order item ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2OrdersIdItemsItemIdGet'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsOrdersV2OrderItem
     */
    public function apiV2OrdersIdItemsItemIdGet($id, $itemId, $itemId2, string $contentType = self::contentTypes['apiV2OrdersIdItemsItemIdGet'][0])
    {
        list($response) = $this->apiV2OrdersIdItemsItemIdGetWithHttpInfo($id, $itemId, $itemId2, $contentType);
        return $response;
    }

    /**
     * Operation apiV2OrdersIdItemsItemIdGetWithHttpInfo
     *
     * Get a specific item from an order
     *
     * @param  int $id The order&#39;s ID (required)
     * @param  int $itemId The order item&#39;s ID&#39; (required)
     * @param  int $itemId2 The order item ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2OrdersIdItemsItemIdGet'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsOrdersV2OrderItem, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV2OrdersIdItemsItemIdGetWithHttpInfo($id, $itemId, $itemId2, string $contentType = self::contentTypes['apiV2OrdersIdItemsItemIdGet'][0])
    {
        $request = $this->apiV2OrdersIdItemsItemIdGetRequest($id, $itemId, $itemId2, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsOrdersV2OrderItem',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsOrdersV2OrderItem',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsOrdersV2OrderItem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV2OrdersIdItemsItemIdGetAsync
     *
     * Get a specific item from an order
     *
     * @param  int $id The order&#39;s ID (required)
     * @param  int $itemId The order item&#39;s ID&#39; (required)
     * @param  int $itemId2 The order item ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2OrdersIdItemsItemIdGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2OrdersIdItemsItemIdGetAsync($id, $itemId, $itemId2, string $contentType = self::contentTypes['apiV2OrdersIdItemsItemIdGet'][0])
    {
        return $this->apiV2OrdersIdItemsItemIdGetAsyncWithHttpInfo($id, $itemId, $itemId2, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV2OrdersIdItemsItemIdGetAsyncWithHttpInfo
     *
     * Get a specific item from an order
     *
     * @param  int $id The order&#39;s ID (required)
     * @param  int $itemId The order item&#39;s ID&#39; (required)
     * @param  int $itemId2 The order item ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2OrdersIdItemsItemIdGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2OrdersIdItemsItemIdGetAsyncWithHttpInfo($id, $itemId, $itemId2, string $contentType = self::contentTypes['apiV2OrdersIdItemsItemIdGet'][0])
    {
        $returnType = '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsOrdersV2OrderItem';
        $request = $this->apiV2OrdersIdItemsItemIdGetRequest($id, $itemId, $itemId2, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV2OrdersIdItemsItemIdGet'
     *
     * @param  int $id The order&#39;s ID (required)
     * @param  int $itemId The order item&#39;s ID&#39; (required)
     * @param  int $itemId2 The order item ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2OrdersIdItemsItemIdGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV2OrdersIdItemsItemIdGetRequest($id, $itemId, $itemId2, string $contentType = self::contentTypes['apiV2OrdersIdItemsItemIdGet'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling apiV2OrdersIdItemsItemIdGet'
            );
        }

        // verify the required parameter 'itemId' is set
        if ($itemId === null || (is_array($itemId) && count($itemId) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $itemId when calling apiV2OrdersIdItemsItemIdGet'
            );
        }

        // verify the required parameter 'itemId2' is set
        if ($itemId2 === null || (is_array($itemId2) && count($itemId2) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $itemId2 when calling apiV2OrdersIdItemsItemIdGet'
            );
        }


        $resourcePath = '/api/v2/orders/{id}/items/{itemId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $itemId2,
            'item_id', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }
        // path params
        if ($itemId !== null) {
            $resourcePath = str_replace(
                '{' . 'itemId' . '}',
                ObjectSerializer::toPathValue($itemId),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV2OrdersIdStatusPut
     *
     * Updates the status of an order
     *
     * @param  int $id The order ID (required)
     * @param  \EKMv2\Model\TempestModelsShopsOrdersV1OrderStatus|null $tempestModelsShopsOrdersV1OrderStatus The updated order status (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2OrdersIdStatusPut'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsOrdersV2Order|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsOrdersV2Order
     */
    public function apiV2OrdersIdStatusPut($id, $tempestModelsShopsOrdersV1OrderStatus = null, string $contentType = self::contentTypes['apiV2OrdersIdStatusPut'][0])
    {
        list($response) = $this->apiV2OrdersIdStatusPutWithHttpInfo($id, $tempestModelsShopsOrdersV1OrderStatus, $contentType);
        return $response;
    }

    /**
     * Operation apiV2OrdersIdStatusPutWithHttpInfo
     *
     * Updates the status of an order
     *
     * @param  int $id The order ID (required)
     * @param  \EKMv2\Model\TempestModelsShopsOrdersV1OrderStatus|null $tempestModelsShopsOrdersV1OrderStatus The updated order status (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2OrdersIdStatusPut'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsOrdersV2Order|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsOrdersV2Order, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV2OrdersIdStatusPutWithHttpInfo($id, $tempestModelsShopsOrdersV1OrderStatus = null, string $contentType = self::contentTypes['apiV2OrdersIdStatusPut'][0])
    {
        $request = $this->apiV2OrdersIdStatusPutRequest($id, $tempestModelsShopsOrdersV1OrderStatus, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsOrdersV2Order',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsOrdersV2Order',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsOrdersV2Order',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsOrdersV2Order',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsOrdersV2Order',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV2OrdersIdStatusPutAsync
     *
     * Updates the status of an order
     *
     * @param  int $id The order ID (required)
     * @param  \EKMv2\Model\TempestModelsShopsOrdersV1OrderStatus|null $tempestModelsShopsOrdersV1OrderStatus The updated order status (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2OrdersIdStatusPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2OrdersIdStatusPutAsync($id, $tempestModelsShopsOrdersV1OrderStatus = null, string $contentType = self::contentTypes['apiV2OrdersIdStatusPut'][0])
    {
        return $this->apiV2OrdersIdStatusPutAsyncWithHttpInfo($id, $tempestModelsShopsOrdersV1OrderStatus, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV2OrdersIdStatusPutAsyncWithHttpInfo
     *
     * Updates the status of an order
     *
     * @param  int $id The order ID (required)
     * @param  \EKMv2\Model\TempestModelsShopsOrdersV1OrderStatus|null $tempestModelsShopsOrdersV1OrderStatus The updated order status (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2OrdersIdStatusPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2OrdersIdStatusPutAsyncWithHttpInfo($id, $tempestModelsShopsOrdersV1OrderStatus = null, string $contentType = self::contentTypes['apiV2OrdersIdStatusPut'][0])
    {
        $returnType = '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsOrdersV2Order';
        $request = $this->apiV2OrdersIdStatusPutRequest($id, $tempestModelsShopsOrdersV1OrderStatus, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV2OrdersIdStatusPut'
     *
     * @param  int $id The order ID (required)
     * @param  \EKMv2\Model\TempestModelsShopsOrdersV1OrderStatus|null $tempestModelsShopsOrdersV1OrderStatus The updated order status (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2OrdersIdStatusPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV2OrdersIdStatusPutRequest($id, $tempestModelsShopsOrdersV1OrderStatus = null, string $contentType = self::contentTypes['apiV2OrdersIdStatusPut'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling apiV2OrdersIdStatusPut'
            );
        }



        $resourcePath = '/api/v2/orders/{id}/status';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($tempestModelsShopsOrdersV1OrderStatus)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($tempestModelsShopsOrdersV1OrderStatus));
            } else {
                $httpBody = $tempestModelsShopsOrdersV1OrderStatus;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV2OrdersSearchGet
     *
     * Searches orders based on search criteria
     *
     * @param  int|null $page Page number to display (optional)
     * @param  int|null $limit Items per page (maximum 20) (optional)
     * @param  string|null $query A &lt;a href&#x3D;\&quot;#tag/OData\&quot; target&#x3D;\&quot;_blank\&quot;&gt;search&lt;/a&gt; query e.g. status eq &#39;PENDING&#39; (optional)
     * @param  string|null $orderby Field to order results. Prefix with a - (dash) for descending e.g. -id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2OrdersSearchGet'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsOrdersV2Order|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsOrdersV2Order
     */
    public function apiV2OrdersSearchGet($page = null, $limit = null, $query = null, $orderby = null, string $contentType = self::contentTypes['apiV2OrdersSearchGet'][0])
    {
        list($response) = $this->apiV2OrdersSearchGetWithHttpInfo($page, $limit, $query, $orderby, $contentType);
        return $response;
    }

    /**
     * Operation apiV2OrdersSearchGetWithHttpInfo
     *
     * Searches orders based on search criteria
     *
     * @param  int|null $page Page number to display (optional)
     * @param  int|null $limit Items per page (maximum 20) (optional)
     * @param  string|null $query A &lt;a href&#x3D;\&quot;#tag/OData\&quot; target&#x3D;\&quot;_blank\&quot;&gt;search&lt;/a&gt; query e.g. status eq &#39;PENDING&#39; (optional)
     * @param  string|null $orderby Field to order results. Prefix with a - (dash) for descending e.g. -id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2OrdersSearchGet'] to see the possible values for this operation
     *
     * @throws \EKMv2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsOrdersV2Order|\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsOrdersV2Order, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV2OrdersSearchGetWithHttpInfo($page = null, $limit = null, $query = null, $orderby = null, string $contentType = self::contentTypes['apiV2OrdersSearchGet'][0])
    {
        $request = $this->apiV2OrdersSearchGetRequest($page, $limit, $query, $orderby, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsOrdersV2Order',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsOrdersV2Order',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsOrdersV2Order',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsOrdersV2Order',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsOrdersV2Order',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV2OrdersSearchGetAsync
     *
     * Searches orders based on search criteria
     *
     * @param  int|null $page Page number to display (optional)
     * @param  int|null $limit Items per page (maximum 20) (optional)
     * @param  string|null $query A &lt;a href&#x3D;\&quot;#tag/OData\&quot; target&#x3D;\&quot;_blank\&quot;&gt;search&lt;/a&gt; query e.g. status eq &#39;PENDING&#39; (optional)
     * @param  string|null $orderby Field to order results. Prefix with a - (dash) for descending e.g. -id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2OrdersSearchGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2OrdersSearchGetAsync($page = null, $limit = null, $query = null, $orderby = null, string $contentType = self::contentTypes['apiV2OrdersSearchGet'][0])
    {
        return $this->apiV2OrdersSearchGetAsyncWithHttpInfo($page, $limit, $query, $orderby, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV2OrdersSearchGetAsyncWithHttpInfo
     *
     * Searches orders based on search criteria
     *
     * @param  int|null $page Page number to display (optional)
     * @param  int|null $limit Items per page (maximum 20) (optional)
     * @param  string|null $query A &lt;a href&#x3D;\&quot;#tag/OData\&quot; target&#x3D;\&quot;_blank\&quot;&gt;search&lt;/a&gt; query e.g. status eq &#39;PENDING&#39; (optional)
     * @param  string|null $orderby Field to order results. Prefix with a - (dash) for descending e.g. -id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2OrdersSearchGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2OrdersSearchGetAsyncWithHttpInfo($page = null, $limit = null, $query = null, $orderby = null, string $contentType = self::contentTypes['apiV2OrdersSearchGet'][0])
    {
        $returnType = '\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsOrdersV2Order';
        $request = $this->apiV2OrdersSearchGetRequest($page, $limit, $query, $orderby, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV2OrdersSearchGet'
     *
     * @param  int|null $page Page number to display (optional)
     * @param  int|null $limit Items per page (maximum 20) (optional)
     * @param  string|null $query A &lt;a href&#x3D;\&quot;#tag/OData\&quot; target&#x3D;\&quot;_blank\&quot;&gt;search&lt;/a&gt; query e.g. status eq &#39;PENDING&#39; (optional)
     * @param  string|null $orderby Field to order results. Prefix with a - (dash) for descending e.g. -id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2OrdersSearchGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV2OrdersSearchGetRequest($page = null, $limit = null, $query = null, $orderby = null, string $contentType = self::contentTypes['apiV2OrdersSearchGet'][0])
    {






        $resourcePath = '/api/v2/orders/search';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $query,
            'query', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $orderby,
            'orderby', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
