# EKMv2\WebhooksApi

All URIs are relative to https://api.ekm.net, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV2WebhooksIdDelete()**](WebhooksApi.md#apiV2WebhooksIdDelete) | **DELETE** /api/v2/Webhooks/{id} | Unsubscribe from a webhook |
| [**apiV2WebhooksIdGet()**](WebhooksApi.md#apiV2WebhooksIdGet) | **GET** /api/v2/Webhooks/{id} | Get a specific subscription |
| [**apiV2WebhooksPost()**](WebhooksApi.md#apiV2WebhooksPost) | **POST** /api/v2/Webhooks | Update a webhook subscription |
| [**apiV2WebhooksPut()**](WebhooksApi.md#apiV2WebhooksPut) | **PUT** /api/v2/Webhooks | Create a webhook subscription |
| [**apiV2WebhooksWebhooksGet()**](WebhooksApi.md#apiV2WebhooksWebhooksGet) | **GET** /api/v2/Webhooks/webhooks | Get list of existing subscriptions |


## `apiV2WebhooksIdDelete()`

```php
apiV2WebhooksIdDelete($id)
```

Unsubscribe from a webhook

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: Bearer
$config = EKMv2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKMv2\Api\WebhooksApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 'id_example'; // string | The ID of the subscription to delete

try {
    $apiInstance->apiV2WebhooksIdDelete($id);
} catch (Exception $e) {
    echo 'Exception when calling WebhooksApi->apiV2WebhooksIdDelete: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **string**| The ID of the subscription to delete | |

### Return type

void (empty response body)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV2WebhooksIdGet()`

```php
apiV2WebhooksIdGet($id)
```

Get a specific subscription

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: Bearer
$config = EKMv2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKMv2\Api\WebhooksApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 'id_example'; // string

try {
    $apiInstance->apiV2WebhooksIdGet($id);
} catch (Exception $e) {
    echo 'Exception when calling WebhooksApi->apiV2WebhooksIdGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **string**|  | |

### Return type

void (empty response body)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV2WebhooksPost()`

```php
apiV2WebhooksPost($tempestModelsWebhooksV2UpdateWebhookSubscription)
```

Update a webhook subscription

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: Bearer
$config = EKMv2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKMv2\Api\WebhooksApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$tempestModelsWebhooksV2UpdateWebhookSubscription = new \EKMv2\Model\TempestModelsWebhooksV2UpdateWebhookSubscription(); // \EKMv2\Model\TempestModelsWebhooksV2UpdateWebhookSubscription | The subscription to be updated

try {
    $apiInstance->apiV2WebhooksPost($tempestModelsWebhooksV2UpdateWebhookSubscription);
} catch (Exception $e) {
    echo 'Exception when calling WebhooksApi->apiV2WebhooksPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **tempestModelsWebhooksV2UpdateWebhookSubscription** | [**\EKMv2\Model\TempestModelsWebhooksV2UpdateWebhookSubscription**](../Model/TempestModelsWebhooksV2UpdateWebhookSubscription.md)| The subscription to be updated | [optional] |

### Return type

void (empty response body)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV2WebhooksPut()`

```php
apiV2WebhooksPut($tempestModelsWebhooksV2AddWebhookSubscription)
```

Create a webhook subscription

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: Bearer
$config = EKMv2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKMv2\Api\WebhooksApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$tempestModelsWebhooksV2AddWebhookSubscription = new \EKMv2\Model\TempestModelsWebhooksV2AddWebhookSubscription(); // \EKMv2\Model\TempestModelsWebhooksV2AddWebhookSubscription | The subscription to be added

try {
    $apiInstance->apiV2WebhooksPut($tempestModelsWebhooksV2AddWebhookSubscription);
} catch (Exception $e) {
    echo 'Exception when calling WebhooksApi->apiV2WebhooksPut: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **tempestModelsWebhooksV2AddWebhookSubscription** | [**\EKMv2\Model\TempestModelsWebhooksV2AddWebhookSubscription**](../Model/TempestModelsWebhooksV2AddWebhookSubscription.md)| The subscription to be added | [optional] |

### Return type

void (empty response body)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV2WebhooksWebhooksGet()`

```php
apiV2WebhooksWebhooksGet()
```

Get list of existing subscriptions

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: Bearer
$config = EKMv2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKMv2\Api\WebhooksApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $apiInstance->apiV2WebhooksWebhooksGet();
} catch (Exception $e) {
    echo 'Exception when calling WebhooksApi->apiV2WebhooksWebhooksGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

void (empty response body)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
