# EKMv2\ProductsApi

All URIs are relative to https://api.ekm.net, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV2ProductsMasterIdGet()**](ProductsApi.md#apiV2ProductsMasterIdGet) | **GET** /api/v2/products/master/{id} | Get a product&#39;s master product by ID |


## `apiV2ProductsMasterIdGet()`

```php
apiV2ProductsMasterIdGet($id): \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2Product
```

Get a product's master product by ID

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: Bearer
$config = EKMv2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKMv2\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | The product ID

try {
    $result = $apiInstance->apiV2ProductsMasterIdGet($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->apiV2ProductsMasterIdGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| The product ID | |

### Return type

[**\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2Product**](../Model/TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2Product.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
