# EKMv2\ProductVariantsApi

All URIs are relative to https://api.ekm.net, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV2ProductsPidVariantCombinationsGet()**](ProductVariantsApi.md#apiV2ProductsPidVariantCombinationsGet) | **GET** /api/v2/products/{pid}/variant_combinations | Get the variant combinations associated with a parent product |
| [**apiV2ProductsPidVariantCombinationsSearchGet()**](ProductVariantsApi.md#apiV2ProductsPidVariantCombinationsSearchGet) | **GET** /api/v2/products/{pid}/variant_combinations/search | Search variants by parent product ID based on a given criteria |
| [**apiV2ProductsPidVariantCombinationsVcidGet()**](ProductVariantsApi.md#apiV2ProductsPidVariantCombinationsVcidGet) | **GET** /api/v2/products/{pid}/variant_combinations/{vcid} | Get a single variant combination associated with a parent product |
| [**apiV2ProductsPidVariantCombinationsVcidImagesGet()**](ProductVariantsApi.md#apiV2ProductsPidVariantCombinationsVcidImagesGet) | **GET** /api/v2/products/{pid}/variant_combinations/{vcid}/images | Get a variant combination&#39;s images. |
| [**apiV2ProductsPidVariantCombinationsVcidImagesImageNumberPost()**](ProductVariantsApi.md#apiV2ProductsPidVariantCombinationsVcidImagesImageNumberPost) | **POST** /api/v2/products/{pid}/variant_combinations/{vcid}/images/{imageNumber} | Assign an image URL to a variant combination |
| [**apiV2ProductsPidVariantCombinationsVcidPut()**](ProductVariantsApi.md#apiV2ProductsPidVariantCombinationsVcidPut) | **PUT** /api/v2/products/{pid}/variant_combinations/{vcid} | Update a single variant combination |
| [**apiV2ProductsPidVariantsGet()**](ProductVariantsApi.md#apiV2ProductsPidVariantsGet) | **GET** /api/v2/products/{pid}/variants | Get all of a product&#39;s associated variants |
| [**apiV2ProductsPidVariantsPost()**](ProductVariantsApi.md#apiV2ProductsPidVariantsPost) | **POST** /api/v2/products/{pid}/variants | Add a new variant to a specific product. |
| [**apiV2ProductsPidVariantsVidChoicesGet()**](ProductVariantsApi.md#apiV2ProductsPidVariantsVidChoicesGet) | **GET** /api/v2/products/{pid}/variants/{vid}/choices | Get the choices associated with a specific variant |
| [**apiV2ProductsPidVariantsVidChoicesPost()**](ProductVariantsApi.md#apiV2ProductsPidVariantsVidChoicesPost) | **POST** /api/v2/products/{pid}/variants/{vid}/choices | Create a new choice for a specific variant |
| [**apiV2ProductsPidVariantsVidChoicesVcidDelete()**](ProductVariantsApi.md#apiV2ProductsPidVariantsVidChoicesVcidDelete) | **DELETE** /api/v2/products/{pid}/variants/{vid}/choices/{vcid} | Delete a specific choice belonging to a variant |
| [**apiV2ProductsPidVariantsVidChoicesVcidGet()**](ProductVariantsApi.md#apiV2ProductsPidVariantsVidChoicesVcidGet) | **GET** /api/v2/products/{pid}/variants/{vid}/choices/{vcid} | Get a single choice associated with a variant |
| [**apiV2ProductsPidVariantsVidChoicesVcidPut()**](ProductVariantsApi.md#apiV2ProductsPidVariantsVidChoicesVcidPut) | **PUT** /api/v2/products/{pid}/variants/{vid}/choices/{vcid} | Update a specific choice belonging to a variant |
| [**apiV2ProductsPidVariantsVidDelete()**](ProductVariantsApi.md#apiV2ProductsPidVariantsVidDelete) | **DELETE** /api/v2/products/{pid}/variants/{vid} | Delete an existing variant |
| [**apiV2ProductsPidVariantsVidGet()**](ProductVariantsApi.md#apiV2ProductsPidVariantsVidGet) | **GET** /api/v2/products/{pid}/variants/{vid} | Get a specific variant belonging to a product |
| [**apiV2ProductsPidVariantsVidPut()**](ProductVariantsApi.md#apiV2ProductsPidVariantsVidPut) | **PUT** /api/v2/products/{pid}/variants/{vid} | Update an existing variant |
| [**apiV2ProductsVariantCombinationsSearchGet()**](ProductVariantsApi.md#apiV2ProductsVariantCombinationsSearchGet) | **GET** /api/v2/products/variant_combinations/search | Search variants by parent product ID based on a given criteria |
| [**apiV2ProductsVariantsChoicesIdGet()**](ProductVariantsApi.md#apiV2ProductsVariantsChoicesIdGet) | **GET** /api/v2/products/variants/choices/{id} | Get a single variant choice by ID |


## `apiV2ProductsPidVariantCombinationsGet()`

```php
apiV2ProductsPidVariantCombinationsGet($pid, $page, $limit, $orderby): \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV2VariantCombination
```

Get the variant combinations associated with a parent product

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: Bearer
$config = EKMv2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKMv2\Api\ProductVariantsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$pid = 56; // int | The ID of the product that the variant combinations are children of
$page = 56; // int | Page number to display
$limit = 56; // int | Items per page (maximum 20)
$orderby = 'orderby_example'; // string | Field to order results. Prefix with a - (dash) for descending e.g. -id

try {
    $result = $apiInstance->apiV2ProductsPidVariantCombinationsGet($pid, $page, $limit, $orderby);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductVariantsApi->apiV2ProductsPidVariantCombinationsGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **pid** | **int**| The ID of the product that the variant combinations are children of | |
| **page** | **int**| Page number to display | [optional] |
| **limit** | **int**| Items per page (maximum 20) | [optional] |
| **orderby** | **string**| Field to order results. Prefix with a - (dash) for descending e.g. -id | [optional] |

### Return type

[**\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV2VariantCombination**](../Model/TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV2VariantCombination.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV2ProductsPidVariantCombinationsSearchGet()`

```php
apiV2ProductsPidVariantCombinationsSearchGet($pid, $page, $limit, $query, $orderby): \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV1ProductVariant
```

Search variants by parent product ID based on a given criteria

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: Bearer
$config = EKMv2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKMv2\Api\ProductVariantsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$pid = 56; // int | The ID of the product that the the variant combinations are a child of
$page = 56; // int | Page number to display
$limit = 56; // int | Items per page (maximum 20)
$query = 'query_example'; // string | A <a href=\"#tag/OData\" target=\"_blank\">search</a> query e.g. live eq true
$orderby = 'orderby_example'; // string | Field to order results. Prefix with a - (dash) for descending e.g. -id

try {
    $result = $apiInstance->apiV2ProductsPidVariantCombinationsSearchGet($pid, $page, $limit, $query, $orderby);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductVariantsApi->apiV2ProductsPidVariantCombinationsSearchGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **pid** | **int**| The ID of the product that the the variant combinations are a child of | |
| **page** | **int**| Page number to display | [optional] |
| **limit** | **int**| Items per page (maximum 20) | [optional] |
| **query** | **string**| A &lt;a href&#x3D;\&quot;#tag/OData\&quot; target&#x3D;\&quot;_blank\&quot;&gt;search&lt;/a&gt; query e.g. live eq true | [optional] |
| **orderby** | **string**| Field to order results. Prefix with a - (dash) for descending e.g. -id | [optional] |

### Return type

[**\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV1ProductVariant**](../Model/TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV1ProductVariant.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV2ProductsPidVariantCombinationsVcidGet()`

```php
apiV2ProductsPidVariantCombinationsVcidGet($pid, $vcid): \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantCombination
```

Get a single variant combination associated with a parent product

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: Bearer
$config = EKMv2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKMv2\Api\ProductVariantsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$pid = 56; // int | The ID of the product that the the variant combination is a child of
$vcid = 56; // int | The variant combination ID

try {
    $result = $apiInstance->apiV2ProductsPidVariantCombinationsVcidGet($pid, $vcid);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductVariantsApi->apiV2ProductsPidVariantCombinationsVcidGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **pid** | **int**| The ID of the product that the the variant combination is a child of | |
| **vcid** | **int**| The variant combination ID | |

### Return type

[**\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantCombination**](../Model/TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantCombination.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV2ProductsPidVariantCombinationsVcidImagesGet()`

```php
apiV2ProductsPidVariantCombinationsVcidImagesGet($pid, $vcid): \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV1ProductImages
```

Get a variant combination's images.

Images stored on EKM servers will have the location property of the response set to the path of the image file. This will need to be prepended with the shop's domain.  Remote images will have the remote property of the response set to the URL of the image.  Images that have been deleted will have the location property of the response set to \"No image available.\"

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: Bearer
$config = EKMv2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKMv2\Api\ProductVariantsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$pid = 56; // int | The product ID
$vcid = 56; // int | The variant combination ID

try {
    $result = $apiInstance->apiV2ProductsPidVariantCombinationsVcidImagesGet($pid, $vcid);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductVariantsApi->apiV2ProductsPidVariantCombinationsVcidImagesGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **pid** | **int**| The product ID | |
| **vcid** | **int**| The variant combination ID | |

### Return type

[**\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV1ProductImages**](../Model/TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV1ProductImages.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV2ProductsPidVariantCombinationsVcidImagesImageNumberPost()`

```php
apiV2ProductsPidVariantCombinationsVcidImagesImageNumberPost($pid, $vcid, $imageNumber, $imageUrl, $id): \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV1ProductImages
```

Assign an image URL to a variant combination

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: Bearer
$config = EKMv2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKMv2\Api\ProductVariantsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$pid = 56; // int | The parent product ID that the variant combination is associated with
$vcid = 56; // int | The variant combination ID
$imageNumber = 56; // int | The image position that the URL will be assigned to
$imageUrl = 'imageUrl_example'; // string | The URL of the image to be assigned
$id = 56; // int | The product ID

try {
    $result = $apiInstance->apiV2ProductsPidVariantCombinationsVcidImagesImageNumberPost($pid, $vcid, $imageNumber, $imageUrl, $id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductVariantsApi->apiV2ProductsPidVariantCombinationsVcidImagesImageNumberPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **pid** | **int**| The parent product ID that the variant combination is associated with | |
| **vcid** | **int**| The variant combination ID | |
| **imageNumber** | **int**| The image position that the URL will be assigned to | |
| **imageUrl** | **string**| The URL of the image to be assigned | |
| **id** | **int**| The product ID | |

### Return type

[**\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV1ProductImages**](../Model/TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV1ProductImages.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV2ProductsPidVariantCombinationsVcidPut()`

```php
apiV2ProductsPidVariantCombinationsVcidPut($pid, $vcid, $tempestModelsShopsProductsV2VariantCombination): \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantCombination
```

Update a single variant combination

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: Bearer
$config = EKMv2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKMv2\Api\ProductVariantsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$pid = 56; // int | The ID of the product that the the variant combination is a child of
$vcid = 56; // int | The variant combination ID
$tempestModelsShopsProductsV2VariantCombination = new \EKMv2\Model\TempestModelsShopsProductsV2VariantCombination(); // \EKMv2\Model\TempestModelsShopsProductsV2VariantCombination

try {
    $result = $apiInstance->apiV2ProductsPidVariantCombinationsVcidPut($pid, $vcid, $tempestModelsShopsProductsV2VariantCombination);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductVariantsApi->apiV2ProductsPidVariantCombinationsVcidPut: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **pid** | **int**| The ID of the product that the the variant combination is a child of | |
| **vcid** | **int**| The variant combination ID | |
| **tempestModelsShopsProductsV2VariantCombination** | [**\EKMv2\Model\TempestModelsShopsProductsV2VariantCombination**](../Model/TempestModelsShopsProductsV2VariantCombination.md)|  | [optional] |

### Return type

[**\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantCombination**](../Model/TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantCombination.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV2ProductsPidVariantsGet()`

```php
apiV2ProductsPidVariantsGet($pid, $page, $limit, $orderby): \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV2Variant
```

Get all of a product's associated variants

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: Bearer
$config = EKMv2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKMv2\Api\ProductVariantsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$pid = 56; // int | The parent product ID
$page = 56; // int | Page number to display
$limit = 56; // int | Items per page (maximum 20)
$orderby = 'orderby_example'; // string | Field to order results. Prefix with a - (dash) for descending e.g. -id

try {
    $result = $apiInstance->apiV2ProductsPidVariantsGet($pid, $page, $limit, $orderby);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductVariantsApi->apiV2ProductsPidVariantsGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **pid** | **int**| The parent product ID | |
| **page** | **int**| Page number to display | [optional] |
| **limit** | **int**| Items per page (maximum 20) | [optional] |
| **orderby** | **string**| Field to order results. Prefix with a - (dash) for descending e.g. -id | [optional] |

### Return type

[**\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV2Variant**](../Model/TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV2Variant.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV2ProductsPidVariantsPost()`

```php
apiV2ProductsPidVariantsPost($pid, $tempestModelsShopsProductsV2AddVariant): \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2Variant
```

Add a new variant to a specific product.

The variant _type_ must be one of **'DROPDOWN'**, **'COLOUR'**, or **'SIZE'**. This relates to how the variant is displayed within the customers shop.  * If the type is '**DROPDOWN**', then the options are displayed in a dropdown menu.  * If the type is '**COLOUR**' then the colour options are displayed on selectable colour swatches. The colour displayed on the swatches are hexadecimal values set using the _data_value_ property of the variant choice. E.g To display the colour red, the _data_value_ of the variant option would be _#ff0000_.  * If the type is '**SIZE**' then the size options are displayed as a collection of buttons. The text displayed on the buttons are set using the _data_value_ of the variant choice.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: Bearer
$config = EKMv2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKMv2\Api\ProductVariantsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$pid = 56; // int | The ID of the product that the variant will be added to
$tempestModelsShopsProductsV2AddVariant = {"meta":{},"links":[],"validation_result":null,"errors":null,"data":{"name":"Flavour","type":"DROPDOWN","size":null}}; // \EKMv2\Model\TempestModelsShopsProductsV2AddVariant

try {
    $result = $apiInstance->apiV2ProductsPidVariantsPost($pid, $tempestModelsShopsProductsV2AddVariant);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductVariantsApi->apiV2ProductsPidVariantsPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **pid** | **int**| The ID of the product that the variant will be added to | |
| **tempestModelsShopsProductsV2AddVariant** | [**\EKMv2\Model\TempestModelsShopsProductsV2AddVariant**](../Model/TempestModelsShopsProductsV2AddVariant.md)|  | [optional] |

### Return type

[**\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2Variant**](../Model/TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2Variant.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV2ProductsPidVariantsVidChoicesGet()`

```php
apiV2ProductsPidVariantsVidChoicesGet($pid, $vid, $page, $limit, $orderby): \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV2VariantChoice
```

Get the choices associated with a specific variant

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: Bearer
$config = EKMv2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKMv2\Api\ProductVariantsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$pid = 56; // int | The ID of the product that the variant belongs to
$vid = 56; // int | The ID of the variant to get the choices for
$page = 56; // int | Page number to display
$limit = 56; // int | Items per page (maximum 20)
$orderby = 'orderby_example'; // string | Field to order results. Prefix with a - (dash) for descending e.g. -id

try {
    $result = $apiInstance->apiV2ProductsPidVariantsVidChoicesGet($pid, $vid, $page, $limit, $orderby);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductVariantsApi->apiV2ProductsPidVariantsVidChoicesGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **pid** | **int**| The ID of the product that the variant belongs to | |
| **vid** | **int**| The ID of the variant to get the choices for | |
| **page** | **int**| Page number to display | [optional] |
| **limit** | **int**| Items per page (maximum 20) | [optional] |
| **orderby** | **string**| Field to order results. Prefix with a - (dash) for descending e.g. -id | [optional] |

### Return type

[**\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV2VariantChoice**](../Model/TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV2VariantChoice.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV2ProductsPidVariantsVidChoicesPost()`

```php
apiV2ProductsPidVariantsVidChoicesPost($pid, $vid, $tempestModelsShopsProductsV2AddVariantChoice): \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantChoice
```

Create a new choice for a specific variant

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: Bearer
$config = EKMv2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKMv2\Api\ProductVariantsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$pid = 56; // int | The ID of the product that the variant belongs to
$vid = 56; // int | The ID of the variant to add the choice to
$tempestModelsShopsProductsV2AddVariantChoice = new \EKMv2\Model\TempestModelsShopsProductsV2AddVariantChoice(); // \EKMv2\Model\TempestModelsShopsProductsV2AddVariantChoice

try {
    $result = $apiInstance->apiV2ProductsPidVariantsVidChoicesPost($pid, $vid, $tempestModelsShopsProductsV2AddVariantChoice);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductVariantsApi->apiV2ProductsPidVariantsVidChoicesPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **pid** | **int**| The ID of the product that the variant belongs to | |
| **vid** | **int**| The ID of the variant to add the choice to | |
| **tempestModelsShopsProductsV2AddVariantChoice** | [**\EKMv2\Model\TempestModelsShopsProductsV2AddVariantChoice**](../Model/TempestModelsShopsProductsV2AddVariantChoice.md)|  | [optional] |

### Return type

[**\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantChoice**](../Model/TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantChoice.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV2ProductsPidVariantsVidChoicesVcidDelete()`

```php
apiV2ProductsPidVariantsVidChoicesVcidDelete($pid, $vid, $vcid): \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV1ProductOptionItem
```

Delete a specific choice belonging to a variant

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: Bearer
$config = EKMv2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKMv2\Api\ProductVariantsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$pid = 56; // int | The ID of the product that the variant belongs to
$vid = 56; // int | The ID of the variant that the choice belongs to
$vcid = 56; // int | The ID of the variant choice to delete

try {
    $result = $apiInstance->apiV2ProductsPidVariantsVidChoicesVcidDelete($pid, $vid, $vcid);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductVariantsApi->apiV2ProductsPidVariantsVidChoicesVcidDelete: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **pid** | **int**| The ID of the product that the variant belongs to | |
| **vid** | **int**| The ID of the variant that the choice belongs to | |
| **vcid** | **int**| The ID of the variant choice to delete | |

### Return type

[**\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV1ProductOptionItem**](../Model/TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV1ProductOptionItem.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV2ProductsPidVariantsVidChoicesVcidGet()`

```php
apiV2ProductsPidVariantsVidChoicesVcidGet($pid, $vid, $vcid): \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantChoice
```

Get a single choice associated with a variant

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: Bearer
$config = EKMv2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKMv2\Api\ProductVariantsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$pid = 56; // int | The ID of the product that the variant belongs to
$vid = 56; // int | The ID of the variant to get the choices for
$vcid = 56; // int | The ID of the variant choice

try {
    $result = $apiInstance->apiV2ProductsPidVariantsVidChoicesVcidGet($pid, $vid, $vcid);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductVariantsApi->apiV2ProductsPidVariantsVidChoicesVcidGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **pid** | **int**| The ID of the product that the variant belongs to | |
| **vid** | **int**| The ID of the variant to get the choices for | |
| **vcid** | **int**| The ID of the variant choice | |

### Return type

[**\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantChoice**](../Model/TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantChoice.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV2ProductsPidVariantsVidChoicesVcidPut()`

```php
apiV2ProductsPidVariantsVidChoicesVcidPut($pid, $vid, $vcid, $tempestModelsShopsProductsV2AddVariantChoice): \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantChoice
```

Update a specific choice belonging to a variant

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: Bearer
$config = EKMv2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKMv2\Api\ProductVariantsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$pid = 56; // int | The ID of the product that the variant belongs to
$vid = 56; // int | The ID of the variant that the choice belongs to
$vcid = 56; // int | The ID of the variant choice to update
$tempestModelsShopsProductsV2AddVariantChoice = new \EKMv2\Model\TempestModelsShopsProductsV2AddVariantChoice(); // \EKMv2\Model\TempestModelsShopsProductsV2AddVariantChoice

try {
    $result = $apiInstance->apiV2ProductsPidVariantsVidChoicesVcidPut($pid, $vid, $vcid, $tempestModelsShopsProductsV2AddVariantChoice);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductVariantsApi->apiV2ProductsPidVariantsVidChoicesVcidPut: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **pid** | **int**| The ID of the product that the variant belongs to | |
| **vid** | **int**| The ID of the variant that the choice belongs to | |
| **vcid** | **int**| The ID of the variant choice to update | |
| **tempestModelsShopsProductsV2AddVariantChoice** | [**\EKMv2\Model\TempestModelsShopsProductsV2AddVariantChoice**](../Model/TempestModelsShopsProductsV2AddVariantChoice.md)|  | [optional] |

### Return type

[**\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantChoice**](../Model/TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantChoice.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV2ProductsPidVariantsVidDelete()`

```php
apiV2ProductsPidVariantsVidDelete($pid, $vid): \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV1ProductOption
```

Delete an existing variant

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: Bearer
$config = EKMv2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKMv2\Api\ProductVariantsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$pid = 56; // int | The ID of the product that the variant belongs to
$vid = 56; // int | The ID of the variant to be updated

try {
    $result = $apiInstance->apiV2ProductsPidVariantsVidDelete($pid, $vid);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductVariantsApi->apiV2ProductsPidVariantsVidDelete: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **pid** | **int**| The ID of the product that the variant belongs to | |
| **vid** | **int**| The ID of the variant to be updated | |

### Return type

[**\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV1ProductOption**](../Model/TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV1ProductOption.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV2ProductsPidVariantsVidGet()`

```php
apiV2ProductsPidVariantsVidGet($pid, $vid): \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2Variant
```

Get a specific variant belonging to a product

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: Bearer
$config = EKMv2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKMv2\Api\ProductVariantsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$pid = 56; // int | The parent product ID
$vid = 56; // int | The variant ID

try {
    $result = $apiInstance->apiV2ProductsPidVariantsVidGet($pid, $vid);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductVariantsApi->apiV2ProductsPidVariantsVidGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **pid** | **int**| The parent product ID | |
| **vid** | **int**| The variant ID | |

### Return type

[**\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2Variant**](../Model/TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2Variant.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV2ProductsPidVariantsVidPut()`

```php
apiV2ProductsPidVariantsVidPut($pid, $vid, $tempestModelsShopsProductsV2AddVariant): \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2Variant
```

Update an existing variant

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: Bearer
$config = EKMv2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKMv2\Api\ProductVariantsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$pid = 56; // int | The ID of the product that the variant belongs to
$vid = 56; // int | The ID of the variant to be updated
$tempestModelsShopsProductsV2AddVariant = new \EKMv2\Model\TempestModelsShopsProductsV2AddVariant(); // \EKMv2\Model\TempestModelsShopsProductsV2AddVariant

try {
    $result = $apiInstance->apiV2ProductsPidVariantsVidPut($pid, $vid, $tempestModelsShopsProductsV2AddVariant);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductVariantsApi->apiV2ProductsPidVariantsVidPut: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **pid** | **int**| The ID of the product that the variant belongs to | |
| **vid** | **int**| The ID of the variant to be updated | |
| **tempestModelsShopsProductsV2AddVariant** | [**\EKMv2\Model\TempestModelsShopsProductsV2AddVariant**](../Model/TempestModelsShopsProductsV2AddVariant.md)|  | [optional] |

### Return type

[**\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2Variant**](../Model/TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2Variant.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV2ProductsVariantCombinationsSearchGet()`

```php
apiV2ProductsVariantCombinationsSearchGet($page, $limit, $query, $orderby): \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV1ProductVariant
```

Search variants by parent product ID based on a given criteria

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: Bearer
$config = EKMv2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKMv2\Api\ProductVariantsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page = 56; // int | Page number to display
$limit = 56; // int | Items per page (maximum 20)
$query = 'query_example'; // string | A <a href=\"#tag/OData\" target=\"_blank\">search</a> query e.g. live eq true
$orderby = 'orderby_example'; // string | Field to order results. Prefix with a - (dash) for descending e.g. -id

try {
    $result = $apiInstance->apiV2ProductsVariantCombinationsSearchGet($page, $limit, $query, $orderby);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductVariantsApi->apiV2ProductsVariantCombinationsSearchGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page** | **int**| Page number to display | [optional] |
| **limit** | **int**| Items per page (maximum 20) | [optional] |
| **query** | **string**| A &lt;a href&#x3D;\&quot;#tag/OData\&quot; target&#x3D;\&quot;_blank\&quot;&gt;search&lt;/a&gt; query e.g. live eq true | [optional] |
| **orderby** | **string**| Field to order results. Prefix with a - (dash) for descending e.g. -id | [optional] |

### Return type

[**\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV1ProductVariant**](../Model/TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV1ProductVariant.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV2ProductsVariantsChoicesIdGet()`

```php
apiV2ProductsVariantsChoicesIdGet($id): \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantChoice
```

Get a single variant choice by ID

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: Bearer
$config = EKMv2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKMv2\Api\ProductVariantsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | The variant choice ID

try {
    $result = $apiInstance->apiV2ProductsVariantsChoicesIdGet($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductVariantsApi->apiV2ProductsVariantsChoicesIdGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| The variant choice ID | |

### Return type

[**\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantChoice**](../Model/TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantChoice.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
