# EKMv2\OrdersApi

All URIs are relative to https://api.ekm.net, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV2OrdersGet()**](OrdersApi.md#apiV2OrdersGet) | **GET** /api/v2/orders | Get a paginated set of orders |
| [**apiV2OrdersIdGet()**](OrdersApi.md#apiV2OrdersIdGet) | **GET** /api/v2/orders/{id} | Get an order by ID |
| [**apiV2OrdersIdItemsGet()**](OrdersApi.md#apiV2OrdersIdItemsGet) | **GET** /api/v2/orders/{id}/items | Get an order&#39;s items |
| [**apiV2OrdersIdItemsItemIdGet()**](OrdersApi.md#apiV2OrdersIdItemsItemIdGet) | **GET** /api/v2/orders/{id}/items/{itemId} | Get a specific item from an order |
| [**apiV2OrdersIdStatusPut()**](OrdersApi.md#apiV2OrdersIdStatusPut) | **PUT** /api/v2/orders/{id}/status | Updates the status of an order |
| [**apiV2OrdersSearchGet()**](OrdersApi.md#apiV2OrdersSearchGet) | **GET** /api/v2/orders/search | Searches orders based on search criteria |


## `apiV2OrdersGet()`

```php
apiV2OrdersGet($page, $limit): \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsOrdersV2Order
```

Get a paginated set of orders

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: Bearer
$config = EKMv2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKMv2\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page = 56; // int | Page number to display
$limit = 56; // int | Items per page (maximum 20)

try {
    $result = $apiInstance->apiV2OrdersGet($page, $limit);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->apiV2OrdersGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page** | **int**| Page number to display | [optional] |
| **limit** | **int**| Items per page (maximum 20) | [optional] |

### Return type

[**\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsOrdersV2Order**](../Model/TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsOrdersV2Order.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV2OrdersIdGet()`

```php
apiV2OrdersIdGet($id): \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsOrdersV2Order
```

Get an order by ID

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: Bearer
$config = EKMv2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKMv2\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | The order ID

try {
    $result = $apiInstance->apiV2OrdersIdGet($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->apiV2OrdersIdGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| The order ID | |

### Return type

[**\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsOrdersV2Order**](../Model/TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsOrdersV2Order.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV2OrdersIdItemsGet()`

```php
apiV2OrdersIdItemsGet($id, $page, $limit): \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsOrdersV2OrderItem
```

Get an order's items

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: Bearer
$config = EKMv2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKMv2\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | The order's ID'
$page = 56; // int | Page number to display
$limit = 56; // int | Items per page (maximum 20)

try {
    $result = $apiInstance->apiV2OrdersIdItemsGet($id, $page, $limit);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->apiV2OrdersIdItemsGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| The order&#39;s ID&#39; | |
| **page** | **int**| Page number to display | [optional] |
| **limit** | **int**| Items per page (maximum 20) | [optional] |

### Return type

[**\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsOrdersV2OrderItem**](../Model/TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsOrdersV2OrderItem.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV2OrdersIdItemsItemIdGet()`

```php
apiV2OrdersIdItemsItemIdGet($id, $itemId, $itemId2): \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsOrdersV2OrderItem
```

Get a specific item from an order

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: Bearer
$config = EKMv2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKMv2\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | The order's ID
$itemId = 56; // int | The order item's ID'
$itemId2 = 56; // int | The order item ID

try {
    $result = $apiInstance->apiV2OrdersIdItemsItemIdGet($id, $itemId, $itemId2);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->apiV2OrdersIdItemsItemIdGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| The order&#39;s ID | |
| **itemId** | **int**| The order item&#39;s ID&#39; | |
| **itemId2** | **int**| The order item ID | |

### Return type

[**\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsOrdersV2OrderItem**](../Model/TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsOrdersV2OrderItem.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV2OrdersIdStatusPut()`

```php
apiV2OrdersIdStatusPut($id, $tempestModelsShopsOrdersV1OrderStatus): \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsOrdersV2Order
```

Updates the status of an order

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: Bearer
$config = EKMv2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKMv2\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | The order ID
$tempestModelsShopsOrdersV1OrderStatus = new \EKMv2\Model\TempestModelsShopsOrdersV1OrderStatus(); // \EKMv2\Model\TempestModelsShopsOrdersV1OrderStatus | The updated order status

try {
    $result = $apiInstance->apiV2OrdersIdStatusPut($id, $tempestModelsShopsOrdersV1OrderStatus);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->apiV2OrdersIdStatusPut: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| The order ID | |
| **tempestModelsShopsOrdersV1OrderStatus** | [**\EKMv2\Model\TempestModelsShopsOrdersV1OrderStatus**](../Model/TempestModelsShopsOrdersV1OrderStatus.md)| The updated order status | [optional] |

### Return type

[**\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsOrdersV2Order**](../Model/TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsOrdersV2Order.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV2OrdersSearchGet()`

```php
apiV2OrdersSearchGet($page, $limit, $query, $orderby): \EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsOrdersV2Order
```

Searches orders based on search criteria

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: Bearer
$config = EKMv2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKMv2\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page = 56; // int | Page number to display
$limit = 56; // int | Items per page (maximum 20)
$query = 'query_example'; // string | A <a href=\"#tag/OData\" target=\"_blank\">search</a> query e.g. status eq 'PENDING'
$orderby = 'orderby_example'; // string | Field to order results. Prefix with a - (dash) for descending e.g. -id

try {
    $result = $apiInstance->apiV2OrdersSearchGet($page, $limit, $query, $orderby);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->apiV2OrdersSearchGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page** | **int**| Page number to display | [optional] |
| **limit** | **int**| Items per page (maximum 20) | [optional] |
| **query** | **string**| A &lt;a href&#x3D;\&quot;#tag/OData\&quot; target&#x3D;\&quot;_blank\&quot;&gt;search&lt;/a&gt; query e.g. status eq &#39;PENDING&#39; | [optional] |
| **orderby** | **string**| Field to order results. Prefix with a - (dash) for descending e.g. -id | [optional] |

### Return type

[**\EKMv2\Model\TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsOrdersV2Order**](../Model/TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsOrdersV2Order.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
