# OpenAPIClient-php

Our new API allows partners to build significantly better integrations with the EKM platform.

To try out the below endpoints, or for full up to date representations of the request / response models, please see the [swagger page](https://api.ekm.net/swagger/index.html). (We display examples here, but the swagger page is guaranteed to show the complete model.)

To keep up to date with the latest updates, please see our [RSS feed](https://partners.ekm.net/ChangeLog/Feed) or the [partner dashboard](https://partners.ekm.net/).

For more information, please visit [https://ekm.com](https://ekm.com).

## Installation & Usage

### Requirements

PHP 8.1 and later.

### Composer

To install the bindings via [Composer](https://getcomposer.org/), add the following to `composer.json`:

```json
{
  "repositories": [
    {
      "type": "vcs",
      "url": "https://github.com/Talisman/EKM.git"
    }
  ],
  "require": {
    "Talisman/EKM": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
<?php
require_once('/path/to/OpenAPIClient-php/vendor/autoload.php');
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



// Configure OAuth2 access token for authorization: Bearer
$config = EKMv2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKMv2\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page = 56; // int | Page number to display
$limit = 56; // int | Items per page (maximum 20)

try {
    $result = $apiInstance->apiV2OrdersGet($page, $limit);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->apiV2OrdersGet: ', $e->getMessage(), PHP_EOL;
}

```

## API Endpoints

All URIs are relative to *https://api.ekm.net*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*OrdersApi* | [**apiV2OrdersGet**](docs/Api/OrdersApi.md#apiv2ordersget) | **GET** /api/v2/orders | Get a paginated set of orders
*OrdersApi* | [**apiV2OrdersIdGet**](docs/Api/OrdersApi.md#apiv2ordersidget) | **GET** /api/v2/orders/{id} | Get an order by ID
*OrdersApi* | [**apiV2OrdersIdItemsGet**](docs/Api/OrdersApi.md#apiv2ordersiditemsget) | **GET** /api/v2/orders/{id}/items | Get an order&#39;s items
*OrdersApi* | [**apiV2OrdersIdItemsItemIdGet**](docs/Api/OrdersApi.md#apiv2ordersiditemsitemidget) | **GET** /api/v2/orders/{id}/items/{itemId} | Get a specific item from an order
*OrdersApi* | [**apiV2OrdersIdStatusPut**](docs/Api/OrdersApi.md#apiv2ordersidstatusput) | **PUT** /api/v2/orders/{id}/status | Updates the status of an order
*OrdersApi* | [**apiV2OrdersSearchGet**](docs/Api/OrdersApi.md#apiv2orderssearchget) | **GET** /api/v2/orders/search | Searches orders based on search criteria
*ProductVariantsApi* | [**apiV2ProductsPidVariantCombinationsGet**](docs/Api/ProductVariantsApi.md#apiv2productspidvariantcombinationsget) | **GET** /api/v2/products/{pid}/variant_combinations | Get the variant combinations associated with a parent product
*ProductVariantsApi* | [**apiV2ProductsPidVariantCombinationsSearchGet**](docs/Api/ProductVariantsApi.md#apiv2productspidvariantcombinationssearchget) | **GET** /api/v2/products/{pid}/variant_combinations/search | Search variants by parent product ID based on a given criteria
*ProductVariantsApi* | [**apiV2ProductsPidVariantCombinationsVcidGet**](docs/Api/ProductVariantsApi.md#apiv2productspidvariantcombinationsvcidget) | **GET** /api/v2/products/{pid}/variant_combinations/{vcid} | Get a single variant combination associated with a parent product
*ProductVariantsApi* | [**apiV2ProductsPidVariantCombinationsVcidImagesGet**](docs/Api/ProductVariantsApi.md#apiv2productspidvariantcombinationsvcidimagesget) | **GET** /api/v2/products/{pid}/variant_combinations/{vcid}/images | Get a variant combination&#39;s images.
*ProductVariantsApi* | [**apiV2ProductsPidVariantCombinationsVcidImagesImageNumberPost**](docs/Api/ProductVariantsApi.md#apiv2productspidvariantcombinationsvcidimagesimagenumberpost) | **POST** /api/v2/products/{pid}/variant_combinations/{vcid}/images/{imageNumber} | Assign an image URL to a variant combination
*ProductVariantsApi* | [**apiV2ProductsPidVariantCombinationsVcidPut**](docs/Api/ProductVariantsApi.md#apiv2productspidvariantcombinationsvcidput) | **PUT** /api/v2/products/{pid}/variant_combinations/{vcid} | Update a single variant combination
*ProductVariantsApi* | [**apiV2ProductsPidVariantsGet**](docs/Api/ProductVariantsApi.md#apiv2productspidvariantsget) | **GET** /api/v2/products/{pid}/variants | Get all of a product&#39;s associated variants
*ProductVariantsApi* | [**apiV2ProductsPidVariantsPost**](docs/Api/ProductVariantsApi.md#apiv2productspidvariantspost) | **POST** /api/v2/products/{pid}/variants | Add a new variant to a specific product.
*ProductVariantsApi* | [**apiV2ProductsPidVariantsVidChoicesGet**](docs/Api/ProductVariantsApi.md#apiv2productspidvariantsvidchoicesget) | **GET** /api/v2/products/{pid}/variants/{vid}/choices | Get the choices associated with a specific variant
*ProductVariantsApi* | [**apiV2ProductsPidVariantsVidChoicesPost**](docs/Api/ProductVariantsApi.md#apiv2productspidvariantsvidchoicespost) | **POST** /api/v2/products/{pid}/variants/{vid}/choices | Create a new choice for a specific variant
*ProductVariantsApi* | [**apiV2ProductsPidVariantsVidChoicesVcidDelete**](docs/Api/ProductVariantsApi.md#apiv2productspidvariantsvidchoicesvciddelete) | **DELETE** /api/v2/products/{pid}/variants/{vid}/choices/{vcid} | Delete a specific choice belonging to a variant
*ProductVariantsApi* | [**apiV2ProductsPidVariantsVidChoicesVcidGet**](docs/Api/ProductVariantsApi.md#apiv2productspidvariantsvidchoicesvcidget) | **GET** /api/v2/products/{pid}/variants/{vid}/choices/{vcid} | Get a single choice associated with a variant
*ProductVariantsApi* | [**apiV2ProductsPidVariantsVidChoicesVcidPut**](docs/Api/ProductVariantsApi.md#apiv2productspidvariantsvidchoicesvcidput) | **PUT** /api/v2/products/{pid}/variants/{vid}/choices/{vcid} | Update a specific choice belonging to a variant
*ProductVariantsApi* | [**apiV2ProductsPidVariantsVidDelete**](docs/Api/ProductVariantsApi.md#apiv2productspidvariantsviddelete) | **DELETE** /api/v2/products/{pid}/variants/{vid} | Delete an existing variant
*ProductVariantsApi* | [**apiV2ProductsPidVariantsVidGet**](docs/Api/ProductVariantsApi.md#apiv2productspidvariantsvidget) | **GET** /api/v2/products/{pid}/variants/{vid} | Get a specific variant belonging to a product
*ProductVariantsApi* | [**apiV2ProductsPidVariantsVidPut**](docs/Api/ProductVariantsApi.md#apiv2productspidvariantsvidput) | **PUT** /api/v2/products/{pid}/variants/{vid} | Update an existing variant
*ProductVariantsApi* | [**apiV2ProductsVariantCombinationsSearchGet**](docs/Api/ProductVariantsApi.md#apiv2productsvariantcombinationssearchget) | **GET** /api/v2/products/variant_combinations/search | Search variants by parent product ID based on a given criteria
*ProductVariantsApi* | [**apiV2ProductsVariantsChoicesIdGet**](docs/Api/ProductVariantsApi.md#apiv2productsvariantschoicesidget) | **GET** /api/v2/products/variants/choices/{id} | Get a single variant choice by ID
*ProductsApi* | [**apiV2ProductsMasterIdGet**](docs/Api/ProductsApi.md#apiv2productsmasteridget) | **GET** /api/v2/products/master/{id} | Get a product&#39;s master product by ID
*WebhooksApi* | [**apiV2WebhooksIdDelete**](docs/Api/WebhooksApi.md#apiv2webhooksiddelete) | **DELETE** /api/v2/Webhooks/{id} | Unsubscribe from a webhook
*WebhooksApi* | [**apiV2WebhooksIdGet**](docs/Api/WebhooksApi.md#apiv2webhooksidget) | **GET** /api/v2/Webhooks/{id} | Get a specific subscription
*WebhooksApi* | [**apiV2WebhooksPost**](docs/Api/WebhooksApi.md#apiv2webhookspost) | **POST** /api/v2/Webhooks | Update a webhook subscription
*WebhooksApi* | [**apiV2WebhooksPut**](docs/Api/WebhooksApi.md#apiv2webhooksput) | **PUT** /api/v2/Webhooks | Create a webhook subscription
*WebhooksApi* | [**apiV2WebhooksWebhooksGet**](docs/Api/WebhooksApi.md#apiv2webhookswebhooksget) | **GET** /api/v2/Webhooks/webhooks | Get list of existing subscriptions

## Models

- [TempestModelsResponsesTempestLink](docs/Model/TempestModelsResponsesTempestLink.md)
- [TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsOrdersV2Order](docs/Model/TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsOrdersV2Order.md)
- [TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsOrdersV2OrderItem](docs/Model/TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsOrdersV2OrderItem.md)
- [TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV1ProductVariant](docs/Model/TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV1ProductVariant.md)
- [TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV2Variant](docs/Model/TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV2Variant.md)
- [TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV2VariantChoice](docs/Model/TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV2VariantChoice.md)
- [TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV2VariantCombination](docs/Model/TempestModelsResponsesTempestResponse1OfOfSystemCollectionsGenericList1OfOfTempestModelsShopsProductsV2VariantCombination.md)
- [TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError](docs/Model/TempestModelsResponsesTempestResponse1OfOfTempestModelsResponsesTempestValidationError.md)
- [TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsOrdersV2Order](docs/Model/TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsOrdersV2Order.md)
- [TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsOrdersV2OrderItem](docs/Model/TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsOrdersV2OrderItem.md)
- [TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV1ProductImages](docs/Model/TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV1ProductImages.md)
- [TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV1ProductOption](docs/Model/TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV1ProductOption.md)
- [TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV1ProductOptionItem](docs/Model/TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV1ProductOptionItem.md)
- [TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2Product](docs/Model/TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2Product.md)
- [TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2Variant](docs/Model/TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2Variant.md)
- [TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantChoice](docs/Model/TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantChoice.md)
- [TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantCombination](docs/Model/TempestModelsResponsesTempestResponse1OfOfTempestModelsShopsProductsV2VariantCombination.md)
- [TempestModelsResponsesTempestValidationError](docs/Model/TempestModelsResponsesTempestValidationError.md)
- [TempestModelsShopsOrdersV1OrderCustomerDetails](docs/Model/TempestModelsShopsOrdersV1OrderCustomerDetails.md)
- [TempestModelsShopsOrdersV1OrderStatus](docs/Model/TempestModelsShopsOrdersV1OrderStatus.md)
- [TempestModelsShopsOrdersV1ShippingAddress](docs/Model/TempestModelsShopsOrdersV1ShippingAddress.md)
- [TempestModelsShopsOrdersV2Order](docs/Model/TempestModelsShopsOrdersV2Order.md)
- [TempestModelsShopsOrdersV2OrderItem](docs/Model/TempestModelsShopsOrdersV2OrderItem.md)
- [TempestModelsShopsProductsV1ProductImage](docs/Model/TempestModelsShopsProductsV1ProductImage.md)
- [TempestModelsShopsProductsV1ProductImages](docs/Model/TempestModelsShopsProductsV1ProductImages.md)
- [TempestModelsShopsProductsV1ProductOption](docs/Model/TempestModelsShopsProductsV1ProductOption.md)
- [TempestModelsShopsProductsV1ProductOptionItem](docs/Model/TempestModelsShopsProductsV1ProductOptionItem.md)
- [TempestModelsShopsProductsV1ProductVariant](docs/Model/TempestModelsShopsProductsV1ProductVariant.md)
- [TempestModelsShopsProductsV1VariantCombination](docs/Model/TempestModelsShopsProductsV1VariantCombination.md)
- [TempestModelsShopsProductsV2AddVariant](docs/Model/TempestModelsShopsProductsV2AddVariant.md)
- [TempestModelsShopsProductsV2AddVariantChoice](docs/Model/TempestModelsShopsProductsV2AddVariantChoice.md)
- [TempestModelsShopsProductsV2Product](docs/Model/TempestModelsShopsProductsV2Product.md)
- [TempestModelsShopsProductsV2Variant](docs/Model/TempestModelsShopsProductsV2Variant.md)
- [TempestModelsShopsProductsV2VariantChoice](docs/Model/TempestModelsShopsProductsV2VariantChoice.md)
- [TempestModelsShopsProductsV2VariantCombination](docs/Model/TempestModelsShopsProductsV2VariantCombination.md)
- [TempestModelsWebhooksV2AddWebhookSubscription](docs/Model/TempestModelsWebhooksV2AddWebhookSubscription.md)
- [TempestModelsWebhooksV2UpdateWebhookSubscription](docs/Model/TempestModelsWebhooksV2UpdateWebhookSubscription.md)

## Authorization

Authentication schemes defined for the API:
### Bearer

- **Type**: `OAuth`
- **Flow**: `accessCode`
- **Authorization URL**: `https://api.ekm.net/connect/authorize`
- **Scopes**: 
    - **openid**: Access a shops identity token.
    - **profile**: Read a user's details. (name, email, etc)
    - **tempest.customers.read**: Read a shop's customers.
    - **tempest.customers.write**: Modify a shop's customers.
    - **tempest.orders.read**: Read a shop's orders.
    - **tempest.orders.write**: Modify a shop's orders.
    - **tempest.products.read**: Read a shop's products.
    - **tempest.products.write**: Modify a shop's products.
    - **tempest.categories.read**: Read a shop's categories.
    - **tempest.categories.write**: Modify a shop's categories.
    - **tempest.settings.orderstatuses.read**: Read a shop's order statuses.
    - **tempest.settings.domains.read**: Read a shop's domains.
    - **tempest.settings.accountdetails.read**: Read a shop's account details.
    - **tempest.settings.tax.read**: Read a shop's tax settings.
    - **tempest.settings.tax.write**: Write a shop's tax settings.

## Tests

To run the tests, use:

```bash
composer install
vendor/bin/phpunit
```

## Author

api-support@ekm.com

## About this package

This PHP package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: `v2`
    - Package version: `2.0`
    - Generator version: `7.13.0`
- Build package: `org.openapitools.codegen.languages.PhpClientCodegen`
