<?php
/**
 * UpdateProduct
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  EKM
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * EKM Partner API
 *
 * Our new API allows partners to build significantly better integrations with the EKM platform.    To try out the below endpoints, or for full up to date representations of the request / response models, please see the [swagger page](https://api.ekm.net/swagger/index.html). (We display examples here, but the swagger page is guaranteed to show the complete model.)    To keep up to date with the latest updates, please see our [RSS feed](https://partners.ekm.net/ChangeLog/Feed) or the [partner dashboard](https://partners.ekm.net/).
 *
 * The version of the OpenAPI document: v1
 * Contact: api-support@ekm.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace EKM\Model;

use \ArrayAccess;
use \EKM\ObjectSerializer;

/**
 * UpdateProduct Class Doc Comment
 *
 * @category Class
 * @package  EKM
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class UpdateProduct implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'UpdateProduct';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'int',
        'categoryId' => 'int',
        'name' => 'string',
        'description' => 'string',
        'shortDescription' => 'string',
        'numberInStock' => 'int',
        'price' => 'float',
        'rrp' => 'float',
        'productCode' => 'string',
        'chargeDelivery' => 'bool',
        'specialOffer' => 'bool',
        'brand' => 'string',
        'condition' => 'string',
        'gtin' => 'string',
        'mpn' => 'string',
        'productWeight' => 'float',
        'canBeAddedToCart' => 'bool',
        'taxApplicable' => 'bool',
        'live' => 'bool',
        'orderNote' => 'string',
        'redirectUrl' => 'string',
        'lastModified' => '\DateTime',
        'metaDescription' => 'string',
        'metaKeywords' => 'string',
        'metaTitle' => 'string',
        'totalProductStock' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => 'int64',
        'categoryId' => 'int64',
        'name' => null,
        'description' => null,
        'shortDescription' => null,
        'numberInStock' => 'int64',
        'price' => 'double',
        'rrp' => 'double',
        'productCode' => null,
        'chargeDelivery' => null,
        'specialOffer' => null,
        'brand' => null,
        'condition' => null,
        'gtin' => null,
        'mpn' => null,
        'productWeight' => 'double',
        'canBeAddedToCart' => null,
        'taxApplicable' => null,
        'live' => null,
        'orderNote' => null,
        'redirectUrl' => null,
        'lastModified' => 'date-time',
        'metaDescription' => null,
        'metaKeywords' => null,
        'metaTitle' => null,
        'totalProductStock' => 'int64'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'id' => false,
        'categoryId' => false,
        'name' => false,
        'description' => false,
        'shortDescription' => false,
        'numberInStock' => false,
        'price' => false,
        'rrp' => false,
        'productCode' => false,
        'chargeDelivery' => false,
        'specialOffer' => false,
        'brand' => false,
        'condition' => false,
        'gtin' => false,
        'mpn' => false,
        'productWeight' => false,
        'canBeAddedToCart' => false,
        'taxApplicable' => false,
        'live' => false,
        'orderNote' => false,
        'redirectUrl' => false,
        'lastModified' => false,
        'metaDescription' => false,
        'metaKeywords' => false,
        'metaTitle' => false,
        'totalProductStock' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'categoryId' => 'category_id',
        'name' => 'name',
        'description' => 'description',
        'shortDescription' => 'short_description',
        'numberInStock' => 'number_in_stock',
        'price' => 'price',
        'rrp' => 'rrp',
        'productCode' => 'product_code',
        'chargeDelivery' => 'charge_delivery',
        'specialOffer' => 'special_offer',
        'brand' => 'brand',
        'condition' => 'condition',
        'gtin' => 'gtin',
        'mpn' => 'mpn',
        'productWeight' => 'product_weight',
        'canBeAddedToCart' => 'can_be_added_to_cart',
        'taxApplicable' => 'tax_applicable',
        'live' => 'live',
        'orderNote' => 'order_note',
        'redirectUrl' => 'redirect_url',
        'lastModified' => 'last_modified',
        'metaDescription' => 'meta_description',
        'metaKeywords' => 'meta_keywords',
        'metaTitle' => 'meta_title',
        'totalProductStock' => 'total_product_stock'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'categoryId' => 'setCategoryId',
        'name' => 'setName',
        'description' => 'setDescription',
        'shortDescription' => 'setShortDescription',
        'numberInStock' => 'setNumberInStock',
        'price' => 'setPrice',
        'rrp' => 'setRrp',
        'productCode' => 'setProductCode',
        'chargeDelivery' => 'setChargeDelivery',
        'specialOffer' => 'setSpecialOffer',
        'brand' => 'setBrand',
        'condition' => 'setCondition',
        'gtin' => 'setGtin',
        'mpn' => 'setMpn',
        'productWeight' => 'setProductWeight',
        'canBeAddedToCart' => 'setCanBeAddedToCart',
        'taxApplicable' => 'setTaxApplicable',
        'live' => 'setLive',
        'orderNote' => 'setOrderNote',
        'redirectUrl' => 'setRedirectUrl',
        'lastModified' => 'setLastModified',
        'metaDescription' => 'setMetaDescription',
        'metaKeywords' => 'setMetaKeywords',
        'metaTitle' => 'setMetaTitle',
        'totalProductStock' => 'setTotalProductStock'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'categoryId' => 'getCategoryId',
        'name' => 'getName',
        'description' => 'getDescription',
        'shortDescription' => 'getShortDescription',
        'numberInStock' => 'getNumberInStock',
        'price' => 'getPrice',
        'rrp' => 'getRrp',
        'productCode' => 'getProductCode',
        'chargeDelivery' => 'getChargeDelivery',
        'specialOffer' => 'getSpecialOffer',
        'brand' => 'getBrand',
        'condition' => 'getCondition',
        'gtin' => 'getGtin',
        'mpn' => 'getMpn',
        'productWeight' => 'getProductWeight',
        'canBeAddedToCart' => 'getCanBeAddedToCart',
        'taxApplicable' => 'getTaxApplicable',
        'live' => 'getLive',
        'orderNote' => 'getOrderNote',
        'redirectUrl' => 'getRedirectUrl',
        'lastModified' => 'getLastModified',
        'metaDescription' => 'getMetaDescription',
        'metaKeywords' => 'getMetaKeywords',
        'metaTitle' => 'getMetaTitle',
        'totalProductStock' => 'getTotalProductStock'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('categoryId', $data ?? [], null);
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('description', $data ?? [], null);
        $this->setIfExists('shortDescription', $data ?? [], null);
        $this->setIfExists('numberInStock', $data ?? [], null);
        $this->setIfExists('price', $data ?? [], null);
        $this->setIfExists('rrp', $data ?? [], null);
        $this->setIfExists('productCode', $data ?? [], null);
        $this->setIfExists('chargeDelivery', $data ?? [], null);
        $this->setIfExists('specialOffer', $data ?? [], null);
        $this->setIfExists('brand', $data ?? [], null);
        $this->setIfExists('condition', $data ?? [], null);
        $this->setIfExists('gtin', $data ?? [], null);
        $this->setIfExists('mpn', $data ?? [], null);
        $this->setIfExists('productWeight', $data ?? [], null);
        $this->setIfExists('canBeAddedToCart', $data ?? [], null);
        $this->setIfExists('taxApplicable', $data ?? [], null);
        $this->setIfExists('live', $data ?? [], null);
        $this->setIfExists('orderNote', $data ?? [], null);
        $this->setIfExists('redirectUrl', $data ?? [], null);
        $this->setIfExists('lastModified', $data ?? [], null);
        $this->setIfExists('metaDescription', $data ?? [], null);
        $this->setIfExists('metaKeywords', $data ?? [], null);
        $this->setIfExists('metaTitle', $data ?? [], null);
        $this->setIfExists('totalProductStock', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['name'] === null) {
            $invalidProperties[] = "'name' can't be null";
        }
        if (!is_null($this->container['price']) && ($this->container['price'] < 0)) {
            $invalidProperties[] = "invalid value for 'price', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['rrp']) && ($this->container['rrp'] < 0)) {
            $invalidProperties[] = "invalid value for 'rrp', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['productWeight']) && ($this->container['productWeight'] < 0)) {
            $invalidProperties[] = "invalid value for 'productWeight', must be bigger than or equal to 0.";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return int|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int|null $id id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets categoryId
     *
     * @return int|null
     */
    public function getCategoryId()
    {
        return $this->container['categoryId'];
    }

    /**
     * Sets categoryId
     *
     * @param int|null $categoryId categoryId
     *
     * @return self
     */
    public function setCategoryId($categoryId)
    {
        if (is_null($categoryId)) {
            throw new \InvalidArgumentException('non-nullable categoryId cannot be null');
        }
        $this->container['categoryId'] = $categoryId;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string $name name
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string|null $description description
     *
     * @return self
     */
    public function setDescription($description)
    {
        if (is_null($description)) {
            throw new \InvalidArgumentException('non-nullable description cannot be null');
        }
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets shortDescription
     *
     * @return string|null
     */
    public function getShortDescription()
    {
        return $this->container['shortDescription'];
    }

    /**
     * Sets shortDescription
     *
     * @param string|null $shortDescription shortDescription
     *
     * @return self
     */
    public function setShortDescription($shortDescription)
    {
        if (is_null($shortDescription)) {
            throw new \InvalidArgumentException('non-nullable shortDescription cannot be null');
        }
        $this->container['shortDescription'] = $shortDescription;

        return $this;
    }

    /**
     * Gets numberInStock
     *
     * @return int|null
     */
    public function getNumberInStock()
    {
        return $this->container['numberInStock'];
    }

    /**
     * Sets numberInStock
     *
     * @param int|null $numberInStock numberInStock
     *
     * @return self
     */
    public function setNumberInStock($numberInStock)
    {
        if (is_null($numberInStock)) {
            throw new \InvalidArgumentException('non-nullable numberInStock cannot be null');
        }
        $this->container['numberInStock'] = $numberInStock;

        return $this;
    }

    /**
     * Gets price
     *
     * @return float|null
     */
    public function getPrice()
    {
        return $this->container['price'];
    }

    /**
     * Sets price
     *
     * @param float|null $price price
     *
     * @return self
     */
    public function setPrice($price)
    {
        if (is_null($price)) {
            throw new \InvalidArgumentException('non-nullable price cannot be null');
        }

        if (($price < 0)) {
            throw new \InvalidArgumentException('invalid value for $price when calling UpdateProduct., must be bigger than or equal to 0.');
        }

        $this->container['price'] = $price;

        return $this;
    }

    /**
     * Gets rrp
     *
     * @return float|null
     */
    public function getRrp()
    {
        return $this->container['rrp'];
    }

    /**
     * Sets rrp
     *
     * @param float|null $rrp rrp
     *
     * @return self
     */
    public function setRrp($rrp)
    {
        if (is_null($rrp)) {
            throw new \InvalidArgumentException('non-nullable rrp cannot be null');
        }

        if (($rrp < 0)) {
            throw new \InvalidArgumentException('invalid value for $rrp when calling UpdateProduct., must be bigger than or equal to 0.');
        }

        $this->container['rrp'] = $rrp;

        return $this;
    }

    /**
     * Gets productCode
     *
     * @return string|null
     */
    public function getProductCode()
    {
        return $this->container['productCode'];
    }

    /**
     * Sets productCode
     *
     * @param string|null $productCode productCode
     *
     * @return self
     */
    public function setProductCode($productCode)
    {
        if (is_null($productCode)) {
            throw new \InvalidArgumentException('non-nullable productCode cannot be null');
        }
        $this->container['productCode'] = $productCode;

        return $this;
    }

    /**
     * Gets chargeDelivery
     *
     * @return bool|null
     */
    public function getChargeDelivery()
    {
        return $this->container['chargeDelivery'];
    }

    /**
     * Sets chargeDelivery
     *
     * @param bool|null $chargeDelivery chargeDelivery
     *
     * @return self
     */
    public function setChargeDelivery($chargeDelivery)
    {
        if (is_null($chargeDelivery)) {
            throw new \InvalidArgumentException('non-nullable chargeDelivery cannot be null');
        }
        $this->container['chargeDelivery'] = $chargeDelivery;

        return $this;
    }

    /**
     * Gets specialOffer
     *
     * @return bool|null
     */
    public function getSpecialOffer()
    {
        return $this->container['specialOffer'];
    }

    /**
     * Sets specialOffer
     *
     * @param bool|null $specialOffer specialOffer
     *
     * @return self
     */
    public function setSpecialOffer($specialOffer)
    {
        if (is_null($specialOffer)) {
            throw new \InvalidArgumentException('non-nullable specialOffer cannot be null');
        }
        $this->container['specialOffer'] = $specialOffer;

        return $this;
    }

    /**
     * Gets brand
     *
     * @return string|null
     */
    public function getBrand()
    {
        return $this->container['brand'];
    }

    /**
     * Sets brand
     *
     * @param string|null $brand brand
     *
     * @return self
     */
    public function setBrand($brand)
    {
        if (is_null($brand)) {
            throw new \InvalidArgumentException('non-nullable brand cannot be null');
        }
        $this->container['brand'] = $brand;

        return $this;
    }

    /**
     * Gets condition
     *
     * @return string|null
     */
    public function getCondition()
    {
        return $this->container['condition'];
    }

    /**
     * Sets condition
     *
     * @param string|null $condition condition
     *
     * @return self
     */
    public function setCondition($condition)
    {
        if (is_null($condition)) {
            throw new \InvalidArgumentException('non-nullable condition cannot be null');
        }
        $this->container['condition'] = $condition;

        return $this;
    }

    /**
     * Gets gtin
     *
     * @return string|null
     */
    public function getGtin()
    {
        return $this->container['gtin'];
    }

    /**
     * Sets gtin
     *
     * @param string|null $gtin gtin
     *
     * @return self
     */
    public function setGtin($gtin)
    {
        if (is_null($gtin)) {
            throw new \InvalidArgumentException('non-nullable gtin cannot be null');
        }
        $this->container['gtin'] = $gtin;

        return $this;
    }

    /**
     * Gets mpn
     *
     * @return string|null
     */
    public function getMpn()
    {
        return $this->container['mpn'];
    }

    /**
     * Sets mpn
     *
     * @param string|null $mpn mpn
     *
     * @return self
     */
    public function setMpn($mpn)
    {
        if (is_null($mpn)) {
            throw new \InvalidArgumentException('non-nullable mpn cannot be null');
        }
        $this->container['mpn'] = $mpn;

        return $this;
    }

    /**
     * Gets productWeight
     *
     * @return float|null
     */
    public function getProductWeight()
    {
        return $this->container['productWeight'];
    }

    /**
     * Sets productWeight
     *
     * @param float|null $productWeight productWeight
     *
     * @return self
     */
    public function setProductWeight($productWeight)
    {
        if (is_null($productWeight)) {
            throw new \InvalidArgumentException('non-nullable productWeight cannot be null');
        }

        if (($productWeight < 0)) {
            throw new \InvalidArgumentException('invalid value for $productWeight when calling UpdateProduct., must be bigger than or equal to 0.');
        }

        $this->container['productWeight'] = $productWeight;

        return $this;
    }

    /**
     * Gets canBeAddedToCart
     *
     * @return bool|null
     */
    public function getCanBeAddedToCart()
    {
        return $this->container['canBeAddedToCart'];
    }

    /**
     * Sets canBeAddedToCart
     *
     * @param bool|null $canBeAddedToCart canBeAddedToCart
     *
     * @return self
     */
    public function setCanBeAddedToCart($canBeAddedToCart)
    {
        if (is_null($canBeAddedToCart)) {
            throw new \InvalidArgumentException('non-nullable canBeAddedToCart cannot be null');
        }
        $this->container['canBeAddedToCart'] = $canBeAddedToCart;

        return $this;
    }

    /**
     * Gets taxApplicable
     *
     * @return bool|null
     */
    public function getTaxApplicable()
    {
        return $this->container['taxApplicable'];
    }

    /**
     * Sets taxApplicable
     *
     * @param bool|null $taxApplicable taxApplicable
     *
     * @return self
     */
    public function setTaxApplicable($taxApplicable)
    {
        if (is_null($taxApplicable)) {
            throw new \InvalidArgumentException('non-nullable taxApplicable cannot be null');
        }
        $this->container['taxApplicable'] = $taxApplicable;

        return $this;
    }

    /**
     * Gets live
     *
     * @return bool|null
     */
    public function getLive()
    {
        return $this->container['live'];
    }

    /**
     * Sets live
     *
     * @param bool|null $live live
     *
     * @return self
     */
    public function setLive($live)
    {
        if (is_null($live)) {
            throw new \InvalidArgumentException('non-nullable live cannot be null');
        }
        $this->container['live'] = $live;

        return $this;
    }

    /**
     * Gets orderNote
     *
     * @return string|null
     */
    public function getOrderNote()
    {
        return $this->container['orderNote'];
    }

    /**
     * Sets orderNote
     *
     * @param string|null $orderNote orderNote
     *
     * @return self
     */
    public function setOrderNote($orderNote)
    {
        if (is_null($orderNote)) {
            throw new \InvalidArgumentException('non-nullable orderNote cannot be null');
        }
        $this->container['orderNote'] = $orderNote;

        return $this;
    }

    /**
     * Gets redirectUrl
     *
     * @return string|null
     */
    public function getRedirectUrl()
    {
        return $this->container['redirectUrl'];
    }

    /**
     * Sets redirectUrl
     *
     * @param string|null $redirectUrl redirectUrl
     *
     * @return self
     */
    public function setRedirectUrl($redirectUrl)
    {
        if (is_null($redirectUrl)) {
            throw new \InvalidArgumentException('non-nullable redirectUrl cannot be null');
        }
        $this->container['redirectUrl'] = $redirectUrl;

        return $this;
    }

    /**
     * Gets lastModified
     *
     * @return \DateTime|null
     */
    public function getLastModified()
    {
        return $this->container['lastModified'];
    }

    /**
     * Sets lastModified
     *
     * @param \DateTime|null $lastModified lastModified
     *
     * @return self
     */
    public function setLastModified($lastModified)
    {
        if (is_null($lastModified)) {
            throw new \InvalidArgumentException('non-nullable lastModified cannot be null');
        }
        $this->container['lastModified'] = $lastModified;

        return $this;
    }

    /**
     * Gets metaDescription
     *
     * @return string|null
     */
    public function getMetaDescription()
    {
        return $this->container['metaDescription'];
    }

    /**
     * Sets metaDescription
     *
     * @param string|null $metaDescription metaDescription
     *
     * @return self
     */
    public function setMetaDescription($metaDescription)
    {
        if (is_null($metaDescription)) {
            throw new \InvalidArgumentException('non-nullable metaDescription cannot be null');
        }
        $this->container['metaDescription'] = $metaDescription;

        return $this;
    }

    /**
     * Gets metaKeywords
     *
     * @return string|null
     */
    public function getMetaKeywords()
    {
        return $this->container['metaKeywords'];
    }

    /**
     * Sets metaKeywords
     *
     * @param string|null $metaKeywords metaKeywords
     *
     * @return self
     */
    public function setMetaKeywords($metaKeywords)
    {
        if (is_null($metaKeywords)) {
            throw new \InvalidArgumentException('non-nullable metaKeywords cannot be null');
        }
        $this->container['metaKeywords'] = $metaKeywords;

        return $this;
    }

    /**
     * Gets metaTitle
     *
     * @return string|null
     */
    public function getMetaTitle()
    {
        return $this->container['metaTitle'];
    }

    /**
     * Sets metaTitle
     *
     * @param string|null $metaTitle metaTitle
     *
     * @return self
     */
    public function setMetaTitle($metaTitle)
    {
        if (is_null($metaTitle)) {
            throw new \InvalidArgumentException('non-nullable metaTitle cannot be null');
        }
        $this->container['metaTitle'] = $metaTitle;

        return $this;
    }

    /**
     * Gets totalProductStock
     *
     * @return int|null
     */
    public function getTotalProductStock()
    {
        return $this->container['totalProductStock'];
    }

    /**
     * Sets totalProductStock
     *
     * @param int|null $totalProductStock totalProductStock
     *
     * @return self
     */
    public function setTotalProductStock($totalProductStock)
    {
        if (is_null($totalProductStock)) {
            throw new \InvalidArgumentException('non-nullable totalProductStock cannot be null');
        }
        $this->container['totalProductStock'] = $totalProductStock;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


