<?php
/**
 * UpdateCustomer
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  EKM
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * EKM Partner API
 *
 * Our new API allows partners to build significantly better integrations with the EKM platform.    To try out the below endpoints, or for full up to date representations of the request / response models, please see the [swagger page](https://api.ekm.net/swagger/index.html). (We display examples here, but the swagger page is guaranteed to show the complete model.)    To keep up to date with the latest updates, please see our [RSS feed](https://partners.ekm.net/ChangeLog/Feed) or the [partner dashboard](https://partners.ekm.net/).
 *
 * The version of the OpenAPI document: v1
 * Contact: api-support@ekm.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace EKM\Model;

use \ArrayAccess;
use \EKM\ObjectSerializer;

/**
 * UpdateCustomer Class Doc Comment
 *
 * @category Class
 * @package  EKM
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class UpdateCustomer implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'UpdateCustomer';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'int',
        'emailAddress' => 'string',
        'firstName' => 'string',
        'lastName' => 'string',
        'orderCount' => 'int',
        'loyaltyPoints' => 'float',
        'createdDate' => '\DateTime',
        'modifiedDate' => '\DateTime',
        'lastLoginDate' => '\DateTime',
        'lastLoginAttemptDate' => '\DateTime',
        'locked' => 'bool',
        'lockedDate' => '\DateTime',
        'lockedEndDate' => '\DateTime',
        'isSubscribedToNewsletter' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => 'int64',
        'emailAddress' => null,
        'firstName' => null,
        'lastName' => null,
        'orderCount' => 'int32',
        'loyaltyPoints' => 'double',
        'createdDate' => 'date-time',
        'modifiedDate' => 'date-time',
        'lastLoginDate' => 'date-time',
        'lastLoginAttemptDate' => 'date-time',
        'locked' => null,
        'lockedDate' => 'date-time',
        'lockedEndDate' => 'date-time',
        'isSubscribedToNewsletter' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'id' => false,
        'emailAddress' => false,
        'firstName' => false,
        'lastName' => false,
        'orderCount' => false,
        'loyaltyPoints' => false,
        'createdDate' => false,
        'modifiedDate' => false,
        'lastLoginDate' => false,
        'lastLoginAttemptDate' => false,
        'locked' => false,
        'lockedDate' => false,
        'lockedEndDate' => false,
        'isSubscribedToNewsletter' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'emailAddress' => 'email_address',
        'firstName' => 'first_name',
        'lastName' => 'last_name',
        'orderCount' => 'order_count',
        'loyaltyPoints' => 'loyalty_points',
        'createdDate' => 'created_date',
        'modifiedDate' => 'modified_date',
        'lastLoginDate' => 'last_login_date',
        'lastLoginAttemptDate' => 'last_login_attempt_date',
        'locked' => 'locked',
        'lockedDate' => 'locked_date',
        'lockedEndDate' => 'locked_end_date',
        'isSubscribedToNewsletter' => 'is_subscribed_to_newsletter'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'emailAddress' => 'setEmailAddress',
        'firstName' => 'setFirstName',
        'lastName' => 'setLastName',
        'orderCount' => 'setOrderCount',
        'loyaltyPoints' => 'setLoyaltyPoints',
        'createdDate' => 'setCreatedDate',
        'modifiedDate' => 'setModifiedDate',
        'lastLoginDate' => 'setLastLoginDate',
        'lastLoginAttemptDate' => 'setLastLoginAttemptDate',
        'locked' => 'setLocked',
        'lockedDate' => 'setLockedDate',
        'lockedEndDate' => 'setLockedEndDate',
        'isSubscribedToNewsletter' => 'setIsSubscribedToNewsletter'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'emailAddress' => 'getEmailAddress',
        'firstName' => 'getFirstName',
        'lastName' => 'getLastName',
        'orderCount' => 'getOrderCount',
        'loyaltyPoints' => 'getLoyaltyPoints',
        'createdDate' => 'getCreatedDate',
        'modifiedDate' => 'getModifiedDate',
        'lastLoginDate' => 'getLastLoginDate',
        'lastLoginAttemptDate' => 'getLastLoginAttemptDate',
        'locked' => 'getLocked',
        'lockedDate' => 'getLockedDate',
        'lockedEndDate' => 'getLockedEndDate',
        'isSubscribedToNewsletter' => 'getIsSubscribedToNewsletter'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('emailAddress', $data ?? [], null);
        $this->setIfExists('firstName', $data ?? [], null);
        $this->setIfExists('lastName', $data ?? [], null);
        $this->setIfExists('orderCount', $data ?? [], null);
        $this->setIfExists('loyaltyPoints', $data ?? [], null);
        $this->setIfExists('createdDate', $data ?? [], null);
        $this->setIfExists('modifiedDate', $data ?? [], null);
        $this->setIfExists('lastLoginDate', $data ?? [], null);
        $this->setIfExists('lastLoginAttemptDate', $data ?? [], null);
        $this->setIfExists('locked', $data ?? [], null);
        $this->setIfExists('lockedDate', $data ?? [], null);
        $this->setIfExists('lockedEndDate', $data ?? [], null);
        $this->setIfExists('isSubscribedToNewsletter', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['firstName'] === null) {
            $invalidProperties[] = "'firstName' can't be null";
        }
        if ($this->container['lastName'] === null) {
            $invalidProperties[] = "'lastName' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return int|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int|null $id id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets emailAddress
     *
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->container['emailAddress'];
    }

    /**
     * Sets emailAddress
     *
     * @param string|null $emailAddress emailAddress
     *
     * @return self
     */
    public function setEmailAddress($emailAddress)
    {
        if (is_null($emailAddress)) {
            throw new \InvalidArgumentException('non-nullable emailAddress cannot be null');
        }
        $this->container['emailAddress'] = $emailAddress;

        return $this;
    }

    /**
     * Gets firstName
     *
     * @return string
     */
    public function getFirstName()
    {
        return $this->container['firstName'];
    }

    /**
     * Sets firstName
     *
     * @param string $firstName firstName
     *
     * @return self
     */
    public function setFirstName($firstName)
    {
        if (is_null($firstName)) {
            throw new \InvalidArgumentException('non-nullable firstName cannot be null');
        }
        $this->container['firstName'] = $firstName;

        return $this;
    }

    /**
     * Gets lastName
     *
     * @return string
     */
    public function getLastName()
    {
        return $this->container['lastName'];
    }

    /**
     * Sets lastName
     *
     * @param string $lastName lastName
     *
     * @return self
     */
    public function setLastName($lastName)
    {
        if (is_null($lastName)) {
            throw new \InvalidArgumentException('non-nullable lastName cannot be null');
        }
        $this->container['lastName'] = $lastName;

        return $this;
    }

    /**
     * Gets orderCount
     *
     * @return int|null
     */
    public function getOrderCount()
    {
        return $this->container['orderCount'];
    }

    /**
     * Sets orderCount
     *
     * @param int|null $orderCount orderCount
     *
     * @return self
     */
    public function setOrderCount($orderCount)
    {
        if (is_null($orderCount)) {
            throw new \InvalidArgumentException('non-nullable orderCount cannot be null');
        }
        $this->container['orderCount'] = $orderCount;

        return $this;
    }

    /**
     * Gets loyaltyPoints
     *
     * @return float|null
     */
    public function getLoyaltyPoints()
    {
        return $this->container['loyaltyPoints'];
    }

    /**
     * Sets loyaltyPoints
     *
     * @param float|null $loyaltyPoints loyaltyPoints
     *
     * @return self
     */
    public function setLoyaltyPoints($loyaltyPoints)
    {
        if (is_null($loyaltyPoints)) {
            throw new \InvalidArgumentException('non-nullable loyaltyPoints cannot be null');
        }
        $this->container['loyaltyPoints'] = $loyaltyPoints;

        return $this;
    }

    /**
     * Gets createdDate
     *
     * @return \DateTime|null
     */
    public function getCreatedDate()
    {
        return $this->container['createdDate'];
    }

    /**
     * Sets createdDate
     *
     * @param \DateTime|null $createdDate createdDate
     *
     * @return self
     */
    public function setCreatedDate($createdDate)
    {
        if (is_null($createdDate)) {
            throw new \InvalidArgumentException('non-nullable createdDate cannot be null');
        }
        $this->container['createdDate'] = $createdDate;

        return $this;
    }

    /**
     * Gets modifiedDate
     *
     * @return \DateTime|null
     */
    public function getModifiedDate()
    {
        return $this->container['modifiedDate'];
    }

    /**
     * Sets modifiedDate
     *
     * @param \DateTime|null $modifiedDate modifiedDate
     *
     * @return self
     */
    public function setModifiedDate($modifiedDate)
    {
        if (is_null($modifiedDate)) {
            throw new \InvalidArgumentException('non-nullable modifiedDate cannot be null');
        }
        $this->container['modifiedDate'] = $modifiedDate;

        return $this;
    }

    /**
     * Gets lastLoginDate
     *
     * @return \DateTime|null
     */
    public function getLastLoginDate()
    {
        return $this->container['lastLoginDate'];
    }

    /**
     * Sets lastLoginDate
     *
     * @param \DateTime|null $lastLoginDate lastLoginDate
     *
     * @return self
     */
    public function setLastLoginDate($lastLoginDate)
    {
        if (is_null($lastLoginDate)) {
            throw new \InvalidArgumentException('non-nullable lastLoginDate cannot be null');
        }
        $this->container['lastLoginDate'] = $lastLoginDate;

        return $this;
    }

    /**
     * Gets lastLoginAttemptDate
     *
     * @return \DateTime|null
     */
    public function getLastLoginAttemptDate()
    {
        return $this->container['lastLoginAttemptDate'];
    }

    /**
     * Sets lastLoginAttemptDate
     *
     * @param \DateTime|null $lastLoginAttemptDate lastLoginAttemptDate
     *
     * @return self
     */
    public function setLastLoginAttemptDate($lastLoginAttemptDate)
    {
        if (is_null($lastLoginAttemptDate)) {
            throw new \InvalidArgumentException('non-nullable lastLoginAttemptDate cannot be null');
        }
        $this->container['lastLoginAttemptDate'] = $lastLoginAttemptDate;

        return $this;
    }

    /**
     * Gets locked
     *
     * @return bool|null
     */
    public function getLocked()
    {
        return $this->container['locked'];
    }

    /**
     * Sets locked
     *
     * @param bool|null $locked locked
     *
     * @return self
     */
    public function setLocked($locked)
    {
        if (is_null($locked)) {
            throw new \InvalidArgumentException('non-nullable locked cannot be null');
        }
        $this->container['locked'] = $locked;

        return $this;
    }

    /**
     * Gets lockedDate
     *
     * @return \DateTime|null
     */
    public function getLockedDate()
    {
        return $this->container['lockedDate'];
    }

    /**
     * Sets lockedDate
     *
     * @param \DateTime|null $lockedDate lockedDate
     *
     * @return self
     */
    public function setLockedDate($lockedDate)
    {
        if (is_null($lockedDate)) {
            throw new \InvalidArgumentException('non-nullable lockedDate cannot be null');
        }
        $this->container['lockedDate'] = $lockedDate;

        return $this;
    }

    /**
     * Gets lockedEndDate
     *
     * @return \DateTime|null
     */
    public function getLockedEndDate()
    {
        return $this->container['lockedEndDate'];
    }

    /**
     * Sets lockedEndDate
     *
     * @param \DateTime|null $lockedEndDate lockedEndDate
     *
     * @return self
     */
    public function setLockedEndDate($lockedEndDate)
    {
        if (is_null($lockedEndDate)) {
            throw new \InvalidArgumentException('non-nullable lockedEndDate cannot be null');
        }
        $this->container['lockedEndDate'] = $lockedEndDate;

        return $this;
    }

    /**
     * Gets isSubscribedToNewsletter
     *
     * @return bool|null
     */
    public function getIsSubscribedToNewsletter()
    {
        return $this->container['isSubscribedToNewsletter'];
    }

    /**
     * Sets isSubscribedToNewsletter
     *
     * @param bool|null $isSubscribedToNewsletter isSubscribedToNewsletter
     *
     * @return self
     */
    public function setIsSubscribedToNewsletter($isSubscribedToNewsletter)
    {
        if (is_null($isSubscribedToNewsletter)) {
            throw new \InvalidArgumentException('non-nullable isSubscribedToNewsletter cannot be null');
        }
        $this->container['isSubscribedToNewsletter'] = $isSubscribedToNewsletter;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


