<?php
/**
 * TaxSettings
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  EKM
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * EKM Partner API
 *
 * Our new API allows partners to build significantly better integrations with the EKM platform.    To try out the below endpoints, or for full up to date representations of the request / response models, please see the [swagger page](https://api.ekm.net/swagger/index.html). (We display examples here, but the swagger page is guaranteed to show the complete model.)    To keep up to date with the latest updates, please see our [RSS feed](https://partners.ekm.net/ChangeLog/Feed) or the [partner dashboard](https://partners.ekm.net/).
 *
 * The version of the OpenAPI document: v1
 * Contact: api-support@ekm.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace EKM\Model;

use \ArrayAccess;
use \EKM\ObjectSerializer;

/**
 * TaxSettings Class Doc Comment
 *
 * @category Class
 * @package  EKM
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class TaxSettings implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'TaxSettings';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'chargeTax' => 'bool',
        'productsIncludeTax' => 'bool',
        'productsPriceIncludeExcludeTax' => 'bool',
        'deliveryTax' => 'string',
        'deliveryShowTax' => 'bool',
        'taxRates' => '\EKM\Model\TaxRateModel[]',
        'countryCodes' => '\EKM\Model\CountryCodeModel[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'chargeTax' => null,
        'productsIncludeTax' => null,
        'productsPriceIncludeExcludeTax' => null,
        'deliveryTax' => null,
        'deliveryShowTax' => null,
        'taxRates' => null,
        'countryCodes' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'chargeTax' => false,
        'productsIncludeTax' => false,
        'productsPriceIncludeExcludeTax' => false,
        'deliveryTax' => false,
        'deliveryShowTax' => false,
        'taxRates' => false,
        'countryCodes' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'chargeTax' => 'charge_tax',
        'productsIncludeTax' => 'products_include_tax',
        'productsPriceIncludeExcludeTax' => 'products_price_include_exclude_tax',
        'deliveryTax' => 'delivery_tax',
        'deliveryShowTax' => 'delivery_show_tax',
        'taxRates' => 'tax_rates',
        'countryCodes' => 'country_codes'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'chargeTax' => 'setChargeTax',
        'productsIncludeTax' => 'setProductsIncludeTax',
        'productsPriceIncludeExcludeTax' => 'setProductsPriceIncludeExcludeTax',
        'deliveryTax' => 'setDeliveryTax',
        'deliveryShowTax' => 'setDeliveryShowTax',
        'taxRates' => 'setTaxRates',
        'countryCodes' => 'setCountryCodes'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'chargeTax' => 'getChargeTax',
        'productsIncludeTax' => 'getProductsIncludeTax',
        'productsPriceIncludeExcludeTax' => 'getProductsPriceIncludeExcludeTax',
        'deliveryTax' => 'getDeliveryTax',
        'deliveryShowTax' => 'getDeliveryShowTax',
        'taxRates' => 'getTaxRates',
        'countryCodes' => 'getCountryCodes'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const DELIVERY_TAX_NON = 'Non';
    public const DELIVERY_TAX_EXCLUDES = 'Excludes';
    public const DELIVERY_TAX_INCLUDES = 'Includes';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getDeliveryTaxAllowableValues()
    {
        return [
            self::DELIVERY_TAX_NON,
            self::DELIVERY_TAX_EXCLUDES,
            self::DELIVERY_TAX_INCLUDES,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('chargeTax', $data ?? [], null);
        $this->setIfExists('productsIncludeTax', $data ?? [], null);
        $this->setIfExists('productsPriceIncludeExcludeTax', $data ?? [], null);
        $this->setIfExists('deliveryTax', $data ?? [], null);
        $this->setIfExists('deliveryShowTax', $data ?? [], null);
        $this->setIfExists('taxRates', $data ?? [], null);
        $this->setIfExists('countryCodes', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getDeliveryTaxAllowableValues();
        if (!is_null($this->container['deliveryTax']) && !in_array($this->container['deliveryTax'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'deliveryTax', must be one of '%s'",
                $this->container['deliveryTax'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets chargeTax
     *
     * @return bool|null
     */
    public function getChargeTax()
    {
        return $this->container['chargeTax'];
    }

    /**
     * Sets chargeTax
     *
     * @param bool|null $chargeTax chargeTax
     *
     * @return self
     */
    public function setChargeTax($chargeTax)
    {
        if (is_null($chargeTax)) {
            throw new \InvalidArgumentException('non-nullable chargeTax cannot be null');
        }
        $this->container['chargeTax'] = $chargeTax;

        return $this;
    }

    /**
     * Gets productsIncludeTax
     *
     * @return bool|null
     */
    public function getProductsIncludeTax()
    {
        return $this->container['productsIncludeTax'];
    }

    /**
     * Sets productsIncludeTax
     *
     * @param bool|null $productsIncludeTax productsIncludeTax
     *
     * @return self
     */
    public function setProductsIncludeTax($productsIncludeTax)
    {
        if (is_null($productsIncludeTax)) {
            throw new \InvalidArgumentException('non-nullable productsIncludeTax cannot be null');
        }
        $this->container['productsIncludeTax'] = $productsIncludeTax;

        return $this;
    }

    /**
     * Gets productsPriceIncludeExcludeTax
     *
     * @return bool|null
     */
    public function getProductsPriceIncludeExcludeTax()
    {
        return $this->container['productsPriceIncludeExcludeTax'];
    }

    /**
     * Sets productsPriceIncludeExcludeTax
     *
     * @param bool|null $productsPriceIncludeExcludeTax productsPriceIncludeExcludeTax
     *
     * @return self
     */
    public function setProductsPriceIncludeExcludeTax($productsPriceIncludeExcludeTax)
    {
        if (is_null($productsPriceIncludeExcludeTax)) {
            throw new \InvalidArgumentException('non-nullable productsPriceIncludeExcludeTax cannot be null');
        }
        $this->container['productsPriceIncludeExcludeTax'] = $productsPriceIncludeExcludeTax;

        return $this;
    }

    /**
     * Gets deliveryTax
     *
     * @return string|null
     */
    public function getDeliveryTax()
    {
        return $this->container['deliveryTax'];
    }

    /**
     * Sets deliveryTax
     *
     * @param string|null $deliveryTax deliveryTax
     *
     * @return self
     */
    public function setDeliveryTax($deliveryTax)
    {
        if (is_null($deliveryTax)) {
            throw new \InvalidArgumentException('non-nullable deliveryTax cannot be null');
        }
        $allowedValues = $this->getDeliveryTaxAllowableValues();
        if (!in_array($deliveryTax, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'deliveryTax', must be one of '%s'",
                    $deliveryTax,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['deliveryTax'] = $deliveryTax;

        return $this;
    }

    /**
     * Gets deliveryShowTax
     *
     * @return bool|null
     */
    public function getDeliveryShowTax()
    {
        return $this->container['deliveryShowTax'];
    }

    /**
     * Sets deliveryShowTax
     *
     * @param bool|null $deliveryShowTax deliveryShowTax
     *
     * @return self
     */
    public function setDeliveryShowTax($deliveryShowTax)
    {
        if (is_null($deliveryShowTax)) {
            throw new \InvalidArgumentException('non-nullable deliveryShowTax cannot be null');
        }
        $this->container['deliveryShowTax'] = $deliveryShowTax;

        return $this;
    }

    /**
     * Gets taxRates
     *
     * @return \EKM\Model\TaxRateModel[]|null
     */
    public function getTaxRates()
    {
        return $this->container['taxRates'];
    }

    /**
     * Sets taxRates
     *
     * @param \EKM\Model\TaxRateModel[]|null $taxRates taxRates
     *
     * @return self
     */
    public function setTaxRates($taxRates)
    {
        if (is_null($taxRates)) {
            throw new \InvalidArgumentException('non-nullable taxRates cannot be null');
        }
        $this->container['taxRates'] = $taxRates;

        return $this;
    }

    /**
     * Gets countryCodes
     *
     * @return \EKM\Model\CountryCodeModel[]|null
     */
    public function getCountryCodes()
    {
        return $this->container['countryCodes'];
    }

    /**
     * Sets countryCodes
     *
     * @param \EKM\Model\CountryCodeModel[]|null $countryCodes countryCodes
     *
     * @return self
     */
    public function setCountryCodes($countryCodes)
    {
        if (is_null($countryCodes)) {
            throw new \InvalidArgumentException('non-nullable countryCodes cannot be null');
        }
        $this->container['countryCodes'] = $countryCodes;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


