<?php
/**
 * ShippingAddress
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  EKM
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * EKM Partner API
 *
 * Our new API allows partners to build significantly better integrations with the EKM platform.    To try out the below endpoints, or for full up to date representations of the request / response models, please see the [swagger page](https://api.ekm.net/swagger/index.html). (We display examples here, but the swagger page is guaranteed to show the complete model.)    To keep up to date with the latest updates, please see our [RSS feed](https://partners.ekm.net/ChangeLog/Feed) or the [partner dashboard](https://partners.ekm.net/).
 *
 * The version of the OpenAPI document: v1
 * Contact: api-support@ekm.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace EKM\Model;

use \ArrayAccess;
use \EKM\ObjectSerializer;

/**
 * ShippingAddress Class Doc Comment
 *
 * @category Class
 * @package  EKM
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ShippingAddress implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ShippingAddress';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'firstName' => 'string',
        'lastName' => 'string',
        'id' => 'int',
        'createdDate' => '\DateTime',
        'modifiedDate' => '\DateTime',
        'customerId' => 'int',
        'isPreferredBillingAddress' => 'bool',
        'isPreferredShippingAddress' => 'bool',
        'company' => 'string',
        'address' => 'string',
        'address2' => 'string',
        'town' => 'string',
        'county' => 'string',
        'country' => 'string',
        'friendlyCountry' => 'string',
        'postCode' => 'string',
        'telephone' => 'string',
        'fax' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'firstName' => null,
        'lastName' => null,
        'id' => 'int64',
        'createdDate' => 'date-time',
        'modifiedDate' => 'date-time',
        'customerId' => 'int64',
        'isPreferredBillingAddress' => null,
        'isPreferredShippingAddress' => null,
        'company' => null,
        'address' => null,
        'address2' => null,
        'town' => null,
        'county' => null,
        'country' => null,
        'friendlyCountry' => null,
        'postCode' => null,
        'telephone' => null,
        'fax' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'firstName' => false,
        'lastName' => false,
        'id' => false,
        'createdDate' => false,
        'modifiedDate' => false,
        'customerId' => false,
        'isPreferredBillingAddress' => false,
        'isPreferredShippingAddress' => false,
        'company' => false,
        'address' => false,
        'address2' => false,
        'town' => false,
        'county' => false,
        'country' => false,
        'friendlyCountry' => false,
        'postCode' => false,
        'telephone' => false,
        'fax' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'firstName' => 'first_name',
        'lastName' => 'last_name',
        'id' => 'id',
        'createdDate' => 'created_date',
        'modifiedDate' => 'modified_date',
        'customerId' => 'customer_id',
        'isPreferredBillingAddress' => 'is_preferred_billing_address',
        'isPreferredShippingAddress' => 'is_preferred_shipping_address',
        'company' => 'company',
        'address' => 'address',
        'address2' => 'address2',
        'town' => 'town',
        'county' => 'county',
        'country' => 'country',
        'friendlyCountry' => 'friendly_country',
        'postCode' => 'post_code',
        'telephone' => 'telephone',
        'fax' => 'fax'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'firstName' => 'setFirstName',
        'lastName' => 'setLastName',
        'id' => 'setId',
        'createdDate' => 'setCreatedDate',
        'modifiedDate' => 'setModifiedDate',
        'customerId' => 'setCustomerId',
        'isPreferredBillingAddress' => 'setIsPreferredBillingAddress',
        'isPreferredShippingAddress' => 'setIsPreferredShippingAddress',
        'company' => 'setCompany',
        'address' => 'setAddress',
        'address2' => 'setAddress2',
        'town' => 'setTown',
        'county' => 'setCounty',
        'country' => 'setCountry',
        'friendlyCountry' => 'setFriendlyCountry',
        'postCode' => 'setPostCode',
        'telephone' => 'setTelephone',
        'fax' => 'setFax'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'firstName' => 'getFirstName',
        'lastName' => 'getLastName',
        'id' => 'getId',
        'createdDate' => 'getCreatedDate',
        'modifiedDate' => 'getModifiedDate',
        'customerId' => 'getCustomerId',
        'isPreferredBillingAddress' => 'getIsPreferredBillingAddress',
        'isPreferredShippingAddress' => 'getIsPreferredShippingAddress',
        'company' => 'getCompany',
        'address' => 'getAddress',
        'address2' => 'getAddress2',
        'town' => 'getTown',
        'county' => 'getCounty',
        'country' => 'getCountry',
        'friendlyCountry' => 'getFriendlyCountry',
        'postCode' => 'getPostCode',
        'telephone' => 'getTelephone',
        'fax' => 'getFax'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('firstName', $data ?? [], null);
        $this->setIfExists('lastName', $data ?? [], null);
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('createdDate', $data ?? [], null);
        $this->setIfExists('modifiedDate', $data ?? [], null);
        $this->setIfExists('customerId', $data ?? [], null);
        $this->setIfExists('isPreferredBillingAddress', $data ?? [], null);
        $this->setIfExists('isPreferredShippingAddress', $data ?? [], null);
        $this->setIfExists('company', $data ?? [], null);
        $this->setIfExists('address', $data ?? [], null);
        $this->setIfExists('address2', $data ?? [], null);
        $this->setIfExists('town', $data ?? [], null);
        $this->setIfExists('county', $data ?? [], null);
        $this->setIfExists('country', $data ?? [], null);
        $this->setIfExists('friendlyCountry', $data ?? [], null);
        $this->setIfExists('postCode', $data ?? [], null);
        $this->setIfExists('telephone', $data ?? [], null);
        $this->setIfExists('fax', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['firstName'] === null) {
            $invalidProperties[] = "'firstName' can't be null";
        }
        if ($this->container['lastName'] === null) {
            $invalidProperties[] = "'lastName' can't be null";
        }
        if ($this->container['address'] === null) {
            $invalidProperties[] = "'address' can't be null";
        }
        if ($this->container['town'] === null) {
            $invalidProperties[] = "'town' can't be null";
        }
        if ($this->container['country'] === null) {
            $invalidProperties[] = "'country' can't be null";
        }
        if ($this->container['postCode'] === null) {
            $invalidProperties[] = "'postCode' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets firstName
     *
     * @return string
     */
    public function getFirstName()
    {
        return $this->container['firstName'];
    }

    /**
     * Sets firstName
     *
     * @param string $firstName firstName
     *
     * @return self
     */
    public function setFirstName($firstName)
    {
        if (is_null($firstName)) {
            throw new \InvalidArgumentException('non-nullable firstName cannot be null');
        }
        $this->container['firstName'] = $firstName;

        return $this;
    }

    /**
     * Gets lastName
     *
     * @return string
     */
    public function getLastName()
    {
        return $this->container['lastName'];
    }

    /**
     * Sets lastName
     *
     * @param string $lastName lastName
     *
     * @return self
     */
    public function setLastName($lastName)
    {
        if (is_null($lastName)) {
            throw new \InvalidArgumentException('non-nullable lastName cannot be null');
        }
        $this->container['lastName'] = $lastName;

        return $this;
    }

    /**
     * Gets id
     *
     * @return int|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int|null $id id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets createdDate
     *
     * @return \DateTime|null
     */
    public function getCreatedDate()
    {
        return $this->container['createdDate'];
    }

    /**
     * Sets createdDate
     *
     * @param \DateTime|null $createdDate createdDate
     *
     * @return self
     */
    public function setCreatedDate($createdDate)
    {
        if (is_null($createdDate)) {
            throw new \InvalidArgumentException('non-nullable createdDate cannot be null');
        }
        $this->container['createdDate'] = $createdDate;

        return $this;
    }

    /**
     * Gets modifiedDate
     *
     * @return \DateTime|null
     */
    public function getModifiedDate()
    {
        return $this->container['modifiedDate'];
    }

    /**
     * Sets modifiedDate
     *
     * @param \DateTime|null $modifiedDate modifiedDate
     *
     * @return self
     */
    public function setModifiedDate($modifiedDate)
    {
        if (is_null($modifiedDate)) {
            throw new \InvalidArgumentException('non-nullable modifiedDate cannot be null');
        }
        $this->container['modifiedDate'] = $modifiedDate;

        return $this;
    }

    /**
     * Gets customerId
     *
     * @return int|null
     */
    public function getCustomerId()
    {
        return $this->container['customerId'];
    }

    /**
     * Sets customerId
     *
     * @param int|null $customerId customerId
     *
     * @return self
     */
    public function setCustomerId($customerId)
    {
        if (is_null($customerId)) {
            throw new \InvalidArgumentException('non-nullable customerId cannot be null');
        }
        $this->container['customerId'] = $customerId;

        return $this;
    }

    /**
     * Gets isPreferredBillingAddress
     *
     * @return bool|null
     */
    public function getIsPreferredBillingAddress()
    {
        return $this->container['isPreferredBillingAddress'];
    }

    /**
     * Sets isPreferredBillingAddress
     *
     * @param bool|null $isPreferredBillingAddress isPreferredBillingAddress
     *
     * @return self
     */
    public function setIsPreferredBillingAddress($isPreferredBillingAddress)
    {
        if (is_null($isPreferredBillingAddress)) {
            throw new \InvalidArgumentException('non-nullable isPreferredBillingAddress cannot be null');
        }
        $this->container['isPreferredBillingAddress'] = $isPreferredBillingAddress;

        return $this;
    }

    /**
     * Gets isPreferredShippingAddress
     *
     * @return bool|null
     */
    public function getIsPreferredShippingAddress()
    {
        return $this->container['isPreferredShippingAddress'];
    }

    /**
     * Sets isPreferredShippingAddress
     *
     * @param bool|null $isPreferredShippingAddress isPreferredShippingAddress
     *
     * @return self
     */
    public function setIsPreferredShippingAddress($isPreferredShippingAddress)
    {
        if (is_null($isPreferredShippingAddress)) {
            throw new \InvalidArgumentException('non-nullable isPreferredShippingAddress cannot be null');
        }
        $this->container['isPreferredShippingAddress'] = $isPreferredShippingAddress;

        return $this;
    }

    /**
     * Gets company
     *
     * @return string|null
     */
    public function getCompany()
    {
        return $this->container['company'];
    }

    /**
     * Sets company
     *
     * @param string|null $company company
     *
     * @return self
     */
    public function setCompany($company)
    {
        if (is_null($company)) {
            throw new \InvalidArgumentException('non-nullable company cannot be null');
        }
        $this->container['company'] = $company;

        return $this;
    }

    /**
     * Gets address
     *
     * @return string
     */
    public function getAddress()
    {
        return $this->container['address'];
    }

    /**
     * Sets address
     *
     * @param string $address address
     *
     * @return self
     */
    public function setAddress($address)
    {
        if (is_null($address)) {
            throw new \InvalidArgumentException('non-nullable address cannot be null');
        }
        $this->container['address'] = $address;

        return $this;
    }

    /**
     * Gets address2
     *
     * @return string|null
     */
    public function getAddress2()
    {
        return $this->container['address2'];
    }

    /**
     * Sets address2
     *
     * @param string|null $address2 address2
     *
     * @return self
     */
    public function setAddress2($address2)
    {
        if (is_null($address2)) {
            throw new \InvalidArgumentException('non-nullable address2 cannot be null');
        }
        $this->container['address2'] = $address2;

        return $this;
    }

    /**
     * Gets town
     *
     * @return string
     */
    public function getTown()
    {
        return $this->container['town'];
    }

    /**
     * Sets town
     *
     * @param string $town town
     *
     * @return self
     */
    public function setTown($town)
    {
        if (is_null($town)) {
            throw new \InvalidArgumentException('non-nullable town cannot be null');
        }
        $this->container['town'] = $town;

        return $this;
    }

    /**
     * Gets county
     *
     * @return string|null
     */
    public function getCounty()
    {
        return $this->container['county'];
    }

    /**
     * Sets county
     *
     * @param string|null $county county
     *
     * @return self
     */
    public function setCounty($county)
    {
        if (is_null($county)) {
            throw new \InvalidArgumentException('non-nullable county cannot be null');
        }
        $this->container['county'] = $county;

        return $this;
    }

    /**
     * Gets country
     *
     * @return string
     */
    public function getCountry()
    {
        return $this->container['country'];
    }

    /**
     * Sets country
     *
     * @param string $country country
     *
     * @return self
     */
    public function setCountry($country)
    {
        if (is_null($country)) {
            throw new \InvalidArgumentException('non-nullable country cannot be null');
        }
        $this->container['country'] = $country;

        return $this;
    }

    /**
     * Gets friendlyCountry
     *
     * @return string|null
     */
    public function getFriendlyCountry()
    {
        return $this->container['friendlyCountry'];
    }

    /**
     * Sets friendlyCountry
     *
     * @param string|null $friendlyCountry friendlyCountry
     *
     * @return self
     */
    public function setFriendlyCountry($friendlyCountry)
    {
        if (is_null($friendlyCountry)) {
            throw new \InvalidArgumentException('non-nullable friendlyCountry cannot be null');
        }
        $this->container['friendlyCountry'] = $friendlyCountry;

        return $this;
    }

    /**
     * Gets postCode
     *
     * @return string
     */
    public function getPostCode()
    {
        return $this->container['postCode'];
    }

    /**
     * Sets postCode
     *
     * @param string $postCode postCode
     *
     * @return self
     */
    public function setPostCode($postCode)
    {
        if (is_null($postCode)) {
            throw new \InvalidArgumentException('non-nullable postCode cannot be null');
        }
        $this->container['postCode'] = $postCode;

        return $this;
    }

    /**
     * Gets telephone
     *
     * @return string|null
     */
    public function getTelephone()
    {
        return $this->container['telephone'];
    }

    /**
     * Sets telephone
     *
     * @param string|null $telephone telephone
     *
     * @return self
     */
    public function setTelephone($telephone)
    {
        if (is_null($telephone)) {
            throw new \InvalidArgumentException('non-nullable telephone cannot be null');
        }
        $this->container['telephone'] = $telephone;

        return $this;
    }

    /**
     * Gets fax
     *
     * @return string|null
     */
    public function getFax()
    {
        return $this->container['fax'];
    }

    /**
     * Sets fax
     *
     * @param string|null $fax fax
     *
     * @return self
     */
    public function setFax($fax)
    {
        if (is_null($fax)) {
            throw new \InvalidArgumentException('non-nullable fax cannot be null');
        }
        $this->container['fax'] = $fax;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


