<?php
/**
 * WebhooksApi
 * PHP version 8.1
 *
 * @category Class
 * @package  EKM
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * EKM Partner API
 *
 * Our new API allows partners to build significantly better integrations with the EKM platform.    To try out the below endpoints, or for full up to date representations of the request / response models, please see the [swagger page](https://api.ekm.net/swagger/index.html). (We display examples here, but the swagger page is guaranteed to show the complete model.)    To keep up to date with the latest updates, please see our [RSS feed](https://partners.ekm.net/ChangeLog/Feed) or the [partner dashboard](https://partners.ekm.net/).
 *
 * The version of the OpenAPI document: v1
 * Contact: api-support@ekm.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace EKM\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use EKM\ApiException;
use EKM\Configuration;
use EKM\FormDataProcessor;
use EKM\HeaderSelector;
use EKM\ObjectSerializer;

/**
 * WebhooksApi Class Doc Comment
 *
 * @category Class
 * @package  EKM
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class WebhooksApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'apiV1WebhooksDelete' => [
            'application/json',
        ],
        'apiV1WebhooksPut' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation apiV1WebhooksDelete
     *
     * Unsubscribe from a webhook
     *
     * @param  string $topic The topic to unsubscribe from (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1WebhooksDelete'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function apiV1WebhooksDelete($topic, string $contentType = self::contentTypes['apiV1WebhooksDelete'][0])
    {
        $this->apiV1WebhooksDeleteWithHttpInfo($topic, $contentType);
    }

    /**
     * Operation apiV1WebhooksDeleteWithHttpInfo
     *
     * Unsubscribe from a webhook
     *
     * @param  string $topic The topic to unsubscribe from (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1WebhooksDelete'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1WebhooksDeleteWithHttpInfo($topic, string $contentType = self::contentTypes['apiV1WebhooksDelete'][0])
    {
        $request = $this->apiV1WebhooksDeleteRequest($topic, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1WebhooksDeleteAsync
     *
     * Unsubscribe from a webhook
     *
     * @param  string $topic The topic to unsubscribe from (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1WebhooksDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1WebhooksDeleteAsync($topic, string $contentType = self::contentTypes['apiV1WebhooksDelete'][0])
    {
        return $this->apiV1WebhooksDeleteAsyncWithHttpInfo($topic, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1WebhooksDeleteAsyncWithHttpInfo
     *
     * Unsubscribe from a webhook
     *
     * @param  string $topic The topic to unsubscribe from (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1WebhooksDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1WebhooksDeleteAsyncWithHttpInfo($topic, string $contentType = self::contentTypes['apiV1WebhooksDelete'][0])
    {
        $returnType = '';
        $request = $this->apiV1WebhooksDeleteRequest($topic, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1WebhooksDelete'
     *
     * @param  string $topic The topic to unsubscribe from (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1WebhooksDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1WebhooksDeleteRequest($topic, string $contentType = self::contentTypes['apiV1WebhooksDelete'][0])
    {

        // verify the required parameter 'topic' is set
        if ($topic === null || (is_array($topic) && count($topic) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $topic when calling apiV1WebhooksDelete'
            );
        }


        $resourcePath = '/api/v1/webhooks';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $topic,
            'topic', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1WebhooksPut
     *
     * Subscribe to a webhook
     *
     * @param  string $topic The topic to subscribe to (required)
     * @param  string $endpoint The endpoint to send webhooks to (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1WebhooksPut'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function apiV1WebhooksPut($topic, $endpoint, string $contentType = self::contentTypes['apiV1WebhooksPut'][0])
    {
        $this->apiV1WebhooksPutWithHttpInfo($topic, $endpoint, $contentType);
    }

    /**
     * Operation apiV1WebhooksPutWithHttpInfo
     *
     * Subscribe to a webhook
     *
     * @param  string $topic The topic to subscribe to (required)
     * @param  string $endpoint The endpoint to send webhooks to (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1WebhooksPut'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1WebhooksPutWithHttpInfo($topic, $endpoint, string $contentType = self::contentTypes['apiV1WebhooksPut'][0])
    {
        $request = $this->apiV1WebhooksPutRequest($topic, $endpoint, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1WebhooksPutAsync
     *
     * Subscribe to a webhook
     *
     * @param  string $topic The topic to subscribe to (required)
     * @param  string $endpoint The endpoint to send webhooks to (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1WebhooksPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1WebhooksPutAsync($topic, $endpoint, string $contentType = self::contentTypes['apiV1WebhooksPut'][0])
    {
        return $this->apiV1WebhooksPutAsyncWithHttpInfo($topic, $endpoint, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1WebhooksPutAsyncWithHttpInfo
     *
     * Subscribe to a webhook
     *
     * @param  string $topic The topic to subscribe to (required)
     * @param  string $endpoint The endpoint to send webhooks to (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1WebhooksPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1WebhooksPutAsyncWithHttpInfo($topic, $endpoint, string $contentType = self::contentTypes['apiV1WebhooksPut'][0])
    {
        $returnType = '';
        $request = $this->apiV1WebhooksPutRequest($topic, $endpoint, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1WebhooksPut'
     *
     * @param  string $topic The topic to subscribe to (required)
     * @param  string $endpoint The endpoint to send webhooks to (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1WebhooksPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1WebhooksPutRequest($topic, $endpoint, string $contentType = self::contentTypes['apiV1WebhooksPut'][0])
    {

        // verify the required parameter 'topic' is set
        if ($topic === null || (is_array($topic) && count($topic) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $topic when calling apiV1WebhooksPut'
            );
        }

        // verify the required parameter 'endpoint' is set
        if ($endpoint === null || (is_array($endpoint) && count($endpoint) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $endpoint when calling apiV1WebhooksPut'
            );
        }


        $resourcePath = '/api/v1/webhooks';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $topic,
            'topic', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $endpoint,
            'endpoint', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
