<?php
/**
 * ProductVariantsApi
 * PHP version 8.1
 *
 * @category Class
 * @package  EKM
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * EKM Partner API
 *
 * Our new API allows partners to build significantly better integrations with the EKM platform.    To try out the below endpoints, or for full up to date representations of the request / response models, please see the [swagger page](https://api.ekm.net/swagger/index.html). (We display examples here, but the swagger page is guaranteed to show the complete model.)    To keep up to date with the latest updates, please see our [RSS feed](https://partners.ekm.net/ChangeLog/Feed) or the [partner dashboard](https://partners.ekm.net/).
 *
 * The version of the OpenAPI document: v1
 * Contact: api-support@ekm.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace EKM\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use EKM\ApiException;
use EKM\Configuration;
use EKM\FormDataProcessor;
use EKM\HeaderSelector;
use EKM\ObjectSerializer;

/**
 * ProductVariantsApi Class Doc Comment
 *
 * @category Class
 * @package  EKM
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ProductVariantsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'apiV1ProductsByIdVariantsByVariantIdDelete' => [
            'application/json',
        ],
        'apiV1ProductsByIdVariantsByVariantIdGet' => [
            'application/json',
        ],
        'apiV1ProductsByIdVariantsByVariantIdImagesByImageNumberPost' => [
            'application/json',
        ],
        'apiV1ProductsByIdVariantsByVariantIdImagesGet' => [
            'application/json',
        ],
        'apiV1ProductsByIdVariantsByVariantIdPut' => [
            'application/json',
        ],
        'apiV1ProductsByIdVariantsGet' => [
            'application/json',
        ],
        'apiV1ProductsByIdVariantsPost' => [
            'application/json',
        ],
        'apiV1ProductsVariantsByVariantIdGet' => [
            'application/json',
        ],
        'apiV1VariantsSearchGet' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation apiV1ProductsByIdVariantsByVariantIdDelete
     *
     * Delete a variant
     *
     * @param  int $id The product ID (required)
     * @param  int $variantId The variant ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdVariantsByVariantIdDelete'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKM\Model\TempestResponseProductVariant|\EKM\Model\TempestResponseTempestValidationError
     */
    public function apiV1ProductsByIdVariantsByVariantIdDelete($id, $variantId, string $contentType = self::contentTypes['apiV1ProductsByIdVariantsByVariantIdDelete'][0])
    {
        list($response) = $this->apiV1ProductsByIdVariantsByVariantIdDeleteWithHttpInfo($id, $variantId, $contentType);
        return $response;
    }

    /**
     * Operation apiV1ProductsByIdVariantsByVariantIdDeleteWithHttpInfo
     *
     * Delete a variant
     *
     * @param  int $id The product ID (required)
     * @param  int $variantId The variant ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdVariantsByVariantIdDelete'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKM\Model\TempestResponseProductVariant|\EKM\Model\TempestResponseTempestValidationError, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1ProductsByIdVariantsByVariantIdDeleteWithHttpInfo($id, $variantId, string $contentType = self::contentTypes['apiV1ProductsByIdVariantsByVariantIdDelete'][0])
    {
        $request = $this->apiV1ProductsByIdVariantsByVariantIdDeleteRequest($id, $variantId, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseProductVariant',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKM\Model\TempestResponseProductVariant',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseProductVariant',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1ProductsByIdVariantsByVariantIdDeleteAsync
     *
     * Delete a variant
     *
     * @param  int $id The product ID (required)
     * @param  int $variantId The variant ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdVariantsByVariantIdDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ProductsByIdVariantsByVariantIdDeleteAsync($id, $variantId, string $contentType = self::contentTypes['apiV1ProductsByIdVariantsByVariantIdDelete'][0])
    {
        return $this->apiV1ProductsByIdVariantsByVariantIdDeleteAsyncWithHttpInfo($id, $variantId, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1ProductsByIdVariantsByVariantIdDeleteAsyncWithHttpInfo
     *
     * Delete a variant
     *
     * @param  int $id The product ID (required)
     * @param  int $variantId The variant ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdVariantsByVariantIdDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ProductsByIdVariantsByVariantIdDeleteAsyncWithHttpInfo($id, $variantId, string $contentType = self::contentTypes['apiV1ProductsByIdVariantsByVariantIdDelete'][0])
    {
        $returnType = '\EKM\Model\TempestResponseProductVariant';
        $request = $this->apiV1ProductsByIdVariantsByVariantIdDeleteRequest($id, $variantId, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1ProductsByIdVariantsByVariantIdDelete'
     *
     * @param  int $id The product ID (required)
     * @param  int $variantId The variant ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdVariantsByVariantIdDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1ProductsByIdVariantsByVariantIdDeleteRequest($id, $variantId, string $contentType = self::contentTypes['apiV1ProductsByIdVariantsByVariantIdDelete'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling apiV1ProductsByIdVariantsByVariantIdDelete'
            );
        }

        // verify the required parameter 'variantId' is set
        if ($variantId === null || (is_array($variantId) && count($variantId) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $variantId when calling apiV1ProductsByIdVariantsByVariantIdDelete'
            );
        }


        $resourcePath = '/api/v1/products/{id}/variants/{variantId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }
        // path params
        if ($variantId !== null) {
            $resourcePath = str_replace(
                '{' . 'variantId' . '}',
                ObjectSerializer::toPathValue($variantId),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1ProductsByIdVariantsByVariantIdGet
     *
     * Get a product variant
     *
     * @param  int $id The product ID (required)
     * @param  int $variantId The variant ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdVariantsByVariantIdGet'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKM\Model\TempestResponseProductVariant|\EKM\Model\TempestResponseTempestValidationError
     */
    public function apiV1ProductsByIdVariantsByVariantIdGet($id, $variantId, string $contentType = self::contentTypes['apiV1ProductsByIdVariantsByVariantIdGet'][0])
    {
        list($response) = $this->apiV1ProductsByIdVariantsByVariantIdGetWithHttpInfo($id, $variantId, $contentType);
        return $response;
    }

    /**
     * Operation apiV1ProductsByIdVariantsByVariantIdGetWithHttpInfo
     *
     * Get a product variant
     *
     * @param  int $id The product ID (required)
     * @param  int $variantId The variant ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdVariantsByVariantIdGet'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKM\Model\TempestResponseProductVariant|\EKM\Model\TempestResponseTempestValidationError, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1ProductsByIdVariantsByVariantIdGetWithHttpInfo($id, $variantId, string $contentType = self::contentTypes['apiV1ProductsByIdVariantsByVariantIdGet'][0])
    {
        $request = $this->apiV1ProductsByIdVariantsByVariantIdGetRequest($id, $variantId, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseProductVariant',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKM\Model\TempestResponseProductVariant',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseProductVariant',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1ProductsByIdVariantsByVariantIdGetAsync
     *
     * Get a product variant
     *
     * @param  int $id The product ID (required)
     * @param  int $variantId The variant ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdVariantsByVariantIdGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ProductsByIdVariantsByVariantIdGetAsync($id, $variantId, string $contentType = self::contentTypes['apiV1ProductsByIdVariantsByVariantIdGet'][0])
    {
        return $this->apiV1ProductsByIdVariantsByVariantIdGetAsyncWithHttpInfo($id, $variantId, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1ProductsByIdVariantsByVariantIdGetAsyncWithHttpInfo
     *
     * Get a product variant
     *
     * @param  int $id The product ID (required)
     * @param  int $variantId The variant ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdVariantsByVariantIdGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ProductsByIdVariantsByVariantIdGetAsyncWithHttpInfo($id, $variantId, string $contentType = self::contentTypes['apiV1ProductsByIdVariantsByVariantIdGet'][0])
    {
        $returnType = '\EKM\Model\TempestResponseProductVariant';
        $request = $this->apiV1ProductsByIdVariantsByVariantIdGetRequest($id, $variantId, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1ProductsByIdVariantsByVariantIdGet'
     *
     * @param  int $id The product ID (required)
     * @param  int $variantId The variant ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdVariantsByVariantIdGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1ProductsByIdVariantsByVariantIdGetRequest($id, $variantId, string $contentType = self::contentTypes['apiV1ProductsByIdVariantsByVariantIdGet'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling apiV1ProductsByIdVariantsByVariantIdGet'
            );
        }

        // verify the required parameter 'variantId' is set
        if ($variantId === null || (is_array($variantId) && count($variantId) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $variantId when calling apiV1ProductsByIdVariantsByVariantIdGet'
            );
        }


        $resourcePath = '/api/v1/products/{id}/variants/{variantId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }
        // path params
        if ($variantId !== null) {
            $resourcePath = str_replace(
                '{' . 'variantId' . '}',
                ObjectSerializer::toPathValue($variantId),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1ProductsByIdVariantsByVariantIdImagesByImageNumberPost
     *
     * Set a variants image to a URL
     *
     * @param  int $id The product ID (required)
     * @param  int $variantId The variant ID (required)
     * @param  int $imageNumber The image number (required)
     * @param  string $imageUrl The URL of the image (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdVariantsByVariantIdImagesByImageNumberPost'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKM\Model\TempestResponseProductImages|\EKM\Model\TempestResponseTempestValidationError
     */
    public function apiV1ProductsByIdVariantsByVariantIdImagesByImageNumberPost($id, $variantId, $imageNumber, $imageUrl, string $contentType = self::contentTypes['apiV1ProductsByIdVariantsByVariantIdImagesByImageNumberPost'][0])
    {
        list($response) = $this->apiV1ProductsByIdVariantsByVariantIdImagesByImageNumberPostWithHttpInfo($id, $variantId, $imageNumber, $imageUrl, $contentType);
        return $response;
    }

    /**
     * Operation apiV1ProductsByIdVariantsByVariantIdImagesByImageNumberPostWithHttpInfo
     *
     * Set a variants image to a URL
     *
     * @param  int $id The product ID (required)
     * @param  int $variantId The variant ID (required)
     * @param  int $imageNumber The image number (required)
     * @param  string $imageUrl The URL of the image (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdVariantsByVariantIdImagesByImageNumberPost'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKM\Model\TempestResponseProductImages|\EKM\Model\TempestResponseTempestValidationError, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1ProductsByIdVariantsByVariantIdImagesByImageNumberPostWithHttpInfo($id, $variantId, $imageNumber, $imageUrl, string $contentType = self::contentTypes['apiV1ProductsByIdVariantsByVariantIdImagesByImageNumberPost'][0])
    {
        $request = $this->apiV1ProductsByIdVariantsByVariantIdImagesByImageNumberPostRequest($id, $variantId, $imageNumber, $imageUrl, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseProductImages',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKM\Model\TempestResponseProductImages',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseProductImages',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1ProductsByIdVariantsByVariantIdImagesByImageNumberPostAsync
     *
     * Set a variants image to a URL
     *
     * @param  int $id The product ID (required)
     * @param  int $variantId The variant ID (required)
     * @param  int $imageNumber The image number (required)
     * @param  string $imageUrl The URL of the image (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdVariantsByVariantIdImagesByImageNumberPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ProductsByIdVariantsByVariantIdImagesByImageNumberPostAsync($id, $variantId, $imageNumber, $imageUrl, string $contentType = self::contentTypes['apiV1ProductsByIdVariantsByVariantIdImagesByImageNumberPost'][0])
    {
        return $this->apiV1ProductsByIdVariantsByVariantIdImagesByImageNumberPostAsyncWithHttpInfo($id, $variantId, $imageNumber, $imageUrl, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1ProductsByIdVariantsByVariantIdImagesByImageNumberPostAsyncWithHttpInfo
     *
     * Set a variants image to a URL
     *
     * @param  int $id The product ID (required)
     * @param  int $variantId The variant ID (required)
     * @param  int $imageNumber The image number (required)
     * @param  string $imageUrl The URL of the image (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdVariantsByVariantIdImagesByImageNumberPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ProductsByIdVariantsByVariantIdImagesByImageNumberPostAsyncWithHttpInfo($id, $variantId, $imageNumber, $imageUrl, string $contentType = self::contentTypes['apiV1ProductsByIdVariantsByVariantIdImagesByImageNumberPost'][0])
    {
        $returnType = '\EKM\Model\TempestResponseProductImages';
        $request = $this->apiV1ProductsByIdVariantsByVariantIdImagesByImageNumberPostRequest($id, $variantId, $imageNumber, $imageUrl, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1ProductsByIdVariantsByVariantIdImagesByImageNumberPost'
     *
     * @param  int $id The product ID (required)
     * @param  int $variantId The variant ID (required)
     * @param  int $imageNumber The image number (required)
     * @param  string $imageUrl The URL of the image (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdVariantsByVariantIdImagesByImageNumberPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1ProductsByIdVariantsByVariantIdImagesByImageNumberPostRequest($id, $variantId, $imageNumber, $imageUrl, string $contentType = self::contentTypes['apiV1ProductsByIdVariantsByVariantIdImagesByImageNumberPost'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling apiV1ProductsByIdVariantsByVariantIdImagesByImageNumberPost'
            );
        }

        // verify the required parameter 'variantId' is set
        if ($variantId === null || (is_array($variantId) && count($variantId) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $variantId when calling apiV1ProductsByIdVariantsByVariantIdImagesByImageNumberPost'
            );
        }

        // verify the required parameter 'imageNumber' is set
        if ($imageNumber === null || (is_array($imageNumber) && count($imageNumber) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $imageNumber when calling apiV1ProductsByIdVariantsByVariantIdImagesByImageNumberPost'
            );
        }

        // verify the required parameter 'imageUrl' is set
        if ($imageUrl === null || (is_array($imageUrl) && count($imageUrl) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $imageUrl when calling apiV1ProductsByIdVariantsByVariantIdImagesByImageNumberPost'
            );
        }


        $resourcePath = '/api/v1/products/{id}/variants/{variantId}/images/{imageNumber}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $imageUrl,
            'imageUrl', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }
        // path params
        if ($variantId !== null) {
            $resourcePath = str_replace(
                '{' . 'variantId' . '}',
                ObjectSerializer::toPathValue($variantId),
                $resourcePath
            );
        }
        // path params
        if ($imageNumber !== null) {
            $resourcePath = str_replace(
                '{' . 'imageNumber' . '}',
                ObjectSerializer::toPathValue($imageNumber),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1ProductsByIdVariantsByVariantIdImagesGet
     *
     * Get a variant&#39;s images.
     *
     * @param  int $id The product ID (required)
     * @param  int $variantId The variant ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdVariantsByVariantIdImagesGet'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKM\Model\TempestResponseProductImages|\EKM\Model\TempestResponseTempestValidationError
     */
    public function apiV1ProductsByIdVariantsByVariantIdImagesGet($id, $variantId, string $contentType = self::contentTypes['apiV1ProductsByIdVariantsByVariantIdImagesGet'][0])
    {
        list($response) = $this->apiV1ProductsByIdVariantsByVariantIdImagesGetWithHttpInfo($id, $variantId, $contentType);
        return $response;
    }

    /**
     * Operation apiV1ProductsByIdVariantsByVariantIdImagesGetWithHttpInfo
     *
     * Get a variant&#39;s images.
     *
     * @param  int $id The product ID (required)
     * @param  int $variantId The variant ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdVariantsByVariantIdImagesGet'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKM\Model\TempestResponseProductImages|\EKM\Model\TempestResponseTempestValidationError, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1ProductsByIdVariantsByVariantIdImagesGetWithHttpInfo($id, $variantId, string $contentType = self::contentTypes['apiV1ProductsByIdVariantsByVariantIdImagesGet'][0])
    {
        $request = $this->apiV1ProductsByIdVariantsByVariantIdImagesGetRequest($id, $variantId, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseProductImages',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKM\Model\TempestResponseProductImages',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseProductImages',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1ProductsByIdVariantsByVariantIdImagesGetAsync
     *
     * Get a variant&#39;s images.
     *
     * @param  int $id The product ID (required)
     * @param  int $variantId The variant ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdVariantsByVariantIdImagesGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ProductsByIdVariantsByVariantIdImagesGetAsync($id, $variantId, string $contentType = self::contentTypes['apiV1ProductsByIdVariantsByVariantIdImagesGet'][0])
    {
        return $this->apiV1ProductsByIdVariantsByVariantIdImagesGetAsyncWithHttpInfo($id, $variantId, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1ProductsByIdVariantsByVariantIdImagesGetAsyncWithHttpInfo
     *
     * Get a variant&#39;s images.
     *
     * @param  int $id The product ID (required)
     * @param  int $variantId The variant ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdVariantsByVariantIdImagesGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ProductsByIdVariantsByVariantIdImagesGetAsyncWithHttpInfo($id, $variantId, string $contentType = self::contentTypes['apiV1ProductsByIdVariantsByVariantIdImagesGet'][0])
    {
        $returnType = '\EKM\Model\TempestResponseProductImages';
        $request = $this->apiV1ProductsByIdVariantsByVariantIdImagesGetRequest($id, $variantId, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1ProductsByIdVariantsByVariantIdImagesGet'
     *
     * @param  int $id The product ID (required)
     * @param  int $variantId The variant ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdVariantsByVariantIdImagesGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1ProductsByIdVariantsByVariantIdImagesGetRequest($id, $variantId, string $contentType = self::contentTypes['apiV1ProductsByIdVariantsByVariantIdImagesGet'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling apiV1ProductsByIdVariantsByVariantIdImagesGet'
            );
        }

        // verify the required parameter 'variantId' is set
        if ($variantId === null || (is_array($variantId) && count($variantId) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $variantId when calling apiV1ProductsByIdVariantsByVariantIdImagesGet'
            );
        }


        $resourcePath = '/api/v1/products/{id}/variants/{variantId}/images';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }
        // path params
        if ($variantId !== null) {
            $resourcePath = str_replace(
                '{' . 'variantId' . '}',
                ObjectSerializer::toPathValue($variantId),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1ProductsByIdVariantsByVariantIdPut
     *
     * Update a product variant
     *
     * @param  int $id The product ID (required)
     * @param  int $variantId The varaint ID (required)
     * @param  \EKM\Model\ProductVariant|null $model model (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdVariantsByVariantIdPut'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKM\Model\TempestResponseProductVariant|\EKM\Model\TempestResponseProductVariant|\EKM\Model\TempestResponseTempestValidationError
     */
    public function apiV1ProductsByIdVariantsByVariantIdPut($id, $variantId, $model = null, string $contentType = self::contentTypes['apiV1ProductsByIdVariantsByVariantIdPut'][0])
    {
        list($response) = $this->apiV1ProductsByIdVariantsByVariantIdPutWithHttpInfo($id, $variantId, $model, $contentType);
        return $response;
    }

    /**
     * Operation apiV1ProductsByIdVariantsByVariantIdPutWithHttpInfo
     *
     * Update a product variant
     *
     * @param  int $id The product ID (required)
     * @param  int $variantId The varaint ID (required)
     * @param  \EKM\Model\ProductVariant|null $model (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdVariantsByVariantIdPut'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKM\Model\TempestResponseProductVariant|\EKM\Model\TempestResponseProductVariant|\EKM\Model\TempestResponseTempestValidationError, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1ProductsByIdVariantsByVariantIdPutWithHttpInfo($id, $variantId, $model = null, string $contentType = self::contentTypes['apiV1ProductsByIdVariantsByVariantIdPut'][0])
    {
        $request = $this->apiV1ProductsByIdVariantsByVariantIdPutRequest($id, $variantId, $model, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseProductVariant',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseProductVariant',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKM\Model\TempestResponseProductVariant',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseProductVariant',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseProductVariant',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1ProductsByIdVariantsByVariantIdPutAsync
     *
     * Update a product variant
     *
     * @param  int $id The product ID (required)
     * @param  int $variantId The varaint ID (required)
     * @param  \EKM\Model\ProductVariant|null $model (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdVariantsByVariantIdPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ProductsByIdVariantsByVariantIdPutAsync($id, $variantId, $model = null, string $contentType = self::contentTypes['apiV1ProductsByIdVariantsByVariantIdPut'][0])
    {
        return $this->apiV1ProductsByIdVariantsByVariantIdPutAsyncWithHttpInfo($id, $variantId, $model, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1ProductsByIdVariantsByVariantIdPutAsyncWithHttpInfo
     *
     * Update a product variant
     *
     * @param  int $id The product ID (required)
     * @param  int $variantId The varaint ID (required)
     * @param  \EKM\Model\ProductVariant|null $model (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdVariantsByVariantIdPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ProductsByIdVariantsByVariantIdPutAsyncWithHttpInfo($id, $variantId, $model = null, string $contentType = self::contentTypes['apiV1ProductsByIdVariantsByVariantIdPut'][0])
    {
        $returnType = '\EKM\Model\TempestResponseProductVariant';
        $request = $this->apiV1ProductsByIdVariantsByVariantIdPutRequest($id, $variantId, $model, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1ProductsByIdVariantsByVariantIdPut'
     *
     * @param  int $id The product ID (required)
     * @param  int $variantId The varaint ID (required)
     * @param  \EKM\Model\ProductVariant|null $model (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdVariantsByVariantIdPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1ProductsByIdVariantsByVariantIdPutRequest($id, $variantId, $model = null, string $contentType = self::contentTypes['apiV1ProductsByIdVariantsByVariantIdPut'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling apiV1ProductsByIdVariantsByVariantIdPut'
            );
        }

        // verify the required parameter 'variantId' is set
        if ($variantId === null || (is_array($variantId) && count($variantId) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $variantId when calling apiV1ProductsByIdVariantsByVariantIdPut'
            );
        }



        $resourcePath = '/api/v1/products/{id}/variants/{variantId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }
        // path params
        if ($variantId !== null) {
            $resourcePath = str_replace(
                '{' . 'variantId' . '}',
                ObjectSerializer::toPathValue($variantId),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($model)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($model));
            } else {
                $httpBody = $model;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1ProductsByIdVariantsGet
     *
     * Get a products variants
     *
     * @param  int $id The product ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdVariantsGet'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKM\Model\TempestResponseListProductVariant|\EKM\Model\TempestResponseTempestValidationError|\EKM\Model\TempestResponseTempestValidationError
     */
    public function apiV1ProductsByIdVariantsGet($id, string $contentType = self::contentTypes['apiV1ProductsByIdVariantsGet'][0])
    {
        list($response) = $this->apiV1ProductsByIdVariantsGetWithHttpInfo($id, $contentType);
        return $response;
    }

    /**
     * Operation apiV1ProductsByIdVariantsGetWithHttpInfo
     *
     * Get a products variants
     *
     * @param  int $id The product ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdVariantsGet'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKM\Model\TempestResponseListProductVariant|\EKM\Model\TempestResponseTempestValidationError|\EKM\Model\TempestResponseTempestValidationError, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1ProductsByIdVariantsGetWithHttpInfo($id, string $contentType = self::contentTypes['apiV1ProductsByIdVariantsGet'][0])
    {
        $request = $this->apiV1ProductsByIdVariantsGetRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseListProductVariant',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $request,
                        $response,
                    );
                case 422:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKM\Model\TempestResponseListProductVariant',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseListProductVariant',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1ProductsByIdVariantsGetAsync
     *
     * Get a products variants
     *
     * @param  int $id The product ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdVariantsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ProductsByIdVariantsGetAsync($id, string $contentType = self::contentTypes['apiV1ProductsByIdVariantsGet'][0])
    {
        return $this->apiV1ProductsByIdVariantsGetAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1ProductsByIdVariantsGetAsyncWithHttpInfo
     *
     * Get a products variants
     *
     * @param  int $id The product ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdVariantsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ProductsByIdVariantsGetAsyncWithHttpInfo($id, string $contentType = self::contentTypes['apiV1ProductsByIdVariantsGet'][0])
    {
        $returnType = '\EKM\Model\TempestResponseListProductVariant';
        $request = $this->apiV1ProductsByIdVariantsGetRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1ProductsByIdVariantsGet'
     *
     * @param  int $id The product ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdVariantsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1ProductsByIdVariantsGetRequest($id, string $contentType = self::contentTypes['apiV1ProductsByIdVariantsGet'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling apiV1ProductsByIdVariantsGet'
            );
        }


        $resourcePath = '/api/v1/products/{id}/variants';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1ProductsByIdVariantsPost
     *
     * Add a variant to a product
     *
     * @param  int $id The product ID (required)
     * @param  \EKM\Model\ProductVariant|null $model model (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdVariantsPost'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKM\Model\TempestResponseListProductVariant|\EKM\Model\TempestResponseProductVariant|\EKM\Model\TempestResponseTempestValidationError
     */
    public function apiV1ProductsByIdVariantsPost($id, $model = null, string $contentType = self::contentTypes['apiV1ProductsByIdVariantsPost'][0])
    {
        list($response) = $this->apiV1ProductsByIdVariantsPostWithHttpInfo($id, $model, $contentType);
        return $response;
    }

    /**
     * Operation apiV1ProductsByIdVariantsPostWithHttpInfo
     *
     * Add a variant to a product
     *
     * @param  int $id The product ID (required)
     * @param  \EKM\Model\ProductVariant|null $model (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdVariantsPost'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKM\Model\TempestResponseListProductVariant|\EKM\Model\TempestResponseProductVariant|\EKM\Model\TempestResponseTempestValidationError, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1ProductsByIdVariantsPostWithHttpInfo($id, $model = null, string $contentType = self::contentTypes['apiV1ProductsByIdVariantsPost'][0])
    {
        $request = $this->apiV1ProductsByIdVariantsPostRequest($id, $model, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 201:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseListProductVariant',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseProductVariant',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKM\Model\TempestResponseListProductVariant',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseListProductVariant',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseProductVariant',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1ProductsByIdVariantsPostAsync
     *
     * Add a variant to a product
     *
     * @param  int $id The product ID (required)
     * @param  \EKM\Model\ProductVariant|null $model (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdVariantsPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ProductsByIdVariantsPostAsync($id, $model = null, string $contentType = self::contentTypes['apiV1ProductsByIdVariantsPost'][0])
    {
        return $this->apiV1ProductsByIdVariantsPostAsyncWithHttpInfo($id, $model, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1ProductsByIdVariantsPostAsyncWithHttpInfo
     *
     * Add a variant to a product
     *
     * @param  int $id The product ID (required)
     * @param  \EKM\Model\ProductVariant|null $model (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdVariantsPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ProductsByIdVariantsPostAsyncWithHttpInfo($id, $model = null, string $contentType = self::contentTypes['apiV1ProductsByIdVariantsPost'][0])
    {
        $returnType = '\EKM\Model\TempestResponseListProductVariant';
        $request = $this->apiV1ProductsByIdVariantsPostRequest($id, $model, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1ProductsByIdVariantsPost'
     *
     * @param  int $id The product ID (required)
     * @param  \EKM\Model\ProductVariant|null $model (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdVariantsPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1ProductsByIdVariantsPostRequest($id, $model = null, string $contentType = self::contentTypes['apiV1ProductsByIdVariantsPost'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling apiV1ProductsByIdVariantsPost'
            );
        }



        $resourcePath = '/api/v1/products/{id}/variants';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($model)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($model));
            } else {
                $httpBody = $model;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1ProductsVariantsByVariantIdGet
     *
     * Get a product variant
     *
     * @param  int $variantId The variant ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsVariantsByVariantIdGet'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKM\Model\TempestResponseProductVariant|\EKM\Model\TempestResponseTempestValidationError
     */
    public function apiV1ProductsVariantsByVariantIdGet($variantId, string $contentType = self::contentTypes['apiV1ProductsVariantsByVariantIdGet'][0])
    {
        list($response) = $this->apiV1ProductsVariantsByVariantIdGetWithHttpInfo($variantId, $contentType);
        return $response;
    }

    /**
     * Operation apiV1ProductsVariantsByVariantIdGetWithHttpInfo
     *
     * Get a product variant
     *
     * @param  int $variantId The variant ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsVariantsByVariantIdGet'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKM\Model\TempestResponseProductVariant|\EKM\Model\TempestResponseTempestValidationError, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1ProductsVariantsByVariantIdGetWithHttpInfo($variantId, string $contentType = self::contentTypes['apiV1ProductsVariantsByVariantIdGet'][0])
    {
        $request = $this->apiV1ProductsVariantsByVariantIdGetRequest($variantId, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseProductVariant',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKM\Model\TempestResponseProductVariant',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseProductVariant',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1ProductsVariantsByVariantIdGetAsync
     *
     * Get a product variant
     *
     * @param  int $variantId The variant ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsVariantsByVariantIdGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ProductsVariantsByVariantIdGetAsync($variantId, string $contentType = self::contentTypes['apiV1ProductsVariantsByVariantIdGet'][0])
    {
        return $this->apiV1ProductsVariantsByVariantIdGetAsyncWithHttpInfo($variantId, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1ProductsVariantsByVariantIdGetAsyncWithHttpInfo
     *
     * Get a product variant
     *
     * @param  int $variantId The variant ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsVariantsByVariantIdGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ProductsVariantsByVariantIdGetAsyncWithHttpInfo($variantId, string $contentType = self::contentTypes['apiV1ProductsVariantsByVariantIdGet'][0])
    {
        $returnType = '\EKM\Model\TempestResponseProductVariant';
        $request = $this->apiV1ProductsVariantsByVariantIdGetRequest($variantId, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1ProductsVariantsByVariantIdGet'
     *
     * @param  int $variantId The variant ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsVariantsByVariantIdGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1ProductsVariantsByVariantIdGetRequest($variantId, string $contentType = self::contentTypes['apiV1ProductsVariantsByVariantIdGet'][0])
    {

        // verify the required parameter 'variantId' is set
        if ($variantId === null || (is_array($variantId) && count($variantId) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $variantId when calling apiV1ProductsVariantsByVariantIdGet'
            );
        }


        $resourcePath = '/api/v1/products/variants/{variantId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($variantId !== null) {
            $resourcePath = str_replace(
                '{' . 'variantId' . '}',
                ObjectSerializer::toPathValue($variantId),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1VariantsSearchGet
     *
     * Searches variants based on search criteria
     *
     * @param  int|null $page Page number to display (optional, default to 1)
     * @param  int|null $limit Items per page (maximum 20) (optional, default to 10)
     * @param  string|null $query A &lt;a href&#x3D;\&quot;#tag/OData\&quot; target&#x3D;\&quot;_blank\&quot;&gt;search&lt;/a&gt; query e.g. live eq true (optional)
     * @param  string|null $orderby Field to order results. Prefix with a - (dash) for descending e.g. -id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1VariantsSearchGet'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKM\Model\TempestResponseListProductVariant|\EKM\Model\TempestResponseListProductVariant
     */
    public function apiV1VariantsSearchGet($page = 1, $limit = 10, $query = null, $orderby = null, string $contentType = self::contentTypes['apiV1VariantsSearchGet'][0])
    {
        list($response) = $this->apiV1VariantsSearchGetWithHttpInfo($page, $limit, $query, $orderby, $contentType);
        return $response;
    }

    /**
     * Operation apiV1VariantsSearchGetWithHttpInfo
     *
     * Searches variants based on search criteria
     *
     * @param  int|null $page Page number to display (optional, default to 1)
     * @param  int|null $limit Items per page (maximum 20) (optional, default to 10)
     * @param  string|null $query A &lt;a href&#x3D;\&quot;#tag/OData\&quot; target&#x3D;\&quot;_blank\&quot;&gt;search&lt;/a&gt; query e.g. live eq true (optional)
     * @param  string|null $orderby Field to order results. Prefix with a - (dash) for descending e.g. -id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1VariantsSearchGet'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKM\Model\TempestResponseListProductVariant|\EKM\Model\TempestResponseListProductVariant, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1VariantsSearchGetWithHttpInfo($page = 1, $limit = 10, $query = null, $orderby = null, string $contentType = self::contentTypes['apiV1VariantsSearchGet'][0])
    {
        $request = $this->apiV1VariantsSearchGetRequest($page, $limit, $query, $orderby, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseListProductVariant',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseListProductVariant',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKM\Model\TempestResponseListProductVariant',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseListProductVariant',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseListProductVariant',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1VariantsSearchGetAsync
     *
     * Searches variants based on search criteria
     *
     * @param  int|null $page Page number to display (optional, default to 1)
     * @param  int|null $limit Items per page (maximum 20) (optional, default to 10)
     * @param  string|null $query A &lt;a href&#x3D;\&quot;#tag/OData\&quot; target&#x3D;\&quot;_blank\&quot;&gt;search&lt;/a&gt; query e.g. live eq true (optional)
     * @param  string|null $orderby Field to order results. Prefix with a - (dash) for descending e.g. -id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1VariantsSearchGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1VariantsSearchGetAsync($page = 1, $limit = 10, $query = null, $orderby = null, string $contentType = self::contentTypes['apiV1VariantsSearchGet'][0])
    {
        return $this->apiV1VariantsSearchGetAsyncWithHttpInfo($page, $limit, $query, $orderby, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1VariantsSearchGetAsyncWithHttpInfo
     *
     * Searches variants based on search criteria
     *
     * @param  int|null $page Page number to display (optional, default to 1)
     * @param  int|null $limit Items per page (maximum 20) (optional, default to 10)
     * @param  string|null $query A &lt;a href&#x3D;\&quot;#tag/OData\&quot; target&#x3D;\&quot;_blank\&quot;&gt;search&lt;/a&gt; query e.g. live eq true (optional)
     * @param  string|null $orderby Field to order results. Prefix with a - (dash) for descending e.g. -id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1VariantsSearchGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1VariantsSearchGetAsyncWithHttpInfo($page = 1, $limit = 10, $query = null, $orderby = null, string $contentType = self::contentTypes['apiV1VariantsSearchGet'][0])
    {
        $returnType = '\EKM\Model\TempestResponseListProductVariant';
        $request = $this->apiV1VariantsSearchGetRequest($page, $limit, $query, $orderby, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1VariantsSearchGet'
     *
     * @param  int|null $page Page number to display (optional, default to 1)
     * @param  int|null $limit Items per page (maximum 20) (optional, default to 10)
     * @param  string|null $query A &lt;a href&#x3D;\&quot;#tag/OData\&quot; target&#x3D;\&quot;_blank\&quot;&gt;search&lt;/a&gt; query e.g. live eq true (optional)
     * @param  string|null $orderby Field to order results. Prefix with a - (dash) for descending e.g. -id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1VariantsSearchGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1VariantsSearchGetRequest($page = 1, $limit = 10, $query = null, $orderby = null, string $contentType = self::contentTypes['apiV1VariantsSearchGet'][0])
    {






        $resourcePath = '/api/v1/variants/search';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $query,
            'query', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $orderby,
            'orderby', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
