<?php
/**
 * ProductVariantStockApi
 * PHP version 8.1
 *
 * @category Class
 * @package  EKM
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * EKM Partner API
 *
 * Our new API allows partners to build significantly better integrations with the EKM platform.    To try out the below endpoints, or for full up to date representations of the request / response models, please see the [swagger page](https://api.ekm.net/swagger/index.html). (We display examples here, but the swagger page is guaranteed to show the complete model.)    To keep up to date with the latest updates, please see our [RSS feed](https://partners.ekm.net/ChangeLog/Feed) or the [partner dashboard](https://partners.ekm.net/).
 *
 * The version of the OpenAPI document: v1
 * Contact: api-support@ekm.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace EKM\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use EKM\ApiException;
use EKM\Configuration;
use EKM\FormDataProcessor;
use EKM\HeaderSelector;
use EKM\ObjectSerializer;

/**
 * ProductVariantStockApi Class Doc Comment
 *
 * @category Class
 * @package  EKM
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ProductVariantStockApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'apiV1ProductsByIdVariantsByVariantIdStockGet' => [
            'application/json',
        ],
        'apiV1ProductsByIdVariantsByVariantIdStockPut' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation apiV1ProductsByIdVariantsByVariantIdStockGet
     *
     * Get a product variant stock
     *
     * @param  int $id The product ID (required)
     * @param  int $variantId The varaint ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdVariantsByVariantIdStockGet'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKM\Model\TempestResponseProductVariantStock|\EKM\Model\TempestResponseTempestValidationError
     */
    public function apiV1ProductsByIdVariantsByVariantIdStockGet($id, $variantId, string $contentType = self::contentTypes['apiV1ProductsByIdVariantsByVariantIdStockGet'][0])
    {
        list($response) = $this->apiV1ProductsByIdVariantsByVariantIdStockGetWithHttpInfo($id, $variantId, $contentType);
        return $response;
    }

    /**
     * Operation apiV1ProductsByIdVariantsByVariantIdStockGetWithHttpInfo
     *
     * Get a product variant stock
     *
     * @param  int $id The product ID (required)
     * @param  int $variantId The varaint ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdVariantsByVariantIdStockGet'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKM\Model\TempestResponseProductVariantStock|\EKM\Model\TempestResponseTempestValidationError, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1ProductsByIdVariantsByVariantIdStockGetWithHttpInfo($id, $variantId, string $contentType = self::contentTypes['apiV1ProductsByIdVariantsByVariantIdStockGet'][0])
    {
        $request = $this->apiV1ProductsByIdVariantsByVariantIdStockGetRequest($id, $variantId, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseProductVariantStock',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKM\Model\TempestResponseProductVariantStock',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseProductVariantStock',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1ProductsByIdVariantsByVariantIdStockGetAsync
     *
     * Get a product variant stock
     *
     * @param  int $id The product ID (required)
     * @param  int $variantId The varaint ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdVariantsByVariantIdStockGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ProductsByIdVariantsByVariantIdStockGetAsync($id, $variantId, string $contentType = self::contentTypes['apiV1ProductsByIdVariantsByVariantIdStockGet'][0])
    {
        return $this->apiV1ProductsByIdVariantsByVariantIdStockGetAsyncWithHttpInfo($id, $variantId, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1ProductsByIdVariantsByVariantIdStockGetAsyncWithHttpInfo
     *
     * Get a product variant stock
     *
     * @param  int $id The product ID (required)
     * @param  int $variantId The varaint ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdVariantsByVariantIdStockGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ProductsByIdVariantsByVariantIdStockGetAsyncWithHttpInfo($id, $variantId, string $contentType = self::contentTypes['apiV1ProductsByIdVariantsByVariantIdStockGet'][0])
    {
        $returnType = '\EKM\Model\TempestResponseProductVariantStock';
        $request = $this->apiV1ProductsByIdVariantsByVariantIdStockGetRequest($id, $variantId, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1ProductsByIdVariantsByVariantIdStockGet'
     *
     * @param  int $id The product ID (required)
     * @param  int $variantId The varaint ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdVariantsByVariantIdStockGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1ProductsByIdVariantsByVariantIdStockGetRequest($id, $variantId, string $contentType = self::contentTypes['apiV1ProductsByIdVariantsByVariantIdStockGet'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling apiV1ProductsByIdVariantsByVariantIdStockGet'
            );
        }

        // verify the required parameter 'variantId' is set
        if ($variantId === null || (is_array($variantId) && count($variantId) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $variantId when calling apiV1ProductsByIdVariantsByVariantIdStockGet'
            );
        }


        $resourcePath = '/api/v1/products/{id}/variants/{variantId}/stock';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }
        // path params
        if ($variantId !== null) {
            $resourcePath = str_replace(
                '{' . 'variantId' . '}',
                ObjectSerializer::toPathValue($variantId),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1ProductsByIdVariantsByVariantIdStockPut
     *
     * Update a product variant stock
     *
     * @param  int $id The product ID (required)
     * @param  int $variantId The varaint ID (required)
     * @param  \EKM\Model\ProductVariantStock|null $model model (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdVariantsByVariantIdStockPut'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKM\Model\TempestResponseProductVariantStock|\EKM\Model\TempestResponseProductVariantStock|\EKM\Model\TempestResponseTempestValidationError
     */
    public function apiV1ProductsByIdVariantsByVariantIdStockPut($id, $variantId, $model = null, string $contentType = self::contentTypes['apiV1ProductsByIdVariantsByVariantIdStockPut'][0])
    {
        list($response) = $this->apiV1ProductsByIdVariantsByVariantIdStockPutWithHttpInfo($id, $variantId, $model, $contentType);
        return $response;
    }

    /**
     * Operation apiV1ProductsByIdVariantsByVariantIdStockPutWithHttpInfo
     *
     * Update a product variant stock
     *
     * @param  int $id The product ID (required)
     * @param  int $variantId The varaint ID (required)
     * @param  \EKM\Model\ProductVariantStock|null $model (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdVariantsByVariantIdStockPut'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKM\Model\TempestResponseProductVariantStock|\EKM\Model\TempestResponseProductVariantStock|\EKM\Model\TempestResponseTempestValidationError, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1ProductsByIdVariantsByVariantIdStockPutWithHttpInfo($id, $variantId, $model = null, string $contentType = self::contentTypes['apiV1ProductsByIdVariantsByVariantIdStockPut'][0])
    {
        $request = $this->apiV1ProductsByIdVariantsByVariantIdStockPutRequest($id, $variantId, $model, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseProductVariantStock',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseProductVariantStock',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKM\Model\TempestResponseProductVariantStock',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseProductVariantStock',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseProductVariantStock',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1ProductsByIdVariantsByVariantIdStockPutAsync
     *
     * Update a product variant stock
     *
     * @param  int $id The product ID (required)
     * @param  int $variantId The varaint ID (required)
     * @param  \EKM\Model\ProductVariantStock|null $model (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdVariantsByVariantIdStockPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ProductsByIdVariantsByVariantIdStockPutAsync($id, $variantId, $model = null, string $contentType = self::contentTypes['apiV1ProductsByIdVariantsByVariantIdStockPut'][0])
    {
        return $this->apiV1ProductsByIdVariantsByVariantIdStockPutAsyncWithHttpInfo($id, $variantId, $model, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1ProductsByIdVariantsByVariantIdStockPutAsyncWithHttpInfo
     *
     * Update a product variant stock
     *
     * @param  int $id The product ID (required)
     * @param  int $variantId The varaint ID (required)
     * @param  \EKM\Model\ProductVariantStock|null $model (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdVariantsByVariantIdStockPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ProductsByIdVariantsByVariantIdStockPutAsyncWithHttpInfo($id, $variantId, $model = null, string $contentType = self::contentTypes['apiV1ProductsByIdVariantsByVariantIdStockPut'][0])
    {
        $returnType = '\EKM\Model\TempestResponseProductVariantStock';
        $request = $this->apiV1ProductsByIdVariantsByVariantIdStockPutRequest($id, $variantId, $model, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1ProductsByIdVariantsByVariantIdStockPut'
     *
     * @param  int $id The product ID (required)
     * @param  int $variantId The varaint ID (required)
     * @param  \EKM\Model\ProductVariantStock|null $model (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdVariantsByVariantIdStockPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1ProductsByIdVariantsByVariantIdStockPutRequest($id, $variantId, $model = null, string $contentType = self::contentTypes['apiV1ProductsByIdVariantsByVariantIdStockPut'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling apiV1ProductsByIdVariantsByVariantIdStockPut'
            );
        }

        // verify the required parameter 'variantId' is set
        if ($variantId === null || (is_array($variantId) && count($variantId) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $variantId when calling apiV1ProductsByIdVariantsByVariantIdStockPut'
            );
        }



        $resourcePath = '/api/v1/products/{id}/variants/{variantId}/stock';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }
        // path params
        if ($variantId !== null) {
            $resourcePath = str_replace(
                '{' . 'variantId' . '}',
                ObjectSerializer::toPathValue($variantId),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($model)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($model));
            } else {
                $httpBody = $model;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
