<?php
/**
 * ProductOptionsApi
 * PHP version 8.1
 *
 * @category Class
 * @package  EKM
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * EKM Partner API
 *
 * Our new API allows partners to build significantly better integrations with the EKM platform.    To try out the below endpoints, or for full up to date representations of the request / response models, please see the [swagger page](https://api.ekm.net/swagger/index.html). (We display examples here, but the swagger page is guaranteed to show the complete model.)    To keep up to date with the latest updates, please see our [RSS feed](https://partners.ekm.net/ChangeLog/Feed) or the [partner dashboard](https://partners.ekm.net/).
 *
 * The version of the OpenAPI document: v1
 * Contact: api-support@ekm.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace EKM\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use EKM\ApiException;
use EKM\Configuration;
use EKM\FormDataProcessor;
use EKM\HeaderSelector;
use EKM\ObjectSerializer;

/**
 * ProductOptionsApi Class Doc Comment
 *
 * @category Class
 * @package  EKM
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ProductOptionsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'apiV1ProductsByIdOptionsByOptionIdDelete' => [
            'application/json',
        ],
        'apiV1ProductsByIdOptionsByOptionIdGet' => [
            'application/json',
        ],
        'apiV1ProductsByIdOptionsByOptionIdPut' => [
            'application/json',
        ],
        'apiV1ProductsByIdOptionsGet' => [
            'application/json',
        ],
        'apiV1ProductsByIdOptionsPost' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation apiV1ProductsByIdOptionsByOptionIdDelete
     *
     * Delete an option
     *
     * @param  int $id The product ID (required)
     * @param  int $optionId The option ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdOptionsByOptionIdDelete'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKM\Model\TempestResponseProductOption|\EKM\Model\TempestResponseTempestValidationError
     */
    public function apiV1ProductsByIdOptionsByOptionIdDelete($id, $optionId, string $contentType = self::contentTypes['apiV1ProductsByIdOptionsByOptionIdDelete'][0])
    {
        list($response) = $this->apiV1ProductsByIdOptionsByOptionIdDeleteWithHttpInfo($id, $optionId, $contentType);
        return $response;
    }

    /**
     * Operation apiV1ProductsByIdOptionsByOptionIdDeleteWithHttpInfo
     *
     * Delete an option
     *
     * @param  int $id The product ID (required)
     * @param  int $optionId The option ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdOptionsByOptionIdDelete'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKM\Model\TempestResponseProductOption|\EKM\Model\TempestResponseTempestValidationError, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1ProductsByIdOptionsByOptionIdDeleteWithHttpInfo($id, $optionId, string $contentType = self::contentTypes['apiV1ProductsByIdOptionsByOptionIdDelete'][0])
    {
        $request = $this->apiV1ProductsByIdOptionsByOptionIdDeleteRequest($id, $optionId, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseProductOption',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKM\Model\TempestResponseProductOption',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseProductOption',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1ProductsByIdOptionsByOptionIdDeleteAsync
     *
     * Delete an option
     *
     * @param  int $id The product ID (required)
     * @param  int $optionId The option ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdOptionsByOptionIdDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ProductsByIdOptionsByOptionIdDeleteAsync($id, $optionId, string $contentType = self::contentTypes['apiV1ProductsByIdOptionsByOptionIdDelete'][0])
    {
        return $this->apiV1ProductsByIdOptionsByOptionIdDeleteAsyncWithHttpInfo($id, $optionId, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1ProductsByIdOptionsByOptionIdDeleteAsyncWithHttpInfo
     *
     * Delete an option
     *
     * @param  int $id The product ID (required)
     * @param  int $optionId The option ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdOptionsByOptionIdDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ProductsByIdOptionsByOptionIdDeleteAsyncWithHttpInfo($id, $optionId, string $contentType = self::contentTypes['apiV1ProductsByIdOptionsByOptionIdDelete'][0])
    {
        $returnType = '\EKM\Model\TempestResponseProductOption';
        $request = $this->apiV1ProductsByIdOptionsByOptionIdDeleteRequest($id, $optionId, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1ProductsByIdOptionsByOptionIdDelete'
     *
     * @param  int $id The product ID (required)
     * @param  int $optionId The option ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdOptionsByOptionIdDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1ProductsByIdOptionsByOptionIdDeleteRequest($id, $optionId, string $contentType = self::contentTypes['apiV1ProductsByIdOptionsByOptionIdDelete'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling apiV1ProductsByIdOptionsByOptionIdDelete'
            );
        }

        // verify the required parameter 'optionId' is set
        if ($optionId === null || (is_array($optionId) && count($optionId) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $optionId when calling apiV1ProductsByIdOptionsByOptionIdDelete'
            );
        }


        $resourcePath = '/api/v1/products/{id}/options/{optionId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }
        // path params
        if ($optionId !== null) {
            $resourcePath = str_replace(
                '{' . 'optionId' . '}',
                ObjectSerializer::toPathValue($optionId),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1ProductsByIdOptionsByOptionIdGet
     *
     * Get a product option
     *
     * @param  int $id The product ID (required)
     * @param  int $optionId The option ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdOptionsByOptionIdGet'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKM\Model\TempestResponseProductOption|\EKM\Model\TempestResponseTempestValidationError
     */
    public function apiV1ProductsByIdOptionsByOptionIdGet($id, $optionId, string $contentType = self::contentTypes['apiV1ProductsByIdOptionsByOptionIdGet'][0])
    {
        list($response) = $this->apiV1ProductsByIdOptionsByOptionIdGetWithHttpInfo($id, $optionId, $contentType);
        return $response;
    }

    /**
     * Operation apiV1ProductsByIdOptionsByOptionIdGetWithHttpInfo
     *
     * Get a product option
     *
     * @param  int $id The product ID (required)
     * @param  int $optionId The option ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdOptionsByOptionIdGet'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKM\Model\TempestResponseProductOption|\EKM\Model\TempestResponseTempestValidationError, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1ProductsByIdOptionsByOptionIdGetWithHttpInfo($id, $optionId, string $contentType = self::contentTypes['apiV1ProductsByIdOptionsByOptionIdGet'][0])
    {
        $request = $this->apiV1ProductsByIdOptionsByOptionIdGetRequest($id, $optionId, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseProductOption',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKM\Model\TempestResponseProductOption',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseProductOption',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1ProductsByIdOptionsByOptionIdGetAsync
     *
     * Get a product option
     *
     * @param  int $id The product ID (required)
     * @param  int $optionId The option ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdOptionsByOptionIdGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ProductsByIdOptionsByOptionIdGetAsync($id, $optionId, string $contentType = self::contentTypes['apiV1ProductsByIdOptionsByOptionIdGet'][0])
    {
        return $this->apiV1ProductsByIdOptionsByOptionIdGetAsyncWithHttpInfo($id, $optionId, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1ProductsByIdOptionsByOptionIdGetAsyncWithHttpInfo
     *
     * Get a product option
     *
     * @param  int $id The product ID (required)
     * @param  int $optionId The option ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdOptionsByOptionIdGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ProductsByIdOptionsByOptionIdGetAsyncWithHttpInfo($id, $optionId, string $contentType = self::contentTypes['apiV1ProductsByIdOptionsByOptionIdGet'][0])
    {
        $returnType = '\EKM\Model\TempestResponseProductOption';
        $request = $this->apiV1ProductsByIdOptionsByOptionIdGetRequest($id, $optionId, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1ProductsByIdOptionsByOptionIdGet'
     *
     * @param  int $id The product ID (required)
     * @param  int $optionId The option ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdOptionsByOptionIdGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1ProductsByIdOptionsByOptionIdGetRequest($id, $optionId, string $contentType = self::contentTypes['apiV1ProductsByIdOptionsByOptionIdGet'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling apiV1ProductsByIdOptionsByOptionIdGet'
            );
        }

        // verify the required parameter 'optionId' is set
        if ($optionId === null || (is_array($optionId) && count($optionId) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $optionId when calling apiV1ProductsByIdOptionsByOptionIdGet'
            );
        }


        $resourcePath = '/api/v1/products/{id}/options/{optionId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }
        // path params
        if ($optionId !== null) {
            $resourcePath = str_replace(
                '{' . 'optionId' . '}',
                ObjectSerializer::toPathValue($optionId),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1ProductsByIdOptionsByOptionIdPut
     *
     * Update a product option
     *
     * @param  int $id The product ID (required)
     * @param  int $optionId The option ID (required)
     * @param  \EKM\Model\UpdateProductOption|null $model model (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdOptionsByOptionIdPut'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKM\Model\TempestResponseProductOption|\EKM\Model\TempestResponseProductOption|\EKM\Model\TempestResponseTempestValidationError
     */
    public function apiV1ProductsByIdOptionsByOptionIdPut($id, $optionId, $model = null, string $contentType = self::contentTypes['apiV1ProductsByIdOptionsByOptionIdPut'][0])
    {
        list($response) = $this->apiV1ProductsByIdOptionsByOptionIdPutWithHttpInfo($id, $optionId, $model, $contentType);
        return $response;
    }

    /**
     * Operation apiV1ProductsByIdOptionsByOptionIdPutWithHttpInfo
     *
     * Update a product option
     *
     * @param  int $id The product ID (required)
     * @param  int $optionId The option ID (required)
     * @param  \EKM\Model\UpdateProductOption|null $model (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdOptionsByOptionIdPut'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKM\Model\TempestResponseProductOption|\EKM\Model\TempestResponseProductOption|\EKM\Model\TempestResponseTempestValidationError, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1ProductsByIdOptionsByOptionIdPutWithHttpInfo($id, $optionId, $model = null, string $contentType = self::contentTypes['apiV1ProductsByIdOptionsByOptionIdPut'][0])
    {
        $request = $this->apiV1ProductsByIdOptionsByOptionIdPutRequest($id, $optionId, $model, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseProductOption',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseProductOption',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKM\Model\TempestResponseProductOption',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseProductOption',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseProductOption',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1ProductsByIdOptionsByOptionIdPutAsync
     *
     * Update a product option
     *
     * @param  int $id The product ID (required)
     * @param  int $optionId The option ID (required)
     * @param  \EKM\Model\UpdateProductOption|null $model (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdOptionsByOptionIdPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ProductsByIdOptionsByOptionIdPutAsync($id, $optionId, $model = null, string $contentType = self::contentTypes['apiV1ProductsByIdOptionsByOptionIdPut'][0])
    {
        return $this->apiV1ProductsByIdOptionsByOptionIdPutAsyncWithHttpInfo($id, $optionId, $model, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1ProductsByIdOptionsByOptionIdPutAsyncWithHttpInfo
     *
     * Update a product option
     *
     * @param  int $id The product ID (required)
     * @param  int $optionId The option ID (required)
     * @param  \EKM\Model\UpdateProductOption|null $model (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdOptionsByOptionIdPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ProductsByIdOptionsByOptionIdPutAsyncWithHttpInfo($id, $optionId, $model = null, string $contentType = self::contentTypes['apiV1ProductsByIdOptionsByOptionIdPut'][0])
    {
        $returnType = '\EKM\Model\TempestResponseProductOption';
        $request = $this->apiV1ProductsByIdOptionsByOptionIdPutRequest($id, $optionId, $model, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1ProductsByIdOptionsByOptionIdPut'
     *
     * @param  int $id The product ID (required)
     * @param  int $optionId The option ID (required)
     * @param  \EKM\Model\UpdateProductOption|null $model (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdOptionsByOptionIdPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1ProductsByIdOptionsByOptionIdPutRequest($id, $optionId, $model = null, string $contentType = self::contentTypes['apiV1ProductsByIdOptionsByOptionIdPut'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling apiV1ProductsByIdOptionsByOptionIdPut'
            );
        }

        // verify the required parameter 'optionId' is set
        if ($optionId === null || (is_array($optionId) && count($optionId) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $optionId when calling apiV1ProductsByIdOptionsByOptionIdPut'
            );
        }



        $resourcePath = '/api/v1/products/{id}/options/{optionId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }
        // path params
        if ($optionId !== null) {
            $resourcePath = str_replace(
                '{' . 'optionId' . '}',
                ObjectSerializer::toPathValue($optionId),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($model)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($model));
            } else {
                $httpBody = $model;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1ProductsByIdOptionsGet
     *
     * Get a products options
     *
     * @param  int $id The product ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdOptionsGet'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKM\Model\TempestResponseListProductOption|\EKM\Model\TempestResponseTempestValidationError|\EKM\Model\TempestResponseTempestValidationError
     */
    public function apiV1ProductsByIdOptionsGet($id, string $contentType = self::contentTypes['apiV1ProductsByIdOptionsGet'][0])
    {
        list($response) = $this->apiV1ProductsByIdOptionsGetWithHttpInfo($id, $contentType);
        return $response;
    }

    /**
     * Operation apiV1ProductsByIdOptionsGetWithHttpInfo
     *
     * Get a products options
     *
     * @param  int $id The product ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdOptionsGet'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKM\Model\TempestResponseListProductOption|\EKM\Model\TempestResponseTempestValidationError|\EKM\Model\TempestResponseTempestValidationError, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1ProductsByIdOptionsGetWithHttpInfo($id, string $contentType = self::contentTypes['apiV1ProductsByIdOptionsGet'][0])
    {
        $request = $this->apiV1ProductsByIdOptionsGetRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseListProductOption',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $request,
                        $response,
                    );
                case 422:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKM\Model\TempestResponseListProductOption',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseListProductOption',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1ProductsByIdOptionsGetAsync
     *
     * Get a products options
     *
     * @param  int $id The product ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdOptionsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ProductsByIdOptionsGetAsync($id, string $contentType = self::contentTypes['apiV1ProductsByIdOptionsGet'][0])
    {
        return $this->apiV1ProductsByIdOptionsGetAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1ProductsByIdOptionsGetAsyncWithHttpInfo
     *
     * Get a products options
     *
     * @param  int $id The product ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdOptionsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ProductsByIdOptionsGetAsyncWithHttpInfo($id, string $contentType = self::contentTypes['apiV1ProductsByIdOptionsGet'][0])
    {
        $returnType = '\EKM\Model\TempestResponseListProductOption';
        $request = $this->apiV1ProductsByIdOptionsGetRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1ProductsByIdOptionsGet'
     *
     * @param  int $id The product ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdOptionsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1ProductsByIdOptionsGetRequest($id, string $contentType = self::contentTypes['apiV1ProductsByIdOptionsGet'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling apiV1ProductsByIdOptionsGet'
            );
        }


        $resourcePath = '/api/v1/products/{id}/options';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1ProductsByIdOptionsPost
     *
     * Add an option to a product
     *
     * @param  int $id The product ID (required)
     * @param  \EKM\Model\AddProductOption|null $model model (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdOptionsPost'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKM\Model\TempestResponseProductOption|\EKM\Model\TempestResponseProductOption|\EKM\Model\TempestResponseTempestValidationError
     */
    public function apiV1ProductsByIdOptionsPost($id, $model = null, string $contentType = self::contentTypes['apiV1ProductsByIdOptionsPost'][0])
    {
        list($response) = $this->apiV1ProductsByIdOptionsPostWithHttpInfo($id, $model, $contentType);
        return $response;
    }

    /**
     * Operation apiV1ProductsByIdOptionsPostWithHttpInfo
     *
     * Add an option to a product
     *
     * @param  int $id The product ID (required)
     * @param  \EKM\Model\AddProductOption|null $model (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdOptionsPost'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKM\Model\TempestResponseProductOption|\EKM\Model\TempestResponseProductOption|\EKM\Model\TempestResponseTempestValidationError, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1ProductsByIdOptionsPostWithHttpInfo($id, $model = null, string $contentType = self::contentTypes['apiV1ProductsByIdOptionsPost'][0])
    {
        $request = $this->apiV1ProductsByIdOptionsPostRequest($id, $model, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseProductOption',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseProductOption',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKM\Model\TempestResponseProductOption',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseProductOption',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseProductOption',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1ProductsByIdOptionsPostAsync
     *
     * Add an option to a product
     *
     * @param  int $id The product ID (required)
     * @param  \EKM\Model\AddProductOption|null $model (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdOptionsPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ProductsByIdOptionsPostAsync($id, $model = null, string $contentType = self::contentTypes['apiV1ProductsByIdOptionsPost'][0])
    {
        return $this->apiV1ProductsByIdOptionsPostAsyncWithHttpInfo($id, $model, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1ProductsByIdOptionsPostAsyncWithHttpInfo
     *
     * Add an option to a product
     *
     * @param  int $id The product ID (required)
     * @param  \EKM\Model\AddProductOption|null $model (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdOptionsPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ProductsByIdOptionsPostAsyncWithHttpInfo($id, $model = null, string $contentType = self::contentTypes['apiV1ProductsByIdOptionsPost'][0])
    {
        $returnType = '\EKM\Model\TempestResponseProductOption';
        $request = $this->apiV1ProductsByIdOptionsPostRequest($id, $model, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1ProductsByIdOptionsPost'
     *
     * @param  int $id The product ID (required)
     * @param  \EKM\Model\AddProductOption|null $model (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdOptionsPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1ProductsByIdOptionsPostRequest($id, $model = null, string $contentType = self::contentTypes['apiV1ProductsByIdOptionsPost'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling apiV1ProductsByIdOptionsPost'
            );
        }



        $resourcePath = '/api/v1/products/{id}/options';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($model)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($model));
            } else {
                $httpBody = $model;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
