<?php
/**
 * ProductOptionItemsApi
 * PHP version 8.1
 *
 * @category Class
 * @package  EKM
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * EKM Partner API
 *
 * Our new API allows partners to build significantly better integrations with the EKM platform.    To try out the below endpoints, or for full up to date representations of the request / response models, please see the [swagger page](https://api.ekm.net/swagger/index.html). (We display examples here, but the swagger page is guaranteed to show the complete model.)    To keep up to date with the latest updates, please see our [RSS feed](https://partners.ekm.net/ChangeLog/Feed) or the [partner dashboard](https://partners.ekm.net/).
 *
 * The version of the OpenAPI document: v1
 * Contact: api-support@ekm.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace EKM\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use EKM\ApiException;
use EKM\Configuration;
use EKM\FormDataProcessor;
use EKM\HeaderSelector;
use EKM\ObjectSerializer;

/**
 * ProductOptionItemsApi Class Doc Comment
 *
 * @category Class
 * @package  EKM
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ProductOptionItemsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdDelete' => [
            'application/json',
        ],
        'apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdPut' => [
            'application/json',
        ],
        'apiV1ProductsByIdOptionsByOptionIdItemsPost' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdDelete
     *
     * Delete an option item
     *
     * @param  int $id The product ID (required)
     * @param  int $optionId The option ID (required)
     * @param  int $optionItemId The option item ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdDelete'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKM\Model\TempestResponseProductOptionItem|\EKM\Model\TempestResponseTempestValidationError
     */
    public function apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdDelete($id, $optionId, $optionItemId, string $contentType = self::contentTypes['apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdDelete'][0])
    {
        list($response) = $this->apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdDeleteWithHttpInfo($id, $optionId, $optionItemId, $contentType);
        return $response;
    }

    /**
     * Operation apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdDeleteWithHttpInfo
     *
     * Delete an option item
     *
     * @param  int $id The product ID (required)
     * @param  int $optionId The option ID (required)
     * @param  int $optionItemId The option item ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdDelete'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKM\Model\TempestResponseProductOptionItem|\EKM\Model\TempestResponseTempestValidationError, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdDeleteWithHttpInfo($id, $optionId, $optionItemId, string $contentType = self::contentTypes['apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdDelete'][0])
    {
        $request = $this->apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdDeleteRequest($id, $optionId, $optionItemId, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseProductOptionItem',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKM\Model\TempestResponseProductOptionItem',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseProductOptionItem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdDeleteAsync
     *
     * Delete an option item
     *
     * @param  int $id The product ID (required)
     * @param  int $optionId The option ID (required)
     * @param  int $optionItemId The option item ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdDeleteAsync($id, $optionId, $optionItemId, string $contentType = self::contentTypes['apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdDelete'][0])
    {
        return $this->apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdDeleteAsyncWithHttpInfo($id, $optionId, $optionItemId, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdDeleteAsyncWithHttpInfo
     *
     * Delete an option item
     *
     * @param  int $id The product ID (required)
     * @param  int $optionId The option ID (required)
     * @param  int $optionItemId The option item ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdDeleteAsyncWithHttpInfo($id, $optionId, $optionItemId, string $contentType = self::contentTypes['apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdDelete'][0])
    {
        $returnType = '\EKM\Model\TempestResponseProductOptionItem';
        $request = $this->apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdDeleteRequest($id, $optionId, $optionItemId, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdDelete'
     *
     * @param  int $id The product ID (required)
     * @param  int $optionId The option ID (required)
     * @param  int $optionItemId The option item ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdDeleteRequest($id, $optionId, $optionItemId, string $contentType = self::contentTypes['apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdDelete'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdDelete'
            );
        }

        // verify the required parameter 'optionId' is set
        if ($optionId === null || (is_array($optionId) && count($optionId) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $optionId when calling apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdDelete'
            );
        }

        // verify the required parameter 'optionItemId' is set
        if ($optionItemId === null || (is_array($optionItemId) && count($optionItemId) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $optionItemId when calling apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdDelete'
            );
        }


        $resourcePath = '/api/v1/products/{id}/options/{optionId}/items/{optionItemId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }
        // path params
        if ($optionId !== null) {
            $resourcePath = str_replace(
                '{' . 'optionId' . '}',
                ObjectSerializer::toPathValue($optionId),
                $resourcePath
            );
        }
        // path params
        if ($optionItemId !== null) {
            $resourcePath = str_replace(
                '{' . 'optionItemId' . '}',
                ObjectSerializer::toPathValue($optionItemId),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdPut
     *
     * Update a product option item
     *
     * @param  int $id The product ID (required)
     * @param  int $optionId The option ID (required)
     * @param  int $optionItemId The option item ID (required)
     * @param  \EKM\Model\ProductOptionItem|null $model model (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdPut'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKM\Model\TempestResponseProductOptionItem|\EKM\Model\TempestResponseProductOptionItem|\EKM\Model\TempestResponseTempestValidationError
     */
    public function apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdPut($id, $optionId, $optionItemId, $model = null, string $contentType = self::contentTypes['apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdPut'][0])
    {
        list($response) = $this->apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdPutWithHttpInfo($id, $optionId, $optionItemId, $model, $contentType);
        return $response;
    }

    /**
     * Operation apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdPutWithHttpInfo
     *
     * Update a product option item
     *
     * @param  int $id The product ID (required)
     * @param  int $optionId The option ID (required)
     * @param  int $optionItemId The option item ID (required)
     * @param  \EKM\Model\ProductOptionItem|null $model (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdPut'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKM\Model\TempestResponseProductOptionItem|\EKM\Model\TempestResponseProductOptionItem|\EKM\Model\TempestResponseTempestValidationError, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdPutWithHttpInfo($id, $optionId, $optionItemId, $model = null, string $contentType = self::contentTypes['apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdPut'][0])
    {
        $request = $this->apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdPutRequest($id, $optionId, $optionItemId, $model, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseProductOptionItem',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseProductOptionItem',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKM\Model\TempestResponseProductOptionItem',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseProductOptionItem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseProductOptionItem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdPutAsync
     *
     * Update a product option item
     *
     * @param  int $id The product ID (required)
     * @param  int $optionId The option ID (required)
     * @param  int $optionItemId The option item ID (required)
     * @param  \EKM\Model\ProductOptionItem|null $model (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdPutAsync($id, $optionId, $optionItemId, $model = null, string $contentType = self::contentTypes['apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdPut'][0])
    {
        return $this->apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdPutAsyncWithHttpInfo($id, $optionId, $optionItemId, $model, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdPutAsyncWithHttpInfo
     *
     * Update a product option item
     *
     * @param  int $id The product ID (required)
     * @param  int $optionId The option ID (required)
     * @param  int $optionItemId The option item ID (required)
     * @param  \EKM\Model\ProductOptionItem|null $model (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdPutAsyncWithHttpInfo($id, $optionId, $optionItemId, $model = null, string $contentType = self::contentTypes['apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdPut'][0])
    {
        $returnType = '\EKM\Model\TempestResponseProductOptionItem';
        $request = $this->apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdPutRequest($id, $optionId, $optionItemId, $model, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdPut'
     *
     * @param  int $id The product ID (required)
     * @param  int $optionId The option ID (required)
     * @param  int $optionItemId The option item ID (required)
     * @param  \EKM\Model\ProductOptionItem|null $model (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdPutRequest($id, $optionId, $optionItemId, $model = null, string $contentType = self::contentTypes['apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdPut'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdPut'
            );
        }

        // verify the required parameter 'optionId' is set
        if ($optionId === null || (is_array($optionId) && count($optionId) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $optionId when calling apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdPut'
            );
        }

        // verify the required parameter 'optionItemId' is set
        if ($optionItemId === null || (is_array($optionItemId) && count($optionItemId) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $optionItemId when calling apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdPut'
            );
        }



        $resourcePath = '/api/v1/products/{id}/options/{optionId}/items/{optionItemId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }
        // path params
        if ($optionId !== null) {
            $resourcePath = str_replace(
                '{' . 'optionId' . '}',
                ObjectSerializer::toPathValue($optionId),
                $resourcePath
            );
        }
        // path params
        if ($optionItemId !== null) {
            $resourcePath = str_replace(
                '{' . 'optionItemId' . '}',
                ObjectSerializer::toPathValue($optionItemId),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($model)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($model));
            } else {
                $httpBody = $model;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1ProductsByIdOptionsByOptionIdItemsPost
     *
     * Add an item to a product option
     *
     * @param  int $id The product ID (required)
     * @param  int $optionId The option ID (required)
     * @param  \EKM\Model\ProductOptionItem|null $model model (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdOptionsByOptionIdItemsPost'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKM\Model\TempestResponseProductOptionItem|\EKM\Model\TempestResponseProductOptionItem|\EKM\Model\TempestResponseTempestValidationError
     */
    public function apiV1ProductsByIdOptionsByOptionIdItemsPost($id, $optionId, $model = null, string $contentType = self::contentTypes['apiV1ProductsByIdOptionsByOptionIdItemsPost'][0])
    {
        list($response) = $this->apiV1ProductsByIdOptionsByOptionIdItemsPostWithHttpInfo($id, $optionId, $model, $contentType);
        return $response;
    }

    /**
     * Operation apiV1ProductsByIdOptionsByOptionIdItemsPostWithHttpInfo
     *
     * Add an item to a product option
     *
     * @param  int $id The product ID (required)
     * @param  int $optionId The option ID (required)
     * @param  \EKM\Model\ProductOptionItem|null $model (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdOptionsByOptionIdItemsPost'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKM\Model\TempestResponseProductOptionItem|\EKM\Model\TempestResponseProductOptionItem|\EKM\Model\TempestResponseTempestValidationError, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1ProductsByIdOptionsByOptionIdItemsPostWithHttpInfo($id, $optionId, $model = null, string $contentType = self::contentTypes['apiV1ProductsByIdOptionsByOptionIdItemsPost'][0])
    {
        $request = $this->apiV1ProductsByIdOptionsByOptionIdItemsPostRequest($id, $optionId, $model, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseProductOptionItem',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseProductOptionItem',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKM\Model\TempestResponseProductOptionItem',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseProductOptionItem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseProductOptionItem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1ProductsByIdOptionsByOptionIdItemsPostAsync
     *
     * Add an item to a product option
     *
     * @param  int $id The product ID (required)
     * @param  int $optionId The option ID (required)
     * @param  \EKM\Model\ProductOptionItem|null $model (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdOptionsByOptionIdItemsPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ProductsByIdOptionsByOptionIdItemsPostAsync($id, $optionId, $model = null, string $contentType = self::contentTypes['apiV1ProductsByIdOptionsByOptionIdItemsPost'][0])
    {
        return $this->apiV1ProductsByIdOptionsByOptionIdItemsPostAsyncWithHttpInfo($id, $optionId, $model, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1ProductsByIdOptionsByOptionIdItemsPostAsyncWithHttpInfo
     *
     * Add an item to a product option
     *
     * @param  int $id The product ID (required)
     * @param  int $optionId The option ID (required)
     * @param  \EKM\Model\ProductOptionItem|null $model (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdOptionsByOptionIdItemsPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ProductsByIdOptionsByOptionIdItemsPostAsyncWithHttpInfo($id, $optionId, $model = null, string $contentType = self::contentTypes['apiV1ProductsByIdOptionsByOptionIdItemsPost'][0])
    {
        $returnType = '\EKM\Model\TempestResponseProductOptionItem';
        $request = $this->apiV1ProductsByIdOptionsByOptionIdItemsPostRequest($id, $optionId, $model, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1ProductsByIdOptionsByOptionIdItemsPost'
     *
     * @param  int $id The product ID (required)
     * @param  int $optionId The option ID (required)
     * @param  \EKM\Model\ProductOptionItem|null $model (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ProductsByIdOptionsByOptionIdItemsPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1ProductsByIdOptionsByOptionIdItemsPostRequest($id, $optionId, $model = null, string $contentType = self::contentTypes['apiV1ProductsByIdOptionsByOptionIdItemsPost'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling apiV1ProductsByIdOptionsByOptionIdItemsPost'
            );
        }

        // verify the required parameter 'optionId' is set
        if ($optionId === null || (is_array($optionId) && count($optionId) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $optionId when calling apiV1ProductsByIdOptionsByOptionIdItemsPost'
            );
        }



        $resourcePath = '/api/v1/products/{id}/options/{optionId}/items';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }
        // path params
        if ($optionId !== null) {
            $resourcePath = str_replace(
                '{' . 'optionId' . '}',
                ObjectSerializer::toPathValue($optionId),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($model)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($model));
            } else {
                $httpBody = $model;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
