<?php
/**
 * CustomerAddressesApi
 * PHP version 8.1
 *
 * @category Class
 * @package  EKM
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * EKM Partner API
 *
 * Our new API allows partners to build significantly better integrations with the EKM platform.    To try out the below endpoints, or for full up to date representations of the request / response models, please see the [swagger page](https://api.ekm.net/swagger/index.html). (We display examples here, but the swagger page is guaranteed to show the complete model.)    To keep up to date with the latest updates, please see our [RSS feed](https://partners.ekm.net/ChangeLog/Feed) or the [partner dashboard](https://partners.ekm.net/).
 *
 * The version of the OpenAPI document: v1
 * Contact: api-support@ekm.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace EKM\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use EKM\ApiException;
use EKM\Configuration;
use EKM\FormDataProcessor;
use EKM\HeaderSelector;
use EKM\ObjectSerializer;

/**
 * CustomerAddressesApi Class Doc Comment
 *
 * @category Class
 * @package  EKM
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class CustomerAddressesApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'apiV1CustomersByCustomerIdAddressesByAddressIdDelete' => [
            'application/json',
        ],
        'apiV1CustomersByCustomerIdAddressesByAddressIdGet' => [
            'application/json',
        ],
        'apiV1CustomersByCustomerIdAddressesByAddressIdPut' => [
            'application/json',
        ],
        'apiV1CustomersByCustomerIdAddressesGet' => [
            'application/json',
        ],
        'apiV1CustomersByCustomerIdAddressesPost' => [
            'application/json',
        ],
        'apiV1CustomersByCustomerIdAddressesSearchGet' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation apiV1CustomersByCustomerIdAddressesByAddressIdDelete
     *
     * Delete a Customer Address
     *
     * @param  int $customerId The Customer Id (required)
     * @param  int $addressId The Address Id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersByCustomerIdAddressesByAddressIdDelete'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKM\Model\TempestResponseCustomerAddress|\EKM\Model\TempestResponseTempestValidationError
     */
    public function apiV1CustomersByCustomerIdAddressesByAddressIdDelete($customerId, $addressId, string $contentType = self::contentTypes['apiV1CustomersByCustomerIdAddressesByAddressIdDelete'][0])
    {
        list($response) = $this->apiV1CustomersByCustomerIdAddressesByAddressIdDeleteWithHttpInfo($customerId, $addressId, $contentType);
        return $response;
    }

    /**
     * Operation apiV1CustomersByCustomerIdAddressesByAddressIdDeleteWithHttpInfo
     *
     * Delete a Customer Address
     *
     * @param  int $customerId The Customer Id (required)
     * @param  int $addressId The Address Id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersByCustomerIdAddressesByAddressIdDelete'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKM\Model\TempestResponseCustomerAddress|\EKM\Model\TempestResponseTempestValidationError, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1CustomersByCustomerIdAddressesByAddressIdDeleteWithHttpInfo($customerId, $addressId, string $contentType = self::contentTypes['apiV1CustomersByCustomerIdAddressesByAddressIdDelete'][0])
    {
        $request = $this->apiV1CustomersByCustomerIdAddressesByAddressIdDeleteRequest($customerId, $addressId, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseCustomerAddress',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKM\Model\TempestResponseCustomerAddress',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseCustomerAddress',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1CustomersByCustomerIdAddressesByAddressIdDeleteAsync
     *
     * Delete a Customer Address
     *
     * @param  int $customerId The Customer Id (required)
     * @param  int $addressId The Address Id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersByCustomerIdAddressesByAddressIdDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersByCustomerIdAddressesByAddressIdDeleteAsync($customerId, $addressId, string $contentType = self::contentTypes['apiV1CustomersByCustomerIdAddressesByAddressIdDelete'][0])
    {
        return $this->apiV1CustomersByCustomerIdAddressesByAddressIdDeleteAsyncWithHttpInfo($customerId, $addressId, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1CustomersByCustomerIdAddressesByAddressIdDeleteAsyncWithHttpInfo
     *
     * Delete a Customer Address
     *
     * @param  int $customerId The Customer Id (required)
     * @param  int $addressId The Address Id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersByCustomerIdAddressesByAddressIdDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersByCustomerIdAddressesByAddressIdDeleteAsyncWithHttpInfo($customerId, $addressId, string $contentType = self::contentTypes['apiV1CustomersByCustomerIdAddressesByAddressIdDelete'][0])
    {
        $returnType = '\EKM\Model\TempestResponseCustomerAddress';
        $request = $this->apiV1CustomersByCustomerIdAddressesByAddressIdDeleteRequest($customerId, $addressId, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1CustomersByCustomerIdAddressesByAddressIdDelete'
     *
     * @param  int $customerId The Customer Id (required)
     * @param  int $addressId The Address Id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersByCustomerIdAddressesByAddressIdDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1CustomersByCustomerIdAddressesByAddressIdDeleteRequest($customerId, $addressId, string $contentType = self::contentTypes['apiV1CustomersByCustomerIdAddressesByAddressIdDelete'][0])
    {

        // verify the required parameter 'customerId' is set
        if ($customerId === null || (is_array($customerId) && count($customerId) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $customerId when calling apiV1CustomersByCustomerIdAddressesByAddressIdDelete'
            );
        }

        // verify the required parameter 'addressId' is set
        if ($addressId === null || (is_array($addressId) && count($addressId) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $addressId when calling apiV1CustomersByCustomerIdAddressesByAddressIdDelete'
            );
        }


        $resourcePath = '/api/v1/customers/{customerId}/addresses/{addressId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($customerId !== null) {
            $resourcePath = str_replace(
                '{' . 'customerId' . '}',
                ObjectSerializer::toPathValue($customerId),
                $resourcePath
            );
        }
        // path params
        if ($addressId !== null) {
            $resourcePath = str_replace(
                '{' . 'addressId' . '}',
                ObjectSerializer::toPathValue($addressId),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1CustomersByCustomerIdAddressesByAddressIdGet
     *
     * Get a single Customer Address by Id
     *
     * @param  int $customerId The Customer Id (required)
     * @param  int $addressId The Address Id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersByCustomerIdAddressesByAddressIdGet'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKM\Model\TempestResponseCustomerAddress|\EKM\Model\TempestResponseTempestValidationError
     */
    public function apiV1CustomersByCustomerIdAddressesByAddressIdGet($customerId, $addressId, string $contentType = self::contentTypes['apiV1CustomersByCustomerIdAddressesByAddressIdGet'][0])
    {
        list($response) = $this->apiV1CustomersByCustomerIdAddressesByAddressIdGetWithHttpInfo($customerId, $addressId, $contentType);
        return $response;
    }

    /**
     * Operation apiV1CustomersByCustomerIdAddressesByAddressIdGetWithHttpInfo
     *
     * Get a single Customer Address by Id
     *
     * @param  int $customerId The Customer Id (required)
     * @param  int $addressId The Address Id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersByCustomerIdAddressesByAddressIdGet'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKM\Model\TempestResponseCustomerAddress|\EKM\Model\TempestResponseTempestValidationError, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1CustomersByCustomerIdAddressesByAddressIdGetWithHttpInfo($customerId, $addressId, string $contentType = self::contentTypes['apiV1CustomersByCustomerIdAddressesByAddressIdGet'][0])
    {
        $request = $this->apiV1CustomersByCustomerIdAddressesByAddressIdGetRequest($customerId, $addressId, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseCustomerAddress',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKM\Model\TempestResponseCustomerAddress',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseCustomerAddress',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1CustomersByCustomerIdAddressesByAddressIdGetAsync
     *
     * Get a single Customer Address by Id
     *
     * @param  int $customerId The Customer Id (required)
     * @param  int $addressId The Address Id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersByCustomerIdAddressesByAddressIdGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersByCustomerIdAddressesByAddressIdGetAsync($customerId, $addressId, string $contentType = self::contentTypes['apiV1CustomersByCustomerIdAddressesByAddressIdGet'][0])
    {
        return $this->apiV1CustomersByCustomerIdAddressesByAddressIdGetAsyncWithHttpInfo($customerId, $addressId, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1CustomersByCustomerIdAddressesByAddressIdGetAsyncWithHttpInfo
     *
     * Get a single Customer Address by Id
     *
     * @param  int $customerId The Customer Id (required)
     * @param  int $addressId The Address Id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersByCustomerIdAddressesByAddressIdGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersByCustomerIdAddressesByAddressIdGetAsyncWithHttpInfo($customerId, $addressId, string $contentType = self::contentTypes['apiV1CustomersByCustomerIdAddressesByAddressIdGet'][0])
    {
        $returnType = '\EKM\Model\TempestResponseCustomerAddress';
        $request = $this->apiV1CustomersByCustomerIdAddressesByAddressIdGetRequest($customerId, $addressId, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1CustomersByCustomerIdAddressesByAddressIdGet'
     *
     * @param  int $customerId The Customer Id (required)
     * @param  int $addressId The Address Id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersByCustomerIdAddressesByAddressIdGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1CustomersByCustomerIdAddressesByAddressIdGetRequest($customerId, $addressId, string $contentType = self::contentTypes['apiV1CustomersByCustomerIdAddressesByAddressIdGet'][0])
    {

        // verify the required parameter 'customerId' is set
        if ($customerId === null || (is_array($customerId) && count($customerId) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $customerId when calling apiV1CustomersByCustomerIdAddressesByAddressIdGet'
            );
        }

        // verify the required parameter 'addressId' is set
        if ($addressId === null || (is_array($addressId) && count($addressId) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $addressId when calling apiV1CustomersByCustomerIdAddressesByAddressIdGet'
            );
        }


        $resourcePath = '/api/v1/customers/{customerId}/addresses/{addressId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($customerId !== null) {
            $resourcePath = str_replace(
                '{' . 'customerId' . '}',
                ObjectSerializer::toPathValue($customerId),
                $resourcePath
            );
        }
        // path params
        if ($addressId !== null) {
            $resourcePath = str_replace(
                '{' . 'addressId' . '}',
                ObjectSerializer::toPathValue($addressId),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1CustomersByCustomerIdAddressesByAddressIdPut
     *
     * Update a Customer Address
     *
     * @param  int $customerId The Customer Id (required)
     * @param  int $addressId The Address Id (required)
     * @param  \EKM\Model\CustomerAddress|null $address address (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersByCustomerIdAddressesByAddressIdPut'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKM\Model\TempestResponseCustomer|\EKM\Model\TempestResponseTempestValidationError|\EKM\Model\TempestResponseTempestValidationError
     */
    public function apiV1CustomersByCustomerIdAddressesByAddressIdPut($customerId, $addressId, $address = null, string $contentType = self::contentTypes['apiV1CustomersByCustomerIdAddressesByAddressIdPut'][0])
    {
        list($response) = $this->apiV1CustomersByCustomerIdAddressesByAddressIdPutWithHttpInfo($customerId, $addressId, $address, $contentType);
        return $response;
    }

    /**
     * Operation apiV1CustomersByCustomerIdAddressesByAddressIdPutWithHttpInfo
     *
     * Update a Customer Address
     *
     * @param  int $customerId The Customer Id (required)
     * @param  int $addressId The Address Id (required)
     * @param  \EKM\Model\CustomerAddress|null $address (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersByCustomerIdAddressesByAddressIdPut'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKM\Model\TempestResponseCustomer|\EKM\Model\TempestResponseTempestValidationError|\EKM\Model\TempestResponseTempestValidationError, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1CustomersByCustomerIdAddressesByAddressIdPutWithHttpInfo($customerId, $addressId, $address = null, string $contentType = self::contentTypes['apiV1CustomersByCustomerIdAddressesByAddressIdPut'][0])
    {
        $request = $this->apiV1CustomersByCustomerIdAddressesByAddressIdPutRequest($customerId, $addressId, $address, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseCustomer',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKM\Model\TempestResponseCustomer',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseCustomer',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1CustomersByCustomerIdAddressesByAddressIdPutAsync
     *
     * Update a Customer Address
     *
     * @param  int $customerId The Customer Id (required)
     * @param  int $addressId The Address Id (required)
     * @param  \EKM\Model\CustomerAddress|null $address (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersByCustomerIdAddressesByAddressIdPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersByCustomerIdAddressesByAddressIdPutAsync($customerId, $addressId, $address = null, string $contentType = self::contentTypes['apiV1CustomersByCustomerIdAddressesByAddressIdPut'][0])
    {
        return $this->apiV1CustomersByCustomerIdAddressesByAddressIdPutAsyncWithHttpInfo($customerId, $addressId, $address, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1CustomersByCustomerIdAddressesByAddressIdPutAsyncWithHttpInfo
     *
     * Update a Customer Address
     *
     * @param  int $customerId The Customer Id (required)
     * @param  int $addressId The Address Id (required)
     * @param  \EKM\Model\CustomerAddress|null $address (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersByCustomerIdAddressesByAddressIdPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersByCustomerIdAddressesByAddressIdPutAsyncWithHttpInfo($customerId, $addressId, $address = null, string $contentType = self::contentTypes['apiV1CustomersByCustomerIdAddressesByAddressIdPut'][0])
    {
        $returnType = '\EKM\Model\TempestResponseCustomer';
        $request = $this->apiV1CustomersByCustomerIdAddressesByAddressIdPutRequest($customerId, $addressId, $address, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1CustomersByCustomerIdAddressesByAddressIdPut'
     *
     * @param  int $customerId The Customer Id (required)
     * @param  int $addressId The Address Id (required)
     * @param  \EKM\Model\CustomerAddress|null $address (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersByCustomerIdAddressesByAddressIdPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1CustomersByCustomerIdAddressesByAddressIdPutRequest($customerId, $addressId, $address = null, string $contentType = self::contentTypes['apiV1CustomersByCustomerIdAddressesByAddressIdPut'][0])
    {

        // verify the required parameter 'customerId' is set
        if ($customerId === null || (is_array($customerId) && count($customerId) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $customerId when calling apiV1CustomersByCustomerIdAddressesByAddressIdPut'
            );
        }

        // verify the required parameter 'addressId' is set
        if ($addressId === null || (is_array($addressId) && count($addressId) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $addressId when calling apiV1CustomersByCustomerIdAddressesByAddressIdPut'
            );
        }



        $resourcePath = '/api/v1/customers/{customerId}/addresses/{addressId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($customerId !== null) {
            $resourcePath = str_replace(
                '{' . 'customerId' . '}',
                ObjectSerializer::toPathValue($customerId),
                $resourcePath
            );
        }
        // path params
        if ($addressId !== null) {
            $resourcePath = str_replace(
                '{' . 'addressId' . '}',
                ObjectSerializer::toPathValue($addressId),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($address)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($address));
            } else {
                $httpBody = $address;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1CustomersByCustomerIdAddressesGet
     *
     * Get a paginated set of Customer Addresses
     *
     * @param  int $customerId The Customer Id (required)
     * @param  int|null $page Page number to display (optional, default to 1)
     * @param  int|null $limit Items per page (maximum 20) (optional, default to 10)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersByCustomerIdAddressesGet'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKM\Model\TempestResponseListCustomerAddress
     */
    public function apiV1CustomersByCustomerIdAddressesGet($customerId, $page = 1, $limit = 10, string $contentType = self::contentTypes['apiV1CustomersByCustomerIdAddressesGet'][0])
    {
        list($response) = $this->apiV1CustomersByCustomerIdAddressesGetWithHttpInfo($customerId, $page, $limit, $contentType);
        return $response;
    }

    /**
     * Operation apiV1CustomersByCustomerIdAddressesGetWithHttpInfo
     *
     * Get a paginated set of Customer Addresses
     *
     * @param  int $customerId The Customer Id (required)
     * @param  int|null $page Page number to display (optional, default to 1)
     * @param  int|null $limit Items per page (maximum 20) (optional, default to 10)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersByCustomerIdAddressesGet'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKM\Model\TempestResponseListCustomerAddress, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1CustomersByCustomerIdAddressesGetWithHttpInfo($customerId, $page = 1, $limit = 10, string $contentType = self::contentTypes['apiV1CustomersByCustomerIdAddressesGet'][0])
    {
        $request = $this->apiV1CustomersByCustomerIdAddressesGetRequest($customerId, $page, $limit, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseListCustomerAddress',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKM\Model\TempestResponseListCustomerAddress',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseListCustomerAddress',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1CustomersByCustomerIdAddressesGetAsync
     *
     * Get a paginated set of Customer Addresses
     *
     * @param  int $customerId The Customer Id (required)
     * @param  int|null $page Page number to display (optional, default to 1)
     * @param  int|null $limit Items per page (maximum 20) (optional, default to 10)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersByCustomerIdAddressesGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersByCustomerIdAddressesGetAsync($customerId, $page = 1, $limit = 10, string $contentType = self::contentTypes['apiV1CustomersByCustomerIdAddressesGet'][0])
    {
        return $this->apiV1CustomersByCustomerIdAddressesGetAsyncWithHttpInfo($customerId, $page, $limit, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1CustomersByCustomerIdAddressesGetAsyncWithHttpInfo
     *
     * Get a paginated set of Customer Addresses
     *
     * @param  int $customerId The Customer Id (required)
     * @param  int|null $page Page number to display (optional, default to 1)
     * @param  int|null $limit Items per page (maximum 20) (optional, default to 10)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersByCustomerIdAddressesGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersByCustomerIdAddressesGetAsyncWithHttpInfo($customerId, $page = 1, $limit = 10, string $contentType = self::contentTypes['apiV1CustomersByCustomerIdAddressesGet'][0])
    {
        $returnType = '\EKM\Model\TempestResponseListCustomerAddress';
        $request = $this->apiV1CustomersByCustomerIdAddressesGetRequest($customerId, $page, $limit, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1CustomersByCustomerIdAddressesGet'
     *
     * @param  int $customerId The Customer Id (required)
     * @param  int|null $page Page number to display (optional, default to 1)
     * @param  int|null $limit Items per page (maximum 20) (optional, default to 10)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersByCustomerIdAddressesGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1CustomersByCustomerIdAddressesGetRequest($customerId, $page = 1, $limit = 10, string $contentType = self::contentTypes['apiV1CustomersByCustomerIdAddressesGet'][0])
    {

        // verify the required parameter 'customerId' is set
        if ($customerId === null || (is_array($customerId) && count($customerId) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $customerId when calling apiV1CustomersByCustomerIdAddressesGet'
            );
        }




        $resourcePath = '/api/v1/customers/{customerId}/addresses';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);


        // path params
        if ($customerId !== null) {
            $resourcePath = str_replace(
                '{' . 'customerId' . '}',
                ObjectSerializer::toPathValue($customerId),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1CustomersByCustomerIdAddressesPost
     *
     * Add a Customer Address
     *
     * @param  int $customerId The Customer Id (required)
     * @param  \EKM\Model\CustomerAddress|null $address address (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersByCustomerIdAddressesPost'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKM\Model\TempestResponseCustomerAddress|\EKM\Model\TempestResponseTempestValidationError|\EKM\Model\TempestResponseTempestValidationError
     */
    public function apiV1CustomersByCustomerIdAddressesPost($customerId, $address = null, string $contentType = self::contentTypes['apiV1CustomersByCustomerIdAddressesPost'][0])
    {
        list($response) = $this->apiV1CustomersByCustomerIdAddressesPostWithHttpInfo($customerId, $address, $contentType);
        return $response;
    }

    /**
     * Operation apiV1CustomersByCustomerIdAddressesPostWithHttpInfo
     *
     * Add a Customer Address
     *
     * @param  int $customerId The Customer Id (required)
     * @param  \EKM\Model\CustomerAddress|null $address (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersByCustomerIdAddressesPost'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKM\Model\TempestResponseCustomerAddress|\EKM\Model\TempestResponseTempestValidationError|\EKM\Model\TempestResponseTempestValidationError, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1CustomersByCustomerIdAddressesPostWithHttpInfo($customerId, $address = null, string $contentType = self::contentTypes['apiV1CustomersByCustomerIdAddressesPost'][0])
    {
        $request = $this->apiV1CustomersByCustomerIdAddressesPostRequest($customerId, $address, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseCustomerAddress',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKM\Model\TempestResponseCustomerAddress',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseCustomerAddress',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1CustomersByCustomerIdAddressesPostAsync
     *
     * Add a Customer Address
     *
     * @param  int $customerId The Customer Id (required)
     * @param  \EKM\Model\CustomerAddress|null $address (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersByCustomerIdAddressesPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersByCustomerIdAddressesPostAsync($customerId, $address = null, string $contentType = self::contentTypes['apiV1CustomersByCustomerIdAddressesPost'][0])
    {
        return $this->apiV1CustomersByCustomerIdAddressesPostAsyncWithHttpInfo($customerId, $address, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1CustomersByCustomerIdAddressesPostAsyncWithHttpInfo
     *
     * Add a Customer Address
     *
     * @param  int $customerId The Customer Id (required)
     * @param  \EKM\Model\CustomerAddress|null $address (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersByCustomerIdAddressesPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersByCustomerIdAddressesPostAsyncWithHttpInfo($customerId, $address = null, string $contentType = self::contentTypes['apiV1CustomersByCustomerIdAddressesPost'][0])
    {
        $returnType = '\EKM\Model\TempestResponseCustomerAddress';
        $request = $this->apiV1CustomersByCustomerIdAddressesPostRequest($customerId, $address, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1CustomersByCustomerIdAddressesPost'
     *
     * @param  int $customerId The Customer Id (required)
     * @param  \EKM\Model\CustomerAddress|null $address (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersByCustomerIdAddressesPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1CustomersByCustomerIdAddressesPostRequest($customerId, $address = null, string $contentType = self::contentTypes['apiV1CustomersByCustomerIdAddressesPost'][0])
    {

        // verify the required parameter 'customerId' is set
        if ($customerId === null || (is_array($customerId) && count($customerId) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $customerId when calling apiV1CustomersByCustomerIdAddressesPost'
            );
        }



        $resourcePath = '/api/v1/customers/{customerId}/addresses';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($customerId !== null) {
            $resourcePath = str_replace(
                '{' . 'customerId' . '}',
                ObjectSerializer::toPathValue($customerId),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($address)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($address));
            } else {
                $httpBody = $address;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1CustomersByCustomerIdAddressesSearchGet
     *
     * Searches customer addresses based on search criteria
     *
     * @param  int $customerId The Customer Id (required)
     * @param  int|null $page Page number to display (optional, default to 1)
     * @param  int|null $limit Items per page (maximum 20) (optional, default to 10)
     * @param  string|null $query A &lt;a href&#x3D;\&quot;#tag/OData\&quot; target&#x3D;\&quot;_blank\&quot;&gt;search&lt;/a&gt; query e.g. email_address eq &#39;test@ekm.com&#39; (optional)
     * @param  string|null $orderby Field to order results. Prefix with a - (dash) for descending e.g. -id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersByCustomerIdAddressesSearchGet'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKM\Model\TempestResponseListCustomerAddress|\EKM\Model\TempestResponseTempestValidationError
     */
    public function apiV1CustomersByCustomerIdAddressesSearchGet($customerId, $page = 1, $limit = 10, $query = null, $orderby = null, string $contentType = self::contentTypes['apiV1CustomersByCustomerIdAddressesSearchGet'][0])
    {
        list($response) = $this->apiV1CustomersByCustomerIdAddressesSearchGetWithHttpInfo($customerId, $page, $limit, $query, $orderby, $contentType);
        return $response;
    }

    /**
     * Operation apiV1CustomersByCustomerIdAddressesSearchGetWithHttpInfo
     *
     * Searches customer addresses based on search criteria
     *
     * @param  int $customerId The Customer Id (required)
     * @param  int|null $page Page number to display (optional, default to 1)
     * @param  int|null $limit Items per page (maximum 20) (optional, default to 10)
     * @param  string|null $query A &lt;a href&#x3D;\&quot;#tag/OData\&quot; target&#x3D;\&quot;_blank\&quot;&gt;search&lt;/a&gt; query e.g. email_address eq &#39;test@ekm.com&#39; (optional)
     * @param  string|null $orderby Field to order results. Prefix with a - (dash) for descending e.g. -id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersByCustomerIdAddressesSearchGet'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKM\Model\TempestResponseListCustomerAddress|\EKM\Model\TempestResponseTempestValidationError, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1CustomersByCustomerIdAddressesSearchGetWithHttpInfo($customerId, $page = 1, $limit = 10, $query = null, $orderby = null, string $contentType = self::contentTypes['apiV1CustomersByCustomerIdAddressesSearchGet'][0])
    {
        $request = $this->apiV1CustomersByCustomerIdAddressesSearchGetRequest($customerId, $page, $limit, $query, $orderby, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseListCustomerAddress',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKM\Model\TempestResponseListCustomerAddress',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseListCustomerAddress',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1CustomersByCustomerIdAddressesSearchGetAsync
     *
     * Searches customer addresses based on search criteria
     *
     * @param  int $customerId The Customer Id (required)
     * @param  int|null $page Page number to display (optional, default to 1)
     * @param  int|null $limit Items per page (maximum 20) (optional, default to 10)
     * @param  string|null $query A &lt;a href&#x3D;\&quot;#tag/OData\&quot; target&#x3D;\&quot;_blank\&quot;&gt;search&lt;/a&gt; query e.g. email_address eq &#39;test@ekm.com&#39; (optional)
     * @param  string|null $orderby Field to order results. Prefix with a - (dash) for descending e.g. -id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersByCustomerIdAddressesSearchGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersByCustomerIdAddressesSearchGetAsync($customerId, $page = 1, $limit = 10, $query = null, $orderby = null, string $contentType = self::contentTypes['apiV1CustomersByCustomerIdAddressesSearchGet'][0])
    {
        return $this->apiV1CustomersByCustomerIdAddressesSearchGetAsyncWithHttpInfo($customerId, $page, $limit, $query, $orderby, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1CustomersByCustomerIdAddressesSearchGetAsyncWithHttpInfo
     *
     * Searches customer addresses based on search criteria
     *
     * @param  int $customerId The Customer Id (required)
     * @param  int|null $page Page number to display (optional, default to 1)
     * @param  int|null $limit Items per page (maximum 20) (optional, default to 10)
     * @param  string|null $query A &lt;a href&#x3D;\&quot;#tag/OData\&quot; target&#x3D;\&quot;_blank\&quot;&gt;search&lt;/a&gt; query e.g. email_address eq &#39;test@ekm.com&#39; (optional)
     * @param  string|null $orderby Field to order results. Prefix with a - (dash) for descending e.g. -id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersByCustomerIdAddressesSearchGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersByCustomerIdAddressesSearchGetAsyncWithHttpInfo($customerId, $page = 1, $limit = 10, $query = null, $orderby = null, string $contentType = self::contentTypes['apiV1CustomersByCustomerIdAddressesSearchGet'][0])
    {
        $returnType = '\EKM\Model\TempestResponseListCustomerAddress';
        $request = $this->apiV1CustomersByCustomerIdAddressesSearchGetRequest($customerId, $page, $limit, $query, $orderby, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1CustomersByCustomerIdAddressesSearchGet'
     *
     * @param  int $customerId The Customer Id (required)
     * @param  int|null $page Page number to display (optional, default to 1)
     * @param  int|null $limit Items per page (maximum 20) (optional, default to 10)
     * @param  string|null $query A &lt;a href&#x3D;\&quot;#tag/OData\&quot; target&#x3D;\&quot;_blank\&quot;&gt;search&lt;/a&gt; query e.g. email_address eq &#39;test@ekm.com&#39; (optional)
     * @param  string|null $orderby Field to order results. Prefix with a - (dash) for descending e.g. -id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersByCustomerIdAddressesSearchGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1CustomersByCustomerIdAddressesSearchGetRequest($customerId, $page = 1, $limit = 10, $query = null, $orderby = null, string $contentType = self::contentTypes['apiV1CustomersByCustomerIdAddressesSearchGet'][0])
    {

        // verify the required parameter 'customerId' is set
        if ($customerId === null || (is_array($customerId) && count($customerId) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $customerId when calling apiV1CustomersByCustomerIdAddressesSearchGet'
            );
        }






        $resourcePath = '/api/v1/customers/{customerId}/addresses/search';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $query,
            'query', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $orderby,
            'orderby', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);


        // path params
        if ($customerId !== null) {
            $resourcePath = str_replace(
                '{' . 'customerId' . '}',
                ObjectSerializer::toPathValue($customerId),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
