<?php
/**
 * CategoriesApi
 * PHP version 8.1
 *
 * @category Class
 * @package  EKM
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * EKM Partner API
 *
 * Our new API allows partners to build significantly better integrations with the EKM platform.    To try out the below endpoints, or for full up to date representations of the request / response models, please see the [swagger page](https://api.ekm.net/swagger/index.html). (We display examples here, but the swagger page is guaranteed to show the complete model.)    To keep up to date with the latest updates, please see our [RSS feed](https://partners.ekm.net/ChangeLog/Feed) or the [partner dashboard](https://partners.ekm.net/).
 *
 * The version of the OpenAPI document: v1
 * Contact: api-support@ekm.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace EKM\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use EKM\ApiException;
use EKM\Configuration;
use EKM\FormDataProcessor;
use EKM\HeaderSelector;
use EKM\ObjectSerializer;

/**
 * CategoriesApi Class Doc Comment
 *
 * @category Class
 * @package  EKM
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class CategoriesApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'apiV1CategoriesByIdCategorymanagedByChildCategoryIdDelete' => [
            'application/json',
        ],
        'apiV1CategoriesByIdCategorymanagedByChildCategoryIdPost' => [
            'application/json',
        ],
        'apiV1CategoriesByIdDelete' => [
            'application/json',
        ],
        'apiV1CategoriesByIdGet' => [
            'application/json',
        ],
        'apiV1CategoriesByIdPut' => [
            'application/json',
        ],
        'apiV1CategoriesByIdSubcategoriesGet' => [
            'application/json',
        ],
        'apiV1CategoriesGet' => [
            'application/json',
        ],
        'apiV1CategoriesPost' => [
            'application/json',
        ],
        'apiV1CategoriesSearchGet' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation apiV1CategoriesByIdCategorymanagedByChildCategoryIdDelete
     *
     * Stops a category from being managed by another category
     *
     * @param  int $id id (required)
     * @param  int $childCategoryId childCategoryId (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesByIdCategorymanagedByChildCategoryIdDelete'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKM\Model\TempestResponseSubCategory|\EKM\Model\TempestResponseTempestValidationError
     */
    public function apiV1CategoriesByIdCategorymanagedByChildCategoryIdDelete($id, $childCategoryId, string $contentType = self::contentTypes['apiV1CategoriesByIdCategorymanagedByChildCategoryIdDelete'][0])
    {
        list($response) = $this->apiV1CategoriesByIdCategorymanagedByChildCategoryIdDeleteWithHttpInfo($id, $childCategoryId, $contentType);
        return $response;
    }

    /**
     * Operation apiV1CategoriesByIdCategorymanagedByChildCategoryIdDeleteWithHttpInfo
     *
     * Stops a category from being managed by another category
     *
     * @param  int $id (required)
     * @param  int $childCategoryId (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesByIdCategorymanagedByChildCategoryIdDelete'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKM\Model\TempestResponseSubCategory|\EKM\Model\TempestResponseTempestValidationError, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1CategoriesByIdCategorymanagedByChildCategoryIdDeleteWithHttpInfo($id, $childCategoryId, string $contentType = self::contentTypes['apiV1CategoriesByIdCategorymanagedByChildCategoryIdDelete'][0])
    {
        $request = $this->apiV1CategoriesByIdCategorymanagedByChildCategoryIdDeleteRequest($id, $childCategoryId, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseSubCategory',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKM\Model\TempestResponseSubCategory',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseSubCategory',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1CategoriesByIdCategorymanagedByChildCategoryIdDeleteAsync
     *
     * Stops a category from being managed by another category
     *
     * @param  int $id (required)
     * @param  int $childCategoryId (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesByIdCategorymanagedByChildCategoryIdDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CategoriesByIdCategorymanagedByChildCategoryIdDeleteAsync($id, $childCategoryId, string $contentType = self::contentTypes['apiV1CategoriesByIdCategorymanagedByChildCategoryIdDelete'][0])
    {
        return $this->apiV1CategoriesByIdCategorymanagedByChildCategoryIdDeleteAsyncWithHttpInfo($id, $childCategoryId, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1CategoriesByIdCategorymanagedByChildCategoryIdDeleteAsyncWithHttpInfo
     *
     * Stops a category from being managed by another category
     *
     * @param  int $id (required)
     * @param  int $childCategoryId (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesByIdCategorymanagedByChildCategoryIdDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CategoriesByIdCategorymanagedByChildCategoryIdDeleteAsyncWithHttpInfo($id, $childCategoryId, string $contentType = self::contentTypes['apiV1CategoriesByIdCategorymanagedByChildCategoryIdDelete'][0])
    {
        $returnType = '\EKM\Model\TempestResponseSubCategory';
        $request = $this->apiV1CategoriesByIdCategorymanagedByChildCategoryIdDeleteRequest($id, $childCategoryId, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1CategoriesByIdCategorymanagedByChildCategoryIdDelete'
     *
     * @param  int $id (required)
     * @param  int $childCategoryId (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesByIdCategorymanagedByChildCategoryIdDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1CategoriesByIdCategorymanagedByChildCategoryIdDeleteRequest($id, $childCategoryId, string $contentType = self::contentTypes['apiV1CategoriesByIdCategorymanagedByChildCategoryIdDelete'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling apiV1CategoriesByIdCategorymanagedByChildCategoryIdDelete'
            );
        }

        // verify the required parameter 'childCategoryId' is set
        if ($childCategoryId === null || (is_array($childCategoryId) && count($childCategoryId) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $childCategoryId when calling apiV1CategoriesByIdCategorymanagedByChildCategoryIdDelete'
            );
        }


        $resourcePath = '/api/v1/categories/{id}/categorymanaged/{childCategoryId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }
        // path params
        if ($childCategoryId !== null) {
            $resourcePath = str_replace(
                '{' . 'childCategoryId' . '}',
                ObjectSerializer::toPathValue($childCategoryId),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1CategoriesByIdCategorymanagedByChildCategoryIdPost
     *
     * Set a category to be managed by another category
     *
     * @param  int $id id (required)
     * @param  int $childCategoryId childCategoryId (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesByIdCategorymanagedByChildCategoryIdPost'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKM\Model\TempestResponseSubCategory|\EKM\Model\TempestResponseTempestValidationError|\EKM\Model\TempestResponseTempestValidationError
     */
    public function apiV1CategoriesByIdCategorymanagedByChildCategoryIdPost($id, $childCategoryId, string $contentType = self::contentTypes['apiV1CategoriesByIdCategorymanagedByChildCategoryIdPost'][0])
    {
        list($response) = $this->apiV1CategoriesByIdCategorymanagedByChildCategoryIdPostWithHttpInfo($id, $childCategoryId, $contentType);
        return $response;
    }

    /**
     * Operation apiV1CategoriesByIdCategorymanagedByChildCategoryIdPostWithHttpInfo
     *
     * Set a category to be managed by another category
     *
     * @param  int $id (required)
     * @param  int $childCategoryId (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesByIdCategorymanagedByChildCategoryIdPost'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKM\Model\TempestResponseSubCategory|\EKM\Model\TempestResponseTempestValidationError|\EKM\Model\TempestResponseTempestValidationError, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1CategoriesByIdCategorymanagedByChildCategoryIdPostWithHttpInfo($id, $childCategoryId, string $contentType = self::contentTypes['apiV1CategoriesByIdCategorymanagedByChildCategoryIdPost'][0])
    {
        $request = $this->apiV1CategoriesByIdCategorymanagedByChildCategoryIdPostRequest($id, $childCategoryId, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseSubCategory',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKM\Model\TempestResponseSubCategory',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseSubCategory',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1CategoriesByIdCategorymanagedByChildCategoryIdPostAsync
     *
     * Set a category to be managed by another category
     *
     * @param  int $id (required)
     * @param  int $childCategoryId (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesByIdCategorymanagedByChildCategoryIdPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CategoriesByIdCategorymanagedByChildCategoryIdPostAsync($id, $childCategoryId, string $contentType = self::contentTypes['apiV1CategoriesByIdCategorymanagedByChildCategoryIdPost'][0])
    {
        return $this->apiV1CategoriesByIdCategorymanagedByChildCategoryIdPostAsyncWithHttpInfo($id, $childCategoryId, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1CategoriesByIdCategorymanagedByChildCategoryIdPostAsyncWithHttpInfo
     *
     * Set a category to be managed by another category
     *
     * @param  int $id (required)
     * @param  int $childCategoryId (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesByIdCategorymanagedByChildCategoryIdPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CategoriesByIdCategorymanagedByChildCategoryIdPostAsyncWithHttpInfo($id, $childCategoryId, string $contentType = self::contentTypes['apiV1CategoriesByIdCategorymanagedByChildCategoryIdPost'][0])
    {
        $returnType = '\EKM\Model\TempestResponseSubCategory';
        $request = $this->apiV1CategoriesByIdCategorymanagedByChildCategoryIdPostRequest($id, $childCategoryId, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1CategoriesByIdCategorymanagedByChildCategoryIdPost'
     *
     * @param  int $id (required)
     * @param  int $childCategoryId (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesByIdCategorymanagedByChildCategoryIdPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1CategoriesByIdCategorymanagedByChildCategoryIdPostRequest($id, $childCategoryId, string $contentType = self::contentTypes['apiV1CategoriesByIdCategorymanagedByChildCategoryIdPost'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling apiV1CategoriesByIdCategorymanagedByChildCategoryIdPost'
            );
        }

        // verify the required parameter 'childCategoryId' is set
        if ($childCategoryId === null || (is_array($childCategoryId) && count($childCategoryId) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $childCategoryId when calling apiV1CategoriesByIdCategorymanagedByChildCategoryIdPost'
            );
        }


        $resourcePath = '/api/v1/categories/{id}/categorymanaged/{childCategoryId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }
        // path params
        if ($childCategoryId !== null) {
            $resourcePath = str_replace(
                '{' . 'childCategoryId' . '}',
                ObjectSerializer::toPathValue($childCategoryId),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1CategoriesByIdDelete
     *
     * Delete a category
     *
     * @param  int $id The category ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesByIdDelete'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKM\Model\TempestResponseCategory
     */
    public function apiV1CategoriesByIdDelete($id, string $contentType = self::contentTypes['apiV1CategoriesByIdDelete'][0])
    {
        list($response) = $this->apiV1CategoriesByIdDeleteWithHttpInfo($id, $contentType);
        return $response;
    }

    /**
     * Operation apiV1CategoriesByIdDeleteWithHttpInfo
     *
     * Delete a category
     *
     * @param  int $id The category ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesByIdDelete'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKM\Model\TempestResponseCategory, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1CategoriesByIdDeleteWithHttpInfo($id, string $contentType = self::contentTypes['apiV1CategoriesByIdDelete'][0])
    {
        $request = $this->apiV1CategoriesByIdDeleteRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseCategory',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKM\Model\TempestResponseCategory',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseCategory',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1CategoriesByIdDeleteAsync
     *
     * Delete a category
     *
     * @param  int $id The category ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesByIdDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CategoriesByIdDeleteAsync($id, string $contentType = self::contentTypes['apiV1CategoriesByIdDelete'][0])
    {
        return $this->apiV1CategoriesByIdDeleteAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1CategoriesByIdDeleteAsyncWithHttpInfo
     *
     * Delete a category
     *
     * @param  int $id The category ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesByIdDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CategoriesByIdDeleteAsyncWithHttpInfo($id, string $contentType = self::contentTypes['apiV1CategoriesByIdDelete'][0])
    {
        $returnType = '\EKM\Model\TempestResponseCategory';
        $request = $this->apiV1CategoriesByIdDeleteRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1CategoriesByIdDelete'
     *
     * @param  int $id The category ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesByIdDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1CategoriesByIdDeleteRequest($id, string $contentType = self::contentTypes['apiV1CategoriesByIdDelete'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling apiV1CategoriesByIdDelete'
            );
        }


        $resourcePath = '/api/v1/categories/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1CategoriesByIdGet
     *
     * Get a category
     *
     * @param  int $id The category ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesByIdGet'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKM\Model\TempestResponseCategory|\EKM\Model\TempestResponseTempestValidationError|\EKM\Model\TempestResponseTempestValidationError
     */
    public function apiV1CategoriesByIdGet($id, string $contentType = self::contentTypes['apiV1CategoriesByIdGet'][0])
    {
        list($response) = $this->apiV1CategoriesByIdGetWithHttpInfo($id, $contentType);
        return $response;
    }

    /**
     * Operation apiV1CategoriesByIdGetWithHttpInfo
     *
     * Get a category
     *
     * @param  int $id The category ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesByIdGet'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKM\Model\TempestResponseCategory|\EKM\Model\TempestResponseTempestValidationError|\EKM\Model\TempestResponseTempestValidationError, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1CategoriesByIdGetWithHttpInfo($id, string $contentType = self::contentTypes['apiV1CategoriesByIdGet'][0])
    {
        $request = $this->apiV1CategoriesByIdGetRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseCategory',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKM\Model\TempestResponseCategory',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseCategory',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1CategoriesByIdGetAsync
     *
     * Get a category
     *
     * @param  int $id The category ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesByIdGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CategoriesByIdGetAsync($id, string $contentType = self::contentTypes['apiV1CategoriesByIdGet'][0])
    {
        return $this->apiV1CategoriesByIdGetAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1CategoriesByIdGetAsyncWithHttpInfo
     *
     * Get a category
     *
     * @param  int $id The category ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesByIdGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CategoriesByIdGetAsyncWithHttpInfo($id, string $contentType = self::contentTypes['apiV1CategoriesByIdGet'][0])
    {
        $returnType = '\EKM\Model\TempestResponseCategory';
        $request = $this->apiV1CategoriesByIdGetRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1CategoriesByIdGet'
     *
     * @param  int $id The category ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesByIdGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1CategoriesByIdGetRequest($id, string $contentType = self::contentTypes['apiV1CategoriesByIdGet'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling apiV1CategoriesByIdGet'
            );
        }


        $resourcePath = '/api/v1/categories/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1CategoriesByIdPut
     *
     * Update a category
     *
     * @param  int $id The category ID (required)
     * @param  \EKM\Model\UpdateCategory|null $model model (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesByIdPut'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKM\Model\TempestResponseCategory|\EKM\Model\TempestResponseTempestValidationError|\EKM\Model\TempestResponseTempestValidationError
     */
    public function apiV1CategoriesByIdPut($id, $model = null, string $contentType = self::contentTypes['apiV1CategoriesByIdPut'][0])
    {
        list($response) = $this->apiV1CategoriesByIdPutWithHttpInfo($id, $model, $contentType);
        return $response;
    }

    /**
     * Operation apiV1CategoriesByIdPutWithHttpInfo
     *
     * Update a category
     *
     * @param  int $id The category ID (required)
     * @param  \EKM\Model\UpdateCategory|null $model (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesByIdPut'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKM\Model\TempestResponseCategory|\EKM\Model\TempestResponseTempestValidationError|\EKM\Model\TempestResponseTempestValidationError, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1CategoriesByIdPutWithHttpInfo($id, $model = null, string $contentType = self::contentTypes['apiV1CategoriesByIdPut'][0])
    {
        $request = $this->apiV1CategoriesByIdPutRequest($id, $model, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseCategory',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKM\Model\TempestResponseCategory',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseCategory',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1CategoriesByIdPutAsync
     *
     * Update a category
     *
     * @param  int $id The category ID (required)
     * @param  \EKM\Model\UpdateCategory|null $model (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesByIdPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CategoriesByIdPutAsync($id, $model = null, string $contentType = self::contentTypes['apiV1CategoriesByIdPut'][0])
    {
        return $this->apiV1CategoriesByIdPutAsyncWithHttpInfo($id, $model, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1CategoriesByIdPutAsyncWithHttpInfo
     *
     * Update a category
     *
     * @param  int $id The category ID (required)
     * @param  \EKM\Model\UpdateCategory|null $model (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesByIdPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CategoriesByIdPutAsyncWithHttpInfo($id, $model = null, string $contentType = self::contentTypes['apiV1CategoriesByIdPut'][0])
    {
        $returnType = '\EKM\Model\TempestResponseCategory';
        $request = $this->apiV1CategoriesByIdPutRequest($id, $model, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1CategoriesByIdPut'
     *
     * @param  int $id The category ID (required)
     * @param  \EKM\Model\UpdateCategory|null $model (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesByIdPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1CategoriesByIdPutRequest($id, $model = null, string $contentType = self::contentTypes['apiV1CategoriesByIdPut'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling apiV1CategoriesByIdPut'
            );
        }



        $resourcePath = '/api/v1/categories/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($model)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($model));
            } else {
                $httpBody = $model;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1CategoriesByIdSubcategoriesGet
     *
     * Get a paginated set of subcategories
     *
     * @param  int $id id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesByIdSubcategoriesGet'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKM\Model\TempestResponseListSubCategory|\EKM\Model\TempestResponseTempestValidationError|\EKM\Model\TempestResponseTempestValidationError
     */
    public function apiV1CategoriesByIdSubcategoriesGet($id, string $contentType = self::contentTypes['apiV1CategoriesByIdSubcategoriesGet'][0])
    {
        list($response) = $this->apiV1CategoriesByIdSubcategoriesGetWithHttpInfo($id, $contentType);
        return $response;
    }

    /**
     * Operation apiV1CategoriesByIdSubcategoriesGetWithHttpInfo
     *
     * Get a paginated set of subcategories
     *
     * @param  int $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesByIdSubcategoriesGet'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKM\Model\TempestResponseListSubCategory|\EKM\Model\TempestResponseTempestValidationError|\EKM\Model\TempestResponseTempestValidationError, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1CategoriesByIdSubcategoriesGetWithHttpInfo($id, string $contentType = self::contentTypes['apiV1CategoriesByIdSubcategoriesGet'][0])
    {
        $request = $this->apiV1CategoriesByIdSubcategoriesGetRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseListSubCategory',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKM\Model\TempestResponseListSubCategory',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseListSubCategory',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1CategoriesByIdSubcategoriesGetAsync
     *
     * Get a paginated set of subcategories
     *
     * @param  int $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesByIdSubcategoriesGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CategoriesByIdSubcategoriesGetAsync($id, string $contentType = self::contentTypes['apiV1CategoriesByIdSubcategoriesGet'][0])
    {
        return $this->apiV1CategoriesByIdSubcategoriesGetAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1CategoriesByIdSubcategoriesGetAsyncWithHttpInfo
     *
     * Get a paginated set of subcategories
     *
     * @param  int $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesByIdSubcategoriesGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CategoriesByIdSubcategoriesGetAsyncWithHttpInfo($id, string $contentType = self::contentTypes['apiV1CategoriesByIdSubcategoriesGet'][0])
    {
        $returnType = '\EKM\Model\TempestResponseListSubCategory';
        $request = $this->apiV1CategoriesByIdSubcategoriesGetRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1CategoriesByIdSubcategoriesGet'
     *
     * @param  int $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesByIdSubcategoriesGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1CategoriesByIdSubcategoriesGetRequest($id, string $contentType = self::contentTypes['apiV1CategoriesByIdSubcategoriesGet'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling apiV1CategoriesByIdSubcategoriesGet'
            );
        }


        $resourcePath = '/api/v1/categories/{id}/subcategories';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1CategoriesGet
     *
     * Get a paginated set of categories
     *
     * @param  int|null $page Page number to display (optional, default to 1)
     * @param  int|null $limit Items per page (maximum 20) (optional, default to 10)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesGet'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKM\Model\TempestResponseListCategory
     */
    public function apiV1CategoriesGet($page = 1, $limit = 10, string $contentType = self::contentTypes['apiV1CategoriesGet'][0])
    {
        list($response) = $this->apiV1CategoriesGetWithHttpInfo($page, $limit, $contentType);
        return $response;
    }

    /**
     * Operation apiV1CategoriesGetWithHttpInfo
     *
     * Get a paginated set of categories
     *
     * @param  int|null $page Page number to display (optional, default to 1)
     * @param  int|null $limit Items per page (maximum 20) (optional, default to 10)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesGet'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKM\Model\TempestResponseListCategory, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1CategoriesGetWithHttpInfo($page = 1, $limit = 10, string $contentType = self::contentTypes['apiV1CategoriesGet'][0])
    {
        $request = $this->apiV1CategoriesGetRequest($page, $limit, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseListCategory',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKM\Model\TempestResponseListCategory',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseListCategory',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1CategoriesGetAsync
     *
     * Get a paginated set of categories
     *
     * @param  int|null $page Page number to display (optional, default to 1)
     * @param  int|null $limit Items per page (maximum 20) (optional, default to 10)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CategoriesGetAsync($page = 1, $limit = 10, string $contentType = self::contentTypes['apiV1CategoriesGet'][0])
    {
        return $this->apiV1CategoriesGetAsyncWithHttpInfo($page, $limit, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1CategoriesGetAsyncWithHttpInfo
     *
     * Get a paginated set of categories
     *
     * @param  int|null $page Page number to display (optional, default to 1)
     * @param  int|null $limit Items per page (maximum 20) (optional, default to 10)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CategoriesGetAsyncWithHttpInfo($page = 1, $limit = 10, string $contentType = self::contentTypes['apiV1CategoriesGet'][0])
    {
        $returnType = '\EKM\Model\TempestResponseListCategory';
        $request = $this->apiV1CategoriesGetRequest($page, $limit, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1CategoriesGet'
     *
     * @param  int|null $page Page number to display (optional, default to 1)
     * @param  int|null $limit Items per page (maximum 20) (optional, default to 10)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1CategoriesGetRequest($page = 1, $limit = 10, string $contentType = self::contentTypes['apiV1CategoriesGet'][0])
    {




        $resourcePath = '/api/v1/categories';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1CategoriesPost
     *
     * Add a category
     *
     * @param  \EKM\Model\AddCategory|null $model model (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesPost'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKM\Model\TempestResponseCategory|\EKM\Model\TempestResponseTempestValidationError
     */
    public function apiV1CategoriesPost($model = null, string $contentType = self::contentTypes['apiV1CategoriesPost'][0])
    {
        list($response) = $this->apiV1CategoriesPostWithHttpInfo($model, $contentType);
        return $response;
    }

    /**
     * Operation apiV1CategoriesPostWithHttpInfo
     *
     * Add a category
     *
     * @param  \EKM\Model\AddCategory|null $model (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesPost'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKM\Model\TempestResponseCategory|\EKM\Model\TempestResponseTempestValidationError, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1CategoriesPostWithHttpInfo($model = null, string $contentType = self::contentTypes['apiV1CategoriesPost'][0])
    {
        $request = $this->apiV1CategoriesPostRequest($model, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseCategory',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKM\Model\TempestResponseCategory',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseCategory',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1CategoriesPostAsync
     *
     * Add a category
     *
     * @param  \EKM\Model\AddCategory|null $model (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CategoriesPostAsync($model = null, string $contentType = self::contentTypes['apiV1CategoriesPost'][0])
    {
        return $this->apiV1CategoriesPostAsyncWithHttpInfo($model, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1CategoriesPostAsyncWithHttpInfo
     *
     * Add a category
     *
     * @param  \EKM\Model\AddCategory|null $model (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CategoriesPostAsyncWithHttpInfo($model = null, string $contentType = self::contentTypes['apiV1CategoriesPost'][0])
    {
        $returnType = '\EKM\Model\TempestResponseCategory';
        $request = $this->apiV1CategoriesPostRequest($model, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1CategoriesPost'
     *
     * @param  \EKM\Model\AddCategory|null $model (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1CategoriesPostRequest($model = null, string $contentType = self::contentTypes['apiV1CategoriesPost'][0])
    {



        $resourcePath = '/api/v1/categories';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($model)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($model));
            } else {
                $httpBody = $model;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1CategoriesSearchGet
     *
     * Searches categories based on search criteria
     *
     * @param  int|null $page Page number to display (optional, default to 1)
     * @param  int|null $limit Items per page (maximum 20) (optional, default to 10)
     * @param  string|null $query A &lt;a href&#x3D;\&quot;#tag/OData\&quot; target&#x3D;\&quot;_blank\&quot;&gt;search&lt;/a&gt; query e.g. live eq true (optional)
     * @param  string|null $orderby Field to order results. Prefix with a - (dash) for descending e.g. -id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesSearchGet'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \EKM\Model\TempestResponseListCategory|\EKM\Model\TempestResponseTempestValidationError
     */
    public function apiV1CategoriesSearchGet($page = 1, $limit = 10, $query = null, $orderby = null, string $contentType = self::contentTypes['apiV1CategoriesSearchGet'][0])
    {
        list($response) = $this->apiV1CategoriesSearchGetWithHttpInfo($page, $limit, $query, $orderby, $contentType);
        return $response;
    }

    /**
     * Operation apiV1CategoriesSearchGetWithHttpInfo
     *
     * Searches categories based on search criteria
     *
     * @param  int|null $page Page number to display (optional, default to 1)
     * @param  int|null $limit Items per page (maximum 20) (optional, default to 10)
     * @param  string|null $query A &lt;a href&#x3D;\&quot;#tag/OData\&quot; target&#x3D;\&quot;_blank\&quot;&gt;search&lt;/a&gt; query e.g. live eq true (optional)
     * @param  string|null $orderby Field to order results. Prefix with a - (dash) for descending e.g. -id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesSearchGet'] to see the possible values for this operation
     *
     * @throws \EKM\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \EKM\Model\TempestResponseListCategory|\EKM\Model\TempestResponseTempestValidationError, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1CategoriesSearchGetWithHttpInfo($page = 1, $limit = 10, $query = null, $orderby = null, string $contentType = self::contentTypes['apiV1CategoriesSearchGet'][0])
    {
        $request = $this->apiV1CategoriesSearchGetRequest($page, $limit, $query, $orderby, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseListCategory',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\EKM\Model\TempestResponseListCategory',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseListCategory',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1CategoriesSearchGetAsync
     *
     * Searches categories based on search criteria
     *
     * @param  int|null $page Page number to display (optional, default to 1)
     * @param  int|null $limit Items per page (maximum 20) (optional, default to 10)
     * @param  string|null $query A &lt;a href&#x3D;\&quot;#tag/OData\&quot; target&#x3D;\&quot;_blank\&quot;&gt;search&lt;/a&gt; query e.g. live eq true (optional)
     * @param  string|null $orderby Field to order results. Prefix with a - (dash) for descending e.g. -id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesSearchGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CategoriesSearchGetAsync($page = 1, $limit = 10, $query = null, $orderby = null, string $contentType = self::contentTypes['apiV1CategoriesSearchGet'][0])
    {
        return $this->apiV1CategoriesSearchGetAsyncWithHttpInfo($page, $limit, $query, $orderby, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1CategoriesSearchGetAsyncWithHttpInfo
     *
     * Searches categories based on search criteria
     *
     * @param  int|null $page Page number to display (optional, default to 1)
     * @param  int|null $limit Items per page (maximum 20) (optional, default to 10)
     * @param  string|null $query A &lt;a href&#x3D;\&quot;#tag/OData\&quot; target&#x3D;\&quot;_blank\&quot;&gt;search&lt;/a&gt; query e.g. live eq true (optional)
     * @param  string|null $orderby Field to order results. Prefix with a - (dash) for descending e.g. -id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesSearchGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CategoriesSearchGetAsyncWithHttpInfo($page = 1, $limit = 10, $query = null, $orderby = null, string $contentType = self::contentTypes['apiV1CategoriesSearchGet'][0])
    {
        $returnType = '\EKM\Model\TempestResponseListCategory';
        $request = $this->apiV1CategoriesSearchGetRequest($page, $limit, $query, $orderby, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1CategoriesSearchGet'
     *
     * @param  int|null $page Page number to display (optional, default to 1)
     * @param  int|null $limit Items per page (maximum 20) (optional, default to 10)
     * @param  string|null $query A &lt;a href&#x3D;\&quot;#tag/OData\&quot; target&#x3D;\&quot;_blank\&quot;&gt;search&lt;/a&gt; query e.g. live eq true (optional)
     * @param  string|null $orderby Field to order results. Prefix with a - (dash) for descending e.g. -id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesSearchGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1CategoriesSearchGetRequest($page = 1, $limit = 10, $query = null, $orderby = null, string $contentType = self::contentTypes['apiV1CategoriesSearchGet'][0])
    {






        $resourcePath = '/api/v1/categories/search';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $query,
            'query', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $orderby,
            'orderby', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
