# EKM\ProductVariantStockApi

All URIs are relative to https://api.ekm.net, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1ProductsByIdVariantsByVariantIdStockGet()**](ProductVariantStockApi.md#apiV1ProductsByIdVariantsByVariantIdStockGet) | **GET** /api/v1/products/{id}/variants/{variantId}/stock | Get a product variant stock |
| [**apiV1ProductsByIdVariantsByVariantIdStockPut()**](ProductVariantStockApi.md#apiV1ProductsByIdVariantsByVariantIdStockPut) | **PUT** /api/v1/products/{id}/variants/{variantId}/stock | Update a product variant stock |


## `apiV1ProductsByIdVariantsByVariantIdStockGet()`

```php
apiV1ProductsByIdVariantsByVariantIdStockGet($id, $variantId): \EKM\Model\TempestResponseProductVariantStock
```

Get a product variant stock

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\ProductVariantStockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | The product ID
$variantId = 56; // int | The varaint ID

try {
    $result = $apiInstance->apiV1ProductsByIdVariantsByVariantIdStockGet($id, $variantId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductVariantStockApi->apiV1ProductsByIdVariantsByVariantIdStockGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| The product ID | |
| **variantId** | **int**| The varaint ID | |

### Return type

[**\EKM\Model\TempestResponseProductVariantStock**](../Model/TempestResponseProductVariantStock.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1ProductsByIdVariantsByVariantIdStockPut()`

```php
apiV1ProductsByIdVariantsByVariantIdStockPut($id, $variantId, $model): \EKM\Model\TempestResponseProductVariantStock
```

Update a product variant stock

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\ProductVariantStockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | The product ID
$variantId = 56; // int | The varaint ID
$model = new \EKM\Model\ProductVariantStock(); // \EKM\Model\ProductVariantStock

try {
    $result = $apiInstance->apiV1ProductsByIdVariantsByVariantIdStockPut($id, $variantId, $model);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductVariantStockApi->apiV1ProductsByIdVariantsByVariantIdStockPut: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| The product ID | |
| **variantId** | **int**| The varaint ID | |
| **model** | [**\EKM\Model\ProductVariantStock**](../Model/ProductVariantStock.md)|  | [optional] |

### Return type

[**\EKM\Model\TempestResponseProductVariantStock**](../Model/TempestResponseProductVariantStock.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
