# EKM\ProductOptionsApi

All URIs are relative to https://api.ekm.net, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1ProductsByIdOptionsByOptionIdDelete()**](ProductOptionsApi.md#apiV1ProductsByIdOptionsByOptionIdDelete) | **DELETE** /api/v1/products/{id}/options/{optionId} | Delete an option |
| [**apiV1ProductsByIdOptionsByOptionIdGet()**](ProductOptionsApi.md#apiV1ProductsByIdOptionsByOptionIdGet) | **GET** /api/v1/products/{id}/options/{optionId} | Get a product option |
| [**apiV1ProductsByIdOptionsByOptionIdPut()**](ProductOptionsApi.md#apiV1ProductsByIdOptionsByOptionIdPut) | **PUT** /api/v1/products/{id}/options/{optionId} | Update a product option |
| [**apiV1ProductsByIdOptionsGet()**](ProductOptionsApi.md#apiV1ProductsByIdOptionsGet) | **GET** /api/v1/products/{id}/options | Get a products options |
| [**apiV1ProductsByIdOptionsPost()**](ProductOptionsApi.md#apiV1ProductsByIdOptionsPost) | **POST** /api/v1/products/{id}/options | Add an option to a product |


## `apiV1ProductsByIdOptionsByOptionIdDelete()`

```php
apiV1ProductsByIdOptionsByOptionIdDelete($id, $optionId): \EKM\Model\TempestResponseProductOption
```

Delete an option

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\ProductOptionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | The product ID
$optionId = 56; // int | The option ID

try {
    $result = $apiInstance->apiV1ProductsByIdOptionsByOptionIdDelete($id, $optionId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductOptionsApi->apiV1ProductsByIdOptionsByOptionIdDelete: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| The product ID | |
| **optionId** | **int**| The option ID | |

### Return type

[**\EKM\Model\TempestResponseProductOption**](../Model/TempestResponseProductOption.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1ProductsByIdOptionsByOptionIdGet()`

```php
apiV1ProductsByIdOptionsByOptionIdGet($id, $optionId): \EKM\Model\TempestResponseProductOption
```

Get a product option

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\ProductOptionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | The product ID
$optionId = 56; // int | The option ID

try {
    $result = $apiInstance->apiV1ProductsByIdOptionsByOptionIdGet($id, $optionId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductOptionsApi->apiV1ProductsByIdOptionsByOptionIdGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| The product ID | |
| **optionId** | **int**| The option ID | |

### Return type

[**\EKM\Model\TempestResponseProductOption**](../Model/TempestResponseProductOption.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1ProductsByIdOptionsByOptionIdPut()`

```php
apiV1ProductsByIdOptionsByOptionIdPut($id, $optionId, $model): \EKM\Model\TempestResponseProductOption
```

Update a product option

Option items must be updated separately

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\ProductOptionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | The product ID
$optionId = 56; // int | The option ID
$model = new \EKM\Model\UpdateProductOption(); // \EKM\Model\UpdateProductOption

try {
    $result = $apiInstance->apiV1ProductsByIdOptionsByOptionIdPut($id, $optionId, $model);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductOptionsApi->apiV1ProductsByIdOptionsByOptionIdPut: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| The product ID | |
| **optionId** | **int**| The option ID | |
| **model** | [**\EKM\Model\UpdateProductOption**](../Model/UpdateProductOption.md)|  | [optional] |

### Return type

[**\EKM\Model\TempestResponseProductOption**](../Model/TempestResponseProductOption.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1ProductsByIdOptionsGet()`

```php
apiV1ProductsByIdOptionsGet($id): \EKM\Model\TempestResponseListProductOption
```

Get a products options

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\ProductOptionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | The product ID

try {
    $result = $apiInstance->apiV1ProductsByIdOptionsGet($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductOptionsApi->apiV1ProductsByIdOptionsGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| The product ID | |

### Return type

[**\EKM\Model\TempestResponseListProductOption**](../Model/TempestResponseListProductOption.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1ProductsByIdOptionsPost()`

```php
apiV1ProductsByIdOptionsPost($id, $model): \EKM\Model\TempestResponseProductOption
```

Add an option to a product

Option items must be added separately

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\ProductOptionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | The product ID
$model = new \EKM\Model\AddProductOption(); // \EKM\Model\AddProductOption

try {
    $result = $apiInstance->apiV1ProductsByIdOptionsPost($id, $model);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductOptionsApi->apiV1ProductsByIdOptionsPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| The product ID | |
| **model** | [**\EKM\Model\AddProductOption**](../Model/AddProductOption.md)|  | [optional] |

### Return type

[**\EKM\Model\TempestResponseProductOption**](../Model/TempestResponseProductOption.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
