# EKM\ProductOptionItemsApi

All URIs are relative to https://api.ekm.net, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdDelete()**](ProductOptionItemsApi.md#apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdDelete) | **DELETE** /api/v1/products/{id}/options/{optionId}/items/{optionItemId} | Delete an option item |
| [**apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdPut()**](ProductOptionItemsApi.md#apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdPut) | **PUT** /api/v1/products/{id}/options/{optionId}/items/{optionItemId} | Update a product option item |
| [**apiV1ProductsByIdOptionsByOptionIdItemsPost()**](ProductOptionItemsApi.md#apiV1ProductsByIdOptionsByOptionIdItemsPost) | **POST** /api/v1/products/{id}/options/{optionId}/items | Add an item to a product option |


## `apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdDelete()`

```php
apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdDelete($id, $optionId, $optionItemId): \EKM\Model\TempestResponseProductOptionItem
```

Delete an option item

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\ProductOptionItemsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | The product ID
$optionId = 56; // int | The option ID
$optionItemId = 56; // int | The option item ID

try {
    $result = $apiInstance->apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdDelete($id, $optionId, $optionItemId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductOptionItemsApi->apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdDelete: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| The product ID | |
| **optionId** | **int**| The option ID | |
| **optionItemId** | **int**| The option item ID | |

### Return type

[**\EKM\Model\TempestResponseProductOptionItem**](../Model/TempestResponseProductOptionItem.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdPut()`

```php
apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdPut($id, $optionId, $optionItemId, $model): \EKM\Model\TempestResponseProductOptionItem
```

Update a product option item

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\ProductOptionItemsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | The product ID
$optionId = 56; // int | The option ID
$optionItemId = 56; // int | The option item ID
$model = new \EKM\Model\ProductOptionItem(); // \EKM\Model\ProductOptionItem

try {
    $result = $apiInstance->apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdPut($id, $optionId, $optionItemId, $model);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductOptionItemsApi->apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdPut: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| The product ID | |
| **optionId** | **int**| The option ID | |
| **optionItemId** | **int**| The option item ID | |
| **model** | [**\EKM\Model\ProductOptionItem**](../Model/ProductOptionItem.md)|  | [optional] |

### Return type

[**\EKM\Model\TempestResponseProductOptionItem**](../Model/TempestResponseProductOptionItem.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1ProductsByIdOptionsByOptionIdItemsPost()`

```php
apiV1ProductsByIdOptionsByOptionIdItemsPost($id, $optionId, $model): \EKM\Model\TempestResponseProductOptionItem
```

Add an item to a product option

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\ProductOptionItemsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | The product ID
$optionId = 56; // int | The option ID
$model = new \EKM\Model\ProductOptionItem(); // \EKM\Model\ProductOptionItem

try {
    $result = $apiInstance->apiV1ProductsByIdOptionsByOptionIdItemsPost($id, $optionId, $model);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductOptionItemsApi->apiV1ProductsByIdOptionsByOptionIdItemsPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| The product ID | |
| **optionId** | **int**| The option ID | |
| **model** | [**\EKM\Model\ProductOptionItem**](../Model/ProductOptionItem.md)|  | [optional] |

### Return type

[**\EKM\Model\TempestResponseProductOptionItem**](../Model/TempestResponseProductOptionItem.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
