# EKM\ProductAttributesApi

All URIs are relative to https://api.ekm.net, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1SettingsProductattributesByAttributeKeyDelete()**](ProductAttributesApi.md#apiV1SettingsProductattributesByAttributeKeyDelete) | **DELETE** /api/v1/settings/productattributes/{attribute_key} | Delete a product attribute |
| [**apiV1SettingsProductattributesByAttributeKeyGet()**](ProductAttributesApi.md#apiV1SettingsProductattributesByAttributeKeyGet) | **GET** /api/v1/settings/productattributes/{attribute_key} | Get a product attribute |
| [**apiV1SettingsProductattributesByAttributeKeyPut()**](ProductAttributesApi.md#apiV1SettingsProductattributesByAttributeKeyPut) | **PUT** /api/v1/settings/productattributes/{attribute_key} | Update a product attribute |
| [**apiV1SettingsProductattributesGet()**](ProductAttributesApi.md#apiV1SettingsProductattributesGet) | **GET** /api/v1/settings/productattributes | Get all product attributes |
| [**apiV1SettingsProductattributesPost()**](ProductAttributesApi.md#apiV1SettingsProductattributesPost) | **POST** /api/v1/settings/productattributes | Add a product attribute |


## `apiV1SettingsProductattributesByAttributeKeyDelete()`

```php
apiV1SettingsProductattributesByAttributeKeyDelete($attributeKey): \EKM\Model\TempestResponseProductAttribute
```

Delete a product attribute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\ProductAttributesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$attributeKey = 'attributeKey_example'; // string | The attribute ID

try {
    $result = $apiInstance->apiV1SettingsProductattributesByAttributeKeyDelete($attributeKey);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductAttributesApi->apiV1SettingsProductattributesByAttributeKeyDelete: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **attributeKey** | **string**| The attribute ID | |

### Return type

[**\EKM\Model\TempestResponseProductAttribute**](../Model/TempestResponseProductAttribute.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1SettingsProductattributesByAttributeKeyGet()`

```php
apiV1SettingsProductattributesByAttributeKeyGet($attributeKey): \EKM\Model\TempestResponseProductAttribute
```

Get a product attribute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\ProductAttributesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$attributeKey = 'attributeKey_example'; // string | The attribute item key

try {
    $result = $apiInstance->apiV1SettingsProductattributesByAttributeKeyGet($attributeKey);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductAttributesApi->apiV1SettingsProductattributesByAttributeKeyGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **attributeKey** | **string**| The attribute item key | |

### Return type

[**\EKM\Model\TempestResponseProductAttribute**](../Model/TempestResponseProductAttribute.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1SettingsProductattributesByAttributeKeyPut()`

```php
apiV1SettingsProductattributesByAttributeKeyPut($attributeKey, $model): \EKM\Model\TempestResponseProductAttribute
```

Update a product attribute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\ProductAttributesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$attributeKey = 'attributeKey_example'; // string | The attribute ID
$model = new \EKM\Model\ProductAttribute(); // \EKM\Model\ProductAttribute | The product attribute item to update

try {
    $result = $apiInstance->apiV1SettingsProductattributesByAttributeKeyPut($attributeKey, $model);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductAttributesApi->apiV1SettingsProductattributesByAttributeKeyPut: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **attributeKey** | **string**| The attribute ID | |
| **model** | [**\EKM\Model\ProductAttribute**](../Model/ProductAttribute.md)| The product attribute item to update | [optional] |

### Return type

[**\EKM\Model\TempestResponseProductAttribute**](../Model/TempestResponseProductAttribute.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1SettingsProductattributesGet()`

```php
apiV1SettingsProductattributesGet(): \EKM\Model\TempestResponseListProductAttribute
```

Get all product attributes

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\ProductAttributesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->apiV1SettingsProductattributesGet();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductAttributesApi->apiV1SettingsProductattributesGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\EKM\Model\TempestResponseListProductAttribute**](../Model/TempestResponseListProductAttribute.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1SettingsProductattributesPost()`

```php
apiV1SettingsProductattributesPost($model): \EKM\Model\TempestResponseProductAttribute
```

Add a product attribute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\ProductAttributesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$model = new \EKM\Model\ProductAttribute(); // \EKM\Model\ProductAttribute

try {
    $result = $apiInstance->apiV1SettingsProductattributesPost($model);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductAttributesApi->apiV1SettingsProductattributesPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **model** | [**\EKM\Model\ProductAttribute**](../Model/ProductAttribute.md)|  | [optional] |

### Return type

[**\EKM\Model\TempestResponseProductAttribute**](../Model/TempestResponseProductAttribute.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
