# EKM\ProductAttributeItemsApi

All URIs are relative to https://api.ekm.net, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1ProductsByIdAttributesByAttrIdDelete()**](ProductAttributeItemsApi.md#apiV1ProductsByIdAttributesByAttrIdDelete) | **DELETE** /api/v1/products/{id}/attributes/{attrId} | Delete an attribute item |
| [**apiV1ProductsByIdAttributesByAttributeKeyGet()**](ProductAttributeItemsApi.md#apiV1ProductsByIdAttributesByAttributeKeyGet) | **GET** /api/v1/products/{id}/attributes/{attribute_key} | Get a product attribute item |
| [**apiV1ProductsByIdAttributesByAttributeKeyPut()**](ProductAttributeItemsApi.md#apiV1ProductsByIdAttributesByAttributeKeyPut) | **PUT** /api/v1/products/{id}/attributes/{attribute_key} | Update a product attribute item |
| [**apiV1ProductsByIdAttributesGet()**](ProductAttributeItemsApi.md#apiV1ProductsByIdAttributesGet) | **GET** /api/v1/products/{id}/attributes | Get all of a products attribute items |
| [**apiV1ProductsByIdAttributesPost()**](ProductAttributeItemsApi.md#apiV1ProductsByIdAttributesPost) | **POST** /api/v1/products/{id}/attributes | Add a attribute item to a product |


## `apiV1ProductsByIdAttributesByAttrIdDelete()`

```php
apiV1ProductsByIdAttributesByAttrIdDelete($id, $attrId, $attributeKey): \EKM\Model\TempestResponseProductAttributeItem
```

Delete an attribute item

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\ProductAttributeItemsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | The product ID
$attrId = 'attrId_example'; // string
$attributeKey = 56; // int | The attribute ID

try {
    $result = $apiInstance->apiV1ProductsByIdAttributesByAttrIdDelete($id, $attrId, $attributeKey);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductAttributeItemsApi->apiV1ProductsByIdAttributesByAttrIdDelete: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| The product ID | |
| **attrId** | **string**|  | |
| **attributeKey** | **int**| The attribute ID | [optional] |

### Return type

[**\EKM\Model\TempestResponseProductAttributeItem**](../Model/TempestResponseProductAttributeItem.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1ProductsByIdAttributesByAttributeKeyGet()`

```php
apiV1ProductsByIdAttributesByAttributeKeyGet($id, $attributeKey): \EKM\Model\TempestResponseProductAttributeItem
```

Get a product attribute item

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\ProductAttributeItemsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | The product ID
$attributeKey = 56; // int | The attribute item key

try {
    $result = $apiInstance->apiV1ProductsByIdAttributesByAttributeKeyGet($id, $attributeKey);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductAttributeItemsApi->apiV1ProductsByIdAttributesByAttributeKeyGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| The product ID | |
| **attributeKey** | **int**| The attribute item key | |

### Return type

[**\EKM\Model\TempestResponseProductAttributeItem**](../Model/TempestResponseProductAttributeItem.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1ProductsByIdAttributesByAttributeKeyPut()`

```php
apiV1ProductsByIdAttributesByAttributeKeyPut($id, $attributeKey, $model): \EKM\Model\TempestResponseProductAttributeItem
```

Update a product attribute item

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\ProductAttributeItemsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | The product ID
$attributeKey = 56; // int | The attribute ID
$model = new \EKM\Model\ProductAttributeItem(); // \EKM\Model\ProductAttributeItem | The product attribute item to update

try {
    $result = $apiInstance->apiV1ProductsByIdAttributesByAttributeKeyPut($id, $attributeKey, $model);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductAttributeItemsApi->apiV1ProductsByIdAttributesByAttributeKeyPut: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| The product ID | |
| **attributeKey** | **int**| The attribute ID | |
| **model** | [**\EKM\Model\ProductAttributeItem**](../Model/ProductAttributeItem.md)| The product attribute item to update | [optional] |

### Return type

[**\EKM\Model\TempestResponseProductAttributeItem**](../Model/TempestResponseProductAttributeItem.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1ProductsByIdAttributesGet()`

```php
apiV1ProductsByIdAttributesGet($id): \EKM\Model\TempestResponseListProductAttributeItem
```

Get all of a products attribute items

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\ProductAttributeItemsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | The product ID

try {
    $result = $apiInstance->apiV1ProductsByIdAttributesGet($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductAttributeItemsApi->apiV1ProductsByIdAttributesGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| The product ID | |

### Return type

[**\EKM\Model\TempestResponseListProductAttributeItem**](../Model/TempestResponseListProductAttributeItem.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1ProductsByIdAttributesPost()`

```php
apiV1ProductsByIdAttributesPost($id, $model): \EKM\Model\TempestResponseProductAttributeItem
```

Add a attribute item to a product

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\ProductAttributeItemsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | The product ID
$model = new \EKM\Model\ProductAttributeItem(); // \EKM\Model\ProductAttributeItem | The product attribute item to update

try {
    $result = $apiInstance->apiV1ProductsByIdAttributesPost($id, $model);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductAttributeItemsApi->apiV1ProductsByIdAttributesPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| The product ID | |
| **model** | [**\EKM\Model\ProductAttributeItem**](../Model/ProductAttributeItem.md)| The product attribute item to update | [optional] |

### Return type

[**\EKM\Model\TempestResponseProductAttributeItem**](../Model/TempestResponseProductAttributeItem.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
