# EKM\PlansApi

All URIs are relative to https://api.ekm.net, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1SettingsPlansByIdGet()**](PlansApi.md#apiV1SettingsPlansByIdGet) | **GET** /api/v1/settings/plans/{id} | Get a plan by id |
| [**apiV1SettingsPlansCurrentGet()**](PlansApi.md#apiV1SettingsPlansCurrentGet) | **GET** /api/v1/settings/plans/current | Get the current users plan |
| [**apiV1SettingsPlansGet()**](PlansApi.md#apiV1SettingsPlansGet) | **GET** /api/v1/settings/plans | Get all plans |


## `apiV1SettingsPlansByIdGet()`

```php
apiV1SettingsPlansByIdGet($id): \EKM\Model\TempestResponsePlan
```

Get a plan by id

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\PlansApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 'id_example'; // string

try {
    $result = $apiInstance->apiV1SettingsPlansByIdGet($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PlansApi->apiV1SettingsPlansByIdGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **string**|  | |

### Return type

[**\EKM\Model\TempestResponsePlan**](../Model/TempestResponsePlan.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1SettingsPlansCurrentGet()`

```php
apiV1SettingsPlansCurrentGet(): \EKM\Model\TempestResponsePlan
```

Get the current users plan

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\PlansApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->apiV1SettingsPlansCurrentGet();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PlansApi->apiV1SettingsPlansCurrentGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\EKM\Model\TempestResponsePlan**](../Model/TempestResponsePlan.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1SettingsPlansGet()`

```php
apiV1SettingsPlansGet(): \EKM\Model\TempestResponseListPlan
```

Get all plans

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\PlansApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->apiV1SettingsPlansGet();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PlansApi->apiV1SettingsPlansGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\EKM\Model\TempestResponseListPlan**](../Model/TempestResponseListPlan.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
