# EKM\CustomersApi

All URIs are relative to https://api.ekm.net, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1CustomersByIdDelete()**](CustomersApi.md#apiV1CustomersByIdDelete) | **DELETE** /api/v1/customers/{id} | Delete a Customer |
| [**apiV1CustomersByIdGet()**](CustomersApi.md#apiV1CustomersByIdGet) | **GET** /api/v1/customers/{id} | Get a single Customer by Id |
| [**apiV1CustomersByIdPut()**](CustomersApi.md#apiV1CustomersByIdPut) | **PUT** /api/v1/customers/{id} | Update a Customer |
| [**apiV1CustomersGet()**](CustomersApi.md#apiV1CustomersGet) | **GET** /api/v1/customers | Get a paginated set of Customers |
| [**apiV1CustomersPost()**](CustomersApi.md#apiV1CustomersPost) | **POST** /api/v1/customers | Add a customer |
| [**apiV1CustomersSearchGet()**](CustomersApi.md#apiV1CustomersSearchGet) | **GET** /api/v1/customers/search | Searches customers based on search criteria |


## `apiV1CustomersByIdDelete()`

```php
apiV1CustomersByIdDelete($id): \EKM\Model\TempestResponseCustomer
```

Delete a Customer

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int

try {
    $result = $apiInstance->apiV1CustomersByIdDelete($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->apiV1CustomersByIdDelete: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |

### Return type

[**\EKM\Model\TempestResponseCustomer**](../Model/TempestResponseCustomer.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1CustomersByIdGet()`

```php
apiV1CustomersByIdGet($id): \EKM\Model\TempestResponseCustomer
```

Get a single Customer by Id

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | The Customers Id

try {
    $result = $apiInstance->apiV1CustomersByIdGet($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->apiV1CustomersByIdGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| The Customers Id | |

### Return type

[**\EKM\Model\TempestResponseCustomer**](../Model/TempestResponseCustomer.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1CustomersByIdPut()`

```php
apiV1CustomersByIdPut($id, $customer): \EKM\Model\TempestResponseCustomer
```

Update a Customer

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int
$customer = new \EKM\Model\UpdateCustomer(); // \EKM\Model\UpdateCustomer

try {
    $result = $apiInstance->apiV1CustomersByIdPut($id, $customer);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->apiV1CustomersByIdPut: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |
| **customer** | [**\EKM\Model\UpdateCustomer**](../Model/UpdateCustomer.md)|  | [optional] |

### Return type

[**\EKM\Model\TempestResponseCustomer**](../Model/TempestResponseCustomer.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1CustomersGet()`

```php
apiV1CustomersGet($page, $limit): \EKM\Model\TempestResponseListCustomer
```

Get a paginated set of Customers

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page = 1; // int | Page number to display
$limit = 10; // int | Items per page (maximum 20)

try {
    $result = $apiInstance->apiV1CustomersGet($page, $limit);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->apiV1CustomersGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page** | **int**| Page number to display | [optional] [default to 1] |
| **limit** | **int**| Items per page (maximum 20) | [optional] [default to 10] |

### Return type

[**\EKM\Model\TempestResponseListCustomer**](../Model/TempestResponseListCustomer.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1CustomersPost()`

```php
apiV1CustomersPost($customer): \EKM\Model\TempestResponseCustomer
```

Add a customer

Note: setting send_email to true will send an email to the customer prompting them to create a password

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer = new \EKM\Model\AddCustomer(); // \EKM\Model\AddCustomer

try {
    $result = $apiInstance->apiV1CustomersPost($customer);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->apiV1CustomersPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **customer** | [**\EKM\Model\AddCustomer**](../Model/AddCustomer.md)|  | [optional] |

### Return type

[**\EKM\Model\TempestResponseCustomer**](../Model/TempestResponseCustomer.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1CustomersSearchGet()`

```php
apiV1CustomersSearchGet($page, $limit, $query, $orderby): \EKM\Model\TempestResponseListCustomer
```

Searches customers based on search criteria

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page = 1; // int | Page number to display
$limit = 10; // int | Items per page (maximum 20)
$query = 'query_example'; // string | A <a href=\"#tag/OData\" target=\"_blank\">search</a> query e.g. email_address eq 'test@ekm.com'
$orderby = 'orderby_example'; // string | Field to order results. Prefix with a - (dash) for descending e.g. -id

try {
    $result = $apiInstance->apiV1CustomersSearchGet($page, $limit, $query, $orderby);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->apiV1CustomersSearchGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page** | **int**| Page number to display | [optional] [default to 1] |
| **limit** | **int**| Items per page (maximum 20) | [optional] [default to 10] |
| **query** | **string**| A &lt;a href&#x3D;\&quot;#tag/OData\&quot; target&#x3D;\&quot;_blank\&quot;&gt;search&lt;/a&gt; query e.g. email_address eq &#39;test@ekm.com&#39; | [optional] |
| **orderby** | **string**| Field to order results. Prefix with a - (dash) for descending e.g. -id | [optional] |

### Return type

[**\EKM\Model\TempestResponseListCustomer**](../Model/TempestResponseListCustomer.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
