# EKM\CategoriesApi

All URIs are relative to https://api.ekm.net, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1CategoriesByIdCategorymanagedByChildCategoryIdDelete()**](CategoriesApi.md#apiV1CategoriesByIdCategorymanagedByChildCategoryIdDelete) | **DELETE** /api/v1/categories/{id}/categorymanaged/{childCategoryId} | Stops a category from being managed by another category |
| [**apiV1CategoriesByIdCategorymanagedByChildCategoryIdPost()**](CategoriesApi.md#apiV1CategoriesByIdCategorymanagedByChildCategoryIdPost) | **POST** /api/v1/categories/{id}/categorymanaged/{childCategoryId} | Set a category to be managed by another category |
| [**apiV1CategoriesByIdDelete()**](CategoriesApi.md#apiV1CategoriesByIdDelete) | **DELETE** /api/v1/categories/{id} | Delete a category |
| [**apiV1CategoriesByIdGet()**](CategoriesApi.md#apiV1CategoriesByIdGet) | **GET** /api/v1/categories/{id} | Get a category |
| [**apiV1CategoriesByIdPut()**](CategoriesApi.md#apiV1CategoriesByIdPut) | **PUT** /api/v1/categories/{id} | Update a category |
| [**apiV1CategoriesByIdSubcategoriesGet()**](CategoriesApi.md#apiV1CategoriesByIdSubcategoriesGet) | **GET** /api/v1/categories/{id}/subcategories | Get a paginated set of subcategories |
| [**apiV1CategoriesGet()**](CategoriesApi.md#apiV1CategoriesGet) | **GET** /api/v1/categories | Get a paginated set of categories |
| [**apiV1CategoriesPost()**](CategoriesApi.md#apiV1CategoriesPost) | **POST** /api/v1/categories | Add a category |
| [**apiV1CategoriesSearchGet()**](CategoriesApi.md#apiV1CategoriesSearchGet) | **GET** /api/v1/categories/search | Searches categories based on search criteria |


## `apiV1CategoriesByIdCategorymanagedByChildCategoryIdDelete()`

```php
apiV1CategoriesByIdCategorymanagedByChildCategoryIdDelete($id, $childCategoryId): \EKM\Model\TempestResponseSubCategory
```

Stops a category from being managed by another category

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\CategoriesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int
$childCategoryId = 56; // int

try {
    $result = $apiInstance->apiV1CategoriesByIdCategorymanagedByChildCategoryIdDelete($id, $childCategoryId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CategoriesApi->apiV1CategoriesByIdCategorymanagedByChildCategoryIdDelete: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |
| **childCategoryId** | **int**|  | |

### Return type

[**\EKM\Model\TempestResponseSubCategory**](../Model/TempestResponseSubCategory.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1CategoriesByIdCategorymanagedByChildCategoryIdPost()`

```php
apiV1CategoriesByIdCategorymanagedByChildCategoryIdPost($id, $childCategoryId): \EKM\Model\TempestResponseSubCategory
```

Set a category to be managed by another category

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\CategoriesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int
$childCategoryId = 56; // int

try {
    $result = $apiInstance->apiV1CategoriesByIdCategorymanagedByChildCategoryIdPost($id, $childCategoryId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CategoriesApi->apiV1CategoriesByIdCategorymanagedByChildCategoryIdPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |
| **childCategoryId** | **int**|  | |

### Return type

[**\EKM\Model\TempestResponseSubCategory**](../Model/TempestResponseSubCategory.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1CategoriesByIdDelete()`

```php
apiV1CategoriesByIdDelete($id): \EKM\Model\TempestResponseCategory
```

Delete a category

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\CategoriesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | The category ID

try {
    $result = $apiInstance->apiV1CategoriesByIdDelete($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CategoriesApi->apiV1CategoriesByIdDelete: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| The category ID | |

### Return type

[**\EKM\Model\TempestResponseCategory**](../Model/TempestResponseCategory.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1CategoriesByIdGet()`

```php
apiV1CategoriesByIdGet($id): \EKM\Model\TempestResponseCategory
```

Get a category

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\CategoriesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | The category ID

try {
    $result = $apiInstance->apiV1CategoriesByIdGet($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CategoriesApi->apiV1CategoriesByIdGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| The category ID | |

### Return type

[**\EKM\Model\TempestResponseCategory**](../Model/TempestResponseCategory.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1CategoriesByIdPut()`

```php
apiV1CategoriesByIdPut($id, $model): \EKM\Model\TempestResponseCategory
```

Update a category

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\CategoriesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | The category ID
$model = new \EKM\Model\UpdateCategory(); // \EKM\Model\UpdateCategory

try {
    $result = $apiInstance->apiV1CategoriesByIdPut($id, $model);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CategoriesApi->apiV1CategoriesByIdPut: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| The category ID | |
| **model** | [**\EKM\Model\UpdateCategory**](../Model/UpdateCategory.md)|  | [optional] |

### Return type

[**\EKM\Model\TempestResponseCategory**](../Model/TempestResponseCategory.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1CategoriesByIdSubcategoriesGet()`

```php
apiV1CategoriesByIdSubcategoriesGet($id): \EKM\Model\TempestResponseListSubCategory
```

Get a paginated set of subcategories

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\CategoriesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int

try {
    $result = $apiInstance->apiV1CategoriesByIdSubcategoriesGet($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CategoriesApi->apiV1CategoriesByIdSubcategoriesGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |

### Return type

[**\EKM\Model\TempestResponseListSubCategory**](../Model/TempestResponseListSubCategory.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1CategoriesGet()`

```php
apiV1CategoriesGet($page, $limit): \EKM\Model\TempestResponseListCategory
```

Get a paginated set of categories

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\CategoriesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page = 1; // int | Page number to display
$limit = 10; // int | Items per page (maximum 20)

try {
    $result = $apiInstance->apiV1CategoriesGet($page, $limit);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CategoriesApi->apiV1CategoriesGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page** | **int**| Page number to display | [optional] [default to 1] |
| **limit** | **int**| Items per page (maximum 20) | [optional] [default to 10] |

### Return type

[**\EKM\Model\TempestResponseListCategory**](../Model/TempestResponseListCategory.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1CategoriesPost()`

```php
apiV1CategoriesPost($model): \EKM\Model\TempestResponseCategory
```

Add a category

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\CategoriesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$model = new \EKM\Model\AddCategory(); // \EKM\Model\AddCategory

try {
    $result = $apiInstance->apiV1CategoriesPost($model);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CategoriesApi->apiV1CategoriesPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **model** | [**\EKM\Model\AddCategory**](../Model/AddCategory.md)|  | [optional] |

### Return type

[**\EKM\Model\TempestResponseCategory**](../Model/TempestResponseCategory.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1CategoriesSearchGet()`

```php
apiV1CategoriesSearchGet($page, $limit, $query, $orderby): \EKM\Model\TempestResponseListCategory
```

Searches categories based on search criteria

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\CategoriesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page = 1; // int | Page number to display
$limit = 10; // int | Items per page (maximum 20)
$query = 'query_example'; // string | A <a href=\"#tag/OData\" target=\"_blank\">search</a> query e.g. live eq true
$orderby = 'orderby_example'; // string | Field to order results. Prefix with a - (dash) for descending e.g. -id

try {
    $result = $apiInstance->apiV1CategoriesSearchGet($page, $limit, $query, $orderby);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CategoriesApi->apiV1CategoriesSearchGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page** | **int**| Page number to display | [optional] [default to 1] |
| **limit** | **int**| Items per page (maximum 20) | [optional] [default to 10] |
| **query** | **string**| A &lt;a href&#x3D;\&quot;#tag/OData\&quot; target&#x3D;\&quot;_blank\&quot;&gt;search&lt;/a&gt; query e.g. live eq true | [optional] |
| **orderby** | **string**| Field to order results. Prefix with a - (dash) for descending e.g. -id | [optional] |

### Return type

[**\EKM\Model\TempestResponseListCategory**](../Model/TempestResponseListCategory.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
