# OpenAPIClient-php

Our new API allows partners to build significantly better integrations with the EKM platform.    To try out the below endpoints, or for full up to date representations of the request / response models, please see the [swagger page](https://api.ekm.net/swagger/index.html). (We display examples here, but the swagger page is guaranteed to show the complete model.)    To keep up to date with the latest updates, please see our [RSS feed](https://partners.ekm.net/ChangeLog/Feed) or the [partner dashboard](https://partners.ekm.net/).

This PHP package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v1
- Package version: 1.0
- Build package: org.openapitools.codegen.languages.PhpClientCodegen
For more information, please visit [https://ekm.com](https://ekm.com)

## Requirements

PHP 5.5 and later

## Installation & Usage

### Composer

To install the bindings via [Composer](http://getcomposer.org/), add the following to `composer.json`:

```json
{
  "repositories": [
    {
      "type": "vcs",
      "url": "https://github.com/Talisman/EKM.git"
    }
  ],
  "require": {
    "Talisman/EKM": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
    require_once('/path/to/OpenAPIClient-php/vendor/autoload.php');
```

## Tests

To run the unit tests:

```bash
composer install
./vendor/bin/phpunit
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\CategoriesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | 
$childCategoryId = 56; // int | 

try {
    $result = $apiInstance->apiV1CategoriesByIdCategorymanagedByChildCategoryIdDelete($id, $childCategoryId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CategoriesApi->apiV1CategoriesByIdCategorymanagedByChildCategoryIdDelete: ', $e->getMessage(), PHP_EOL;
}

?>
```

## Documentation for API Endpoints

All URIs are relative to *https://api.ekm.net*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*CategoriesApi* | [**apiV1CategoriesByIdCategorymanagedByChildCategoryIdDelete**](1.0/docs/Api/CategoriesApi.md#apiv1categoriesbyidcategorymanagedbychildcategoryiddelete) | **DELETE** /api/v1/categories/{id}/categorymanaged/{childCategoryId} | Stops a category from being managed by another category
*CategoriesApi* | [**apiV1CategoriesByIdCategorymanagedByChildCategoryIdPost**](1.0/docs/Api/CategoriesApi.md#apiv1categoriesbyidcategorymanagedbychildcategoryidpost) | **POST** /api/v1/categories/{id}/categorymanaged/{childCategoryId} | Set a category to be managed by another category
*CategoriesApi* | [**apiV1CategoriesByIdDelete**](1.0/docs/Api/CategoriesApi.md#apiv1categoriesbyiddelete) | **DELETE** /api/v1/categories/{id} | Delete a category
*CategoriesApi* | [**apiV1CategoriesByIdGet**](1.0/docs/Api/CategoriesApi.md#apiv1categoriesbyidget) | **GET** /api/v1/categories/{id} | Get a category
*CategoriesApi* | [**apiV1CategoriesByIdPut**](1.0/docs/Api/CategoriesApi.md#apiv1categoriesbyidput) | **PUT** /api/v1/categories/{id} | Update a category
*CategoriesApi* | [**apiV1CategoriesByIdSubcategoriesGet**](1.0/docs/Api/CategoriesApi.md#apiv1categoriesbyidsubcategoriesget) | **GET** /api/v1/categories/{id}/subcategories | Get a paginated set of subcategories
*CategoriesApi* | [**apiV1CategoriesGet**](1.0/docs/Api/CategoriesApi.md#apiv1categoriesget) | **GET** /api/v1/categories | Get a paginated set of categories
*CategoriesApi* | [**apiV1CategoriesPost**](1.0/docs/Api/CategoriesApi.md#apiv1categoriespost) | **POST** /api/v1/categories | Add a category
*CategoriesApi* | [**apiV1CategoriesSearchGet**](1.0/docs/Api/CategoriesApi.md#apiv1categoriessearchget) | **GET** /api/v1/categories/search | Searches categories based on search criteria
*CustomerAddressesApi* | [**apiV1CustomersByCustomerIdAddressesByAddressIdDelete**](1.0/docs/Api/CustomerAddressesApi.md#apiv1customersbycustomeridaddressesbyaddressiddelete) | **DELETE** /api/v1/customers/{customerId}/addresses/{addressId} | Delete a Customer Address
*CustomerAddressesApi* | [**apiV1CustomersByCustomerIdAddressesByAddressIdGet**](1.0/docs/Api/CustomerAddressesApi.md#apiv1customersbycustomeridaddressesbyaddressidget) | **GET** /api/v1/customers/{customerId}/addresses/{addressId} | Get a single Customer Address by Id
*CustomerAddressesApi* | [**apiV1CustomersByCustomerIdAddressesByAddressIdPut**](1.0/docs/Api/CustomerAddressesApi.md#apiv1customersbycustomeridaddressesbyaddressidput) | **PUT** /api/v1/customers/{customerId}/addresses/{addressId} | Update a Customer Address
*CustomerAddressesApi* | [**apiV1CustomersByCustomerIdAddressesGet**](1.0/docs/Api/CustomerAddressesApi.md#apiv1customersbycustomeridaddressesget) | **GET** /api/v1/customers/{customerId}/addresses | Get a paginated set of Customer Addresses
*CustomerAddressesApi* | [**apiV1CustomersByCustomerIdAddressesPost**](1.0/docs/Api/CustomerAddressesApi.md#apiv1customersbycustomeridaddressespost) | **POST** /api/v1/customers/{customerId}/addresses | Add a Customer Address
*CustomerAddressesApi* | [**apiV1CustomersByCustomerIdAddressesSearchGet**](1.0/docs/Api/CustomerAddressesApi.md#apiv1customersbycustomeridaddressessearchget) | **GET** /api/v1/customers/{customerId}/addresses/search | Searches customer addresses based on search criteria
*CustomersApi* | [**apiV1CustomersByIdDelete**](1.0/docs/Api/CustomersApi.md#apiv1customersbyiddelete) | **DELETE** /api/v1/customers/{id} | Delete a Customer
*CustomersApi* | [**apiV1CustomersByIdGet**](1.0/docs/Api/CustomersApi.md#apiv1customersbyidget) | **GET** /api/v1/customers/{id} | Get a single Customer by Id
*CustomersApi* | [**apiV1CustomersByIdPut**](1.0/docs/Api/CustomersApi.md#apiv1customersbyidput) | **PUT** /api/v1/customers/{id} | Update a Customer
*CustomersApi* | [**apiV1CustomersGet**](1.0/docs/Api/CustomersApi.md#apiv1customersget) | **GET** /api/v1/customers | Get a paginated set of Customers
*CustomersApi* | [**apiV1CustomersPost**](1.0/docs/Api/CustomersApi.md#apiv1customerspost) | **POST** /api/v1/customers | Add a customer
*CustomersApi* | [**apiV1CustomersSearchGet**](1.0/docs/Api/CustomersApi.md#apiv1customerssearchget) | **GET** /api/v1/customers/search | Searches customers based on search criteria
*DomainsApi* | [**apiV1SettingsDomainsGet**](1.0/docs/Api/DomainsApi.md#apiv1settingsdomainsget) | **GET** /api/v1/settings/domains | Get the current Primary Domain
*OrderStatusesApi* | [**apiV1SettingsOrderstatusesGet**](1.0/docs/Api/OrderStatusesApi.md#apiv1settingsorderstatusesget) | **GET** /api/v1/settings/orderstatuses | Get the current Order Statuses
*OrdersApi* | [**apiV1OrdersByIdGet**](1.0/docs/Api/OrdersApi.md#apiv1ordersbyidget) | **GET** /api/v1/orders/{id} | Get a single Order by Id
*OrdersApi* | [**apiV1OrdersByIdStatusPut**](1.0/docs/Api/OrdersApi.md#apiv1ordersbyidstatusput) | **PUT** /api/v1/orders/{id}/status | Updates the status of a chosen order
*OrdersApi* | [**apiV1OrdersGet**](1.0/docs/Api/OrdersApi.md#apiv1ordersget) | **GET** /api/v1/orders | Get a paginated set of orders
*OrdersApi* | [**apiV1OrdersSearchGet**](1.0/docs/Api/OrdersApi.md#apiv1orderssearchget) | **GET** /api/v1/orders/search | Searches orders based on search criteria
*PlansApi* | [**apiV1SettingsPlansByIdGet**](1.0/docs/Api/PlansApi.md#apiv1settingsplansbyidget) | **GET** /api/v1/settings/plans/{id} | Get a plan by id
*PlansApi* | [**apiV1SettingsPlansCurrentGet**](1.0/docs/Api/PlansApi.md#apiv1settingsplanscurrentget) | **GET** /api/v1/settings/plans/current | Get the current users plan
*PlansApi* | [**apiV1SettingsPlansGet**](1.0/docs/Api/PlansApi.md#apiv1settingsplansget) | **GET** /api/v1/settings/plans | Get all plans
*ProductAttributeItemsApi* | [**apiV1ProductsByIdAttributesByAttrIdDelete**](1.0/docs/Api/ProductAttributeItemsApi.md#apiv1productsbyidattributesbyattriddelete) | **DELETE** /api/v1/products/{id}/attributes/{attrId} | Delete an attribute item
*ProductAttributeItemsApi* | [**apiV1ProductsByIdAttributesByAttributeKeyGet**](1.0/docs/Api/ProductAttributeItemsApi.md#apiv1productsbyidattributesbyattributekeyget) | **GET** /api/v1/products/{id}/attributes/{attribute_key} | Get a product attribute item
*ProductAttributeItemsApi* | [**apiV1ProductsByIdAttributesByAttributeKeyPut**](1.0/docs/Api/ProductAttributeItemsApi.md#apiv1productsbyidattributesbyattributekeyput) | **PUT** /api/v1/products/{id}/attributes/{attribute_key} | Update a product attribute item
*ProductAttributeItemsApi* | [**apiV1ProductsByIdAttributesGet**](1.0/docs/Api/ProductAttributeItemsApi.md#apiv1productsbyidattributesget) | **GET** /api/v1/products/{id}/attributes | Get all of a products attribute items
*ProductAttributeItemsApi* | [**apiV1ProductsByIdAttributesPost**](1.0/docs/Api/ProductAttributeItemsApi.md#apiv1productsbyidattributespost) | **POST** /api/v1/products/{id}/attributes | Add a attribute item to a product
*ProductAttributesApi* | [**apiV1SettingsProductattributesByAttributeKeyDelete**](1.0/docs/Api/ProductAttributesApi.md#apiv1settingsproductattributesbyattributekeydelete) | **DELETE** /api/v1/settings/productattributes/{attribute_key} | Delete a product attribute
*ProductAttributesApi* | [**apiV1SettingsProductattributesByAttributeKeyGet**](1.0/docs/Api/ProductAttributesApi.md#apiv1settingsproductattributesbyattributekeyget) | **GET** /api/v1/settings/productattributes/{attribute_key} | Get a product attribute
*ProductAttributesApi* | [**apiV1SettingsProductattributesByAttributeKeyPut**](1.0/docs/Api/ProductAttributesApi.md#apiv1settingsproductattributesbyattributekeyput) | **PUT** /api/v1/settings/productattributes/{attribute_key} | Update a product attribute
*ProductAttributesApi* | [**apiV1SettingsProductattributesGet**](1.0/docs/Api/ProductAttributesApi.md#apiv1settingsproductattributesget) | **GET** /api/v1/settings/productattributes | Get all product attributes
*ProductAttributesApi* | [**apiV1SettingsProductattributesPost**](1.0/docs/Api/ProductAttributesApi.md#apiv1settingsproductattributespost) | **POST** /api/v1/settings/productattributes | Add a product attribute
*ProductOptionItemsApi* | [**apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdDelete**](1.0/docs/Api/ProductOptionItemsApi.md#apiv1productsbyidoptionsbyoptioniditemsbyoptionitemiddelete) | **DELETE** /api/v1/products/{id}/options/{optionId}/items/{optionItemId} | Delete an option item
*ProductOptionItemsApi* | [**apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdPut**](1.0/docs/Api/ProductOptionItemsApi.md#apiv1productsbyidoptionsbyoptioniditemsbyoptionitemidput) | **PUT** /api/v1/products/{id}/options/{optionId}/items/{optionItemId} | Update a product option item
*ProductOptionItemsApi* | [**apiV1ProductsByIdOptionsByOptionIdItemsPost**](1.0/docs/Api/ProductOptionItemsApi.md#apiv1productsbyidoptionsbyoptioniditemspost) | **POST** /api/v1/products/{id}/options/{optionId}/items | Add an item to a product option
*ProductOptionsApi* | [**apiV1ProductsByIdOptionsByOptionIdDelete**](1.0/docs/Api/ProductOptionsApi.md#apiv1productsbyidoptionsbyoptioniddelete) | **DELETE** /api/v1/products/{id}/options/{optionId} | Delete an option
*ProductOptionsApi* | [**apiV1ProductsByIdOptionsByOptionIdGet**](1.0/docs/Api/ProductOptionsApi.md#apiv1productsbyidoptionsbyoptionidget) | **GET** /api/v1/products/{id}/options/{optionId} | Get a product option
*ProductOptionsApi* | [**apiV1ProductsByIdOptionsByOptionIdPut**](1.0/docs/Api/ProductOptionsApi.md#apiv1productsbyidoptionsbyoptionidput) | **PUT** /api/v1/products/{id}/options/{optionId} | Update a product option
*ProductOptionsApi* | [**apiV1ProductsByIdOptionsGet**](1.0/docs/Api/ProductOptionsApi.md#apiv1productsbyidoptionsget) | **GET** /api/v1/products/{id}/options | Get a products options
*ProductOptionsApi* | [**apiV1ProductsByIdOptionsPost**](1.0/docs/Api/ProductOptionsApi.md#apiv1productsbyidoptionspost) | **POST** /api/v1/products/{id}/options | Add an option to a product
*ProductStockApi* | [**apiV1ProductsByIdStockGet**](1.0/docs/Api/ProductStockApi.md#apiv1productsbyidstockget) | **GET** /api/v1/products/{id}/stock | Get the stock for a product
*ProductStockApi* | [**apiV1ProductsByIdStockPut**](1.0/docs/Api/ProductStockApi.md#apiv1productsbyidstockput) | **PUT** /api/v1/products/{id}/stock | Set the stock for a product
*ProductVariantStockApi* | [**apiV1ProductsByIdVariantsByVariantIdStockGet**](1.0/docs/Api/ProductVariantStockApi.md#apiv1productsbyidvariantsbyvariantidstockget) | **GET** /api/v1/products/{id}/variants/{variantId}/stock | Get a product variant stock
*ProductVariantStockApi* | [**apiV1ProductsByIdVariantsByVariantIdStockPut**](1.0/docs/Api/ProductVariantStockApi.md#apiv1productsbyidvariantsbyvariantidstockput) | **PUT** /api/v1/products/{id}/variants/{variantId}/stock | Update a product variant stock
*ProductVariantsApi* | [**apiV1ProductsByIdVariantsByVariantIdDelete**](1.0/docs/Api/ProductVariantsApi.md#apiv1productsbyidvariantsbyvariantiddelete) | **DELETE** /api/v1/products/{id}/variants/{variantId} | Delete a variant
*ProductVariantsApi* | [**apiV1ProductsByIdVariantsByVariantIdGet**](1.0/docs/Api/ProductVariantsApi.md#apiv1productsbyidvariantsbyvariantidget) | **GET** /api/v1/products/{id}/variants/{variantId} | Get a product variant
*ProductVariantsApi* | [**apiV1ProductsByIdVariantsByVariantIdImagesByImageNumberPost**](1.0/docs/Api/ProductVariantsApi.md#apiv1productsbyidvariantsbyvariantidimagesbyimagenumberpost) | **POST** /api/v1/products/{id}/variants/{variantId}/images/{imageNumber} | Set a variants image to a URL
*ProductVariantsApi* | [**apiV1ProductsByIdVariantsByVariantIdImagesGet**](1.0/docs/Api/ProductVariantsApi.md#apiv1productsbyidvariantsbyvariantidimagesget) | **GET** /api/v1/products/{id}/variants/{variantId}/images | Get a variant&#39;s images.
*ProductVariantsApi* | [**apiV1ProductsByIdVariantsByVariantIdPut**](1.0/docs/Api/ProductVariantsApi.md#apiv1productsbyidvariantsbyvariantidput) | **PUT** /api/v1/products/{id}/variants/{variantId} | Update a product variant
*ProductVariantsApi* | [**apiV1ProductsByIdVariantsGet**](1.0/docs/Api/ProductVariantsApi.md#apiv1productsbyidvariantsget) | **GET** /api/v1/products/{id}/variants | Get a products variants
*ProductVariantsApi* | [**apiV1ProductsByIdVariantsPost**](1.0/docs/Api/ProductVariantsApi.md#apiv1productsbyidvariantspost) | **POST** /api/v1/products/{id}/variants | Add a variant to a product
*ProductVariantsApi* | [**apiV1ProductsVariantsByVariantIdGet**](1.0/docs/Api/ProductVariantsApi.md#apiv1productsvariantsbyvariantidget) | **GET** /api/v1/products/variants/{variantId} | Get a product variant
*ProductVariantsApi* | [**apiV1VariantsSearchGet**](1.0/docs/Api/ProductVariantsApi.md#apiv1variantssearchget) | **GET** /api/v1/variants/search | Searches variants based on search criteria
*ProductsApi* | [**apiV1ProductsByIdCategorymanagedByCategoryIdDelete**](1.0/docs/Api/ProductsApi.md#apiv1productsbyidcategorymanagedbycategoryiddelete) | **DELETE** /api/v1/products/{id}/categorymanaged/{categoryId} | Stops a product from being managed by another category
*ProductsApi* | [**apiV1ProductsByIdCategorymanagedByCategoryIdPost**](1.0/docs/Api/ProductsApi.md#apiv1productsbyidcategorymanagedbycategoryidpost) | **POST** /api/v1/products/{id}/categorymanaged/{categoryId} | Set a product to be managed by another category
*ProductsApi* | [**apiV1ProductsByIdDelete**](1.0/docs/Api/ProductsApi.md#apiv1productsbyiddelete) | **DELETE** /api/v1/products/{id} | Delete a Product
*ProductsApi* | [**apiV1ProductsByIdGet**](1.0/docs/Api/ProductsApi.md#apiv1productsbyidget) | **GET** /api/v1/products/{id} | Get a product
*ProductsApi* | [**apiV1ProductsByIdImagesByImageNumberPost**](1.0/docs/Api/ProductsApi.md#apiv1productsbyidimagesbyimagenumberpost) | **POST** /api/v1/products/{id}/images/{imageNumber} | Assign an image by Url to a product
*ProductsApi* | [**apiV1ProductsByIdImagesGet**](1.0/docs/Api/ProductsApi.md#apiv1productsbyidimagesget) | **GET** /api/v1/products/{id}/images | Get a product&#39;s images.
*ProductsApi* | [**apiV1ProductsByIdPut**](1.0/docs/Api/ProductsApi.md#apiv1productsbyidput) | **PUT** /api/v1/products/{id} | Update a Product
*ProductsApi* | [**apiV1ProductsGet**](1.0/docs/Api/ProductsApi.md#apiv1productsget) | **GET** /api/v1/products | Get a paginated set of products
*ProductsApi* | [**apiV1ProductsPost**](1.0/docs/Api/ProductsApi.md#apiv1productspost) | **POST** /api/v1/products | Add a Product
*ProductsApi* | [**apiV1ProductsSearchGet**](1.0/docs/Api/ProductsApi.md#apiv1productssearchget) | **GET** /api/v1/products/search | Searches products based on search criteria
*TaxApi* | [**apiV1SettingsTaxGet**](1.0/docs/Api/TaxApi.md#apiv1settingstaxget) | **GET** /api/v1/settings/tax | Get the current Tax Settings
*TaxApi* | [**apiV1SettingsTaxPut**](1.0/docs/Api/TaxApi.md#apiv1settingstaxput) | **PUT** /api/v1/settings/tax | Update the current Tax Settings
*TaxApi* | [**apiV1SettingsTaxRatesByIdDelete**](1.0/docs/Api/TaxApi.md#apiv1settingstaxratesbyiddelete) | **DELETE** /api/v1/settings/tax/rates/{id} | Delete a Tax Rate
*TaxApi* | [**apiV1SettingsTaxRatesByIdGet**](1.0/docs/Api/TaxApi.md#apiv1settingstaxratesbyidget) | **GET** /api/v1/settings/tax/rates/{id} | Get a specific Tax Rate
*TaxApi* | [**apiV1SettingsTaxRatesByIdPut**](1.0/docs/Api/TaxApi.md#apiv1settingstaxratesbyidput) | **PUT** /api/v1/settings/tax/rates/{id} | Update a Tax Rate
*TaxApi* | [**apiV1SettingsTaxRatesGet**](1.0/docs/Api/TaxApi.md#apiv1settingstaxratesget) | **GET** /api/v1/settings/tax/rates | Get a list of Tax Rates
*TaxApi* | [**apiV1SettingsTaxRatesPost**](1.0/docs/Api/TaxApi.md#apiv1settingstaxratespost) | **POST** /api/v1/settings/tax/rates | Add a Tax Rate
*TaxApi* | [**apiV1SettingsTaxRatesStandardGet**](1.0/docs/Api/TaxApi.md#apiv1settingstaxratesstandardget) | **GET** /api/v1/settings/tax/rates/standard | Get the standard Tax Rate
*WebhooksApi* | [**apiV1WebhooksDelete**](1.0/docs/Api/WebhooksApi.md#apiv1webhooksdelete) | **DELETE** /api/v1/webhooks | Unsubscribe from a webhook
*WebhooksApi* | [**apiV1WebhooksPut**](1.0/docs/Api/WebhooksApi.md#apiv1webhooksput) | **PUT** /api/v1/webhooks | Subscribe to a webhook


## Documentation For Models

 - [AddCategory](1.0/docs/Model/AddCategory.md)
 - [AddCustomer](1.0/docs/Model/AddCustomer.md)
 - [AddProduct](1.0/docs/Model/AddProduct.md)
 - [AddProductOption](1.0/docs/Model/AddProductOption.md)
 - [Category](1.0/docs/Model/Category.md)
 - [CountryCodeModel](1.0/docs/Model/CountryCodeModel.md)
 - [Customer](1.0/docs/Model/Customer.md)
 - [CustomerAddress](1.0/docs/Model/CustomerAddress.md)
 - [DomainName](1.0/docs/Model/DomainName.md)
 - [Order](1.0/docs/Model/Order.md)
 - [OrderCustomerDetails](1.0/docs/Model/OrderCustomerDetails.md)
 - [OrderItem](1.0/docs/Model/OrderItem.md)
 - [OrderStatus](1.0/docs/Model/OrderStatus.md)
 - [OrderStatusSetting](1.0/docs/Model/OrderStatusSetting.md)
 - [OrderStatuses](1.0/docs/Model/OrderStatuses.md)
 - [Plan](1.0/docs/Model/Plan.md)
 - [PlanRestriction](1.0/docs/Model/PlanRestriction.md)
 - [Product](1.0/docs/Model/Product.md)
 - [ProductAttribute](1.0/docs/Model/ProductAttribute.md)
 - [ProductAttributeItem](1.0/docs/Model/ProductAttributeItem.md)
 - [ProductCategory](1.0/docs/Model/ProductCategory.md)
 - [ProductImage](1.0/docs/Model/ProductImage.md)
 - [ProductImages](1.0/docs/Model/ProductImages.md)
 - [ProductOption](1.0/docs/Model/ProductOption.md)
 - [ProductOptionItem](1.0/docs/Model/ProductOptionItem.md)
 - [ProductStock](1.0/docs/Model/ProductStock.md)
 - [ProductVariant](1.0/docs/Model/ProductVariant.md)
 - [ProductVariantStock](1.0/docs/Model/ProductVariantStock.md)
 - [ShippingAddress](1.0/docs/Model/ShippingAddress.md)
 - [SubCategory](1.0/docs/Model/SubCategory.md)
 - [TaxRateModel](1.0/docs/Model/TaxRateModel.md)
 - [TaxSettings](1.0/docs/Model/TaxSettings.md)
 - [TempestLink](1.0/docs/Model/TempestLink.md)
 - [TempestResponseCategory](1.0/docs/Model/TempestResponseCategory.md)
 - [TempestResponseCustomer](1.0/docs/Model/TempestResponseCustomer.md)
 - [TempestResponseCustomerAddress](1.0/docs/Model/TempestResponseCustomerAddress.md)
 - [TempestResponseDomainName](1.0/docs/Model/TempestResponseDomainName.md)
 - [TempestResponseListCategory](1.0/docs/Model/TempestResponseListCategory.md)
 - [TempestResponseListCustomer](1.0/docs/Model/TempestResponseListCustomer.md)
 - [TempestResponseListCustomerAddress](1.0/docs/Model/TempestResponseListCustomerAddress.md)
 - [TempestResponseListOrder](1.0/docs/Model/TempestResponseListOrder.md)
 - [TempestResponseListPlan](1.0/docs/Model/TempestResponseListPlan.md)
 - [TempestResponseListProduct](1.0/docs/Model/TempestResponseListProduct.md)
 - [TempestResponseListProductAttribute](1.0/docs/Model/TempestResponseListProductAttribute.md)
 - [TempestResponseListProductAttributeItem](1.0/docs/Model/TempestResponseListProductAttributeItem.md)
 - [TempestResponseListProductOption](1.0/docs/Model/TempestResponseListProductOption.md)
 - [TempestResponseListProductVariant](1.0/docs/Model/TempestResponseListProductVariant.md)
 - [TempestResponseListSubCategory](1.0/docs/Model/TempestResponseListSubCategory.md)
 - [TempestResponseListTaxRateModel](1.0/docs/Model/TempestResponseListTaxRateModel.md)
 - [TempestResponseOrder](1.0/docs/Model/TempestResponseOrder.md)
 - [TempestResponseOrderStatuses](1.0/docs/Model/TempestResponseOrderStatuses.md)
 - [TempestResponsePlan](1.0/docs/Model/TempestResponsePlan.md)
 - [TempestResponseProduct](1.0/docs/Model/TempestResponseProduct.md)
 - [TempestResponseProductAttribute](1.0/docs/Model/TempestResponseProductAttribute.md)
 - [TempestResponseProductAttributeItem](1.0/docs/Model/TempestResponseProductAttributeItem.md)
 - [TempestResponseProductCategory](1.0/docs/Model/TempestResponseProductCategory.md)
 - [TempestResponseProductImages](1.0/docs/Model/TempestResponseProductImages.md)
 - [TempestResponseProductOption](1.0/docs/Model/TempestResponseProductOption.md)
 - [TempestResponseProductOptionItem](1.0/docs/Model/TempestResponseProductOptionItem.md)
 - [TempestResponseProductStock](1.0/docs/Model/TempestResponseProductStock.md)
 - [TempestResponseProductVariant](1.0/docs/Model/TempestResponseProductVariant.md)
 - [TempestResponseProductVariantStock](1.0/docs/Model/TempestResponseProductVariantStock.md)
 - [TempestResponseSubCategory](1.0/docs/Model/TempestResponseSubCategory.md)
 - [TempestResponseTaxRateModel](1.0/docs/Model/TempestResponseTaxRateModel.md)
 - [TempestResponseTaxSettings](1.0/docs/Model/TempestResponseTaxSettings.md)
 - [TempestResponseTempestValidationError](1.0/docs/Model/TempestResponseTempestValidationError.md)
 - [TempestValidationError](1.0/docs/Model/TempestValidationError.md)
 - [UpdateCategory](1.0/docs/Model/UpdateCategory.md)
 - [UpdateCustomer](1.0/docs/Model/UpdateCustomer.md)
 - [UpdateProduct](1.0/docs/Model/UpdateProduct.md)
 - [UpdateProductOption](1.0/docs/Model/UpdateProductOption.md)
 - [VariantCombination](1.0/docs/Model/VariantCombination.md)


## Documentation For Authorization



## OAuth


- **Type**: OAuth
- **Flow**: accessCode
- **Authorization URL**: https://api.ekm.net/connect/authorize
- **Scopes**: 
- **tempest.customers.read**: Read a shop's customers.
- **tempest.customers.write**: Modify a shop's customers.
- **tempest.orders.read**: Read a shop's orders.
- **tempest.orders.write**: Modify a shop's orders.
- **tempest.products.read**: Read a shop's products.
- **tempest.products.write**: Modify a shop's products.
- **tempest.categories.read**: Read a shop's categories.
- **tempest.categories.write**: Modify a shop's categories.
- **tempest.settings.orderstatuses.read**: Read a shop's order statuses.
- **tempest.settings.domains.read**: Read a shop's domains.
- **tempest.settings.accountdetails.read**: Read a shop's account details.
- **tempest.settings.tax.read**: Read a shop's tax settings.
- **tempest.settings.tax.write**: Write a shop's tax settings.


## Author

api-support@ekm.com

