<?php
/**
 * Copyright Talisman Innovations Ltd. (2018). All rights reserved.
 */

namespace EKM;

use EKM\Api\ProductsApi;
use EKM\ApiException;
use EKM\Model\Product;
use EKM\Model\TempestResponseListProduct;
use GuzzleHttp\HandlerStack;
use GuzzleHttp\Client;
use GuzzleHttp\Middleware;
use League\OAuth2\Client\Token\AccessToken;

class Examples extends \PHPUnit_Framework_TestCase
{
    public function testAuthenticate()
    {
        try {

            // AccessToken is an object in symfony root - this cannot be tested at the moment
            $token = new AccessToken($this->settingsManager, 'ekm');

            $client = ClientBuilder::getClient(
                'a6349fc0-f64d-4583-971e-02f0877bf115',
                'fc0b4d22-067b-4ce5-b15d-d9735480d93a',
                $token,
                $this->logger
            );

            $endpoint = new ProductsApi($client);

            /* @var TempestResponseListProduct $response */
            $response = $endpoint->apiV1ProductsGet();

            /* @var Product[] $products */
            $products = $response->getData();

        } catch (ApiException $exception) {

            echo $exception->getMessage();

        }
    }
}
