<?php
/**
 * UpdateCategory
 *
 * PHP version 5
 *
 * @category Class
 * @package  EKM
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * EKM Partner API
 *
 * Our new API allows partners to build significantly better integrations with the EKM platform.  To keep up to date with the latest updates, please see our [RSS feed](https://partners.ekm.net/ChangeLog/Feed) or the [partner dashboard](https://partners.ekm.net/).
 *
 * OpenAPI spec version: v1
 * Contact: support@ekm.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.3.1
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace EKM\Model;

use \ArrayAccess;
use \EKM\ObjectSerializer;

/**
 * UpdateCategory Class Doc Comment
 *
 * @category Class
 * @package  EKM
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class UpdateCategory implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'UpdateCategory';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'id' => 'int',
        'name' => 'string',
        'description' => 'string',
        'inCategoryDescription' => 'string',
        'metaDescription' => 'string',
        'metaKeywords' => 'string',
        'metaTitle' => 'string',
        'orderLocation' => 'int',
        'live' => 'bool',
        'parentCategoryId' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'id' => 'int64',
        'name' => null,
        'description' => null,
        'inCategoryDescription' => null,
        'metaDescription' => null,
        'metaKeywords' => null,
        'metaTitle' => null,
        'orderLocation' => 'int64',
        'live' => null,
        'parentCategoryId' => 'int64'
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'name' => 'name',
        'description' => 'description',
        'inCategoryDescription' => 'in_category_description',
        'metaDescription' => 'meta_description',
        'metaKeywords' => 'meta_keywords',
        'metaTitle' => 'meta_title',
        'orderLocation' => 'order_location',
        'live' => 'live',
        'parentCategoryId' => 'parent_category_id'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'name' => 'setName',
        'description' => 'setDescription',
        'inCategoryDescription' => 'setInCategoryDescription',
        'metaDescription' => 'setMetaDescription',
        'metaKeywords' => 'setMetaKeywords',
        'metaTitle' => 'setMetaTitle',
        'orderLocation' => 'setOrderLocation',
        'live' => 'setLive',
        'parentCategoryId' => 'setParentCategoryId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'name' => 'getName',
        'description' => 'getDescription',
        'inCategoryDescription' => 'getInCategoryDescription',
        'metaDescription' => 'getMetaDescription',
        'metaKeywords' => 'getMetaKeywords',
        'metaTitle' => 'getMetaTitle',
        'orderLocation' => 'getOrderLocation',
        'live' => 'getLive',
        'parentCategoryId' => 'getParentCategoryId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['inCategoryDescription'] = isset($data['inCategoryDescription']) ? $data['inCategoryDescription'] : null;
        $this->container['metaDescription'] = isset($data['metaDescription']) ? $data['metaDescription'] : null;
        $this->container['metaKeywords'] = isset($data['metaKeywords']) ? $data['metaKeywords'] : null;
        $this->container['metaTitle'] = isset($data['metaTitle']) ? $data['metaTitle'] : null;
        $this->container['orderLocation'] = isset($data['orderLocation']) ? $data['orderLocation'] : null;
        $this->container['live'] = isset($data['live']) ? $data['live'] : null;
        $this->container['parentCategoryId'] = isset($data['parentCategoryId']) ? $data['parentCategoryId'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['name'] === null) {
            $invalidProperties[] = "'name' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {

        if ($this->container['name'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     *
     * @return int
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int $id id
     *
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string $name name
     *
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string $description description
     *
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets inCategoryDescription
     *
     * @return string
     */
    public function getInCategoryDescription()
    {
        return $this->container['inCategoryDescription'];
    }

    /**
     * Sets inCategoryDescription
     *
     * @param string $inCategoryDescription inCategoryDescription
     *
     * @return $this
     */
    public function setInCategoryDescription($inCategoryDescription)
    {
        $this->container['inCategoryDescription'] = $inCategoryDescription;

        return $this;
    }

    /**
     * Gets metaDescription
     *
     * @return string
     */
    public function getMetaDescription()
    {
        return $this->container['metaDescription'];
    }

    /**
     * Sets metaDescription
     *
     * @param string $metaDescription metaDescription
     *
     * @return $this
     */
    public function setMetaDescription($metaDescription)
    {
        $this->container['metaDescription'] = $metaDescription;

        return $this;
    }

    /**
     * Gets metaKeywords
     *
     * @return string
     */
    public function getMetaKeywords()
    {
        return $this->container['metaKeywords'];
    }

    /**
     * Sets metaKeywords
     *
     * @param string $metaKeywords metaKeywords
     *
     * @return $this
     */
    public function setMetaKeywords($metaKeywords)
    {
        $this->container['metaKeywords'] = $metaKeywords;

        return $this;
    }

    /**
     * Gets metaTitle
     *
     * @return string
     */
    public function getMetaTitle()
    {
        return $this->container['metaTitle'];
    }

    /**
     * Sets metaTitle
     *
     * @param string $metaTitle metaTitle
     *
     * @return $this
     */
    public function setMetaTitle($metaTitle)
    {
        $this->container['metaTitle'] = $metaTitle;

        return $this;
    }

    /**
     * Gets orderLocation
     *
     * @return int
     */
    public function getOrderLocation()
    {
        return $this->container['orderLocation'];
    }

    /**
     * Sets orderLocation
     *
     * @param int $orderLocation orderLocation
     *
     * @return $this
     */
    public function setOrderLocation($orderLocation)
    {
        $this->container['orderLocation'] = $orderLocation;

        return $this;
    }

    /**
     * Gets live
     *
     * @return bool
     */
    public function getLive()
    {
        return $this->container['live'];
    }

    /**
     * Sets live
     *
     * @param bool $live live
     *
     * @return $this
     */
    public function setLive($live)
    {
        $this->container['live'] = $live;

        return $this;
    }

    /**
     * Gets parentCategoryId
     *
     * @return int
     */
    public function getParentCategoryId()
    {
        return $this->container['parentCategoryId'];
    }

    /**
     * Sets parentCategoryId
     *
     * @param int $parentCategoryId parentCategoryId
     *
     * @return $this
     */
    public function setParentCategoryId($parentCategoryId)
    {
        $this->container['parentCategoryId'] = $parentCategoryId;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


