<?php
/**
 * ShippingAddress
 *
 * PHP version 5
 *
 * @category Class
 * @package  EKM
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * EKM Partner API
 *
 * Our new API allows partners to build significantly better integrations with the EKM platform.  To keep up to date with the latest updates, please see our [RSS feed](https://partners.ekm.net/ChangeLog/Feed) or the [partner dashboard](https://partners.ekm.net/).
 *
 * OpenAPI spec version: v1
 * Contact: support@ekm.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.3.1
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace EKM\Model;

use \ArrayAccess;
use \EKM\ObjectSerializer;

/**
 * ShippingAddress Class Doc Comment
 *
 * @category Class
 * @package  EKM
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ShippingAddress implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'ShippingAddress';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'firstName' => 'string',
        'lastName' => 'string',
        'id' => 'int',
        'createdDate' => '\DateTime',
        'modifiedDate' => '\DateTime',
        'customerId' => 'int',
        'isPreferredBillingAddress' => 'bool',
        'isPreferredShippingAddress' => 'bool',
        'company' => 'string',
        'address' => 'string',
        'address2' => 'string',
        'town' => 'string',
        'county' => 'string',
        'country' => 'string',
        'friendlyCountry' => 'string',
        'postCode' => 'string',
        'telephone' => 'string',
        'fax' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'firstName' => null,
        'lastName' => null,
        'id' => 'int64',
        'createdDate' => 'date-time',
        'modifiedDate' => 'date-time',
        'customerId' => 'int64',
        'isPreferredBillingAddress' => null,
        'isPreferredShippingAddress' => null,
        'company' => null,
        'address' => null,
        'address2' => null,
        'town' => null,
        'county' => null,
        'country' => null,
        'friendlyCountry' => null,
        'postCode' => null,
        'telephone' => null,
        'fax' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'firstName' => 'first_name',
        'lastName' => 'last_name',
        'id' => 'id',
        'createdDate' => 'created_date',
        'modifiedDate' => 'modified_date',
        'customerId' => 'customer_id',
        'isPreferredBillingAddress' => 'is_preferred_billing_address',
        'isPreferredShippingAddress' => 'is_preferred_shipping_address',
        'company' => 'company',
        'address' => 'address',
        'address2' => 'address2',
        'town' => 'town',
        'county' => 'county',
        'country' => 'country',
        'friendlyCountry' => 'friendly_country',
        'postCode' => 'post_code',
        'telephone' => 'telephone',
        'fax' => 'fax'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'firstName' => 'setFirstName',
        'lastName' => 'setLastName',
        'id' => 'setId',
        'createdDate' => 'setCreatedDate',
        'modifiedDate' => 'setModifiedDate',
        'customerId' => 'setCustomerId',
        'isPreferredBillingAddress' => 'setIsPreferredBillingAddress',
        'isPreferredShippingAddress' => 'setIsPreferredShippingAddress',
        'company' => 'setCompany',
        'address' => 'setAddress',
        'address2' => 'setAddress2',
        'town' => 'setTown',
        'county' => 'setCounty',
        'country' => 'setCountry',
        'friendlyCountry' => 'setFriendlyCountry',
        'postCode' => 'setPostCode',
        'telephone' => 'setTelephone',
        'fax' => 'setFax'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'firstName' => 'getFirstName',
        'lastName' => 'getLastName',
        'id' => 'getId',
        'createdDate' => 'getCreatedDate',
        'modifiedDate' => 'getModifiedDate',
        'customerId' => 'getCustomerId',
        'isPreferredBillingAddress' => 'getIsPreferredBillingAddress',
        'isPreferredShippingAddress' => 'getIsPreferredShippingAddress',
        'company' => 'getCompany',
        'address' => 'getAddress',
        'address2' => 'getAddress2',
        'town' => 'getTown',
        'county' => 'getCounty',
        'country' => 'getCountry',
        'friendlyCountry' => 'getFriendlyCountry',
        'postCode' => 'getPostCode',
        'telephone' => 'getTelephone',
        'fax' => 'getFax'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['firstName'] = isset($data['firstName']) ? $data['firstName'] : null;
        $this->container['lastName'] = isset($data['lastName']) ? $data['lastName'] : null;
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['createdDate'] = isset($data['createdDate']) ? $data['createdDate'] : null;
        $this->container['modifiedDate'] = isset($data['modifiedDate']) ? $data['modifiedDate'] : null;
        $this->container['customerId'] = isset($data['customerId']) ? $data['customerId'] : null;
        $this->container['isPreferredBillingAddress'] = isset($data['isPreferredBillingAddress']) ? $data['isPreferredBillingAddress'] : null;
        $this->container['isPreferredShippingAddress'] = isset($data['isPreferredShippingAddress']) ? $data['isPreferredShippingAddress'] : null;
        $this->container['company'] = isset($data['company']) ? $data['company'] : null;
        $this->container['address'] = isset($data['address']) ? $data['address'] : null;
        $this->container['address2'] = isset($data['address2']) ? $data['address2'] : null;
        $this->container['town'] = isset($data['town']) ? $data['town'] : null;
        $this->container['county'] = isset($data['county']) ? $data['county'] : null;
        $this->container['country'] = isset($data['country']) ? $data['country'] : null;
        $this->container['friendlyCountry'] = isset($data['friendlyCountry']) ? $data['friendlyCountry'] : null;
        $this->container['postCode'] = isset($data['postCode']) ? $data['postCode'] : null;
        $this->container['telephone'] = isset($data['telephone']) ? $data['telephone'] : null;
        $this->container['fax'] = isset($data['fax']) ? $data['fax'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['firstName'] === null) {
            $invalidProperties[] = "'firstName' can't be null";
        }
        if ($this->container['lastName'] === null) {
            $invalidProperties[] = "'lastName' can't be null";
        }
        if ($this->container['address'] === null) {
            $invalidProperties[] = "'address' can't be null";
        }
        if ($this->container['town'] === null) {
            $invalidProperties[] = "'town' can't be null";
        }
        if ($this->container['country'] === null) {
            $invalidProperties[] = "'country' can't be null";
        }
        if ($this->container['postCode'] === null) {
            $invalidProperties[] = "'postCode' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {

        if ($this->container['firstName'] === null) {
            return false;
        }
        if ($this->container['lastName'] === null) {
            return false;
        }
        if ($this->container['address'] === null) {
            return false;
        }
        if ($this->container['town'] === null) {
            return false;
        }
        if ($this->container['country'] === null) {
            return false;
        }
        if ($this->container['postCode'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets firstName
     *
     * @return string
     */
    public function getFirstName()
    {
        return $this->container['firstName'];
    }

    /**
     * Sets firstName
     *
     * @param string $firstName firstName
     *
     * @return $this
     */
    public function setFirstName($firstName)
    {
        $this->container['firstName'] = $firstName;

        return $this;
    }

    /**
     * Gets lastName
     *
     * @return string
     */
    public function getLastName()
    {
        return $this->container['lastName'];
    }

    /**
     * Sets lastName
     *
     * @param string $lastName lastName
     *
     * @return $this
     */
    public function setLastName($lastName)
    {
        $this->container['lastName'] = $lastName;

        return $this;
    }

    /**
     * Gets id
     *
     * @return int
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int $id id
     *
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets createdDate
     *
     * @return \DateTime
     */
    public function getCreatedDate()
    {
        return $this->container['createdDate'];
    }

    /**
     * Sets createdDate
     *
     * @param \DateTime $createdDate createdDate
     *
     * @return $this
     */
    public function setCreatedDate($createdDate)
    {
        $this->container['createdDate'] = $createdDate;

        return $this;
    }

    /**
     * Gets modifiedDate
     *
     * @return \DateTime
     */
    public function getModifiedDate()
    {
        return $this->container['modifiedDate'];
    }

    /**
     * Sets modifiedDate
     *
     * @param \DateTime $modifiedDate modifiedDate
     *
     * @return $this
     */
    public function setModifiedDate($modifiedDate)
    {
        $this->container['modifiedDate'] = $modifiedDate;

        return $this;
    }

    /**
     * Gets customerId
     *
     * @return int
     */
    public function getCustomerId()
    {
        return $this->container['customerId'];
    }

    /**
     * Sets customerId
     *
     * @param int $customerId customerId
     *
     * @return $this
     */
    public function setCustomerId($customerId)
    {
        $this->container['customerId'] = $customerId;

        return $this;
    }

    /**
     * Gets isPreferredBillingAddress
     *
     * @return bool
     */
    public function getIsPreferredBillingAddress()
    {
        return $this->container['isPreferredBillingAddress'];
    }

    /**
     * Sets isPreferredBillingAddress
     *
     * @param bool $isPreferredBillingAddress isPreferredBillingAddress
     *
     * @return $this
     */
    public function setIsPreferredBillingAddress($isPreferredBillingAddress)
    {
        $this->container['isPreferredBillingAddress'] = $isPreferredBillingAddress;

        return $this;
    }

    /**
     * Gets isPreferredShippingAddress
     *
     * @return bool
     */
    public function getIsPreferredShippingAddress()
    {
        return $this->container['isPreferredShippingAddress'];
    }

    /**
     * Sets isPreferredShippingAddress
     *
     * @param bool $isPreferredShippingAddress isPreferredShippingAddress
     *
     * @return $this
     */
    public function setIsPreferredShippingAddress($isPreferredShippingAddress)
    {
        $this->container['isPreferredShippingAddress'] = $isPreferredShippingAddress;

        return $this;
    }

    /**
     * Gets company
     *
     * @return string
     */
    public function getCompany()
    {
        return $this->container['company'];
    }

    /**
     * Sets company
     *
     * @param string $company company
     *
     * @return $this
     */
    public function setCompany($company)
    {
        $this->container['company'] = $company;

        return $this;
    }

    /**
     * Gets address
     *
     * @return string
     */
    public function getAddress()
    {
        return $this->container['address'];
    }

    /**
     * Sets address
     *
     * @param string $address address
     *
     * @return $this
     */
    public function setAddress($address)
    {
        $this->container['address'] = $address;

        return $this;
    }

    /**
     * Gets address2
     *
     * @return string
     */
    public function getAddress2()
    {
        return $this->container['address2'];
    }

    /**
     * Sets address2
     *
     * @param string $address2 address2
     *
     * @return $this
     */
    public function setAddress2($address2)
    {
        $this->container['address2'] = $address2;

        return $this;
    }

    /**
     * Gets town
     *
     * @return string
     */
    public function getTown()
    {
        return $this->container['town'];
    }

    /**
     * Sets town
     *
     * @param string $town town
     *
     * @return $this
     */
    public function setTown($town)
    {
        $this->container['town'] = $town;

        return $this;
    }

    /**
     * Gets county
     *
     * @return string
     */
    public function getCounty()
    {
        return $this->container['county'];
    }

    /**
     * Sets county
     *
     * @param string $county county
     *
     * @return $this
     */
    public function setCounty($county)
    {
        $this->container['county'] = $county;

        return $this;
    }

    /**
     * Gets country
     *
     * @return string
     */
    public function getCountry()
    {
        return $this->container['country'];
    }

    /**
     * Sets country
     *
     * @param string $country country
     *
     * @return $this
     */
    public function setCountry($country)
    {
        $this->container['country'] = $country;

        return $this;
    }

    /**
     * Gets friendlyCountry
     *
     * @return string
     */
    public function getFriendlyCountry()
    {
        return $this->container['friendlyCountry'];
    }

    /**
     * Sets friendlyCountry
     *
     * @param string $friendlyCountry friendlyCountry
     *
     * @return $this
     */
    public function setFriendlyCountry($friendlyCountry)
    {
        $this->container['friendlyCountry'] = $friendlyCountry;

        return $this;
    }

    /**
     * Gets postCode
     *
     * @return string
     */
    public function getPostCode()
    {
        return $this->container['postCode'];
    }

    /**
     * Sets postCode
     *
     * @param string $postCode postCode
     *
     * @return $this
     */
    public function setPostCode($postCode)
    {
        $this->container['postCode'] = $postCode;

        return $this;
    }

    /**
     * Gets telephone
     *
     * @return string
     */
    public function getTelephone()
    {
        return $this->container['telephone'];
    }

    /**
     * Sets telephone
     *
     * @param string $telephone telephone
     *
     * @return $this
     */
    public function setTelephone($telephone)
    {
        $this->container['telephone'] = $telephone;

        return $this;
    }

    /**
     * Gets fax
     *
     * @return string
     */
    public function getFax()
    {
        return $this->container['fax'];
    }

    /**
     * Sets fax
     *
     * @param string $fax fax
     *
     * @return $this
     */
    public function setFax($fax)
    {
        $this->container['fax'] = $fax;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


