<?php
/**
 * Order
 *
 * PHP version 5
 *
 * @category Class
 * @package  EKM
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * EKM Partner API
 *
 * Our new API allows partners to build significantly better integrations with the EKM platform.  To keep up to date with the latest updates, please see our [RSS feed](https://partners.ekm.net/ChangeLog/Feed) or the [partner dashboard](https://partners.ekm.net/).
 *
 * OpenAPI spec version: v1
 * Contact: support@ekm.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.3.1
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace EKM\Model;

use \ArrayAccess;
use \EKM\ObjectSerializer;

/**
 * Order Class Doc Comment
 *
 * @category Class
 * @package  EKM
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class Order implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'Order';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'id' => 'int',
        'orderNumber' => 'string',
        'orderDate' => '\DateTime',
        'isConfirmed' => 'bool',
        'subTotal' => 'double',
        'totalDelivery' => 'double',
        'totalTax' => 'double',
        'totalCost' => 'double',
        'status' => 'string',
        'paymentStatus' => 'string',
        'deliveryMethod' => 'string',
        'transactionId' => 'string',
        'transactionStatus' => 'string',
        'orderType' => 'string',
        'useShippingAddress' => 'bool',
        'shippingAddress' => '\EKM\Model\ShippingAddress',
        'internalNotes' => 'string',
        'customerFacingNotes' => 'string',
        'emailed' => 'bool',
        'discounts' => 'string',
        'discountsTotal' => 'double',
        'shippingCompany' => 'string',
        'ipAddress' => 'string',
        'guid' => 'string',
        'lastUpdated' => '\DateTime',
        'items' => '\EKM\Model\OrderItem[]',
        'customerDetails' => '\EKM\Model\OrderCustomerDetails'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'id' => 'int64',
        'orderNumber' => null,
        'orderDate' => 'date-time',
        'isConfirmed' => null,
        'subTotal' => 'double',
        'totalDelivery' => 'double',
        'totalTax' => 'double',
        'totalCost' => 'double',
        'status' => null,
        'paymentStatus' => null,
        'deliveryMethod' => null,
        'transactionId' => null,
        'transactionStatus' => null,
        'orderType' => null,
        'useShippingAddress' => null,
        'shippingAddress' => null,
        'internalNotes' => null,
        'customerFacingNotes' => null,
        'emailed' => null,
        'discounts' => null,
        'discountsTotal' => 'double',
        'shippingCompany' => null,
        'ipAddress' => null,
        'guid' => 'uuid',
        'lastUpdated' => 'date-time',
        'items' => null,
        'customerDetails' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'orderNumber' => 'order_number',
        'orderDate' => 'order_date',
        'isConfirmed' => 'is_confirmed',
        'subTotal' => 'sub_total',
        'totalDelivery' => 'total_delivery',
        'totalTax' => 'total_tax',
        'totalCost' => 'total_cost',
        'status' => 'status',
        'paymentStatus' => 'payment_status',
        'deliveryMethod' => 'delivery_method',
        'transactionId' => 'transaction_id',
        'transactionStatus' => 'transaction_status',
        'orderType' => 'order_type',
        'useShippingAddress' => 'use_shipping_address',
        'shippingAddress' => 'shipping_address',
        'internalNotes' => 'internal_notes',
        'customerFacingNotes' => 'customer_facing_notes',
        'emailed' => 'emailed',
        'discounts' => 'discounts',
        'discountsTotal' => 'discounts_total',
        'shippingCompany' => 'shipping_company',
        'ipAddress' => 'ip_address',
        'guid' => 'guid',
        'lastUpdated' => 'last_updated',
        'items' => 'items',
        'customerDetails' => 'customer_details'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'orderNumber' => 'setOrderNumber',
        'orderDate' => 'setOrderDate',
        'isConfirmed' => 'setIsConfirmed',
        'subTotal' => 'setSubTotal',
        'totalDelivery' => 'setTotalDelivery',
        'totalTax' => 'setTotalTax',
        'totalCost' => 'setTotalCost',
        'status' => 'setStatus',
        'paymentStatus' => 'setPaymentStatus',
        'deliveryMethod' => 'setDeliveryMethod',
        'transactionId' => 'setTransactionId',
        'transactionStatus' => 'setTransactionStatus',
        'orderType' => 'setOrderType',
        'useShippingAddress' => 'setUseShippingAddress',
        'shippingAddress' => 'setShippingAddress',
        'internalNotes' => 'setInternalNotes',
        'customerFacingNotes' => 'setCustomerFacingNotes',
        'emailed' => 'setEmailed',
        'discounts' => 'setDiscounts',
        'discountsTotal' => 'setDiscountsTotal',
        'shippingCompany' => 'setShippingCompany',
        'ipAddress' => 'setIpAddress',
        'guid' => 'setGuid',
        'lastUpdated' => 'setLastUpdated',
        'items' => 'setItems',
        'customerDetails' => 'setCustomerDetails'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'orderNumber' => 'getOrderNumber',
        'orderDate' => 'getOrderDate',
        'isConfirmed' => 'getIsConfirmed',
        'subTotal' => 'getSubTotal',
        'totalDelivery' => 'getTotalDelivery',
        'totalTax' => 'getTotalTax',
        'totalCost' => 'getTotalCost',
        'status' => 'getStatus',
        'paymentStatus' => 'getPaymentStatus',
        'deliveryMethod' => 'getDeliveryMethod',
        'transactionId' => 'getTransactionId',
        'transactionStatus' => 'getTransactionStatus',
        'orderType' => 'getOrderType',
        'useShippingAddress' => 'getUseShippingAddress',
        'shippingAddress' => 'getShippingAddress',
        'internalNotes' => 'getInternalNotes',
        'customerFacingNotes' => 'getCustomerFacingNotes',
        'emailed' => 'getEmailed',
        'discounts' => 'getDiscounts',
        'discountsTotal' => 'getDiscountsTotal',
        'shippingCompany' => 'getShippingCompany',
        'ipAddress' => 'getIpAddress',
        'guid' => 'getGuid',
        'lastUpdated' => 'getLastUpdated',
        'items' => 'getItems',
        'customerDetails' => 'getCustomerDetails'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['orderNumber'] = isset($data['orderNumber']) ? $data['orderNumber'] : null;
        $this->container['orderDate'] = isset($data['orderDate']) ? $data['orderDate'] : null;
        $this->container['isConfirmed'] = isset($data['isConfirmed']) ? $data['isConfirmed'] : null;
        $this->container['subTotal'] = isset($data['subTotal']) ? $data['subTotal'] : null;
        $this->container['totalDelivery'] = isset($data['totalDelivery']) ? $data['totalDelivery'] : null;
        $this->container['totalTax'] = isset($data['totalTax']) ? $data['totalTax'] : null;
        $this->container['totalCost'] = isset($data['totalCost']) ? $data['totalCost'] : null;
        $this->container['status'] = isset($data['status']) ? $data['status'] : null;
        $this->container['paymentStatus'] = isset($data['paymentStatus']) ? $data['paymentStatus'] : null;
        $this->container['deliveryMethod'] = isset($data['deliveryMethod']) ? $data['deliveryMethod'] : null;
        $this->container['transactionId'] = isset($data['transactionId']) ? $data['transactionId'] : null;
        $this->container['transactionStatus'] = isset($data['transactionStatus']) ? $data['transactionStatus'] : null;
        $this->container['orderType'] = isset($data['orderType']) ? $data['orderType'] : null;
        $this->container['useShippingAddress'] = isset($data['useShippingAddress']) ? $data['useShippingAddress'] : null;
        $this->container['shippingAddress'] = isset($data['shippingAddress']) ? $data['shippingAddress'] : null;
        $this->container['internalNotes'] = isset($data['internalNotes']) ? $data['internalNotes'] : null;
        $this->container['customerFacingNotes'] = isset($data['customerFacingNotes']) ? $data['customerFacingNotes'] : null;
        $this->container['emailed'] = isset($data['emailed']) ? $data['emailed'] : null;
        $this->container['discounts'] = isset($data['discounts']) ? $data['discounts'] : null;
        $this->container['discountsTotal'] = isset($data['discountsTotal']) ? $data['discountsTotal'] : null;
        $this->container['shippingCompany'] = isset($data['shippingCompany']) ? $data['shippingCompany'] : null;
        $this->container['ipAddress'] = isset($data['ipAddress']) ? $data['ipAddress'] : null;
        $this->container['guid'] = isset($data['guid']) ? $data['guid'] : null;
        $this->container['lastUpdated'] = isset($data['lastUpdated']) ? $data['lastUpdated'] : null;
        $this->container['items'] = isset($data['items']) ? $data['items'] : null;
        $this->container['customerDetails'] = isset($data['customerDetails']) ? $data['customerDetails'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['id'] === null) {
            $invalidProperties[] = "'id' can't be null";
        }
        if ($this->container['orderNumber'] === null) {
            $invalidProperties[] = "'orderNumber' can't be null";
        }
        if ($this->container['orderDate'] === null) {
            $invalidProperties[] = "'orderDate' can't be null";
        }
        if ($this->container['isConfirmed'] === null) {
            $invalidProperties[] = "'isConfirmed' can't be null";
        }
        if ($this->container['subTotal'] === null) {
            $invalidProperties[] = "'subTotal' can't be null";
        }
        if ($this->container['totalDelivery'] === null) {
            $invalidProperties[] = "'totalDelivery' can't be null";
        }
        if ($this->container['totalTax'] === null) {
            $invalidProperties[] = "'totalTax' can't be null";
        }
        if ($this->container['totalCost'] === null) {
            $invalidProperties[] = "'totalCost' can't be null";
        }
        if ($this->container['status'] === null) {
            $invalidProperties[] = "'status' can't be null";
        }
        if ($this->container['deliveryMethod'] === null) {
            $invalidProperties[] = "'deliveryMethod' can't be null";
        }
        if ($this->container['transactionId'] === null) {
            $invalidProperties[] = "'transactionId' can't be null";
        }
        if ($this->container['transactionStatus'] === null) {
            $invalidProperties[] = "'transactionStatus' can't be null";
        }
        if ($this->container['orderType'] === null) {
            $invalidProperties[] = "'orderType' can't be null";
        }
        if ($this->container['useShippingAddress'] === null) {
            $invalidProperties[] = "'useShippingAddress' can't be null";
        }
        if ($this->container['shippingAddress'] === null) {
            $invalidProperties[] = "'shippingAddress' can't be null";
        }
        if ($this->container['internalNotes'] === null) {
            $invalidProperties[] = "'internalNotes' can't be null";
        }
        if ($this->container['customerFacingNotes'] === null) {
            $invalidProperties[] = "'customerFacingNotes' can't be null";
        }
        if ($this->container['emailed'] === null) {
            $invalidProperties[] = "'emailed' can't be null";
        }
        if ($this->container['discounts'] === null) {
            $invalidProperties[] = "'discounts' can't be null";
        }
        if ($this->container['discountsTotal'] === null) {
            $invalidProperties[] = "'discountsTotal' can't be null";
        }
        if ($this->container['shippingCompany'] === null) {
            $invalidProperties[] = "'shippingCompany' can't be null";
        }
        if ($this->container['ipAddress'] === null) {
            $invalidProperties[] = "'ipAddress' can't be null";
        }
        if ($this->container['guid'] === null) {
            $invalidProperties[] = "'guid' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {

        if ($this->container['id'] === null) {
            return false;
        }
        if ($this->container['orderNumber'] === null) {
            return false;
        }
        if ($this->container['orderDate'] === null) {
            return false;
        }
        if ($this->container['isConfirmed'] === null) {
            return false;
        }
        if ($this->container['subTotal'] === null) {
            return false;
        }
        if ($this->container['totalDelivery'] === null) {
            return false;
        }
        if ($this->container['totalTax'] === null) {
            return false;
        }
        if ($this->container['totalCost'] === null) {
            return false;
        }
        if ($this->container['status'] === null) {
            return false;
        }
        if ($this->container['deliveryMethod'] === null) {
            return false;
        }
        if ($this->container['transactionId'] === null) {
            return false;
        }
        if ($this->container['transactionStatus'] === null) {
            return false;
        }
        if ($this->container['orderType'] === null) {
            return false;
        }
        if ($this->container['useShippingAddress'] === null) {
            return false;
        }
        if ($this->container['shippingAddress'] === null) {
            return false;
        }
        if ($this->container['internalNotes'] === null) {
            return false;
        }
        if ($this->container['customerFacingNotes'] === null) {
            return false;
        }
        if ($this->container['emailed'] === null) {
            return false;
        }
        if ($this->container['discounts'] === null) {
            return false;
        }
        if ($this->container['discountsTotal'] === null) {
            return false;
        }
        if ($this->container['shippingCompany'] === null) {
            return false;
        }
        if ($this->container['ipAddress'] === null) {
            return false;
        }
        if ($this->container['guid'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     *
     * @return int
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int $id id
     *
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets orderNumber
     *
     * @return string
     */
    public function getOrderNumber()
    {
        return $this->container['orderNumber'];
    }

    /**
     * Sets orderNumber
     *
     * @param string $orderNumber orderNumber
     *
     * @return $this
     */
    public function setOrderNumber($orderNumber)
    {
        $this->container['orderNumber'] = $orderNumber;

        return $this;
    }

    /**
     * Gets orderDate
     *
     * @return \DateTime
     */
    public function getOrderDate()
    {
        return $this->container['orderDate'];
    }

    /**
     * Sets orderDate
     *
     * @param \DateTime $orderDate orderDate
     *
     * @return $this
     */
    public function setOrderDate($orderDate)
    {
        $this->container['orderDate'] = $orderDate;

        return $this;
    }

    /**
     * Gets isConfirmed
     *
     * @return bool
     */
    public function getIsConfirmed()
    {
        return $this->container['isConfirmed'];
    }

    /**
     * Sets isConfirmed
     *
     * @param bool $isConfirmed isConfirmed
     *
     * @return $this
     */
    public function setIsConfirmed($isConfirmed)
    {
        $this->container['isConfirmed'] = $isConfirmed;

        return $this;
    }

    /**
     * Gets subTotal
     *
     * @return double
     */
    public function getSubTotal()
    {
        return $this->container['subTotal'];
    }

    /**
     * Sets subTotal
     *
     * @param double $subTotal subTotal
     *
     * @return $this
     */
    public function setSubTotal($subTotal)
    {
        $this->container['subTotal'] = $subTotal;

        return $this;
    }

    /**
     * Gets totalDelivery
     *
     * @return double
     */
    public function getTotalDelivery()
    {
        return $this->container['totalDelivery'];
    }

    /**
     * Sets totalDelivery
     *
     * @param double $totalDelivery totalDelivery
     *
     * @return $this
     */
    public function setTotalDelivery($totalDelivery)
    {
        $this->container['totalDelivery'] = $totalDelivery;

        return $this;
    }

    /**
     * Gets totalTax
     *
     * @return double
     */
    public function getTotalTax()
    {
        return $this->container['totalTax'];
    }

    /**
     * Sets totalTax
     *
     * @param double $totalTax totalTax
     *
     * @return $this
     */
    public function setTotalTax($totalTax)
    {
        $this->container['totalTax'] = $totalTax;

        return $this;
    }

    /**
     * Gets totalCost
     *
     * @return double
     */
    public function getTotalCost()
    {
        return $this->container['totalCost'];
    }

    /**
     * Sets totalCost
     *
     * @param double $totalCost totalCost
     *
     * @return $this
     */
    public function setTotalCost($totalCost)
    {
        $this->container['totalCost'] = $totalCost;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string $status status
     *
     * @return $this
     */
    public function setStatus($status)
    {
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets paymentStatus
     *
     * @return string
     */
    public function getPaymentStatus()
    {
        return $this->container['paymentStatus'];
    }

    /**
     * Sets paymentStatus
     *
     * @param string $paymentStatus paymentStatus
     *
     * @return $this
     */
    public function setPaymentStatus($paymentStatus)
    {
        $this->container['paymentStatus'] = $paymentStatus;

        return $this;
    }

    /**
     * Gets deliveryMethod
     *
     * @return string
     */
    public function getDeliveryMethod()
    {
        return $this->container['deliveryMethod'];
    }

    /**
     * Sets deliveryMethod
     *
     * @param string $deliveryMethod deliveryMethod
     *
     * @return $this
     */
    public function setDeliveryMethod($deliveryMethod)
    {
        $this->container['deliveryMethod'] = $deliveryMethod;

        return $this;
    }

    /**
     * Gets transactionId
     *
     * @return string
     */
    public function getTransactionId()
    {
        return $this->container['transactionId'];
    }

    /**
     * Sets transactionId
     *
     * @param string $transactionId transactionId
     *
     * @return $this
     */
    public function setTransactionId($transactionId)
    {
        $this->container['transactionId'] = $transactionId;

        return $this;
    }

    /**
     * Gets transactionStatus
     *
     * @return string
     */
    public function getTransactionStatus()
    {
        return $this->container['transactionStatus'];
    }

    /**
     * Sets transactionStatus
     *
     * @param string $transactionStatus transactionStatus
     *
     * @return $this
     */
    public function setTransactionStatus($transactionStatus)
    {
        $this->container['transactionStatus'] = $transactionStatus;

        return $this;
    }

    /**
     * Gets orderType
     *
     * @return string
     */
    public function getOrderType()
    {
        return $this->container['orderType'];
    }

    /**
     * Sets orderType
     *
     * @param string $orderType orderType
     *
     * @return $this
     */
    public function setOrderType($orderType)
    {
        $this->container['orderType'] = $orderType;

        return $this;
    }

    /**
     * Gets useShippingAddress
     *
     * @return bool
     */
    public function getUseShippingAddress()
    {
        return $this->container['useShippingAddress'];
    }

    /**
     * Sets useShippingAddress
     *
     * @param bool $useShippingAddress useShippingAddress
     *
     * @return $this
     */
    public function setUseShippingAddress($useShippingAddress)
    {
        $this->container['useShippingAddress'] = $useShippingAddress;

        return $this;
    }

    /**
     * Gets shippingAddress
     *
     * @return \EKM\Model\ShippingAddress
     */
    public function getShippingAddress()
    {
        return $this->container['shippingAddress'];
    }

    /**
     * Sets shippingAddress
     *
     * @param \EKM\Model\ShippingAddress $shippingAddress shippingAddress
     *
     * @return $this
     */
    public function setShippingAddress($shippingAddress)
    {
        $this->container['shippingAddress'] = $shippingAddress;

        return $this;
    }

    /**
     * Gets internalNotes
     *
     * @return string
     */
    public function getInternalNotes()
    {
        return $this->container['internalNotes'];
    }

    /**
     * Sets internalNotes
     *
     * @param string $internalNotes internalNotes
     *
     * @return $this
     */
    public function setInternalNotes($internalNotes)
    {
        $this->container['internalNotes'] = $internalNotes;

        return $this;
    }

    /**
     * Gets customerFacingNotes
     *
     * @return string
     */
    public function getCustomerFacingNotes()
    {
        return $this->container['customerFacingNotes'];
    }

    /**
     * Sets customerFacingNotes
     *
     * @param string $customerFacingNotes customerFacingNotes
     *
     * @return $this
     */
    public function setCustomerFacingNotes($customerFacingNotes)
    {
        $this->container['customerFacingNotes'] = $customerFacingNotes;

        return $this;
    }

    /**
     * Gets emailed
     *
     * @return bool
     */
    public function getEmailed()
    {
        return $this->container['emailed'];
    }

    /**
     * Sets emailed
     *
     * @param bool $emailed emailed
     *
     * @return $this
     */
    public function setEmailed($emailed)
    {
        $this->container['emailed'] = $emailed;

        return $this;
    }

    /**
     * Gets discounts
     *
     * @return string
     */
    public function getDiscounts()
    {
        return $this->container['discounts'];
    }

    /**
     * Sets discounts
     *
     * @param string $discounts discounts
     *
     * @return $this
     */
    public function setDiscounts($discounts)
    {
        $this->container['discounts'] = $discounts;

        return $this;
    }

    /**
     * Gets discountsTotal
     *
     * @return double
     */
    public function getDiscountsTotal()
    {
        return $this->container['discountsTotal'];
    }

    /**
     * Sets discountsTotal
     *
     * @param double $discountsTotal discountsTotal
     *
     * @return $this
     */
    public function setDiscountsTotal($discountsTotal)
    {
        $this->container['discountsTotal'] = $discountsTotal;

        return $this;
    }

    /**
     * Gets shippingCompany
     *
     * @return string
     */
    public function getShippingCompany()
    {
        return $this->container['shippingCompany'];
    }

    /**
     * Sets shippingCompany
     *
     * @param string $shippingCompany shippingCompany
     *
     * @return $this
     */
    public function setShippingCompany($shippingCompany)
    {
        $this->container['shippingCompany'] = $shippingCompany;

        return $this;
    }

    /**
     * Gets ipAddress
     *
     * @return string
     */
    public function getIpAddress()
    {
        return $this->container['ipAddress'];
    }

    /**
     * Sets ipAddress
     *
     * @param string $ipAddress ipAddress
     *
     * @return $this
     */
    public function setIpAddress($ipAddress)
    {
        $this->container['ipAddress'] = $ipAddress;

        return $this;
    }

    /**
     * Gets guid
     *
     * @return string
     */
    public function getGuid()
    {
        return $this->container['guid'];
    }

    /**
     * Sets guid
     *
     * @param string $guid guid
     *
     * @return $this
     */
    public function setGuid($guid)
    {
        $this->container['guid'] = $guid;

        return $this;
    }

    /**
     * Gets lastUpdated
     *
     * @return \DateTime
     */
    public function getLastUpdated()
    {
        return $this->container['lastUpdated'];
    }

    /**
     * Sets lastUpdated
     *
     * @param \DateTime $lastUpdated lastUpdated
     *
     * @return $this
     */
    public function setLastUpdated($lastUpdated)
    {
        $this->container['lastUpdated'] = $lastUpdated;

        return $this;
    }

    /**
     * Gets items
     *
     * @return \EKM\Model\OrderItem[]
     */
    public function getItems()
    {
        return $this->container['items'];
    }

    /**
     * Sets items
     *
     * @param \EKM\Model\OrderItem[] $items items
     *
     * @return $this
     */
    public function setItems($items)
    {
        $this->container['items'] = $items;

        return $this;
    }

    /**
     * Gets customerDetails
     *
     * @return \EKM\Model\OrderCustomerDetails
     */
    public function getCustomerDetails()
    {
        return $this->container['customerDetails'];
    }

    /**
     * Sets customerDetails
     *
     * @param \EKM\Model\OrderCustomerDetails $customerDetails customerDetails
     *
     * @return $this
     */
    public function setCustomerDetails($customerDetails)
    {
        $this->container['customerDetails'] = $customerDetails;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


