<?php
/**
 * CustomerAddressesApi
 * PHP version 5
 *
 * @category Class
 * @package  EKM
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * EKM Partner API
 *
 * Our new API allows partners to build significantly better integrations with the EKM platform.  To keep up to date with the latest updates, please see our [RSS feed](https://partners.ekm.net/ChangeLog/Feed) or the [partner dashboard](https://partners.ekm.net/).
 *
 * OpenAPI spec version: v1
 * Contact: support@ekm.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.3.1
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace EKM\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use EKM\ApiException;
use EKM\Configuration;
use EKM\HeaderSelector;
use EKM\ObjectSerializer;

/**
 * CustomerAddressesApi Class Doc Comment
 *
 * @category Class
 * @package  EKM
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class CustomerAddressesApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation apiV1CustomersByCustomerIdAddressesByAddressIdDelete
     *
     * Delete a Customer Address
     *
     * @param  int $customerId The Customer Id (required)
     * @param  int $addressId The Address Id (required)
     *
     * @throws \EKM\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \EKM\Model\TempestResponseCustomerAddress
     */
    public function apiV1CustomersByCustomerIdAddressesByAddressIdDelete($customerId, $addressId)
    {
        list($response) = $this->apiV1CustomersByCustomerIdAddressesByAddressIdDeleteWithHttpInfo($customerId, $addressId);
        return $response;
    }

    /**
     * Operation apiV1CustomersByCustomerIdAddressesByAddressIdDeleteWithHttpInfo
     *
     * Delete a Customer Address
     *
     * @param  int $customerId The Customer Id (required)
     * @param  int $addressId The Address Id (required)
     *
     * @throws \EKM\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \EKM\Model\TempestResponseCustomerAddress, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1CustomersByCustomerIdAddressesByAddressIdDeleteWithHttpInfo($customerId, $addressId)
    {
        $returnType = '\EKM\Model\TempestResponseCustomerAddress';
        $request = $this->apiV1CustomersByCustomerIdAddressesByAddressIdDeleteRequest($customerId, $addressId);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseCustomerAddress',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation apiV1CustomersByCustomerIdAddressesByAddressIdDeleteAsync
     *
     * Delete a Customer Address
     *
     * @param  int $customerId The Customer Id (required)
     * @param  int $addressId The Address Id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersByCustomerIdAddressesByAddressIdDeleteAsync($customerId, $addressId)
    {
        return $this->apiV1CustomersByCustomerIdAddressesByAddressIdDeleteAsyncWithHttpInfo($customerId, $addressId)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1CustomersByCustomerIdAddressesByAddressIdDeleteAsyncWithHttpInfo
     *
     * Delete a Customer Address
     *
     * @param  int $customerId The Customer Id (required)
     * @param  int $addressId The Address Id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersByCustomerIdAddressesByAddressIdDeleteAsyncWithHttpInfo($customerId, $addressId)
    {
        $returnType = '\EKM\Model\TempestResponseCustomerAddress';
        $request = $this->apiV1CustomersByCustomerIdAddressesByAddressIdDeleteRequest($customerId, $addressId);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1CustomersByCustomerIdAddressesByAddressIdDelete'
     *
     * @param  int $customerId The Customer Id (required)
     * @param  int $addressId The Address Id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function apiV1CustomersByCustomerIdAddressesByAddressIdDeleteRequest($customerId, $addressId)
    {
        // verify the required parameter 'customerId' is set
        if ($customerId === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $customerId when calling apiV1CustomersByCustomerIdAddressesByAddressIdDelete'
            );
        }
        // verify the required parameter 'addressId' is set
        if ($addressId === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $addressId when calling apiV1CustomersByCustomerIdAddressesByAddressIdDelete'
            );
        }

        $resourcePath = '/api/v1/customers/{customerId}/addresses/{addressId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // path params
        if ($customerId !== null) {
            $resourcePath = str_replace(
                '{' . 'customerId' . '}',
                ObjectSerializer::toPathValue($customerId),
                $resourcePath
            );
        }
        // path params
        if ($addressId !== null) {
            $resourcePath = str_replace(
                '{' . 'addressId' . '}',
                ObjectSerializer::toPathValue($addressId),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1CustomersByCustomerIdAddressesByAddressIdGet
     *
     * Get a single Customer Address by Id
     *
     * @param  int $customerId The Customer Id (required)
     * @param  int $addressId The Address Id (required)
     *
     * @throws \EKM\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \EKM\Model\TempestResponseCustomerAddress
     */
    public function apiV1CustomersByCustomerIdAddressesByAddressIdGet($customerId, $addressId)
    {
        list($response) = $this->apiV1CustomersByCustomerIdAddressesByAddressIdGetWithHttpInfo($customerId, $addressId);
        return $response;
    }

    /**
     * Operation apiV1CustomersByCustomerIdAddressesByAddressIdGetWithHttpInfo
     *
     * Get a single Customer Address by Id
     *
     * @param  int $customerId The Customer Id (required)
     * @param  int $addressId The Address Id (required)
     *
     * @throws \EKM\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \EKM\Model\TempestResponseCustomerAddress, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1CustomersByCustomerIdAddressesByAddressIdGetWithHttpInfo($customerId, $addressId)
    {
        $returnType = '\EKM\Model\TempestResponseCustomerAddress';
        $request = $this->apiV1CustomersByCustomerIdAddressesByAddressIdGetRequest($customerId, $addressId);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseCustomerAddress',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation apiV1CustomersByCustomerIdAddressesByAddressIdGetAsync
     *
     * Get a single Customer Address by Id
     *
     * @param  int $customerId The Customer Id (required)
     * @param  int $addressId The Address Id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersByCustomerIdAddressesByAddressIdGetAsync($customerId, $addressId)
    {
        return $this->apiV1CustomersByCustomerIdAddressesByAddressIdGetAsyncWithHttpInfo($customerId, $addressId)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1CustomersByCustomerIdAddressesByAddressIdGetAsyncWithHttpInfo
     *
     * Get a single Customer Address by Id
     *
     * @param  int $customerId The Customer Id (required)
     * @param  int $addressId The Address Id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersByCustomerIdAddressesByAddressIdGetAsyncWithHttpInfo($customerId, $addressId)
    {
        $returnType = '\EKM\Model\TempestResponseCustomerAddress';
        $request = $this->apiV1CustomersByCustomerIdAddressesByAddressIdGetRequest($customerId, $addressId);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1CustomersByCustomerIdAddressesByAddressIdGet'
     *
     * @param  int $customerId The Customer Id (required)
     * @param  int $addressId The Address Id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function apiV1CustomersByCustomerIdAddressesByAddressIdGetRequest($customerId, $addressId)
    {
        // verify the required parameter 'customerId' is set
        if ($customerId === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $customerId when calling apiV1CustomersByCustomerIdAddressesByAddressIdGet'
            );
        }
        // verify the required parameter 'addressId' is set
        if ($addressId === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $addressId when calling apiV1CustomersByCustomerIdAddressesByAddressIdGet'
            );
        }

        $resourcePath = '/api/v1/customers/{customerId}/addresses/{addressId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // path params
        if ($customerId !== null) {
            $resourcePath = str_replace(
                '{' . 'customerId' . '}',
                ObjectSerializer::toPathValue($customerId),
                $resourcePath
            );
        }
        // path params
        if ($addressId !== null) {
            $resourcePath = str_replace(
                '{' . 'addressId' . '}',
                ObjectSerializer::toPathValue($addressId),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1CustomersByCustomerIdAddressesByAddressIdPut
     *
     * Update a Customer Address
     *
     * @param  int $customerId The Customer Id (required)
     * @param  int $addressId The Address Id (required)
     * @param  \EKM\Model\CustomerAddress $address address (optional)
     *
     * @throws \EKM\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \EKM\Model\TempestResponseCustomer
     */
    public function apiV1CustomersByCustomerIdAddressesByAddressIdPut($customerId, $addressId, $address = null)
    {
        list($response) = $this->apiV1CustomersByCustomerIdAddressesByAddressIdPutWithHttpInfo($customerId, $addressId, $address);
        return $response;
    }

    /**
     * Operation apiV1CustomersByCustomerIdAddressesByAddressIdPutWithHttpInfo
     *
     * Update a Customer Address
     *
     * @param  int $customerId The Customer Id (required)
     * @param  int $addressId The Address Id (required)
     * @param  \EKM\Model\CustomerAddress $address (optional)
     *
     * @throws \EKM\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \EKM\Model\TempestResponseCustomer, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1CustomersByCustomerIdAddressesByAddressIdPutWithHttpInfo($customerId, $addressId, $address = null)
    {
        $returnType = '\EKM\Model\TempestResponseCustomer';
        $request = $this->apiV1CustomersByCustomerIdAddressesByAddressIdPutRequest($customerId, $addressId, $address);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseCustomer',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation apiV1CustomersByCustomerIdAddressesByAddressIdPutAsync
     *
     * Update a Customer Address
     *
     * @param  int $customerId The Customer Id (required)
     * @param  int $addressId The Address Id (required)
     * @param  \EKM\Model\CustomerAddress $address (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersByCustomerIdAddressesByAddressIdPutAsync($customerId, $addressId, $address = null)
    {
        return $this->apiV1CustomersByCustomerIdAddressesByAddressIdPutAsyncWithHttpInfo($customerId, $addressId, $address)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1CustomersByCustomerIdAddressesByAddressIdPutAsyncWithHttpInfo
     *
     * Update a Customer Address
     *
     * @param  int $customerId The Customer Id (required)
     * @param  int $addressId The Address Id (required)
     * @param  \EKM\Model\CustomerAddress $address (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersByCustomerIdAddressesByAddressIdPutAsyncWithHttpInfo($customerId, $addressId, $address = null)
    {
        $returnType = '\EKM\Model\TempestResponseCustomer';
        $request = $this->apiV1CustomersByCustomerIdAddressesByAddressIdPutRequest($customerId, $addressId, $address);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1CustomersByCustomerIdAddressesByAddressIdPut'
     *
     * @param  int $customerId The Customer Id (required)
     * @param  int $addressId The Address Id (required)
     * @param  \EKM\Model\CustomerAddress $address (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function apiV1CustomersByCustomerIdAddressesByAddressIdPutRequest($customerId, $addressId, $address = null)
    {
        // verify the required parameter 'customerId' is set
        if ($customerId === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $customerId when calling apiV1CustomersByCustomerIdAddressesByAddressIdPut'
            );
        }
        // verify the required parameter 'addressId' is set
        if ($addressId === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $addressId when calling apiV1CustomersByCustomerIdAddressesByAddressIdPut'
            );
        }

        $resourcePath = '/api/v1/customers/{customerId}/addresses/{addressId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // path params
        if ($customerId !== null) {
            $resourcePath = str_replace(
                '{' . 'customerId' . '}',
                ObjectSerializer::toPathValue($customerId),
                $resourcePath
            );
        }
        // path params
        if ($addressId !== null) {
            $resourcePath = str_replace(
                '{' . 'addressId' . '}',
                ObjectSerializer::toPathValue($addressId),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($address)) {
            $_tempBody = $address;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1CustomersByCustomerIdAddressesGet
     *
     * Get a paginated set of Customer Addresses
     *
     * @param  int $customerId The Customer Id (required)
     * @param  int $page Page number to display (optional, default to 1)
     * @param  int $limit Maximum number to display (optional, default to 10)
     *
     * @throws \EKM\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \EKM\Model\TempestResponseListCustomerAddress
     */
    public function apiV1CustomersByCustomerIdAddressesGet($customerId, $page = '1', $limit = '10')
    {
        list($response) = $this->apiV1CustomersByCustomerIdAddressesGetWithHttpInfo($customerId, $page, $limit);
        return $response;
    }

    /**
     * Operation apiV1CustomersByCustomerIdAddressesGetWithHttpInfo
     *
     * Get a paginated set of Customer Addresses
     *
     * @param  int $customerId The Customer Id (required)
     * @param  int $page Page number to display (optional, default to 1)
     * @param  int $limit Maximum number to display (optional, default to 10)
     *
     * @throws \EKM\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \EKM\Model\TempestResponseListCustomerAddress, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1CustomersByCustomerIdAddressesGetWithHttpInfo($customerId, $page = '1', $limit = '10')
    {
        $returnType = '\EKM\Model\TempestResponseListCustomerAddress';
        $request = $this->apiV1CustomersByCustomerIdAddressesGetRequest($customerId, $page, $limit);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseListCustomerAddress',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation apiV1CustomersByCustomerIdAddressesGetAsync
     *
     * Get a paginated set of Customer Addresses
     *
     * @param  int $customerId The Customer Id (required)
     * @param  int $page Page number to display (optional, default to 1)
     * @param  int $limit Maximum number to display (optional, default to 10)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersByCustomerIdAddressesGetAsync($customerId, $page = '1', $limit = '10')
    {
        return $this->apiV1CustomersByCustomerIdAddressesGetAsyncWithHttpInfo($customerId, $page, $limit)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1CustomersByCustomerIdAddressesGetAsyncWithHttpInfo
     *
     * Get a paginated set of Customer Addresses
     *
     * @param  int $customerId The Customer Id (required)
     * @param  int $page Page number to display (optional, default to 1)
     * @param  int $limit Maximum number to display (optional, default to 10)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersByCustomerIdAddressesGetAsyncWithHttpInfo($customerId, $page = '1', $limit = '10')
    {
        $returnType = '\EKM\Model\TempestResponseListCustomerAddress';
        $request = $this->apiV1CustomersByCustomerIdAddressesGetRequest($customerId, $page, $limit);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1CustomersByCustomerIdAddressesGet'
     *
     * @param  int $customerId The Customer Id (required)
     * @param  int $page Page number to display (optional, default to 1)
     * @param  int $limit Maximum number to display (optional, default to 10)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function apiV1CustomersByCustomerIdAddressesGetRequest($customerId, $page = '1', $limit = '10')
    {
        // verify the required parameter 'customerId' is set
        if ($customerId === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $customerId when calling apiV1CustomersByCustomerIdAddressesGet'
            );
        }

        $resourcePath = '/api/v1/customers/{customerId}/addresses';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($page !== null) {
            $queryParams['page'] = ObjectSerializer::toQueryValue($page);
        }
        // query params
        if ($limit !== null) {
            $queryParams['limit'] = ObjectSerializer::toQueryValue($limit);
        }

        // path params
        if ($customerId !== null) {
            $resourcePath = str_replace(
                '{' . 'customerId' . '}',
                ObjectSerializer::toPathValue($customerId),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1CustomersByCustomerIdAddressesPost
     *
     * Add a Customer Address
     *
     * @param  int $customerId The Customer Id (required)
     * @param  \EKM\Model\CustomerAddress $address address (optional)
     *
     * @throws \EKM\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \EKM\Model\TempestResponseCustomerAddress
     */
    public function apiV1CustomersByCustomerIdAddressesPost($customerId, $address = null)
    {
        list($response) = $this->apiV1CustomersByCustomerIdAddressesPostWithHttpInfo($customerId, $address);
        return $response;
    }

    /**
     * Operation apiV1CustomersByCustomerIdAddressesPostWithHttpInfo
     *
     * Add a Customer Address
     *
     * @param  int $customerId The Customer Id (required)
     * @param  \EKM\Model\CustomerAddress $address (optional)
     *
     * @throws \EKM\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \EKM\Model\TempestResponseCustomerAddress, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1CustomersByCustomerIdAddressesPostWithHttpInfo($customerId, $address = null)
    {
        $returnType = '\EKM\Model\TempestResponseCustomerAddress';
        $request = $this->apiV1CustomersByCustomerIdAddressesPostRequest($customerId, $address);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseCustomerAddress',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation apiV1CustomersByCustomerIdAddressesPostAsync
     *
     * Add a Customer Address
     *
     * @param  int $customerId The Customer Id (required)
     * @param  \EKM\Model\CustomerAddress $address (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersByCustomerIdAddressesPostAsync($customerId, $address = null)
    {
        return $this->apiV1CustomersByCustomerIdAddressesPostAsyncWithHttpInfo($customerId, $address)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1CustomersByCustomerIdAddressesPostAsyncWithHttpInfo
     *
     * Add a Customer Address
     *
     * @param  int $customerId The Customer Id (required)
     * @param  \EKM\Model\CustomerAddress $address (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersByCustomerIdAddressesPostAsyncWithHttpInfo($customerId, $address = null)
    {
        $returnType = '\EKM\Model\TempestResponseCustomerAddress';
        $request = $this->apiV1CustomersByCustomerIdAddressesPostRequest($customerId, $address);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1CustomersByCustomerIdAddressesPost'
     *
     * @param  int $customerId The Customer Id (required)
     * @param  \EKM\Model\CustomerAddress $address (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function apiV1CustomersByCustomerIdAddressesPostRequest($customerId, $address = null)
    {
        // verify the required parameter 'customerId' is set
        if ($customerId === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $customerId when calling apiV1CustomersByCustomerIdAddressesPost'
            );
        }

        $resourcePath = '/api/v1/customers/{customerId}/addresses';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // path params
        if ($customerId !== null) {
            $resourcePath = str_replace(
                '{' . 'customerId' . '}',
                ObjectSerializer::toPathValue($customerId),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($address)) {
            $_tempBody = $address;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1CustomersByCustomerIdAddressesSearchGet
     *
     * Searches customer addresses based on search criteria
     *
     * @param  int $customerId The Customer Id (required)
     * @param  int $page Page number to display (optional, default to 1)
     * @param  int $limit Maximum number to display (optional, default to 10)
     * @param  string $query An &lt;a href&#x3D;\&quot;http://www.odata.org/\&quot; target&#x3D;\&quot;_blank\&quot;&gt;OData&lt;/a&gt; query e.g. email_address eq &#39;test@ekm.com&#39; (optional)
     * @param  string $orderby Field to order results. Prefix with a - (dash) for descending e.g. -id (optional)
     *
     * @throws \EKM\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \EKM\Model\TempestResponseListCustomerAddress
     */
    public function apiV1CustomersByCustomerIdAddressesSearchGet($customerId, $page = '1', $limit = '10', $query = null, $orderby = null)
    {
        list($response) = $this->apiV1CustomersByCustomerIdAddressesSearchGetWithHttpInfo($customerId, $page, $limit, $query, $orderby);
        return $response;
    }

    /**
     * Operation apiV1CustomersByCustomerIdAddressesSearchGetWithHttpInfo
     *
     * Searches customer addresses based on search criteria
     *
     * @param  int $customerId The Customer Id (required)
     * @param  int $page Page number to display (optional, default to 1)
     * @param  int $limit Maximum number to display (optional, default to 10)
     * @param  string $query An &lt;a href&#x3D;\&quot;http://www.odata.org/\&quot; target&#x3D;\&quot;_blank\&quot;&gt;OData&lt;/a&gt; query e.g. email_address eq &#39;test@ekm.com&#39; (optional)
     * @param  string $orderby Field to order results. Prefix with a - (dash) for descending e.g. -id (optional)
     *
     * @throws \EKM\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \EKM\Model\TempestResponseListCustomerAddress, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1CustomersByCustomerIdAddressesSearchGetWithHttpInfo($customerId, $page = '1', $limit = '10', $query = null, $orderby = null)
    {
        $returnType = '\EKM\Model\TempestResponseListCustomerAddress';
        $request = $this->apiV1CustomersByCustomerIdAddressesSearchGetRequest($customerId, $page, $limit, $query, $orderby);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseListCustomerAddress',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation apiV1CustomersByCustomerIdAddressesSearchGetAsync
     *
     * Searches customer addresses based on search criteria
     *
     * @param  int $customerId The Customer Id (required)
     * @param  int $page Page number to display (optional, default to 1)
     * @param  int $limit Maximum number to display (optional, default to 10)
     * @param  string $query An &lt;a href&#x3D;\&quot;http://www.odata.org/\&quot; target&#x3D;\&quot;_blank\&quot;&gt;OData&lt;/a&gt; query e.g. email_address eq &#39;test@ekm.com&#39; (optional)
     * @param  string $orderby Field to order results. Prefix with a - (dash) for descending e.g. -id (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersByCustomerIdAddressesSearchGetAsync($customerId, $page = '1', $limit = '10', $query = null, $orderby = null)
    {
        return $this->apiV1CustomersByCustomerIdAddressesSearchGetAsyncWithHttpInfo($customerId, $page, $limit, $query, $orderby)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1CustomersByCustomerIdAddressesSearchGetAsyncWithHttpInfo
     *
     * Searches customer addresses based on search criteria
     *
     * @param  int $customerId The Customer Id (required)
     * @param  int $page Page number to display (optional, default to 1)
     * @param  int $limit Maximum number to display (optional, default to 10)
     * @param  string $query An &lt;a href&#x3D;\&quot;http://www.odata.org/\&quot; target&#x3D;\&quot;_blank\&quot;&gt;OData&lt;/a&gt; query e.g. email_address eq &#39;test@ekm.com&#39; (optional)
     * @param  string $orderby Field to order results. Prefix with a - (dash) for descending e.g. -id (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersByCustomerIdAddressesSearchGetAsyncWithHttpInfo($customerId, $page = '1', $limit = '10', $query = null, $orderby = null)
    {
        $returnType = '\EKM\Model\TempestResponseListCustomerAddress';
        $request = $this->apiV1CustomersByCustomerIdAddressesSearchGetRequest($customerId, $page, $limit, $query, $orderby);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1CustomersByCustomerIdAddressesSearchGet'
     *
     * @param  int $customerId The Customer Id (required)
     * @param  int $page Page number to display (optional, default to 1)
     * @param  int $limit Maximum number to display (optional, default to 10)
     * @param  string $query An &lt;a href&#x3D;\&quot;http://www.odata.org/\&quot; target&#x3D;\&quot;_blank\&quot;&gt;OData&lt;/a&gt; query e.g. email_address eq &#39;test@ekm.com&#39; (optional)
     * @param  string $orderby Field to order results. Prefix with a - (dash) for descending e.g. -id (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function apiV1CustomersByCustomerIdAddressesSearchGetRequest($customerId, $page = '1', $limit = '10', $query = null, $orderby = null)
    {
        // verify the required parameter 'customerId' is set
        if ($customerId === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $customerId when calling apiV1CustomersByCustomerIdAddressesSearchGet'
            );
        }

        $resourcePath = '/api/v1/customers/{customerId}/addresses/search';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($page !== null) {
            $queryParams['page'] = ObjectSerializer::toQueryValue($page);
        }
        // query params
        if ($limit !== null) {
            $queryParams['limit'] = ObjectSerializer::toQueryValue($limit);
        }
        // query params
        if ($query !== null) {
            $queryParams['query'] = ObjectSerializer::toQueryValue($query);
        }
        // query params
        if ($orderby !== null) {
            $queryParams['orderby'] = ObjectSerializer::toQueryValue($orderby);
        }

        // path params
        if ($customerId !== null) {
            $resourcePath = str_replace(
                '{' . 'customerId' . '}',
                ObjectSerializer::toPathValue($customerId),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
