# EKM\WebhooksApi

All URIs are relative to *https://api.ekm.net*

Method | HTTP request | Description
------------- | ------------- | -------------
[**apiV1WebhooksDelete**](WebhooksApi.md#apiV1WebhooksDelete) | **DELETE** /api/v1/webhooks | Unsubscribe from a webhook
[**apiV1WebhooksPut**](WebhooksApi.md#apiV1WebhooksPut) | **PUT** /api/v1/webhooks | Subscribe to a webhook


# **apiV1WebhooksDelete**
> apiV1WebhooksDelete($topic)

Unsubscribe from a webhook

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new EKM\Api\WebhooksApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$topic = "topic_example"; // string | The topic to unsubscribe from

try {
    $apiInstance->apiV1WebhooksDelete($topic);
} catch (Exception $e) {
    echo 'Exception when calling WebhooksApi->apiV1WebhooksDelete: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **topic** | **string**| The topic to unsubscribe from |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **apiV1WebhooksPut**
> apiV1WebhooksPut($topic, $endpoint)

Subscribe to a webhook

Webhooks allow an application to subscribe to events, or topics, happening on a Merchant's shop, so they can react to these events without polling the API.  Currently we offer the following topics:  | Friendly Name | Topic Name | Topic Description | |:-------------:|:----------:|-------------------| |Order Created|order.created|This event is fired whenever a Shopper passes completely through the checkout process.|  A `POST` request will be made to subscribed endpoints with the following JSON body:  `{ 'username': '<merchantUsername>', 'topic': '<webhookTopic>', entity_id: '<entityId>' }` | Field | Description | |:-----:|-------------| | merchantUsername | The username of the merchant. This can be used for identifying which merchant this event belongs to. The username for a given bearer token can be found by looking at the `sub` value stored inside the token. | | webhookTopic | The topic from the above list which caused this event to be fired | | entityId | An Id relevant to the topic of this event. For `order.created` events for example, this would be the order id. |  ## Timeouts When sending an event, we will wait for 5 seconds.  This may sound like a long time, but this includes all of the network traversal from our application to your application. We suggest that you queue messages and respond with a 200 OK response as soon as possible, processing events from your queue later.  ## Duplicates Please be aware that we will potentially send duplicate events. It is left as a task for the application implementer to deal with these duplicates.  ## Retries If we fail to receive a 200 OK response within 5 seconds of sending the event, we will attempt to resend the event 20 times with an exponential delay.  The formula we use to figure out the delay is as follows:  `function getDelay(n) { let result = 200; for(var i = 0; i < n; i++) { result *= 1.97; } return result; }`  | Retry Count | Delay in milliseconds | Friendly Delay | |:-----------:|:---------------------:|:--------------:| | 1 | 200 | 200 ms | | 2 | 394 | 394 ms | | 3 | 776.18 | 776 ms | | 4 | 1529.07 | 1.5 seconds | | ... | ... | ... | | 18 | 20274765.527682442 | 5 hours |  | 19 | 39941288.08953441 | 11 hours | | 20 | 78684337.53638278 | 21 hours |

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new EKM\Api\WebhooksApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$topic = "topic_example"; // string | The topic to subscribe to
$endpoint = "endpoint_example"; // string | The endpoint to send webhooks to

try {
    $apiInstance->apiV1WebhooksPut($topic, $endpoint);
} catch (Exception $e) {
    echo 'Exception when calling WebhooksApi->apiV1WebhooksPut: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **topic** | **string**| The topic to subscribe to |
 **endpoint** | **string**| The endpoint to send webhooks to |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

