# EKM\ProductStockApi

All URIs are relative to *https://api.ekm.net*

Method | HTTP request | Description
------------- | ------------- | -------------
[**apiV1ProductsByIdStockGet**](ProductStockApi.md#apiV1ProductsByIdStockGet) | **GET** /api/v1/products/{id}/stock | Get the stock for a product
[**apiV1ProductsByIdStockPut**](ProductStockApi.md#apiV1ProductsByIdStockPut) | **PUT** /api/v1/products/{id}/stock | Set the stock for a product


# **apiV1ProductsByIdStockGet**
> \EKM\Model\TempestResponseProductStock apiV1ProductsByIdStockGet($id)

Get the stock for a product

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new EKM\Api\ProductStockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 789; // int | The product ID

try {
    $result = $apiInstance->apiV1ProductsByIdStockGet($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductStockApi->apiV1ProductsByIdStockGet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| The product ID |

### Return type

[**\EKM\Model\TempestResponseProductStock**](../Model/TempestResponseProductStock.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **apiV1ProductsByIdStockPut**
> \EKM\Model\TempestResponseProductStock apiV1ProductsByIdStockPut($id, $stock)

Set the stock for a product

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new EKM\Api\ProductStockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 789; // int | The product ID
$stock = new \EKM\Model\ProductStock(); // \EKM\Model\ProductStock | 

try {
    $result = $apiInstance->apiV1ProductsByIdStockPut($id, $stock);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductStockApi->apiV1ProductsByIdStockPut: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| The product ID |
 **stock** | [**\EKM\Model\ProductStock**](../Model/ProductStock.md)|  | [optional]

### Return type

[**\EKM\Model\TempestResponseProductStock**](../Model/TempestResponseProductStock.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

