# EKM\OrdersApi

All URIs are relative to *https://api.ekm.net*

Method | HTTP request | Description
------------- | ------------- | -------------
[**apiV1OrdersByIdGet**](OrdersApi.md#apiV1OrdersByIdGet) | **GET** /api/v1/orders/{id} | Get a single Order by Id
[**apiV1OrdersByIdStatusPut**](OrdersApi.md#apiV1OrdersByIdStatusPut) | **PUT** /api/v1/orders/{id}/status | Updates the status of a chosen order
[**apiV1OrdersGet**](OrdersApi.md#apiV1OrdersGet) | **GET** /api/v1/orders | Get a paginated set of orders
[**apiV1OrdersSearchGet**](OrdersApi.md#apiV1OrdersSearchGet) | **GET** /api/v1/orders/search | Searches orders based on search criteria


# **apiV1OrdersByIdGet**
> \EKM\Model\TempestResponseOrder apiV1OrdersByIdGet($id)

Get a single Order by Id

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new EKM\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 789; // int | The Order Id

try {
    $result = $apiInstance->apiV1OrdersByIdGet($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->apiV1OrdersByIdGet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| The Order Id |

### Return type

[**\EKM\Model\TempestResponseOrder**](../Model/TempestResponseOrder.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **apiV1OrdersByIdStatusPut**
> \EKM\Model\TempestResponseOrder apiV1OrdersByIdStatusPut($id, $orderStatus)

Updates the status of a chosen order

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new EKM\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 789; // int | The Order Id
$orderStatus = new \EKM\Model\OrderStatus(); // \EKM\Model\OrderStatus | 

try {
    $result = $apiInstance->apiV1OrdersByIdStatusPut($id, $orderStatus);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->apiV1OrdersByIdStatusPut: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| The Order Id |
 **orderStatus** | [**\EKM\Model\OrderStatus**](../Model/OrderStatus.md)|  | [optional]

### Return type

[**\EKM\Model\TempestResponseOrder**](../Model/TempestResponseOrder.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **apiV1OrdersGet**
> \EKM\Model\TempestResponseListOrder apiV1OrdersGet($page, $limit)

Get a paginated set of orders

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new EKM\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page = 1; // int | Page number to display
$limit = 10; // int | Maximum number to display

try {
    $result = $apiInstance->apiV1OrdersGet($page, $limit);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->apiV1OrdersGet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page** | **int**| Page number to display | [optional] [default to 1]
 **limit** | **int**| Maximum number to display | [optional] [default to 10]

### Return type

[**\EKM\Model\TempestResponseListOrder**](../Model/TempestResponseListOrder.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **apiV1OrdersSearchGet**
> \EKM\Model\TempestResponseListOrder apiV1OrdersSearchGet($page, $limit, $query, $orderby)

Searches orders based on search criteria

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new EKM\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page = 1; // int | Page number to display
$limit = 10; // int | Maximum number to display
$query = "query_example"; // string | An <a href=\"http://www.odata.org/\" target=\"_blank\">OData</a> query e.g. status eq 'PENDING'
$orderby = "orderby_example"; // string | Field to order results. Prefix with a - (dash) for descending e.g. -id

try {
    $result = $apiInstance->apiV1OrdersSearchGet($page, $limit, $query, $orderby);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->apiV1OrdersSearchGet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page** | **int**| Page number to display | [optional] [default to 1]
 **limit** | **int**| Maximum number to display | [optional] [default to 10]
 **query** | **string**| An &lt;a href&#x3D;\&quot;http://www.odata.org/\&quot; target&#x3D;\&quot;_blank\&quot;&gt;OData&lt;/a&gt; query e.g. status eq &#39;PENDING&#39; | [optional]
 **orderby** | **string**| Field to order results. Prefix with a - (dash) for descending e.g. -id | [optional]

### Return type

[**\EKM\Model\TempestResponseListOrder**](../Model/TempestResponseListOrder.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

