# EKM\CustomerAddressesApi

All URIs are relative to *https://api.ekm.net*

Method | HTTP request | Description
------------- | ------------- | -------------
[**apiV1CustomersByCustomerIdAddressesByAddressIdDelete**](CustomerAddressesApi.md#apiV1CustomersByCustomerIdAddressesByAddressIdDelete) | **DELETE** /api/v1/customers/{customerId}/addresses/{addressId} | Delete a Customer Address
[**apiV1CustomersByCustomerIdAddressesByAddressIdGet**](CustomerAddressesApi.md#apiV1CustomersByCustomerIdAddressesByAddressIdGet) | **GET** /api/v1/customers/{customerId}/addresses/{addressId} | Get a single Customer Address by Id
[**apiV1CustomersByCustomerIdAddressesByAddressIdPut**](CustomerAddressesApi.md#apiV1CustomersByCustomerIdAddressesByAddressIdPut) | **PUT** /api/v1/customers/{customerId}/addresses/{addressId} | Update a Customer Address
[**apiV1CustomersByCustomerIdAddressesGet**](CustomerAddressesApi.md#apiV1CustomersByCustomerIdAddressesGet) | **GET** /api/v1/customers/{customerId}/addresses | Get a paginated set of Customer Addresses
[**apiV1CustomersByCustomerIdAddressesPost**](CustomerAddressesApi.md#apiV1CustomersByCustomerIdAddressesPost) | **POST** /api/v1/customers/{customerId}/addresses | Add a Customer Address
[**apiV1CustomersByCustomerIdAddressesSearchGet**](CustomerAddressesApi.md#apiV1CustomersByCustomerIdAddressesSearchGet) | **GET** /api/v1/customers/{customerId}/addresses/search | Searches customer addresses based on search criteria


# **apiV1CustomersByCustomerIdAddressesByAddressIdDelete**
> \EKM\Model\TempestResponseCustomerAddress apiV1CustomersByCustomerIdAddressesByAddressIdDelete($customerId, $addressId)

Delete a Customer Address

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new EKM\Api\CustomerAddressesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customerId = 789; // int | The Customer Id
$addressId = 789; // int | The Address Id

try {
    $result = $apiInstance->apiV1CustomersByCustomerIdAddressesByAddressIdDelete($customerId, $addressId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerAddressesApi->apiV1CustomersByCustomerIdAddressesByAddressIdDelete: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **customerId** | **int**| The Customer Id |
 **addressId** | **int**| The Address Id |

### Return type

[**\EKM\Model\TempestResponseCustomerAddress**](../Model/TempestResponseCustomerAddress.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **apiV1CustomersByCustomerIdAddressesByAddressIdGet**
> \EKM\Model\TempestResponseCustomerAddress apiV1CustomersByCustomerIdAddressesByAddressIdGet($customerId, $addressId)

Get a single Customer Address by Id

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new EKM\Api\CustomerAddressesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customerId = 789; // int | The Customer Id
$addressId = 789; // int | The Address Id

try {
    $result = $apiInstance->apiV1CustomersByCustomerIdAddressesByAddressIdGet($customerId, $addressId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerAddressesApi->apiV1CustomersByCustomerIdAddressesByAddressIdGet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **customerId** | **int**| The Customer Id |
 **addressId** | **int**| The Address Id |

### Return type

[**\EKM\Model\TempestResponseCustomerAddress**](../Model/TempestResponseCustomerAddress.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **apiV1CustomersByCustomerIdAddressesByAddressIdPut**
> \EKM\Model\TempestResponseCustomer apiV1CustomersByCustomerIdAddressesByAddressIdPut($customerId, $addressId, $address)

Update a Customer Address

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new EKM\Api\CustomerAddressesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customerId = 789; // int | The Customer Id
$addressId = 789; // int | The Address Id
$address = new \EKM\Model\CustomerAddress(); // \EKM\Model\CustomerAddress | 

try {
    $result = $apiInstance->apiV1CustomersByCustomerIdAddressesByAddressIdPut($customerId, $addressId, $address);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerAddressesApi->apiV1CustomersByCustomerIdAddressesByAddressIdPut: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **customerId** | **int**| The Customer Id |
 **addressId** | **int**| The Address Id |
 **address** | [**\EKM\Model\CustomerAddress**](../Model/CustomerAddress.md)|  | [optional]

### Return type

[**\EKM\Model\TempestResponseCustomer**](../Model/TempestResponseCustomer.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **apiV1CustomersByCustomerIdAddressesGet**
> \EKM\Model\TempestResponseListCustomerAddress apiV1CustomersByCustomerIdAddressesGet($customerId, $page, $limit)

Get a paginated set of Customer Addresses

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new EKM\Api\CustomerAddressesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customerId = 789; // int | The Customer Id
$page = 1; // int | Page number to display
$limit = 10; // int | Maximum number to display

try {
    $result = $apiInstance->apiV1CustomersByCustomerIdAddressesGet($customerId, $page, $limit);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerAddressesApi->apiV1CustomersByCustomerIdAddressesGet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **customerId** | **int**| The Customer Id |
 **page** | **int**| Page number to display | [optional] [default to 1]
 **limit** | **int**| Maximum number to display | [optional] [default to 10]

### Return type

[**\EKM\Model\TempestResponseListCustomerAddress**](../Model/TempestResponseListCustomerAddress.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **apiV1CustomersByCustomerIdAddressesPost**
> \EKM\Model\TempestResponseCustomerAddress apiV1CustomersByCustomerIdAddressesPost($customerId, $address)

Add a Customer Address

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new EKM\Api\CustomerAddressesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customerId = 789; // int | The Customer Id
$address = new \EKM\Model\CustomerAddress(); // \EKM\Model\CustomerAddress | 

try {
    $result = $apiInstance->apiV1CustomersByCustomerIdAddressesPost($customerId, $address);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerAddressesApi->apiV1CustomersByCustomerIdAddressesPost: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **customerId** | **int**| The Customer Id |
 **address** | [**\EKM\Model\CustomerAddress**](../Model/CustomerAddress.md)|  | [optional]

### Return type

[**\EKM\Model\TempestResponseCustomerAddress**](../Model/TempestResponseCustomerAddress.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **apiV1CustomersByCustomerIdAddressesSearchGet**
> \EKM\Model\TempestResponseListCustomerAddress apiV1CustomersByCustomerIdAddressesSearchGet($customerId, $page, $limit, $query, $orderby)

Searches customer addresses based on search criteria

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new EKM\Api\CustomerAddressesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customerId = 789; // int | The Customer Id
$page = 1; // int | Page number to display
$limit = 10; // int | Maximum number to display
$query = "query_example"; // string | An <a href=\"http://www.odata.org/\" target=\"_blank\">OData</a> query e.g. email_address eq 'test@ekm.com'
$orderby = "orderby_example"; // string | Field to order results. Prefix with a - (dash) for descending e.g. -id

try {
    $result = $apiInstance->apiV1CustomersByCustomerIdAddressesSearchGet($customerId, $page, $limit, $query, $orderby);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerAddressesApi->apiV1CustomersByCustomerIdAddressesSearchGet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **customerId** | **int**| The Customer Id |
 **page** | **int**| Page number to display | [optional] [default to 1]
 **limit** | **int**| Maximum number to display | [optional] [default to 10]
 **query** | **string**| An &lt;a href&#x3D;\&quot;http://www.odata.org/\&quot; target&#x3D;\&quot;_blank\&quot;&gt;OData&lt;/a&gt; query e.g. email_address eq &#39;test@ekm.com&#39; | [optional]
 **orderby** | **string**| Field to order results. Prefix with a - (dash) for descending e.g. -id | [optional]

### Return type

[**\EKM\Model\TempestResponseListCustomerAddress**](../Model/TempestResponseListCustomerAddress.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

