# .
Our new API allows partners to build significantly better integrations with the EKM platform.  To keep up to date with the latest updates, please see our [RSS feed](https://partners.ekm.net/ChangeLog/Feed) or the [partner dashboard](https://partners.ekm.net/).

This PHP package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: v1
- Package version: 1.0
- Build package: io.swagger.codegen.languages.PhpClientCodegen
For more information, please visit [https://ekm.com](https://ekm.com)

## Requirements

PHP 5.5 and later

## Installation & Usage
### Composer

To install the bindings via [Composer](http://getcomposer.org/), add the following to `composer.json`:

```
{
  "repositories": [
    {
      "type": "git",
      "url": "https://github.com/Talisman/EKM.git"
    }
  ],
  "require": {
    "Talisman/EKM": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
    require_once('/path/to/./vendor/autoload.php');
```

## Tests

To run the unit tests:

```
composer install
./vendor/bin/phpunit
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new EKM\Api\CategoriesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 789; // int | 
$childCategoryId = 789; // int | 

try {
    $result = $apiInstance->apiV1CategoriesByIdCategorymanagedByChildCategoryIdDelete($id, $childCategoryId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CategoriesApi->apiV1CategoriesByIdCategorymanagedByChildCategoryIdDelete: ', $e->getMessage(), PHP_EOL;
}

?>
```

## Documentation for API Endpoints

All URIs are relative to *https://api.ekm.net*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*CategoriesApi* | [**apiV1CategoriesByIdCategorymanagedByChildCategoryIdDelete**](docs/Api/CategoriesApi.md#apiv1categoriesbyidcategorymanagedbychildcategoryiddelete) | **DELETE** /api/v1/categories/{id}/categorymanaged/{childCategoryId} | Stops a category from being managed by another category
*CategoriesApi* | [**apiV1CategoriesByIdCategorymanagedByChildCategoryIdPost**](docs/Api/CategoriesApi.md#apiv1categoriesbyidcategorymanagedbychildcategoryidpost) | **POST** /api/v1/categories/{id}/categorymanaged/{childCategoryId} | Set a category to be managed by another category
*CategoriesApi* | [**apiV1CategoriesByIdDelete**](docs/Api/CategoriesApi.md#apiv1categoriesbyiddelete) | **DELETE** /api/v1/categories/{id} | Delete a category
*CategoriesApi* | [**apiV1CategoriesByIdGet**](docs/Api/CategoriesApi.md#apiv1categoriesbyidget) | **GET** /api/v1/categories/{id} | Get a category
*CategoriesApi* | [**apiV1CategoriesByIdPut**](docs/Api/CategoriesApi.md#apiv1categoriesbyidput) | **PUT** /api/v1/categories/{id} | Update a category
*CategoriesApi* | [**apiV1CategoriesByIdSubcategoriesGet**](docs/Api/CategoriesApi.md#apiv1categoriesbyidsubcategoriesget) | **GET** /api/v1/categories/{id}/subcategories | Get a paginated set of subcategories
*CategoriesApi* | [**apiV1CategoriesGet**](docs/Api/CategoriesApi.md#apiv1categoriesget) | **GET** /api/v1/categories | Get a paginated set of categories
*CategoriesApi* | [**apiV1CategoriesPost**](docs/Api/CategoriesApi.md#apiv1categoriespost) | **POST** /api/v1/categories | Add a category
*CategoriesApi* | [**apiV1CategoriesSearchGet**](docs/Api/CategoriesApi.md#apiv1categoriessearchget) | **GET** /api/v1/categories/search | Searches categories based on search criteria
*CustomerAddressesApi* | [**apiV1CustomersByCustomerIdAddressesByAddressIdDelete**](docs/Api/CustomerAddressesApi.md#apiv1customersbycustomeridaddressesbyaddressiddelete) | **DELETE** /api/v1/customers/{customerId}/addresses/{addressId} | Delete a Customer Address
*CustomerAddressesApi* | [**apiV1CustomersByCustomerIdAddressesByAddressIdGet**](docs/Api/CustomerAddressesApi.md#apiv1customersbycustomeridaddressesbyaddressidget) | **GET** /api/v1/customers/{customerId}/addresses/{addressId} | Get a single Customer Address by Id
*CustomerAddressesApi* | [**apiV1CustomersByCustomerIdAddressesByAddressIdPut**](docs/Api/CustomerAddressesApi.md#apiv1customersbycustomeridaddressesbyaddressidput) | **PUT** /api/v1/customers/{customerId}/addresses/{addressId} | Update a Customer Address
*CustomerAddressesApi* | [**apiV1CustomersByCustomerIdAddressesGet**](docs/Api/CustomerAddressesApi.md#apiv1customersbycustomeridaddressesget) | **GET** /api/v1/customers/{customerId}/addresses | Get a paginated set of Customer Addresses
*CustomerAddressesApi* | [**apiV1CustomersByCustomerIdAddressesPost**](docs/Api/CustomerAddressesApi.md#apiv1customersbycustomeridaddressespost) | **POST** /api/v1/customers/{customerId}/addresses | Add a Customer Address
*CustomerAddressesApi* | [**apiV1CustomersByCustomerIdAddressesSearchGet**](docs/Api/CustomerAddressesApi.md#apiv1customersbycustomeridaddressessearchget) | **GET** /api/v1/customers/{customerId}/addresses/search | Searches customer addresses based on search criteria
*CustomersApi* | [**apiV1CustomersByIdDelete**](docs/Api/CustomersApi.md#apiv1customersbyiddelete) | **DELETE** /api/v1/customers/{id} | Delete a Customer
*CustomersApi* | [**apiV1CustomersByIdGet**](docs/Api/CustomersApi.md#apiv1customersbyidget) | **GET** /api/v1/customers/{id} | Get a single Customer by Id
*CustomersApi* | [**apiV1CustomersByIdPut**](docs/Api/CustomersApi.md#apiv1customersbyidput) | **PUT** /api/v1/customers/{id} | Update a Customer
*CustomersApi* | [**apiV1CustomersGet**](docs/Api/CustomersApi.md#apiv1customersget) | **GET** /api/v1/customers | Get a paginated set of Customers
*CustomersApi* | [**apiV1CustomersPost**](docs/Api/CustomersApi.md#apiv1customerspost) | **POST** /api/v1/customers | Add a customer
*CustomersApi* | [**apiV1CustomersSearchGet**](docs/Api/CustomersApi.md#apiv1customerssearchget) | **GET** /api/v1/customers/search | Searches customers based on search criteria
*DomainsApi* | [**apiV1SettingsDomainsGet**](docs/Api/DomainsApi.md#apiv1settingsdomainsget) | **GET** /api/v1/settings/domains | Get the current Primary Domain
*OrderStatusesApi* | [**apiV1SettingsOrderstatusesGet**](docs/Api/OrderStatusesApi.md#apiv1settingsorderstatusesget) | **GET** /api/v1/settings/orderstatuses | Get the current Order Statuses
*OrdersApi* | [**apiV1OrdersByIdGet**](docs/Api/OrdersApi.md#apiv1ordersbyidget) | **GET** /api/v1/orders/{id} | Get a single Order by Id
*OrdersApi* | [**apiV1OrdersByIdStatusPut**](docs/Api/OrdersApi.md#apiv1ordersbyidstatusput) | **PUT** /api/v1/orders/{id}/status | Updates the status of a chosen order
*OrdersApi* | [**apiV1OrdersGet**](docs/Api/OrdersApi.md#apiv1ordersget) | **GET** /api/v1/orders | Get a paginated set of orders
*OrdersApi* | [**apiV1OrdersSearchGet**](docs/Api/OrdersApi.md#apiv1orderssearchget) | **GET** /api/v1/orders/search | Searches orders based on search criteria
*PlansApi* | [**apiV1SettingsPlansByIdGet**](docs/Api/PlansApi.md#apiv1settingsplansbyidget) | **GET** /api/v1/settings/plans/{id} | Get a plan by id
*PlansApi* | [**apiV1SettingsPlansCurrentGet**](docs/Api/PlansApi.md#apiv1settingsplanscurrentget) | **GET** /api/v1/settings/plans/current | Get the current users plan
*PlansApi* | [**apiV1SettingsPlansGet**](docs/Api/PlansApi.md#apiv1settingsplansget) | **GET** /api/v1/settings/plans | Get all plans
*ProductAttributeItemsApi* | [**apiV1ProductsByIdAttributesByAttrIdDelete**](docs/Api/ProductAttributeItemsApi.md#apiv1productsbyidattributesbyattriddelete) | **DELETE** /api/v1/products/{id}/attributes/{attrId} | Delete an attribute item
*ProductAttributeItemsApi* | [**apiV1ProductsByIdAttributesByAttributeKeyGet**](docs/Api/ProductAttributeItemsApi.md#apiv1productsbyidattributesbyattributekeyget) | **GET** /api/v1/products/{id}/attributes/{attribute_key} | Get a product attribute item
*ProductAttributeItemsApi* | [**apiV1ProductsByIdAttributesByAttributeKeyPut**](docs/Api/ProductAttributeItemsApi.md#apiv1productsbyidattributesbyattributekeyput) | **PUT** /api/v1/products/{id}/attributes/{attribute_key} | Update a product attribute item
*ProductAttributeItemsApi* | [**apiV1ProductsByIdAttributesGet**](docs/Api/ProductAttributeItemsApi.md#apiv1productsbyidattributesget) | **GET** /api/v1/products/{id}/attributes | Get all of a products attribute items
*ProductAttributeItemsApi* | [**apiV1ProductsByIdAttributesPost**](docs/Api/ProductAttributeItemsApi.md#apiv1productsbyidattributespost) | **POST** /api/v1/products/{id}/attributes | Add a attribute item to a product
*ProductAttributesApi* | [**apiV1SettingsProductattributesByAttributeKeyDelete**](docs/Api/ProductAttributesApi.md#apiv1settingsproductattributesbyattributekeydelete) | **DELETE** /api/v1/settings/productattributes/{attribute_key} | Delete a product attribute
*ProductAttributesApi* | [**apiV1SettingsProductattributesByAttributeKeyGet**](docs/Api/ProductAttributesApi.md#apiv1settingsproductattributesbyattributekeyget) | **GET** /api/v1/settings/productattributes/{attribute_key} | Get a product attribute
*ProductAttributesApi* | [**apiV1SettingsProductattributesByAttributeKeyPut**](docs/Api/ProductAttributesApi.md#apiv1settingsproductattributesbyattributekeyput) | **PUT** /api/v1/settings/productattributes/{attribute_key} | Update a product attribute
*ProductAttributesApi* | [**apiV1SettingsProductattributesGet**](docs/Api/ProductAttributesApi.md#apiv1settingsproductattributesget) | **GET** /api/v1/settings/productattributes | Get all product attributes
*ProductAttributesApi* | [**apiV1SettingsProductattributesPost**](docs/Api/ProductAttributesApi.md#apiv1settingsproductattributespost) | **POST** /api/v1/settings/productattributes | Add a product attribute
*ProductOptionItemsApi* | [**apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdDelete**](docs/Api/ProductOptionItemsApi.md#apiv1productsbyidoptionsbyoptioniditemsbyoptionitemiddelete) | **DELETE** /api/v1/products/{id}/options/{optionId}/items/{optionItemId} | Delete an option item
*ProductOptionItemsApi* | [**apiV1ProductsByIdOptionsByOptionIdItemsByOptionItemIdPut**](docs/Api/ProductOptionItemsApi.md#apiv1productsbyidoptionsbyoptioniditemsbyoptionitemidput) | **PUT** /api/v1/products/{id}/options/{optionId}/items/{optionItemId} | Update a product option item
*ProductOptionItemsApi* | [**apiV1ProductsByIdOptionsByOptionIdItemsPost**](docs/Api/ProductOptionItemsApi.md#apiv1productsbyidoptionsbyoptioniditemspost) | **POST** /api/v1/products/{id}/options/{optionId}/items | Add an item to a product option
*ProductOptionsApi* | [**apiV1ProductsByIdOptionsByOptionIdDelete**](docs/Api/ProductOptionsApi.md#apiv1productsbyidoptionsbyoptioniddelete) | **DELETE** /api/v1/products/{id}/options/{optionId} | Delete an option
*ProductOptionsApi* | [**apiV1ProductsByIdOptionsByOptionIdGet**](docs/Api/ProductOptionsApi.md#apiv1productsbyidoptionsbyoptionidget) | **GET** /api/v1/products/{id}/options/{optionId} | Get a product option
*ProductOptionsApi* | [**apiV1ProductsByIdOptionsByOptionIdPut**](docs/Api/ProductOptionsApi.md#apiv1productsbyidoptionsbyoptionidput) | **PUT** /api/v1/products/{id}/options/{optionId} | Update a product option
*ProductOptionsApi* | [**apiV1ProductsByIdOptionsGet**](docs/Api/ProductOptionsApi.md#apiv1productsbyidoptionsget) | **GET** /api/v1/products/{id}/options | Get a products options
*ProductOptionsApi* | [**apiV1ProductsByIdOptionsPost**](docs/Api/ProductOptionsApi.md#apiv1productsbyidoptionspost) | **POST** /api/v1/products/{id}/options | Add an option to a product
*ProductStockApi* | [**apiV1ProductsByIdStockGet**](docs/Api/ProductStockApi.md#apiv1productsbyidstockget) | **GET** /api/v1/products/{id}/stock | Get the stock for a product
*ProductStockApi* | [**apiV1ProductsByIdStockPut**](docs/Api/ProductStockApi.md#apiv1productsbyidstockput) | **PUT** /api/v1/products/{id}/stock | Set the stock for a product
*ProductVariantStockApi* | [**apiV1ProductsByIdVariantsByVariantIdStockGet**](docs/Api/ProductVariantStockApi.md#apiv1productsbyidvariantsbyvariantidstockget) | **GET** /api/v1/products/{id}/variants/{variantId}/stock | Get a product variant stock
*ProductVariantStockApi* | [**apiV1ProductsByIdVariantsByVariantIdStockPut**](docs/Api/ProductVariantStockApi.md#apiv1productsbyidvariantsbyvariantidstockput) | **PUT** /api/v1/products/{id}/variants/{variantId}/stock | Update a product variant stock
*ProductVariantsApi* | [**apiV1ProductsByIdVariantsByVariantIdDelete**](docs/Api/ProductVariantsApi.md#apiv1productsbyidvariantsbyvariantiddelete) | **DELETE** /api/v1/products/{id}/variants/{variantId} | Delete a variant
*ProductVariantsApi* | [**apiV1ProductsByIdVariantsByVariantIdGet**](docs/Api/ProductVariantsApi.md#apiv1productsbyidvariantsbyvariantidget) | **GET** /api/v1/products/{id}/variants/{variantId} | Get a product variant
*ProductVariantsApi* | [**apiV1ProductsByIdVariantsByVariantIdPut**](docs/Api/ProductVariantsApi.md#apiv1productsbyidvariantsbyvariantidput) | **PUT** /api/v1/products/{id}/variants/{variantId} | Update a product variant
*ProductVariantsApi* | [**apiV1ProductsByIdVariantsGet**](docs/Api/ProductVariantsApi.md#apiv1productsbyidvariantsget) | **GET** /api/v1/products/{id}/variants | Get a products variants
*ProductVariantsApi* | [**apiV1ProductsByIdVariantsPost**](docs/Api/ProductVariantsApi.md#apiv1productsbyidvariantspost) | **POST** /api/v1/products/{id}/variants | Add a variant to a product
*ProductVariantsApi* | [**apiV1ProductsVariantsByVariantIdGet**](docs/Api/ProductVariantsApi.md#apiv1productsvariantsbyvariantidget) | **GET** /api/v1/products/variants/{variantId} | Get a product variant
*ProductVariantsApi* | [**apiV1VariantsSearchGet**](docs/Api/ProductVariantsApi.md#apiv1variantssearchget) | **GET** /api/v1/variants/search | Searches variants based on search criteria
*ProductsApi* | [**apiV1ProductsByIdCategorymanagedByCategoryIdDelete**](docs/Api/ProductsApi.md#apiv1productsbyidcategorymanagedbycategoryiddelete) | **DELETE** /api/v1/products/{id}/categorymanaged/{categoryId} | Stops a product from being managed by another category
*ProductsApi* | [**apiV1ProductsByIdCategorymanagedByCategoryIdPost**](docs/Api/ProductsApi.md#apiv1productsbyidcategorymanagedbycategoryidpost) | **POST** /api/v1/products/{id}/categorymanaged/{categoryId} | Set a product to be managed by another category
*ProductsApi* | [**apiV1ProductsByIdDelete**](docs/Api/ProductsApi.md#apiv1productsbyiddelete) | **DELETE** /api/v1/products/{id} | Delete a Product
*ProductsApi* | [**apiV1ProductsByIdGet**](docs/Api/ProductsApi.md#apiv1productsbyidget) | **GET** /api/v1/products/{id} | Get a product
*ProductsApi* | [**apiV1ProductsByIdImagesByImageNumberPost**](docs/Api/ProductsApi.md#apiv1productsbyidimagesbyimagenumberpost) | **POST** /api/v1/products/{id}/images/{imageNumber} | Assign an image by Url to a product
*ProductsApi* | [**apiV1ProductsByIdImagesGet**](docs/Api/ProductsApi.md#apiv1productsbyidimagesget) | **GET** /api/v1/products/{id}/images | Get a product&#39;s images.
*ProductsApi* | [**apiV1ProductsByIdPut**](docs/Api/ProductsApi.md#apiv1productsbyidput) | **PUT** /api/v1/products/{id} | Update a Product
*ProductsApi* | [**apiV1ProductsGet**](docs/Api/ProductsApi.md#apiv1productsget) | **GET** /api/v1/products | Get a paginated set of products
*ProductsApi* | [**apiV1ProductsPost**](docs/Api/ProductsApi.md#apiv1productspost) | **POST** /api/v1/products | Add a Product
*ProductsApi* | [**apiV1ProductsSearchGet**](docs/Api/ProductsApi.md#apiv1productssearchget) | **GET** /api/v1/products/search | Searches products based on search criteria
*WebhooksApi* | [**apiV1WebhooksDelete**](docs/Api/WebhooksApi.md#apiv1webhooksdelete) | **DELETE** /api/v1/webhooks | Unsubscribe from a webhook
*WebhooksApi* | [**apiV1WebhooksPut**](docs/Api/WebhooksApi.md#apiv1webhooksput) | **PUT** /api/v1/webhooks | Subscribe to a webhook


## Documentation For Models

 - [AddCategory](docs/Model/AddCategory.md)
 - [AddCustomer](docs/Model/AddCustomer.md)
 - [AddProduct](docs/Model/AddProduct.md)
 - [AddProductOption](docs/Model/AddProductOption.md)
 - [Category](docs/Model/Category.md)
 - [Customer](docs/Model/Customer.md)
 - [CustomerAddress](docs/Model/CustomerAddress.md)
 - [DomainName](docs/Model/DomainName.md)
 - [Order](docs/Model/Order.md)
 - [OrderCustomerDetails](docs/Model/OrderCustomerDetails.md)
 - [OrderItem](docs/Model/OrderItem.md)
 - [OrderStatus](docs/Model/OrderStatus.md)
 - [OrderStatusSetting](docs/Model/OrderStatusSetting.md)
 - [Plan](docs/Model/Plan.md)
 - [PlanRestriction](docs/Model/PlanRestriction.md)
 - [Product](docs/Model/Product.md)
 - [ProductAttribute](docs/Model/ProductAttribute.md)
 - [ProductAttributeItem](docs/Model/ProductAttributeItem.md)
 - [ProductCategory](docs/Model/ProductCategory.md)
 - [ProductImage](docs/Model/ProductImage.md)
 - [ProductImages](docs/Model/ProductImages.md)
 - [ProductOption](docs/Model/ProductOption.md)
 - [ProductOptionItem](docs/Model/ProductOptionItem.md)
 - [ProductStock](docs/Model/ProductStock.md)
 - [ProductVariant](docs/Model/ProductVariant.md)
 - [ProductVariantStock](docs/Model/ProductVariantStock.md)
 - [ShippingAddress](docs/Model/ShippingAddress.md)
 - [SubCategory](docs/Model/SubCategory.md)
 - [TempestLink](docs/Model/TempestLink.md)
 - [TempestResponseCategory](docs/Model/TempestResponseCategory.md)
 - [TempestResponseCustomer](docs/Model/TempestResponseCustomer.md)
 - [TempestResponseCustomerAddress](docs/Model/TempestResponseCustomerAddress.md)
 - [TempestResponseDomainName](docs/Model/TempestResponseDomainName.md)
 - [TempestResponseListCategory](docs/Model/TempestResponseListCategory.md)
 - [TempestResponseListCustomer](docs/Model/TempestResponseListCustomer.md)
 - [TempestResponseListCustomerAddress](docs/Model/TempestResponseListCustomerAddress.md)
 - [TempestResponseListOrder](docs/Model/TempestResponseListOrder.md)
 - [TempestResponseListPlan](docs/Model/TempestResponseListPlan.md)
 - [TempestResponseListProduct](docs/Model/TempestResponseListProduct.md)
 - [TempestResponseListProductAttribute](docs/Model/TempestResponseListProductAttribute.md)
 - [TempestResponseListProductAttributeItem](docs/Model/TempestResponseListProductAttributeItem.md)
 - [TempestResponseListProductOption](docs/Model/TempestResponseListProductOption.md)
 - [TempestResponseListProductVariant](docs/Model/TempestResponseListProductVariant.md)
 - [TempestResponseListSubCategory](docs/Model/TempestResponseListSubCategory.md)
 - [TempestResponseOrder](docs/Model/TempestResponseOrder.md)
 - [TempestResponseOrderStatusSetting](docs/Model/TempestResponseOrderStatusSetting.md)
 - [TempestResponsePlan](docs/Model/TempestResponsePlan.md)
 - [TempestResponseProduct](docs/Model/TempestResponseProduct.md)
 - [TempestResponseProductAttribute](docs/Model/TempestResponseProductAttribute.md)
 - [TempestResponseProductAttributeItem](docs/Model/TempestResponseProductAttributeItem.md)
 - [TempestResponseProductCategory](docs/Model/TempestResponseProductCategory.md)
 - [TempestResponseProductImages](docs/Model/TempestResponseProductImages.md)
 - [TempestResponseProductOption](docs/Model/TempestResponseProductOption.md)
 - [TempestResponseProductOptionItem](docs/Model/TempestResponseProductOptionItem.md)
 - [TempestResponseProductStock](docs/Model/TempestResponseProductStock.md)
 - [TempestResponseProductVariant](docs/Model/TempestResponseProductVariant.md)
 - [TempestResponseProductVariantStock](docs/Model/TempestResponseProductVariantStock.md)
 - [TempestResponseSubCategory](docs/Model/TempestResponseSubCategory.md)
 - [TempestResponseTempestValidationError](docs/Model/TempestResponseTempestValidationError.md)
 - [TempestValidationError](docs/Model/TempestValidationError.md)
 - [UpdateCategory](docs/Model/UpdateCategory.md)
 - [UpdateCustomer](docs/Model/UpdateCustomer.md)
 - [UpdateProduct](docs/Model/UpdateProduct.md)
 - [UpdateProductOption](docs/Model/UpdateProductOption.md)
 - [VariantCombination](docs/Model/VariantCombination.md)


## Documentation For Authorization


## OAuth

- **Type**: OAuth
- **Flow**: accessCode
- **Authorization URL**: https://api.ekm.net/connect/authorize
- **Scopes**: 
 - **tempest.customers.read**: Read a shop's customers.
 - **tempest.customers.write**: Modify a shop's customers.
 - **tempest.orders.read**: Read a shop's orders.
 - **tempest.orders.write**: Modify a shop's orders.
 - **tempest.products.read**: Read a shop's products.
 - **tempest.products.write**: Modify a shop's products.
 - **tempest.categories.read**: Read a shop's categories.
 - **tempest.categories.write**: Modify a shop's categories.
 - **tempest.settings.orderstatuses.read**: Read a shop's order statuses.
 - **tempest.settings.domains.read**: Read a shop's domains.
 - **tempest.settings.accountdetails.read**: Read a shop's account details.


## Author

support@ekm.com


