<?php
/**
 * Copyright Talisman Innovations Ltd. (2018). All rights reserved.
 */

namespace EKM;

use League\OAuth2\Client\Provider\AbstractProvider;
use League\OAuth2\Client\Token\AccessToken;
use League\OAuth2\Client\Tool\BearerAuthorizationTrait;
use Psr\Http\Message\ResponseInterface;

class EKMProvider extends AbstractProvider
{
    /** @var array */
    protected $scope;

    use BearerAuthorizationTrait;

    public function getBaseAuthorizationUrl()
    {
        return 'https://api.ekm.net/connect/authorize';
    }

    public function getBaseAccessTokenUrl(array $params)
    {
        return 'https://api.ekm.net/connect/token';
    }

    public function getResourceOwnerDetailsUrl(AccessToken $token)
    {
        return 'http://api.ekm.net/api/v1/settings/domains';
    }

    public function getAccessToken($grant, array $options = [])
    {
        if (is_array($this->scope)) {
            $scopes = implode($this->getScopeSeparator(), $this->scope);
        } else {
            $scopes = $this->scope;
        }

        $options = array_merge($options, ['scopes' => $scopes]);
        return parent::getAccessToken($grant, $options);
    }

    public function getDefaultScopes()
    {
        return [
            'offline_access'
        ];
    }

    public function getScopeSeparator()
    {
        return ' ';
    }

    protected function checkResponse(ResponseInterface $response, $data)
    {
        return;
    }

    protected function createResourceOwner(array $response, AccessToken $token)
    {
        return $token;
    }

    protected function getAllowedClientOptions(array $options)
    {
        $client_options = ['timeout', 'proxy', 'handler'];

        // Only allow turning off ssl verification if it's for a proxy
        if (!empty($options['proxy'])) {
            $client_options[] = 'verify';
        }

        return $client_options;
    }
}