<?php
/**
 * V2Order
 *
 * PHP version 5
 *
 * @category Class
 * @package  EKM
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * EKM Partner API
 *
 * Our new API allows partners to build significantly better integrations with the EKM platform.    To try out the below endpoints, or for full up to date representations of the request / response models, please see the [swagger page](https://api.ekm.net/swagger/index.html). (We display examples here, but the swagger page is guaranteed to show the complete model.)    To keep up to date with the latest updates, please see our [RSS feed](https://partners.ekm.net/ChangeLog/Feed) or the [partner dashboard](https://partners.ekm.net/).
 *
 * The version of the OpenAPI document: Latest
 * Contact: api-support@ekm.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 4.2.3-SNAPSHOT
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace EKM\Model;

use \ArrayAccess;
use \EKM\ObjectSerializer;

/**
 * V2Order Class Doc Comment
 *
 * @category Class
 * @package  EKM
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class V2Order implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'V2Order';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'int',
        'orderNumber' => 'string',
        'orderDate' => '\DateTime',
        'isConfirmed' => 'bool',
        'subTotal' => 'double',
        'totalDelivery' => 'double',
        'totalTax' => 'double',
        'totalCost' => 'double',
        'status' => 'string',
        'paymentStatus' => 'string',
        'deliveryMethod' => 'string',
        'transactionId' => 'string',
        'transactionStatus' => 'string',
        'orderType' => 'string',
        'useShippingAddress' => 'bool',
        'shippingAddress' => '\EKM\Model\V1ShippingAddress',
        'internalNotes' => 'string',
        'customerFacingNotes' => 'string',
        'emailed' => 'bool',
        'discounts' => 'string',
        'discountsTotal' => 'double',
        'shippingCompany' => 'string',
        'ipAddress' => 'string',
        'guid' => 'string',
        'lastUpdated' => '\DateTime',
        'deliveryTaxRate' => 'double',
        'deliveryIncludesTax' => 'int',
        'customFieldsTotal' => 'double',
        'customFieldsTaxTotal' => 'double',
        'customerDetails' => '\EKM\Model\V1OrderCustomerDetails',
        'customFields' => 'string',
        'deliveryTrackingNumber' => 'string',
        'deliveryTrackingCompany' => 'string',
        'deliveryTrackingUrl' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPIFormats = [
        'id' => 'int64',
        'orderNumber' => null,
        'orderDate' => 'date-time',
        'isConfirmed' => null,
        'subTotal' => 'double',
        'totalDelivery' => 'double',
        'totalTax' => 'double',
        'totalCost' => 'double',
        'status' => null,
        'paymentStatus' => null,
        'deliveryMethod' => null,
        'transactionId' => null,
        'transactionStatus' => null,
        'orderType' => null,
        'useShippingAddress' => null,
        'shippingAddress' => null,
        'internalNotes' => null,
        'customerFacingNotes' => null,
        'emailed' => null,
        'discounts' => null,
        'discountsTotal' => 'double',
        'shippingCompany' => null,
        'ipAddress' => null,
        'guid' => 'uuid',
        'lastUpdated' => 'date-time',
        'deliveryTaxRate' => 'double',
        'deliveryIncludesTax' => 'int32',
        'customFieldsTotal' => 'double',
        'customFieldsTaxTotal' => 'double',
        'customerDetails' => null,
        'customFields' => null,
        'deliveryTrackingNumber' => null,
        'deliveryTrackingCompany' => null,
        'deliveryTrackingUrl' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'orderNumber' => 'order_number',
        'orderDate' => 'order_date',
        'isConfirmed' => 'is_confirmed',
        'subTotal' => 'sub_total',
        'totalDelivery' => 'total_delivery',
        'totalTax' => 'total_tax',
        'totalCost' => 'total_cost',
        'status' => 'status',
        'paymentStatus' => 'payment_status',
        'deliveryMethod' => 'delivery_method',
        'transactionId' => 'transaction_id',
        'transactionStatus' => 'transaction_status',
        'orderType' => 'order_type',
        'useShippingAddress' => 'use_shipping_address',
        'shippingAddress' => 'shipping_address',
        'internalNotes' => 'internal_notes',
        'customerFacingNotes' => 'customer_facing_notes',
        'emailed' => 'emailed',
        'discounts' => 'discounts',
        'discountsTotal' => 'discounts_total',
        'shippingCompany' => 'shipping_company',
        'ipAddress' => 'ip_address',
        'guid' => 'guid',
        'lastUpdated' => 'last_updated',
        'deliveryTaxRate' => 'delivery_tax_rate',
        'deliveryIncludesTax' => 'delivery_includes_tax',
        'customFieldsTotal' => 'custom_fields_total',
        'customFieldsTaxTotal' => 'custom_fields_tax_total',
        'customerDetails' => 'customer_details',
        'customFields' => 'custom_fields',
        'deliveryTrackingNumber' => 'delivery_tracking_number',
        'deliveryTrackingCompany' => 'delivery_tracking_company',
        'deliveryTrackingUrl' => 'delivery_tracking_url'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'orderNumber' => 'setOrderNumber',
        'orderDate' => 'setOrderDate',
        'isConfirmed' => 'setIsConfirmed',
        'subTotal' => 'setSubTotal',
        'totalDelivery' => 'setTotalDelivery',
        'totalTax' => 'setTotalTax',
        'totalCost' => 'setTotalCost',
        'status' => 'setStatus',
        'paymentStatus' => 'setPaymentStatus',
        'deliveryMethod' => 'setDeliveryMethod',
        'transactionId' => 'setTransactionId',
        'transactionStatus' => 'setTransactionStatus',
        'orderType' => 'setOrderType',
        'useShippingAddress' => 'setUseShippingAddress',
        'shippingAddress' => 'setShippingAddress',
        'internalNotes' => 'setInternalNotes',
        'customerFacingNotes' => 'setCustomerFacingNotes',
        'emailed' => 'setEmailed',
        'discounts' => 'setDiscounts',
        'discountsTotal' => 'setDiscountsTotal',
        'shippingCompany' => 'setShippingCompany',
        'ipAddress' => 'setIpAddress',
        'guid' => 'setGuid',
        'lastUpdated' => 'setLastUpdated',
        'deliveryTaxRate' => 'setDeliveryTaxRate',
        'deliveryIncludesTax' => 'setDeliveryIncludesTax',
        'customFieldsTotal' => 'setCustomFieldsTotal',
        'customFieldsTaxTotal' => 'setCustomFieldsTaxTotal',
        'customerDetails' => 'setCustomerDetails',
        'customFields' => 'setCustomFields',
        'deliveryTrackingNumber' => 'setDeliveryTrackingNumber',
        'deliveryTrackingCompany' => 'setDeliveryTrackingCompany',
        'deliveryTrackingUrl' => 'setDeliveryTrackingUrl'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'orderNumber' => 'getOrderNumber',
        'orderDate' => 'getOrderDate',
        'isConfirmed' => 'getIsConfirmed',
        'subTotal' => 'getSubTotal',
        'totalDelivery' => 'getTotalDelivery',
        'totalTax' => 'getTotalTax',
        'totalCost' => 'getTotalCost',
        'status' => 'getStatus',
        'paymentStatus' => 'getPaymentStatus',
        'deliveryMethod' => 'getDeliveryMethod',
        'transactionId' => 'getTransactionId',
        'transactionStatus' => 'getTransactionStatus',
        'orderType' => 'getOrderType',
        'useShippingAddress' => 'getUseShippingAddress',
        'shippingAddress' => 'getShippingAddress',
        'internalNotes' => 'getInternalNotes',
        'customerFacingNotes' => 'getCustomerFacingNotes',
        'emailed' => 'getEmailed',
        'discounts' => 'getDiscounts',
        'discountsTotal' => 'getDiscountsTotal',
        'shippingCompany' => 'getShippingCompany',
        'ipAddress' => 'getIpAddress',
        'guid' => 'getGuid',
        'lastUpdated' => 'getLastUpdated',
        'deliveryTaxRate' => 'getDeliveryTaxRate',
        'deliveryIncludesTax' => 'getDeliveryIncludesTax',
        'customFieldsTotal' => 'getCustomFieldsTotal',
        'customFieldsTaxTotal' => 'getCustomFieldsTaxTotal',
        'customerDetails' => 'getCustomerDetails',
        'customFields' => 'getCustomFields',
        'deliveryTrackingNumber' => 'getDeliveryTrackingNumber',
        'deliveryTrackingCompany' => 'getDeliveryTrackingCompany',
        'deliveryTrackingUrl' => 'getDeliveryTrackingUrl'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['orderNumber'] = isset($data['orderNumber']) ? $data['orderNumber'] : null;
        $this->container['orderDate'] = isset($data['orderDate']) ? $data['orderDate'] : null;
        $this->container['isConfirmed'] = isset($data['isConfirmed']) ? $data['isConfirmed'] : null;
        $this->container['subTotal'] = isset($data['subTotal']) ? $data['subTotal'] : null;
        $this->container['totalDelivery'] = isset($data['totalDelivery']) ? $data['totalDelivery'] : null;
        $this->container['totalTax'] = isset($data['totalTax']) ? $data['totalTax'] : null;
        $this->container['totalCost'] = isset($data['totalCost']) ? $data['totalCost'] : null;
        $this->container['status'] = isset($data['status']) ? $data['status'] : null;
        $this->container['paymentStatus'] = isset($data['paymentStatus']) ? $data['paymentStatus'] : null;
        $this->container['deliveryMethod'] = isset($data['deliveryMethod']) ? $data['deliveryMethod'] : null;
        $this->container['transactionId'] = isset($data['transactionId']) ? $data['transactionId'] : null;
        $this->container['transactionStatus'] = isset($data['transactionStatus']) ? $data['transactionStatus'] : null;
        $this->container['orderType'] = isset($data['orderType']) ? $data['orderType'] : null;
        $this->container['useShippingAddress'] = isset($data['useShippingAddress']) ? $data['useShippingAddress'] : null;
        $this->container['shippingAddress'] = isset($data['shippingAddress']) ? $data['shippingAddress'] : null;
        $this->container['internalNotes'] = isset($data['internalNotes']) ? $data['internalNotes'] : null;
        $this->container['customerFacingNotes'] = isset($data['customerFacingNotes']) ? $data['customerFacingNotes'] : null;
        $this->container['emailed'] = isset($data['emailed']) ? $data['emailed'] : null;
        $this->container['discounts'] = isset($data['discounts']) ? $data['discounts'] : null;
        $this->container['discountsTotal'] = isset($data['discountsTotal']) ? $data['discountsTotal'] : null;
        $this->container['shippingCompany'] = isset($data['shippingCompany']) ? $data['shippingCompany'] : null;
        $this->container['ipAddress'] = isset($data['ipAddress']) ? $data['ipAddress'] : null;
        $this->container['guid'] = isset($data['guid']) ? $data['guid'] : null;
        $this->container['lastUpdated'] = isset($data['lastUpdated']) ? $data['lastUpdated'] : null;
        $this->container['deliveryTaxRate'] = isset($data['deliveryTaxRate']) ? $data['deliveryTaxRate'] : null;
        $this->container['deliveryIncludesTax'] = isset($data['deliveryIncludesTax']) ? $data['deliveryIncludesTax'] : null;
        $this->container['customFieldsTotal'] = isset($data['customFieldsTotal']) ? $data['customFieldsTotal'] : null;
        $this->container['customFieldsTaxTotal'] = isset($data['customFieldsTaxTotal']) ? $data['customFieldsTaxTotal'] : null;
        $this->container['customerDetails'] = isset($data['customerDetails']) ? $data['customerDetails'] : null;
        $this->container['customFields'] = isset($data['customFields']) ? $data['customFields'] : null;
        $this->container['deliveryTrackingNumber'] = isset($data['deliveryTrackingNumber']) ? $data['deliveryTrackingNumber'] : null;
        $this->container['deliveryTrackingCompany'] = isset($data['deliveryTrackingCompany']) ? $data['deliveryTrackingCompany'] : null;
        $this->container['deliveryTrackingUrl'] = isset($data['deliveryTrackingUrl']) ? $data['deliveryTrackingUrl'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['id'] === null) {
            $invalidProperties[] = "'id' can't be null";
        }
        if ($this->container['orderNumber'] === null) {
            $invalidProperties[] = "'orderNumber' can't be null";
        }
        if ($this->container['orderDate'] === null) {
            $invalidProperties[] = "'orderDate' can't be null";
        }
        if ($this->container['isConfirmed'] === null) {
            $invalidProperties[] = "'isConfirmed' can't be null";
        }
        if ($this->container['subTotal'] === null) {
            $invalidProperties[] = "'subTotal' can't be null";
        }
        if ($this->container['totalDelivery'] === null) {
            $invalidProperties[] = "'totalDelivery' can't be null";
        }
        if ($this->container['totalTax'] === null) {
            $invalidProperties[] = "'totalTax' can't be null";
        }
        if ($this->container['totalCost'] === null) {
            $invalidProperties[] = "'totalCost' can't be null";
        }
        if ($this->container['status'] === null) {
            $invalidProperties[] = "'status' can't be null";
        }
        if ($this->container['deliveryMethod'] === null) {
            $invalidProperties[] = "'deliveryMethod' can't be null";
        }
        if ($this->container['transactionId'] === null) {
            $invalidProperties[] = "'transactionId' can't be null";
        }
        if ($this->container['transactionStatus'] === null) {
            $invalidProperties[] = "'transactionStatus' can't be null";
        }
        if ($this->container['orderType'] === null) {
            $invalidProperties[] = "'orderType' can't be null";
        }
        if ($this->container['useShippingAddress'] === null) {
            $invalidProperties[] = "'useShippingAddress' can't be null";
        }
        if ($this->container['shippingAddress'] === null) {
            $invalidProperties[] = "'shippingAddress' can't be null";
        }
        if ($this->container['internalNotes'] === null) {
            $invalidProperties[] = "'internalNotes' can't be null";
        }
        if ($this->container['customerFacingNotes'] === null) {
            $invalidProperties[] = "'customerFacingNotes' can't be null";
        }
        if ($this->container['emailed'] === null) {
            $invalidProperties[] = "'emailed' can't be null";
        }
        if ($this->container['discounts'] === null) {
            $invalidProperties[] = "'discounts' can't be null";
        }
        if ($this->container['discountsTotal'] === null) {
            $invalidProperties[] = "'discountsTotal' can't be null";
        }
        if ($this->container['shippingCompany'] === null) {
            $invalidProperties[] = "'shippingCompany' can't be null";
        }
        if ($this->container['ipAddress'] === null) {
            $invalidProperties[] = "'ipAddress' can't be null";
        }
        if ($this->container['guid'] === null) {
            $invalidProperties[] = "'guid' can't be null";
        }
        if ($this->container['deliveryIncludesTax'] === null) {
            $invalidProperties[] = "'deliveryIncludesTax' can't be null";
        }
        if ($this->container['customFieldsTotal'] === null) {
            $invalidProperties[] = "'customFieldsTotal' can't be null";
        }
        if ($this->container['customFieldsTaxTotal'] === null) {
            $invalidProperties[] = "'customFieldsTaxTotal' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return int
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int $id id
     *
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets orderNumber
     *
     * @return string
     */
    public function getOrderNumber()
    {
        return $this->container['orderNumber'];
    }

    /**
     * Sets orderNumber
     *
     * @param string $orderNumber orderNumber
     *
     * @return $this
     */
    public function setOrderNumber($orderNumber)
    {
        $this->container['orderNumber'] = $orderNumber;

        return $this;
    }

    /**
     * Gets orderDate
     *
     * @return \DateTime
     */
    public function getOrderDate()
    {
        return $this->container['orderDate'];
    }

    /**
     * Sets orderDate
     *
     * @param \DateTime $orderDate orderDate
     *
     * @return $this
     */
    public function setOrderDate($orderDate)
    {
        $this->container['orderDate'] = $orderDate;

        return $this;
    }

    /**
     * Gets isConfirmed
     *
     * @return bool
     */
    public function getIsConfirmed()
    {
        return $this->container['isConfirmed'];
    }

    /**
     * Sets isConfirmed
     *
     * @param bool $isConfirmed isConfirmed
     *
     * @return $this
     */
    public function setIsConfirmed($isConfirmed)
    {
        $this->container['isConfirmed'] = $isConfirmed;

        return $this;
    }

    /**
     * Gets subTotal
     *
     * @return double
     */
    public function getSubTotal()
    {
        return $this->container['subTotal'];
    }

    /**
     * Sets subTotal
     *
     * @param double $subTotal subTotal
     *
     * @return $this
     */
    public function setSubTotal($subTotal)
    {
        $this->container['subTotal'] = $subTotal;

        return $this;
    }

    /**
     * Gets totalDelivery
     *
     * @return double
     */
    public function getTotalDelivery()
    {
        return $this->container['totalDelivery'];
    }

    /**
     * Sets totalDelivery
     *
     * @param double $totalDelivery totalDelivery
     *
     * @return $this
     */
    public function setTotalDelivery($totalDelivery)
    {
        $this->container['totalDelivery'] = $totalDelivery;

        return $this;
    }

    /**
     * Gets totalTax
     *
     * @return double
     */
    public function getTotalTax()
    {
        return $this->container['totalTax'];
    }

    /**
     * Sets totalTax
     *
     * @param double $totalTax totalTax
     *
     * @return $this
     */
    public function setTotalTax($totalTax)
    {
        $this->container['totalTax'] = $totalTax;

        return $this;
    }

    /**
     * Gets totalCost
     *
     * @return double
     */
    public function getTotalCost()
    {
        return $this->container['totalCost'];
    }

    /**
     * Sets totalCost
     *
     * @param double $totalCost totalCost
     *
     * @return $this
     */
    public function setTotalCost($totalCost)
    {
        $this->container['totalCost'] = $totalCost;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string $status status
     *
     * @return $this
     */
    public function setStatus($status)
    {
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets paymentStatus
     *
     * @return string|null
     */
    public function getPaymentStatus()
    {
        return $this->container['paymentStatus'];
    }

    /**
     * Sets paymentStatus
     *
     * @param string|null $paymentStatus paymentStatus
     *
     * @return $this
     */
    public function setPaymentStatus($paymentStatus)
    {
        $this->container['paymentStatus'] = $paymentStatus;

        return $this;
    }

    /**
     * Gets deliveryMethod
     *
     * @return string
     */
    public function getDeliveryMethod()
    {
        return $this->container['deliveryMethod'];
    }

    /**
     * Sets deliveryMethod
     *
     * @param string $deliveryMethod deliveryMethod
     *
     * @return $this
     */
    public function setDeliveryMethod($deliveryMethod)
    {
        $this->container['deliveryMethod'] = $deliveryMethod;

        return $this;
    }

    /**
     * Gets transactionId
     *
     * @return string
     */
    public function getTransactionId()
    {
        return $this->container['transactionId'];
    }

    /**
     * Sets transactionId
     *
     * @param string $transactionId transactionId
     *
     * @return $this
     */
    public function setTransactionId($transactionId)
    {
        $this->container['transactionId'] = $transactionId;

        return $this;
    }

    /**
     * Gets transactionStatus
     *
     * @return string
     */
    public function getTransactionStatus()
    {
        return $this->container['transactionStatus'];
    }

    /**
     * Sets transactionStatus
     *
     * @param string $transactionStatus transactionStatus
     *
     * @return $this
     */
    public function setTransactionStatus($transactionStatus)
    {
        $this->container['transactionStatus'] = $transactionStatus;

        return $this;
    }

    /**
     * Gets orderType
     *
     * @return string
     */
    public function getOrderType()
    {
        return $this->container['orderType'];
    }

    /**
     * Sets orderType
     *
     * @param string $orderType orderType
     *
     * @return $this
     */
    public function setOrderType($orderType)
    {
        $this->container['orderType'] = $orderType;

        return $this;
    }

    /**
     * Gets useShippingAddress
     *
     * @return bool
     */
    public function getUseShippingAddress()
    {
        return $this->container['useShippingAddress'];
    }

    /**
     * Sets useShippingAddress
     *
     * @param bool $useShippingAddress useShippingAddress
     *
     * @return $this
     */
    public function setUseShippingAddress($useShippingAddress)
    {
        $this->container['useShippingAddress'] = $useShippingAddress;

        return $this;
    }

    /**
     * Gets shippingAddress
     *
     * @return \EKM\Model\V1ShippingAddress
     */
    public function getShippingAddress()
    {
        return $this->container['shippingAddress'];
    }

    /**
     * Sets shippingAddress
     *
     * @param \EKM\Model\V1ShippingAddress $shippingAddress shippingAddress
     *
     * @return $this
     */
    public function setShippingAddress($shippingAddress)
    {
        $this->container['shippingAddress'] = $shippingAddress;

        return $this;
    }

    /**
     * Gets internalNotes
     *
     * @return string
     */
    public function getInternalNotes()
    {
        return $this->container['internalNotes'];
    }

    /**
     * Sets internalNotes
     *
     * @param string $internalNotes internalNotes
     *
     * @return $this
     */
    public function setInternalNotes($internalNotes)
    {
        $this->container['internalNotes'] = $internalNotes;

        return $this;
    }

    /**
     * Gets customerFacingNotes
     *
     * @return string
     */
    public function getCustomerFacingNotes()
    {
        return $this->container['customerFacingNotes'];
    }

    /**
     * Sets customerFacingNotes
     *
     * @param string $customerFacingNotes customerFacingNotes
     *
     * @return $this
     */
    public function setCustomerFacingNotes($customerFacingNotes)
    {
        $this->container['customerFacingNotes'] = $customerFacingNotes;

        return $this;
    }

    /**
     * Gets emailed
     *
     * @return bool
     */
    public function getEmailed()
    {
        return $this->container['emailed'];
    }

    /**
     * Sets emailed
     *
     * @param bool $emailed emailed
     *
     * @return $this
     */
    public function setEmailed($emailed)
    {
        $this->container['emailed'] = $emailed;

        return $this;
    }

    /**
     * Gets discounts
     *
     * @return string
     */
    public function getDiscounts()
    {
        return $this->container['discounts'];
    }

    /**
     * Sets discounts
     *
     * @param string $discounts discounts
     *
     * @return $this
     */
    public function setDiscounts($discounts)
    {
        $this->container['discounts'] = $discounts;

        return $this;
    }

    /**
     * Gets discountsTotal
     *
     * @return double
     */
    public function getDiscountsTotal()
    {
        return $this->container['discountsTotal'];
    }

    /**
     * Sets discountsTotal
     *
     * @param double $discountsTotal discountsTotal
     *
     * @return $this
     */
    public function setDiscountsTotal($discountsTotal)
    {
        $this->container['discountsTotal'] = $discountsTotal;

        return $this;
    }

    /**
     * Gets shippingCompany
     *
     * @return string
     */
    public function getShippingCompany()
    {
        return $this->container['shippingCompany'];
    }

    /**
     * Sets shippingCompany
     *
     * @param string $shippingCompany shippingCompany
     *
     * @return $this
     */
    public function setShippingCompany($shippingCompany)
    {
        $this->container['shippingCompany'] = $shippingCompany;

        return $this;
    }

    /**
     * Gets ipAddress
     *
     * @return string
     */
    public function getIpAddress()
    {
        return $this->container['ipAddress'];
    }

    /**
     * Sets ipAddress
     *
     * @param string $ipAddress ipAddress
     *
     * @return $this
     */
    public function setIpAddress($ipAddress)
    {
        $this->container['ipAddress'] = $ipAddress;

        return $this;
    }

    /**
     * Gets guid
     *
     * @return string
     */
    public function getGuid()
    {
        return $this->container['guid'];
    }

    /**
     * Sets guid
     *
     * @param string $guid guid
     *
     * @return $this
     */
    public function setGuid($guid)
    {
        $this->container['guid'] = $guid;

        return $this;
    }

    /**
     * Gets lastUpdated
     *
     * @return \DateTime|null
     */
    public function getLastUpdated()
    {
        return $this->container['lastUpdated'];
    }

    /**
     * Sets lastUpdated
     *
     * @param \DateTime|null $lastUpdated lastUpdated
     *
     * @return $this
     */
    public function setLastUpdated($lastUpdated)
    {
        $this->container['lastUpdated'] = $lastUpdated;

        return $this;
    }

    /**
     * Gets deliveryTaxRate
     *
     * @return double|null
     */
    public function getDeliveryTaxRate()
    {
        return $this->container['deliveryTaxRate'];
    }

    /**
     * Sets deliveryTaxRate
     *
     * @param double|null $deliveryTaxRate deliveryTaxRate
     *
     * @return $this
     */
    public function setDeliveryTaxRate($deliveryTaxRate)
    {
        $this->container['deliveryTaxRate'] = $deliveryTaxRate;

        return $this;
    }

    /**
     * Gets deliveryIncludesTax
     *
     * @return int
     */
    public function getDeliveryIncludesTax()
    {
        return $this->container['deliveryIncludesTax'];
    }

    /**
     * Sets deliveryIncludesTax
     *
     * @param int $deliveryIncludesTax deliveryIncludesTax
     *
     * @return $this
     */
    public function setDeliveryIncludesTax($deliveryIncludesTax)
    {
        $this->container['deliveryIncludesTax'] = $deliveryIncludesTax;

        return $this;
    }

    /**
     * Gets customFieldsTotal
     *
     * @return double
     */
    public function getCustomFieldsTotal()
    {
        return $this->container['customFieldsTotal'];
    }

    /**
     * Sets customFieldsTotal
     *
     * @param double $customFieldsTotal customFieldsTotal
     *
     * @return $this
     */
    public function setCustomFieldsTotal($customFieldsTotal)
    {
        $this->container['customFieldsTotal'] = $customFieldsTotal;

        return $this;
    }

    /**
     * Gets customFieldsTaxTotal
     *
     * @return double
     */
    public function getCustomFieldsTaxTotal()
    {
        return $this->container['customFieldsTaxTotal'];
    }

    /**
     * Sets customFieldsTaxTotal
     *
     * @param double $customFieldsTaxTotal customFieldsTaxTotal
     *
     * @return $this
     */
    public function setCustomFieldsTaxTotal($customFieldsTaxTotal)
    {
        $this->container['customFieldsTaxTotal'] = $customFieldsTaxTotal;

        return $this;
    }

    /**
     * Gets customerDetails
     *
     * @return \EKM\Model\V1OrderCustomerDetails|null
     */
    public function getCustomerDetails()
    {
        return $this->container['customerDetails'];
    }

    /**
     * Sets customerDetails
     *
     * @param \EKM\Model\V1OrderCustomerDetails|null $customerDetails customerDetails
     *
     * @return $this
     */
    public function setCustomerDetails($customerDetails)
    {
        $this->container['customerDetails'] = $customerDetails;

        return $this;
    }

    /**
     * Gets customFields
     *
     * @return string|null
     */
    public function getCustomFields()
    {
        return $this->container['customFields'];
    }

    /**
     * Sets customFields
     *
     * @param string|null $customFields customFields
     *
     * @return $this
     */
    public function setCustomFields($customFields)
    {
        $this->container['customFields'] = $customFields;

        return $this;
    }

    /**
     * Gets deliveryTrackingNumber
     *
     * @return string|null
     */
    public function getDeliveryTrackingNumber()
    {
        return $this->container['deliveryTrackingNumber'];
    }

    /**
     * Sets deliveryTrackingNumber
     *
     * @param string|null $deliveryTrackingNumber deliveryTrackingNumber
     *
     * @return $this
     */
    public function setDeliveryTrackingNumber($deliveryTrackingNumber)
    {
        $this->container['deliveryTrackingNumber'] = $deliveryTrackingNumber;

        return $this;
    }

    /**
     * Gets deliveryTrackingCompany
     *
     * @return string|null
     */
    public function getDeliveryTrackingCompany()
    {
        return $this->container['deliveryTrackingCompany'];
    }

    /**
     * Sets deliveryTrackingCompany
     *
     * @param string|null $deliveryTrackingCompany deliveryTrackingCompany
     *
     * @return $this
     */
    public function setDeliveryTrackingCompany($deliveryTrackingCompany)
    {
        $this->container['deliveryTrackingCompany'] = $deliveryTrackingCompany;

        return $this;
    }

    /**
     * Gets deliveryTrackingUrl
     *
     * @return string|null
     */
    public function getDeliveryTrackingUrl()
    {
        return $this->container['deliveryTrackingUrl'];
    }

    /**
     * Sets deliveryTrackingUrl
     *
     * @param string|null $deliveryTrackingUrl deliveryTrackingUrl
     *
     * @return $this
     */
    public function setDeliveryTrackingUrl($deliveryTrackingUrl)
    {
        $this->container['deliveryTrackingUrl'] = $deliveryTrackingUrl;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


