<?php
/**
 * ProductOptionItemsApi
 * PHP version 5
 *
 * @category Class
 * @package  EKM
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * EKM Partner API
 *
 * Our new API allows partners to build significantly better integrations with the EKM platform.    To try out the below endpoints, or for full up to date representations of the request / response models, please see the [swagger page](https://api.ekm.net/swagger/index.html). (We display examples here, but the swagger page is guaranteed to show the complete model.)    To keep up to date with the latest updates, please see our [RSS feed](https://partners.ekm.net/ChangeLog/Feed) or the [partner dashboard](https://partners.ekm.net/).
 *
 * The version of the OpenAPI document: Latest
 * Contact: api-support@ekm.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 4.2.3-SNAPSHOT
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace EKM\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use EKM\ApiException;
use EKM\Configuration;
use EKM\HeaderSelector;
use EKM\ObjectSerializer;

/**
 * ProductOptionItemsApi Class Doc Comment
 *
 * @category Class
 * @package  EKM
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ProductOptionItemsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $host_index (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $host_index = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $host_index;
    }

    /**
     * Set the host index
     *
     * @param  int Host index (required)
     */
    public function setHostIndex($host_index)
    {
        $this->hostIndex = $host_index;
    }

    /**
     * Get the host index
     *
     * @return Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation productOptionItemsCreate
     *
     * Add an item to a product option
     *
     * @param  int $id The product ID (required)
     * @param  int $optionId The option ID (required)
     * @param  \EKM\Model\V1ProductOptionItem $v1ProductOptionItem v1ProductOptionItem (optional)
     *
     * @throws \EKM\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \EKM\Model\TempestResponseV1ProductOptionItem|\EKM\Model\TempestResponseV1ProductOptionItem|\EKM\Model\TempestResponseTempestValidationError
     */
    public function productOptionItemsCreate($id, $optionId, $v1ProductOptionItem = null)
    {
        list($response) = $this->productOptionItemsCreateWithHttpInfo($id, $optionId, $v1ProductOptionItem);
        return $response;
    }

    /**
     * Operation productOptionItemsCreateWithHttpInfo
     *
     * Add an item to a product option
     *
     * @param  int $id The product ID (required)
     * @param  int $optionId The option ID (required)
     * @param  \EKM\Model\V1ProductOptionItem $v1ProductOptionItem (optional)
     *
     * @throws \EKM\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \EKM\Model\TempestResponseV1ProductOptionItem|\EKM\Model\TempestResponseV1ProductOptionItem|\EKM\Model\TempestResponseTempestValidationError, HTTP status code, HTTP response headers (array of strings)
     */
    public function productOptionItemsCreateWithHttpInfo($id, $optionId, $v1ProductOptionItem = null)
    {
        $request = $this->productOptionItemsCreateRequest($id, $optionId, $v1ProductOptionItem);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\EKM\Model\TempestResponseV1ProductOptionItem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EKM\Model\TempestResponseV1ProductOptionItem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\EKM\Model\TempestResponseV1ProductOptionItem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EKM\Model\TempestResponseV1ProductOptionItem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\EKM\Model\TempestResponseTempestValidationError' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EKM\Model\TempestResponseTempestValidationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\EKM\Model\TempestResponseV1ProductOptionItem';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseV1ProductOptionItem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseV1ProductOptionItem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation productOptionItemsCreateAsync
     *
     * Add an item to a product option
     *
     * @param  int $id The product ID (required)
     * @param  int $optionId The option ID (required)
     * @param  \EKM\Model\V1ProductOptionItem $v1ProductOptionItem (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productOptionItemsCreateAsync($id, $optionId, $v1ProductOptionItem = null)
    {
        return $this->productOptionItemsCreateAsyncWithHttpInfo($id, $optionId, $v1ProductOptionItem)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation productOptionItemsCreateAsyncWithHttpInfo
     *
     * Add an item to a product option
     *
     * @param  int $id The product ID (required)
     * @param  int $optionId The option ID (required)
     * @param  \EKM\Model\V1ProductOptionItem $v1ProductOptionItem (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productOptionItemsCreateAsyncWithHttpInfo($id, $optionId, $v1ProductOptionItem = null)
    {
        $returnType = '\EKM\Model\TempestResponseV1ProductOptionItem';
        $request = $this->productOptionItemsCreateRequest($id, $optionId, $v1ProductOptionItem);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'productOptionItemsCreate'
     *
     * @param  int $id The product ID (required)
     * @param  int $optionId The option ID (required)
     * @param  \EKM\Model\V1ProductOptionItem $v1ProductOptionItem (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function productOptionItemsCreateRequest($id, $optionId, $v1ProductOptionItem = null)
    {
        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling productOptionItemsCreate'
            );
        }
        // verify the required parameter 'optionId' is set
        if ($optionId === null || (is_array($optionId) && count($optionId) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $optionId when calling productOptionItemsCreate'
            );
        }

        $resourcePath = '/api/v1/products/{id}/options/{optionId}/items';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }
        // path params
        if ($optionId !== null) {
            $resourcePath = str_replace(
                '{' . 'optionId' . '}',
                ObjectSerializer::toPathValue($optionId),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($v1ProductOptionItem)) {
            $_tempBody = $v1ProductOptionItem;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation productOptionItemsDelete
     *
     * Delete an option item
     *
     * @param  int $id The product ID (required)
     * @param  int $optionId The option ID (required)
     * @param  int $optionItemId The option item ID (required)
     *
     * @throws \EKM\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \EKM\Model\TempestResponseV1ProductOptionItem|\EKM\Model\TempestResponseTempestValidationError
     */
    public function productOptionItemsDelete($id, $optionId, $optionItemId)
    {
        list($response) = $this->productOptionItemsDeleteWithHttpInfo($id, $optionId, $optionItemId);
        return $response;
    }

    /**
     * Operation productOptionItemsDeleteWithHttpInfo
     *
     * Delete an option item
     *
     * @param  int $id The product ID (required)
     * @param  int $optionId The option ID (required)
     * @param  int $optionItemId The option item ID (required)
     *
     * @throws \EKM\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \EKM\Model\TempestResponseV1ProductOptionItem|\EKM\Model\TempestResponseTempestValidationError, HTTP status code, HTTP response headers (array of strings)
     */
    public function productOptionItemsDeleteWithHttpInfo($id, $optionId, $optionItemId)
    {
        $request = $this->productOptionItemsDeleteRequest($id, $optionId, $optionItemId);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\EKM\Model\TempestResponseV1ProductOptionItem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EKM\Model\TempestResponseV1ProductOptionItem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\EKM\Model\TempestResponseTempestValidationError' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EKM\Model\TempestResponseTempestValidationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\EKM\Model\TempestResponseV1ProductOptionItem';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseV1ProductOptionItem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation productOptionItemsDeleteAsync
     *
     * Delete an option item
     *
     * @param  int $id The product ID (required)
     * @param  int $optionId The option ID (required)
     * @param  int $optionItemId The option item ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productOptionItemsDeleteAsync($id, $optionId, $optionItemId)
    {
        return $this->productOptionItemsDeleteAsyncWithHttpInfo($id, $optionId, $optionItemId)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation productOptionItemsDeleteAsyncWithHttpInfo
     *
     * Delete an option item
     *
     * @param  int $id The product ID (required)
     * @param  int $optionId The option ID (required)
     * @param  int $optionItemId The option item ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productOptionItemsDeleteAsyncWithHttpInfo($id, $optionId, $optionItemId)
    {
        $returnType = '\EKM\Model\TempestResponseV1ProductOptionItem';
        $request = $this->productOptionItemsDeleteRequest($id, $optionId, $optionItemId);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'productOptionItemsDelete'
     *
     * @param  int $id The product ID (required)
     * @param  int $optionId The option ID (required)
     * @param  int $optionItemId The option item ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function productOptionItemsDeleteRequest($id, $optionId, $optionItemId)
    {
        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling productOptionItemsDelete'
            );
        }
        // verify the required parameter 'optionId' is set
        if ($optionId === null || (is_array($optionId) && count($optionId) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $optionId when calling productOptionItemsDelete'
            );
        }
        // verify the required parameter 'optionItemId' is set
        if ($optionItemId === null || (is_array($optionItemId) && count($optionItemId) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $optionItemId when calling productOptionItemsDelete'
            );
        }

        $resourcePath = '/api/v1/products/{id}/options/{optionId}/items/{optionItemId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }
        // path params
        if ($optionId !== null) {
            $resourcePath = str_replace(
                '{' . 'optionId' . '}',
                ObjectSerializer::toPathValue($optionId),
                $resourcePath
            );
        }
        // path params
        if ($optionItemId !== null) {
            $resourcePath = str_replace(
                '{' . 'optionItemId' . '}',
                ObjectSerializer::toPathValue($optionItemId),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation productOptionItemsUpdate
     *
     * Update a product option item
     *
     * @param  int $id The product ID (required)
     * @param  int $optionId The option ID (required)
     * @param  int $optionItemId The option item ID (required)
     * @param  \EKM\Model\V1ProductOptionItem $v1ProductOptionItem v1ProductOptionItem (optional)
     *
     * @throws \EKM\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \EKM\Model\TempestResponseV1ProductOptionItem|\EKM\Model\TempestResponseV1ProductOptionItem|\EKM\Model\TempestResponseTempestValidationError
     */
    public function productOptionItemsUpdate($id, $optionId, $optionItemId, $v1ProductOptionItem = null)
    {
        list($response) = $this->productOptionItemsUpdateWithHttpInfo($id, $optionId, $optionItemId, $v1ProductOptionItem);
        return $response;
    }

    /**
     * Operation productOptionItemsUpdateWithHttpInfo
     *
     * Update a product option item
     *
     * @param  int $id The product ID (required)
     * @param  int $optionId The option ID (required)
     * @param  int $optionItemId The option item ID (required)
     * @param  \EKM\Model\V1ProductOptionItem $v1ProductOptionItem (optional)
     *
     * @throws \EKM\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \EKM\Model\TempestResponseV1ProductOptionItem|\EKM\Model\TempestResponseV1ProductOptionItem|\EKM\Model\TempestResponseTempestValidationError, HTTP status code, HTTP response headers (array of strings)
     */
    public function productOptionItemsUpdateWithHttpInfo($id, $optionId, $optionItemId, $v1ProductOptionItem = null)
    {
        $request = $this->productOptionItemsUpdateRequest($id, $optionId, $optionItemId, $v1ProductOptionItem);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\EKM\Model\TempestResponseV1ProductOptionItem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EKM\Model\TempestResponseV1ProductOptionItem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\EKM\Model\TempestResponseV1ProductOptionItem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EKM\Model\TempestResponseV1ProductOptionItem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\EKM\Model\TempestResponseTempestValidationError' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EKM\Model\TempestResponseTempestValidationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\EKM\Model\TempestResponseV1ProductOptionItem';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseV1ProductOptionItem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseV1ProductOptionItem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EKM\Model\TempestResponseTempestValidationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation productOptionItemsUpdateAsync
     *
     * Update a product option item
     *
     * @param  int $id The product ID (required)
     * @param  int $optionId The option ID (required)
     * @param  int $optionItemId The option item ID (required)
     * @param  \EKM\Model\V1ProductOptionItem $v1ProductOptionItem (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productOptionItemsUpdateAsync($id, $optionId, $optionItemId, $v1ProductOptionItem = null)
    {
        return $this->productOptionItemsUpdateAsyncWithHttpInfo($id, $optionId, $optionItemId, $v1ProductOptionItem)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation productOptionItemsUpdateAsyncWithHttpInfo
     *
     * Update a product option item
     *
     * @param  int $id The product ID (required)
     * @param  int $optionId The option ID (required)
     * @param  int $optionItemId The option item ID (required)
     * @param  \EKM\Model\V1ProductOptionItem $v1ProductOptionItem (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productOptionItemsUpdateAsyncWithHttpInfo($id, $optionId, $optionItemId, $v1ProductOptionItem = null)
    {
        $returnType = '\EKM\Model\TempestResponseV1ProductOptionItem';
        $request = $this->productOptionItemsUpdateRequest($id, $optionId, $optionItemId, $v1ProductOptionItem);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'productOptionItemsUpdate'
     *
     * @param  int $id The product ID (required)
     * @param  int $optionId The option ID (required)
     * @param  int $optionItemId The option item ID (required)
     * @param  \EKM\Model\V1ProductOptionItem $v1ProductOptionItem (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function productOptionItemsUpdateRequest($id, $optionId, $optionItemId, $v1ProductOptionItem = null)
    {
        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling productOptionItemsUpdate'
            );
        }
        // verify the required parameter 'optionId' is set
        if ($optionId === null || (is_array($optionId) && count($optionId) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $optionId when calling productOptionItemsUpdate'
            );
        }
        // verify the required parameter 'optionItemId' is set
        if ($optionItemId === null || (is_array($optionItemId) && count($optionItemId) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $optionItemId when calling productOptionItemsUpdate'
            );
        }

        $resourcePath = '/api/v1/products/{id}/options/{optionId}/items/{optionItemId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }
        // path params
        if ($optionId !== null) {
            $resourcePath = str_replace(
                '{' . 'optionId' . '}',
                ObjectSerializer::toPathValue($optionId),
                $resourcePath
            );
        }
        // path params
        if ($optionItemId !== null) {
            $resourcePath = str_replace(
                '{' . 'optionItemId' . '}',
                ObjectSerializer::toPathValue($optionItemId),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($v1ProductOptionItem)) {
            $_tempBody = $v1ProductOptionItem;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
