# EKM\ProductVariantStockApi

All URIs are relative to *https://api.ekm.net*

Method | HTTP request | Description
------------- | ------------- | -------------
[**productVariantStockGet**](ProductVariantStockApi.md#productVariantStockGet) | **GET** /api/v1/products/{id}/variants/{variantId}/stock | Get a product variant stock
[**productVariantStockUpdate**](ProductVariantStockApi.md#productVariantStockUpdate) | **PUT** /api/v1/products/{id}/variants/{variantId}/stock | Update a product variant stock



## productVariantStockGet

> \EKM\Model\TempestResponseV1ProductVariantStock productVariantStockGet($id, $variantId)

Get a product variant stock

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: Bearer
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\ProductVariantStockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | The product ID
$variantId = 56; // int | The varaint ID

try {
    $result = $apiInstance->productVariantStockGet($id, $variantId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductVariantStockApi->productVariantStockGet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| The product ID |
 **variantId** | **int**| The varaint ID |

### Return type

[**\EKM\Model\TempestResponseV1ProductVariantStock**](../Model/TempestResponseV1ProductVariantStock.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## productVariantStockUpdate

> \EKM\Model\TempestResponseV1ProductVariantStock productVariantStockUpdate($id, $variantId, $v1ProductVariantStock)

Update a product variant stock

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: Bearer
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\ProductVariantStockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | The product ID
$variantId = 56; // int | The varaint ID
$v1ProductVariantStock = new \EKM\Model\V1ProductVariantStock(); // \EKM\Model\V1ProductVariantStock | 

try {
    $result = $apiInstance->productVariantStockUpdate($id, $variantId, $v1ProductVariantStock);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductVariantStockApi->productVariantStockUpdate: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| The product ID |
 **variantId** | **int**| The varaint ID |
 **v1ProductVariantStock** | [**\EKM\Model\V1ProductVariantStock**](../Model/V1ProductVariantStock.md)|  | [optional]

### Return type

[**\EKM\Model\TempestResponseV1ProductVariantStock**](../Model/TempestResponseV1ProductVariantStock.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)

