# EKM\ProductOptionsApi

All URIs are relative to *https://api.ekm.net*

Method | HTTP request | Description
------------- | ------------- | -------------
[**productOptionsCreate**](ProductOptionsApi.md#productOptionsCreate) | **POST** /api/v1/products/{id}/options | Add an option to a product
[**productOptionsDelete**](ProductOptionsApi.md#productOptionsDelete) | **DELETE** /api/v1/products/{id}/options/{optionId} | Delete an option
[**productOptionsGet**](ProductOptionsApi.md#productOptionsGet) | **GET** /api/v1/products/{id}/options/{optionId} | Get a product option
[**productOptionsGetAll**](ProductOptionsApi.md#productOptionsGetAll) | **GET** /api/v1/products/{id}/options | Get a products options
[**productOptionsUpdate**](ProductOptionsApi.md#productOptionsUpdate) | **PUT** /api/v1/products/{id}/options/{optionId} | Update a product option



## productOptionsCreate

> \EKM\Model\TempestResponseV1ProductOption productOptionsCreate($id, $v1AddProductOption)

Add an option to a product

Option items must be added separately

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: Bearer
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\ProductOptionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | The product ID
$v1AddProductOption = new \EKM\Model\V1AddProductOption(); // \EKM\Model\V1AddProductOption | 

try {
    $result = $apiInstance->productOptionsCreate($id, $v1AddProductOption);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductOptionsApi->productOptionsCreate: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| The product ID |
 **v1AddProductOption** | [**\EKM\Model\V1AddProductOption**](../Model/V1AddProductOption.md)|  | [optional]

### Return type

[**\EKM\Model\TempestResponseV1ProductOption**](../Model/TempestResponseV1ProductOption.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## productOptionsDelete

> \EKM\Model\TempestResponseV1ProductOption productOptionsDelete($id, $optionId)

Delete an option

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: Bearer
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\ProductOptionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | The product ID
$optionId = 56; // int | The option ID

try {
    $result = $apiInstance->productOptionsDelete($id, $optionId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductOptionsApi->productOptionsDelete: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| The product ID |
 **optionId** | **int**| The option ID |

### Return type

[**\EKM\Model\TempestResponseV1ProductOption**](../Model/TempestResponseV1ProductOption.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## productOptionsGet

> \EKM\Model\TempestResponseV1ProductOption productOptionsGet($id, $optionId)

Get a product option

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: Bearer
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\ProductOptionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | The product ID
$optionId = 56; // int | The option ID

try {
    $result = $apiInstance->productOptionsGet($id, $optionId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductOptionsApi->productOptionsGet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| The product ID |
 **optionId** | **int**| The option ID |

### Return type

[**\EKM\Model\TempestResponseV1ProductOption**](../Model/TempestResponseV1ProductOption.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## productOptionsGetAll

> \EKM\Model\TempestResponseListV1ProductOption productOptionsGetAll($id)

Get a products options

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: Bearer
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\ProductOptionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | The product ID

try {
    $result = $apiInstance->productOptionsGetAll($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductOptionsApi->productOptionsGetAll: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| The product ID |

### Return type

[**\EKM\Model\TempestResponseListV1ProductOption**](../Model/TempestResponseListV1ProductOption.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## productOptionsUpdate

> \EKM\Model\TempestResponseV1ProductOption productOptionsUpdate($id, $optionId, $v1UpdateProductOption)

Update a product option

Option items must be updated separately

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: Bearer
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\ProductOptionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | The product ID
$optionId = 56; // int | The option ID
$v1UpdateProductOption = new \EKM\Model\V1UpdateProductOption(); // \EKM\Model\V1UpdateProductOption | 

try {
    $result = $apiInstance->productOptionsUpdate($id, $optionId, $v1UpdateProductOption);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductOptionsApi->productOptionsUpdate: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| The product ID |
 **optionId** | **int**| The option ID |
 **v1UpdateProductOption** | [**\EKM\Model\V1UpdateProductOption**](../Model/V1UpdateProductOption.md)|  | [optional]

### Return type

[**\EKM\Model\TempestResponseV1ProductOption**](../Model/TempestResponseV1ProductOption.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)

