# EKM\ProductAttributesApi

All URIs are relative to *https://api.ekm.net*

Method | HTTP request | Description
------------- | ------------- | -------------
[**productAttributesCreate**](ProductAttributesApi.md#productAttributesCreate) | **POST** /api/v1/settings/productattributes | Add a product attribute
[**productAttributesDelete**](ProductAttributesApi.md#productAttributesDelete) | **DELETE** /api/v1/settings/productattributes/{attribute_key} | Delete a product attribute
[**productAttributesGet**](ProductAttributesApi.md#productAttributesGet) | **GET** /api/v1/settings/productattributes/{attribute_key} | Get a product attribute
[**productAttributesGetAll**](ProductAttributesApi.md#productAttributesGetAll) | **GET** /api/v1/settings/productattributes | Get all product attributes
[**productAttributesUpdate**](ProductAttributesApi.md#productAttributesUpdate) | **PUT** /api/v1/settings/productattributes/{attribute_key} | Update a product attribute



## productAttributesCreate

> \EKM\Model\TempestResponseV1ProductAttribute productAttributesCreate($v1ProductAttribute)

Add a product attribute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: Bearer
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\ProductAttributesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$v1ProductAttribute = new \EKM\Model\V1ProductAttribute(); // \EKM\Model\V1ProductAttribute | 

try {
    $result = $apiInstance->productAttributesCreate($v1ProductAttribute);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductAttributesApi->productAttributesCreate: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **v1ProductAttribute** | [**\EKM\Model\V1ProductAttribute**](../Model/V1ProductAttribute.md)|  | [optional]

### Return type

[**\EKM\Model\TempestResponseV1ProductAttribute**](../Model/TempestResponseV1ProductAttribute.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## productAttributesDelete

> \EKM\Model\TempestResponseV1ProductAttribute productAttributesDelete($attributeKey)

Delete a product attribute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: Bearer
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\ProductAttributesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$attributeKey = 'attributeKey_example'; // string | The attribute ID

try {
    $result = $apiInstance->productAttributesDelete($attributeKey);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductAttributesApi->productAttributesDelete: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **attributeKey** | **string**| The attribute ID |

### Return type

[**\EKM\Model\TempestResponseV1ProductAttribute**](../Model/TempestResponseV1ProductAttribute.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## productAttributesGet

> \EKM\Model\TempestResponseV1ProductAttribute productAttributesGet($attributeKey)

Get a product attribute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: Bearer
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\ProductAttributesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$attributeKey = 'attributeKey_example'; // string | The attribute item key

try {
    $result = $apiInstance->productAttributesGet($attributeKey);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductAttributesApi->productAttributesGet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **attributeKey** | **string**| The attribute item key |

### Return type

[**\EKM\Model\TempestResponseV1ProductAttribute**](../Model/TempestResponseV1ProductAttribute.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## productAttributesGetAll

> \EKM\Model\TempestResponseListV1ProductAttribute productAttributesGetAll()

Get all product attributes

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: Bearer
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\ProductAttributesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->productAttributesGetAll();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductAttributesApi->productAttributesGetAll: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\EKM\Model\TempestResponseListV1ProductAttribute**](../Model/TempestResponseListV1ProductAttribute.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## productAttributesUpdate

> \EKM\Model\TempestResponseV1ProductAttribute productAttributesUpdate($attributeKey, $v1ProductAttribute)

Update a product attribute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: Bearer
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new EKM\Api\ProductAttributesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$attributeKey = 'attributeKey_example'; // string | The attribute ID
$v1ProductAttribute = new \EKM\Model\V1ProductAttribute(); // \EKM\Model\V1ProductAttribute | The product attribute item to update

try {
    $result = $apiInstance->productAttributesUpdate($attributeKey, $v1ProductAttribute);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductAttributesApi->productAttributesUpdate: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **attributeKey** | **string**| The attribute ID |
 **v1ProductAttribute** | [**\EKM\Model\V1ProductAttribute**](../Model/V1ProductAttribute.md)| The product attribute item to update | [optional]

### Return type

[**\EKM\Model\TempestResponseV1ProductAttribute**](../Model/TempestResponseV1ProductAttribute.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)

