<?php
/**
 * Copyright Talisman Innovations Ltd. (2018). All rights reserved.
 */

namespace EKM;

use League\OAuth2\Client\Provider\AbstractProvider;
use League\OAuth2\Client\Token\AccessToken;
use League\OAuth2\Client\Tool\BearerAuthorizationTrait;
use Psr\Http\Message\ResponseInterface;

class EKMProvider extends AbstractProvider
{
    protected $baseUrl = 'https://api.ekm.net/';

    use BearerAuthorizationTrait;

    public function getBaseUrl()
    {
        return $this->baseUrl;
    }

    public function getBaseAuthorizationUrl()
    {
        return $this->baseUrl.'connect/authorize';
    }

    public function getBaseAccessTokenUrl(array $params)
    {
        return $this->baseUrl.'connect/token';
    }

    public function getResourceOwnerDetailsUrl(AccessToken $token)
    {
        return 'http://api.ekm.net/api/v1/settings/domains';
    }

    protected function getDefaultScopes()
    {
        return [
            'tempest.customers.read',
            'tempest.customers.write',
            'tempest.orders.read',
            'tempest.orders.write',
            'tempest.products.read',
            'tempest.products.write',
            'tempest.categories.read',
            'tempest.categories.write',
            'tempest.settings.orderstatuses.read',
            'tempest.settings.domains.read',
            'tempest.settings.accountdetails.read',
            'tempest.settings.tax.read',
            'offline_access'
        ];
    }

    public function getScopeSeparator()
    {
        return ' ';
    }

    protected function checkResponse(ResponseInterface $response, $data)
    {
        return;
    }

    protected function createResourceOwner(array $response, AccessToken $token)
    {
        return $token;
    }

    protected function getAllowedClientOptions(array $options)
    {
        $client_options = ['timeout', 'proxy', 'handler'];

        // Only allow turning off ssl verification if it's for a proxy
        if (!empty($options['proxy'])) {
            $client_options[] = 'verify';
        }

        return $client_options;
    }
}